# Generated by Django 5.2.7 on 2025-11-03 20:39

import logging

from django.db import migrations

from openedx_authz.engine.utils import migrate_legacy_permissions

logger = logging.getLogger(__name__)


def _log_migration_errors(permissions_with_errors: list) -> None:
    """
    Log the permissions that could not be migrated during the migration process.
    Args:
        permissions_with_errors (list): List of ContentLibraryPermission instances that failed to migrate.
    """
    logger.error(
        f"Migration completed with errors for {len(permissions_with_errors)} permissions.\n"
        "The following permissions could not be migrated:"
    )
    for permission in permissions_with_errors:
        logger.error(
            "Access level: %s, %sLibrary: %s",
            permission.access_level,
            f"User: {permission.user.username}, " if permission.user else f"Group: {permission.group.name}, ",
            permission.library.slug,
        )


def apply_migrate_legacy_permissions(apps, schema_editor):
    """
    Wrapper to run the migration using the historical version of the ContentLibraryPermission model.
    """
    # ContentLibraryPermission model from the content_libraries app, here is where the legacy permissions are stored
    try:
        ContentLibraryPermission = apps.get_model("content_libraries", "ContentLibraryPermission")
    except LookupError:
        # Don't run the migration where the content_libraries app is not installed, like during development.
        logger.warning("ContentLibraryPermission model not found. Skipping migration.")
        return

    permissions_with_errors = migrate_legacy_permissions(ContentLibraryPermission)

    if permissions_with_errors:
        _log_migration_errors(permissions_with_errors)


class Migration(migrations.Migration):
    """
    Migration to transfer legacy permissions from ContentLibraryPermission
    to the new Casbin-based authorization model.
    """

    dependencies = [
        ("openedx_authz", "0005_policycachecontrol"),
    ]

    operations = [
        migrations.RunPython(apply_migrate_legacy_permissions),
    ]
