from typing import overload
import abc
import typing

import System
import System.Globalization
import System.Numerics

System_Numerics_Vector4 = typing.Any
System_Numerics_Quaternion = typing.Any
System_Numerics_Matrix3x2 = typing.Any
System_Numerics_Vector = typing.Any
System_Numerics_Vector2 = typing.Any
System_Numerics_Matrix4x4 = typing.Any
System_Numerics_Plane = typing.Any
System_Numerics_Vector3 = typing.Any

System_Numerics_IComparisonOperators_TSelf = typing.TypeVar("System_Numerics_IComparisonOperators_TSelf")
System_Numerics_IComparisonOperators_TOther = typing.TypeVar("System_Numerics_IComparisonOperators_TOther")
System_Numerics_IComparisonOperators_TResult = typing.TypeVar("System_Numerics_IComparisonOperators_TResult")
System_Numerics_IFloatingPoint_TSelf = typing.TypeVar("System_Numerics_IFloatingPoint_TSelf")
System_Numerics_INumberBase_TSelf = typing.TypeVar("System_Numerics_INumberBase_TSelf")
System_Numerics_INumberBase_CreateChecked_TOther = typing.TypeVar("System_Numerics_INumberBase_CreateChecked_TOther")
System_Numerics_INumberBase_CreateSaturating_TOther = typing.TypeVar("System_Numerics_INumberBase_CreateSaturating_TOther")
System_Numerics_INumberBase_CreateTruncating_TOther = typing.TypeVar("System_Numerics_INumberBase_CreateTruncating_TOther")
System_Numerics_INumberBase_TryConvertFromChecked_TOther = typing.TypeVar("System_Numerics_INumberBase_TryConvertFromChecked_TOther")
System_Numerics_INumberBase_TryConvertFromSaturating_TOther = typing.TypeVar("System_Numerics_INumberBase_TryConvertFromSaturating_TOther")
System_Numerics_INumberBase_TryConvertFromTruncating_TOther = typing.TypeVar("System_Numerics_INumberBase_TryConvertFromTruncating_TOther")
System_Numerics_INumberBase_TryConvertToChecked_TOther = typing.TypeVar("System_Numerics_INumberBase_TryConvertToChecked_TOther")
System_Numerics_INumberBase_TryConvertToSaturating_TOther = typing.TypeVar("System_Numerics_INumberBase_TryConvertToSaturating_TOther")
System_Numerics_INumberBase_TryConvertToTruncating_TOther = typing.TypeVar("System_Numerics_INumberBase_TryConvertToTruncating_TOther")
System_Numerics_IEqualityOperators_TSelf = typing.TypeVar("System_Numerics_IEqualityOperators_TSelf")
System_Numerics_IEqualityOperators_TOther = typing.TypeVar("System_Numerics_IEqualityOperators_TOther")
System_Numerics_IEqualityOperators_TResult = typing.TypeVar("System_Numerics_IEqualityOperators_TResult")
System_Numerics_ILogarithmicFunctions_TSelf = typing.TypeVar("System_Numerics_ILogarithmicFunctions_TSelf")
System_Numerics_ISignedNumber_TSelf = typing.TypeVar("System_Numerics_ISignedNumber_TSelf")
System_Numerics_IDivisionOperators_TSelf = typing.TypeVar("System_Numerics_IDivisionOperators_TSelf")
System_Numerics_IDivisionOperators_TOther = typing.TypeVar("System_Numerics_IDivisionOperators_TOther")
System_Numerics_IDivisionOperators_TResult = typing.TypeVar("System_Numerics_IDivisionOperators_TResult")
System_Numerics_IExponentialFunctions_TSelf = typing.TypeVar("System_Numerics_IExponentialFunctions_TSelf")
System_Numerics_IRootFunctions_TSelf = typing.TypeVar("System_Numerics_IRootFunctions_TSelf")
System_Numerics_IMultiplicativeIdentity_TResult = typing.TypeVar("System_Numerics_IMultiplicativeIdentity_TResult")
System_Numerics_IMultiplicativeIdentity_TSelf = typing.TypeVar("System_Numerics_IMultiplicativeIdentity_TSelf")
System_Numerics_IUnaryPlusOperators_TSelf = typing.TypeVar("System_Numerics_IUnaryPlusOperators_TSelf")
System_Numerics_IUnaryPlusOperators_TResult = typing.TypeVar("System_Numerics_IUnaryPlusOperators_TResult")
System_Numerics_IFloatingPointConstants_TSelf = typing.TypeVar("System_Numerics_IFloatingPointConstants_TSelf")
System_Numerics_INumber_TSelf = typing.TypeVar("System_Numerics_INumber_TSelf")
System_Numerics_IBinaryNumber_TSelf = typing.TypeVar("System_Numerics_IBinaryNumber_TSelf")
System_Numerics_ITrigonometricFunctions_TSelf = typing.TypeVar("System_Numerics_ITrigonometricFunctions_TSelf")
System_Numerics_IDecrementOperators_TSelf = typing.TypeVar("System_Numerics_IDecrementOperators_TSelf")
System_Numerics_ISubtractionOperators_TSelf = typing.TypeVar("System_Numerics_ISubtractionOperators_TSelf")
System_Numerics_ISubtractionOperators_TOther = typing.TypeVar("System_Numerics_ISubtractionOperators_TOther")
System_Numerics_ISubtractionOperators_TResult = typing.TypeVar("System_Numerics_ISubtractionOperators_TResult")
System_Numerics_IAdditionOperators_TSelf = typing.TypeVar("System_Numerics_IAdditionOperators_TSelf")
System_Numerics_IAdditionOperators_TOther = typing.TypeVar("System_Numerics_IAdditionOperators_TOther")
System_Numerics_IAdditionOperators_TResult = typing.TypeVar("System_Numerics_IAdditionOperators_TResult")
System_Numerics_IShiftOperators_TSelf = typing.TypeVar("System_Numerics_IShiftOperators_TSelf")
System_Numerics_IShiftOperators_TOther = typing.TypeVar("System_Numerics_IShiftOperators_TOther")
System_Numerics_IShiftOperators_TResult = typing.TypeVar("System_Numerics_IShiftOperators_TResult")
System_Numerics_Vector_Dot_T = typing.TypeVar("System_Numerics_Vector_Dot_T")
System_Numerics_Vector_Multiply_T = typing.TypeVar("System_Numerics_Vector_Multiply_T")
System_Numerics_Vector_Sum_T = typing.TypeVar("System_Numerics_Vector_Sum_T")
System_Numerics_Vector_T = typing.TypeVar("System_Numerics_Vector_T")
System_Numerics_Vector_Abs_T = typing.TypeVar("System_Numerics_Vector_Abs_T")
System_Numerics_Vector_Add_T = typing.TypeVar("System_Numerics_Vector_Add_T")
System_Numerics_Vector_AndNot_T = typing.TypeVar("System_Numerics_Vector_AndNot_T")
System_Numerics_Vector_As_TTo = typing.TypeVar("System_Numerics_Vector_As_TTo")
System_Numerics_Vector_As_TFrom = typing.TypeVar("System_Numerics_Vector_As_TFrom")
System_Numerics_Vector_AsVectorByte_T = typing.TypeVar("System_Numerics_Vector_AsVectorByte_T")
System_Numerics_Vector_AsVectorDouble_T = typing.TypeVar("System_Numerics_Vector_AsVectorDouble_T")
System_Numerics_Vector_AsVectorInt16_T = typing.TypeVar("System_Numerics_Vector_AsVectorInt16_T")
System_Numerics_Vector_AsVectorInt32_T = typing.TypeVar("System_Numerics_Vector_AsVectorInt32_T")
System_Numerics_Vector_AsVectorInt64_T = typing.TypeVar("System_Numerics_Vector_AsVectorInt64_T")
System_Numerics_Vector_AsVectorNInt_T = typing.TypeVar("System_Numerics_Vector_AsVectorNInt_T")
System_Numerics_Vector_AsVectorNUInt_T = typing.TypeVar("System_Numerics_Vector_AsVectorNUInt_T")
System_Numerics_Vector_AsVectorSByte_T = typing.TypeVar("System_Numerics_Vector_AsVectorSByte_T")
System_Numerics_Vector_AsVectorSingle_T = typing.TypeVar("System_Numerics_Vector_AsVectorSingle_T")
System_Numerics_Vector_AsVectorUInt16_T = typing.TypeVar("System_Numerics_Vector_AsVectorUInt16_T")
System_Numerics_Vector_AsVectorUInt32_T = typing.TypeVar("System_Numerics_Vector_AsVectorUInt32_T")
System_Numerics_Vector_AsVectorUInt64_T = typing.TypeVar("System_Numerics_Vector_AsVectorUInt64_T")
System_Numerics_Vector_BitwiseAnd_T = typing.TypeVar("System_Numerics_Vector_BitwiseAnd_T")
System_Numerics_Vector_BitwiseOr_T = typing.TypeVar("System_Numerics_Vector_BitwiseOr_T")
System_Numerics_Vector_ConditionalSelect_T = typing.TypeVar("System_Numerics_Vector_ConditionalSelect_T")
System_Numerics_Vector_Divide_T = typing.TypeVar("System_Numerics_Vector_Divide_T")
System_Numerics_Vector_Equals_T = typing.TypeVar("System_Numerics_Vector_Equals_T")
System_Numerics_Vector_EqualsAll_T = typing.TypeVar("System_Numerics_Vector_EqualsAll_T")
System_Numerics_Vector_EqualsAny_T = typing.TypeVar("System_Numerics_Vector_EqualsAny_T")
System_Numerics_Vector_GreaterThan_T = typing.TypeVar("System_Numerics_Vector_GreaterThan_T")
System_Numerics_Vector_GreaterThanAll_T = typing.TypeVar("System_Numerics_Vector_GreaterThanAll_T")
System_Numerics_Vector_GreaterThanAny_T = typing.TypeVar("System_Numerics_Vector_GreaterThanAny_T")
System_Numerics_Vector_GreaterThanOrEqual_T = typing.TypeVar("System_Numerics_Vector_GreaterThanOrEqual_T")
System_Numerics_Vector_GreaterThanOrEqualAll_T = typing.TypeVar("System_Numerics_Vector_GreaterThanOrEqualAll_T")
System_Numerics_Vector_GreaterThanOrEqualAny_T = typing.TypeVar("System_Numerics_Vector_GreaterThanOrEqualAny_T")
System_Numerics_Vector_LessThan_T = typing.TypeVar("System_Numerics_Vector_LessThan_T")
System_Numerics_Vector_LessThanAll_T = typing.TypeVar("System_Numerics_Vector_LessThanAll_T")
System_Numerics_Vector_LessThanAny_T = typing.TypeVar("System_Numerics_Vector_LessThanAny_T")
System_Numerics_Vector_LessThanOrEqual_T = typing.TypeVar("System_Numerics_Vector_LessThanOrEqual_T")
System_Numerics_Vector_LessThanOrEqualAll_T = typing.TypeVar("System_Numerics_Vector_LessThanOrEqualAll_T")
System_Numerics_Vector_LessThanOrEqualAny_T = typing.TypeVar("System_Numerics_Vector_LessThanOrEqualAny_T")
System_Numerics_Vector_Max_T = typing.TypeVar("System_Numerics_Vector_Max_T")
System_Numerics_Vector_Min_T = typing.TypeVar("System_Numerics_Vector_Min_T")
System_Numerics_Vector_Negate_T = typing.TypeVar("System_Numerics_Vector_Negate_T")
System_Numerics_Vector_OnesComplement_T = typing.TypeVar("System_Numerics_Vector_OnesComplement_T")
System_Numerics_Vector_SquareRoot_T = typing.TypeVar("System_Numerics_Vector_SquareRoot_T")
System_Numerics_Vector_Subtract_T = typing.TypeVar("System_Numerics_Vector_Subtract_T")
System_Numerics_Vector_Xor_T = typing.TypeVar("System_Numerics_Vector_Xor_T")
System_Numerics_IUnsignedNumber_TSelf = typing.TypeVar("System_Numerics_IUnsignedNumber_TSelf")
System_Numerics_IBitwiseOperators_TSelf = typing.TypeVar("System_Numerics_IBitwiseOperators_TSelf")
System_Numerics_IBitwiseOperators_TOther = typing.TypeVar("System_Numerics_IBitwiseOperators_TOther")
System_Numerics_IBitwiseOperators_TResult = typing.TypeVar("System_Numerics_IBitwiseOperators_TResult")
System_Numerics_IPowerFunctions_TSelf = typing.TypeVar("System_Numerics_IPowerFunctions_TSelf")
System_Numerics_IModulusOperators_TSelf = typing.TypeVar("System_Numerics_IModulusOperators_TSelf")
System_Numerics_IModulusOperators_TOther = typing.TypeVar("System_Numerics_IModulusOperators_TOther")
System_Numerics_IModulusOperators_TResult = typing.TypeVar("System_Numerics_IModulusOperators_TResult")
System_Numerics_IIncrementOperators_TSelf = typing.TypeVar("System_Numerics_IIncrementOperators_TSelf")
System_Numerics_IUnaryNegationOperators_TSelf = typing.TypeVar("System_Numerics_IUnaryNegationOperators_TSelf")
System_Numerics_IUnaryNegationOperators_TResult = typing.TypeVar("System_Numerics_IUnaryNegationOperators_TResult")
System_Numerics_IFloatingPointIeee754_TSelf = typing.TypeVar("System_Numerics_IFloatingPointIeee754_TSelf")
System_Numerics_IBinaryFloatingPointIeee754_TSelf = typing.TypeVar("System_Numerics_IBinaryFloatingPointIeee754_TSelf")
System_Numerics_IHyperbolicFunctions_TSelf = typing.TypeVar("System_Numerics_IHyperbolicFunctions_TSelf")
System_Numerics_IAdditiveIdentity_TResult = typing.TypeVar("System_Numerics_IAdditiveIdentity_TResult")
System_Numerics_IAdditiveIdentity_TSelf = typing.TypeVar("System_Numerics_IAdditiveIdentity_TSelf")
System_Numerics_IMinMaxValue_TSelf = typing.TypeVar("System_Numerics_IMinMaxValue_TSelf")
System_Numerics_IMultiplyOperators_TSelf = typing.TypeVar("System_Numerics_IMultiplyOperators_TSelf")
System_Numerics_IMultiplyOperators_TOther = typing.TypeVar("System_Numerics_IMultiplyOperators_TOther")
System_Numerics_IMultiplyOperators_TResult = typing.TypeVar("System_Numerics_IMultiplyOperators_TResult")
System_Numerics_IBinaryInteger_TSelf = typing.TypeVar("System_Numerics_IBinaryInteger_TSelf")


class IEqualityOperators(typing.Generic[System_Numerics_IEqualityOperators_TSelf, System_Numerics_IEqualityOperators_TOther, System_Numerics_IEqualityOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for comparing two values to determine equality."""


class IComparisonOperators(typing.Generic[System_Numerics_IComparisonOperators_TSelf, System_Numerics_IComparisonOperators_TOther, System_Numerics_IComparisonOperators_TResult], System.Numerics.IEqualityOperators[System_Numerics_IComparisonOperators_TSelf, System_Numerics_IComparisonOperators_TOther, System_Numerics_IComparisonOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for comparing two values to determine relative order."""


class IAdditionOperators(typing.Generic[System_Numerics_IAdditionOperators_TSelf, System_Numerics_IAdditionOperators_TOther, System_Numerics_IAdditionOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the sum of two values."""


class IAdditiveIdentity(typing.Generic[System_Numerics_IAdditiveIdentity_TSelf, System_Numerics_IAdditiveIdentity_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for getting the additive identity of a given type."""

    AdditiveIdentity: System_Numerics_IAdditiveIdentity_TResult
    """Gets the additive identity of the current type."""


class IDecrementOperators(typing.Generic[System_Numerics_IDecrementOperators_TSelf], metaclass=abc.ABCMeta):
    """Defines a mechanism for decrementing a given value."""


class IDivisionOperators(typing.Generic[System_Numerics_IDivisionOperators_TSelf, System_Numerics_IDivisionOperators_TOther, System_Numerics_IDivisionOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the quotient of two values."""


class IIncrementOperators(typing.Generic[System_Numerics_IIncrementOperators_TSelf], metaclass=abc.ABCMeta):
    """Defines a mechanism for incrementing a given value."""


class IMultiplicativeIdentity(typing.Generic[System_Numerics_IMultiplicativeIdentity_TSelf, System_Numerics_IMultiplicativeIdentity_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for getting the multiplicative identity of a given type."""

    MultiplicativeIdentity: System_Numerics_IMultiplicativeIdentity_TResult
    """Gets the multiplicative identity of the current type."""


class IMultiplyOperators(typing.Generic[System_Numerics_IMultiplyOperators_TSelf, System_Numerics_IMultiplyOperators_TOther, System_Numerics_IMultiplyOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the product of two values."""


class ISubtractionOperators(typing.Generic[System_Numerics_ISubtractionOperators_TSelf, System_Numerics_ISubtractionOperators_TOther, System_Numerics_ISubtractionOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the difference of two values."""


class IUnaryPlusOperators(typing.Generic[System_Numerics_IUnaryPlusOperators_TSelf, System_Numerics_IUnaryPlusOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the unary plus of a value."""


class IUnaryNegationOperators(typing.Generic[System_Numerics_IUnaryNegationOperators_TSelf, System_Numerics_IUnaryNegationOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the unary negation of a value."""


class INumberBase(typing.Generic[System_Numerics_INumberBase_TSelf], System.Numerics.IAdditionOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.Numerics.IAdditiveIdentity[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.Numerics.IDecrementOperators[System_Numerics_INumberBase_TSelf], System.Numerics.IDivisionOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.IEquatable[System_Numerics_INumberBase_TSelf], System.Numerics.IEqualityOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf, bool], System.Numerics.IIncrementOperators[System_Numerics_INumberBase_TSelf], System.Numerics.IMultiplicativeIdentity[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.Numerics.IMultiplyOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.ISpanFormattable, System.ISpanParsable[System_Numerics_INumberBase_TSelf], System.Numerics.ISubtractionOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.Numerics.IUnaryPlusOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], System.Numerics.IUnaryNegationOperators[System_Numerics_INumberBase_TSelf, System_Numerics_INumberBase_TSelf], metaclass=abc.ABCMeta):
    """Defines the base of other number types."""

    One: System_Numerics_INumberBase_TSelf
    """Gets the value 1 for the type."""

    Radix: int
    """Gets the radix, or base, for the type."""

    Zero: System_Numerics_INumberBase_TSelf
    """Gets the value 0 for the type."""

    @staticmethod
    def Abs(value: System_Numerics_INumberBase_TSelf) -> System_Numerics_INumberBase_TSelf:
        """
        Computes the absolute of a value.
        
        :param value: The value for which to get its absolute.
        :returns: The absolute of .
        """
        ...

    @staticmethod
    def CreateChecked(value: System_Numerics_INumberBase_CreateChecked_TOther) -> System_Numerics_INumberBase_TSelf:
        """
        Creates an instance of the current type from a value, throwing an overflow exception for any values that fall outside the representable range of the current type.
        
        :param value: The value which is used to create the instance of TSelf.
        :returns: An instance of TSelf created from .
        """
        ...

    @staticmethod
    def CreateSaturating(value: System_Numerics_INumberBase_CreateSaturating_TOther) -> System_Numerics_INumberBase_TSelf:
        """
        Creates an instance of the current type from a value, saturating any values that fall outside the representable range of the current type.
        
        :param value: The value which is used to create the instance of TSelf.
        :returns: An instance of TSelf created from , saturating if  falls outside the representable range of TSelf.
        """
        ...

    @staticmethod
    def CreateTruncating(value: System_Numerics_INumberBase_CreateTruncating_TOther) -> System_Numerics_INumberBase_TSelf:
        """
        Creates an instance of the current type from a value, truncating any values that fall outside the representable range of the current type.
        
        :param value: The value which is used to create the instance of TSelf.
        :returns: An instance of TSelf created from , truncating if  falls outside the representable range of TSelf.
        """
        ...

    @staticmethod
    def IsCanonical(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is in its canonical representation.
        
        :param value: The value to be checked.
        :returns: true if  is in its canonical representation; otherwise, false.
        """
        ...

    @staticmethod
    def IsComplexNumber(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value represents a complex value.
        
        :param value: The value to be checked.
        :returns: true if  is a complex number; otherwise, false.
        """
        ...

    @staticmethod
    def IsEvenInteger(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value represents an even integral value.
        
        :param value: The value to be checked.
        :returns: true if  is an even integer; otherwise, false.
        """
        ...

    @staticmethod
    def IsFinite(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is finite.
        
        :param value: The value to be checked.
        :returns: true if  is finite; otherwise, false.
        """
        ...

    @staticmethod
    def IsImaginaryNumber(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value represents an imaginary value.
        
        :param value: The value to be checked.
        :returns: true if  is an imaginary number; otherwise, false.
        """
        ...

    @staticmethod
    def IsInfinity(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is infinite.
        
        :param value: The value to be checked.
        :returns: true if  is infinite; otherwise, false.
        """
        ...

    @staticmethod
    def IsInteger(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value represents an integral value.
        
        :param value: The value to be checked.
        :returns: true if  is an integer; otherwise, false.
        """
        ...

    @staticmethod
    def IsNaN(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is NaN.
        
        :param value: The value to be checked.
        :returns: true if  is NaN; otherwise, false.
        """
        ...

    @staticmethod
    def IsNegative(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is negative.
        
        :param value: The value to be checked.
        :returns: true if  is negative; otherwise, false.
        """
        ...

    @staticmethod
    def IsNegativeInfinity(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is negative infinity.
        
        :param value: The value to be checked.
        :returns: true if  is negative infinity; otherwise, false.
        """
        ...

    @staticmethod
    def IsNormal(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is normal.
        
        :param value: The value to be checked.
        :returns: true if  is normal; otherwise, false.
        """
        ...

    @staticmethod
    def IsOddInteger(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value represents an odd integral value.
        
        :param value: The value to be checked.
        :returns: true if  is an odd integer; otherwise, false.
        """
        ...

    @staticmethod
    def IsPositive(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is positive.
        
        :param value: The value to be checked.
        :returns: true if  is positive; otherwise, false.
        """
        ...

    @staticmethod
    def IsPositiveInfinity(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is positive infinity.
        
        :param value: The value to be checked.
        :returns: true if  is positive infinity; otherwise, false.
        """
        ...

    @staticmethod
    def IsRealNumber(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value represents a real value.
        
        :param value: The value to be checked.
        :returns: true if  is a real number; otherwise, false.
        """
        ...

    @staticmethod
    def IsSubnormal(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is subnormal.
        
        :param value: The value to be checked.
        :returns: true if  is subnormal; otherwise, false.
        """
        ...

    @staticmethod
    def IsZero(value: System_Numerics_INumberBase_TSelf) -> bool:
        """
        Determines if a value is zero.
        
        :param value: The value to be checked.
        :returns: true if  is zero; otherwise, false.
        """
        ...

    @staticmethod
    def MaxMagnitude(x: System_Numerics_INumberBase_TSelf, y: System_Numerics_INumberBase_TSelf) -> System_Numerics_INumberBase_TSelf:
        """
        Compares two values to compute which is greater.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is greater than ; otherwise, .
        """
        ...

    @staticmethod
    def MaxMagnitudeNumber(x: System_Numerics_INumberBase_TSelf, y: System_Numerics_INumberBase_TSelf) -> System_Numerics_INumberBase_TSelf:
        """
        Compares two values to compute which has the greater magnitude and returning the other value if an input is NaN.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is greater than ; otherwise, .
        """
        ...

    @staticmethod
    def MinMagnitude(x: System_Numerics_INumberBase_TSelf, y: System_Numerics_INumberBase_TSelf) -> System_Numerics_INumberBase_TSelf:
        """
        Compares two values to compute which is lesser.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is less than ; otherwise, .
        """
        ...

    @staticmethod
    def MinMagnitudeNumber(x: System_Numerics_INumberBase_TSelf, y: System_Numerics_INumberBase_TSelf) -> System_Numerics_INumberBase_TSelf:
        """
        Compares two values to compute which has the lesser magnitude and returning the other value if an input is NaN.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is less than ; otherwise, .
        """
        ...

    @staticmethod
    @overload
    def Parse(s: str, style: System.Globalization.NumberStyles, provider: System.IFormatProvider) -> System_Numerics_INumberBase_TSelf:
        """
        Parses a string into a value.
        
        :param s: The string to parse.
        :param style: A bitwise combination of number styles that can be present in .
        :param provider: An object that provides culture-specific formatting information about .
        :returns: The result of parsing .
        """
        ...

    @staticmethod
    @overload
    def Parse(s: System.ReadOnlySpan[str], style: System.Globalization.NumberStyles, provider: System.IFormatProvider) -> System_Numerics_INumberBase_TSelf:
        """
        Parses a span of characters into a value.
        
        :param s: The span of characters to parse.
        :param style: A bitwise combination of number styles that can be present in .
        :param provider: An object that provides culture-specific formatting information about .
        :returns: The result of parsing .
        """
        ...

    @staticmethod
    def TryConvertFromChecked(value: System_Numerics_INumberBase_TryConvertFromChecked_TOther, result: typing.Optional[System_Numerics_INumberBase_TSelf]) -> typing.Union[bool, System_Numerics_INumberBase_TSelf]:
        """
        Tries to convert a value to an instance of the current type, throwing an overflow exception for any values that fall outside the representable range of the current type.
        
        This method is protected.
        
        :param value: The value which is used to create the instance of TSelf.
        :param result: On return, contains an instance of TSelf converted from .
        :returns: false if TOther is not supported; otherwise, true.
        """
        ...

    @staticmethod
    def TryConvertFromSaturating(value: System_Numerics_INumberBase_TryConvertFromSaturating_TOther, result: typing.Optional[System_Numerics_INumberBase_TSelf]) -> typing.Union[bool, System_Numerics_INumberBase_TSelf]:
        """This method is protected."""
        ...

    @staticmethod
    def TryConvertFromTruncating(value: System_Numerics_INumberBase_TryConvertFromTruncating_TOther, result: typing.Optional[System_Numerics_INumberBase_TSelf]) -> typing.Union[bool, System_Numerics_INumberBase_TSelf]:
        """This method is protected."""
        ...

    @staticmethod
    def TryConvertToChecked(value: System_Numerics_INumberBase_TSelf, result: typing.Optional[System_Numerics_INumberBase_TryConvertToChecked_TOther]) -> typing.Union[bool, System_Numerics_INumberBase_TryConvertToChecked_TOther]:
        """This method is protected."""
        ...

    @staticmethod
    def TryConvertToSaturating(value: System_Numerics_INumberBase_TSelf, result: typing.Optional[System_Numerics_INumberBase_TryConvertToSaturating_TOther]) -> typing.Union[bool, System_Numerics_INumberBase_TryConvertToSaturating_TOther]:
        """This method is protected."""
        ...

    @staticmethod
    def TryConvertToTruncating(value: System_Numerics_INumberBase_TSelf, result: typing.Optional[System_Numerics_INumberBase_TryConvertToTruncating_TOther]) -> typing.Union[bool, System_Numerics_INumberBase_TryConvertToTruncating_TOther]:
        """This method is protected."""
        ...

    @staticmethod
    @overload
    def TryParse(s: str, style: System.Globalization.NumberStyles, provider: System.IFormatProvider, result: typing.Optional[System_Numerics_INumberBase_TSelf]) -> typing.Union[bool, System_Numerics_INumberBase_TSelf]:
        ...

    @staticmethod
    @overload
    def TryParse(s: System.ReadOnlySpan[str], style: System.Globalization.NumberStyles, provider: System.IFormatProvider, result: typing.Optional[System_Numerics_INumberBase_TSelf]) -> typing.Union[bool, System_Numerics_INumberBase_TSelf]:
        """
        Tries to parses a span of characters into a value.
        
        :param s: The span of characters to parse.
        :param style: A bitwise combination of number styles that can be present in .
        :param provider: An object that provides culture-specific formatting information about .
        :param result: On return, contains the result of successfully parsing  or an undefined value on failure.
        :returns: true if  was successfully parsed; otherwise, false.
        """
        ...


class IFloatingPointConstants(typing.Generic[System_Numerics_IFloatingPointConstants_TSelf], System.Numerics.INumberBase[System_Numerics_IFloatingPointConstants_TSelf], metaclass=abc.ABCMeta):
    """Defines support for floating-point constants."""

    E: System_Numerics_IFloatingPointConstants_TSelf
    """Gets the mathematical constant e."""

    Pi: System_Numerics_IFloatingPointConstants_TSelf
    """Gets the mathematical constant pi."""

    Tau: System_Numerics_IFloatingPointConstants_TSelf
    """Gets the mathematical constant tau."""


class IModulusOperators(typing.Generic[System_Numerics_IModulusOperators_TSelf, System_Numerics_IModulusOperators_TOther, System_Numerics_IModulusOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for computing the modulus or remainder of two values."""


class INumber(typing.Generic[System_Numerics_INumber_TSelf], System.IComparable[System_Numerics_INumber_TSelf], System.Numerics.IComparisonOperators[System_Numerics_INumber_TSelf, System_Numerics_INumber_TSelf, bool], System.Numerics.IModulusOperators[System_Numerics_INumber_TSelf, System_Numerics_INumber_TSelf, System_Numerics_INumber_TSelf], System.Numerics.INumberBase[System_Numerics_INumber_TSelf], metaclass=abc.ABCMeta):
    """Defines a number type."""

    @staticmethod
    def Clamp(value: System_Numerics_INumber_TSelf, min: System_Numerics_INumber_TSelf, max: System_Numerics_INumber_TSelf) -> System_Numerics_INumber_TSelf:
        """
        Clamps a value to an inclusive minimum and maximum value.
        
        :param value: The value to clamp.
        :param min: The inclusive minimum to which  should clamp.
        :param max: The inclusive maximum to which  should clamp.
        :returns: The result of clamping  to the inclusive range of  and .
        """
        ...

    @staticmethod
    def CopySign(value: System_Numerics_INumber_TSelf, sign: System_Numerics_INumber_TSelf) -> System_Numerics_INumber_TSelf:
        """
        Copies the sign of a value to the sign of another value..
        
        :param value: The value whose magnitude is used in the result.
        :param sign: The value whose sign is used in the result.
        :returns: A value with the magnitude of  and the sign of .
        """
        ...

    @staticmethod
    def Max(x: System_Numerics_INumber_TSelf, y: System_Numerics_INumber_TSelf) -> System_Numerics_INumber_TSelf:
        """
        Compares two values to compute which is greater.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is greater than ; otherwise, .
        """
        ...

    @staticmethod
    def MaxNumber(x: System_Numerics_INumber_TSelf, y: System_Numerics_INumber_TSelf) -> System_Numerics_INumber_TSelf:
        """
        Compares two values to compute which is greater and returning the other value if an input is NaN.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is greater than ; otherwise, .
        """
        ...

    @staticmethod
    def Min(x: System_Numerics_INumber_TSelf, y: System_Numerics_INumber_TSelf) -> System_Numerics_INumber_TSelf:
        """
        Compares two values to compute which is lesser.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is less than ; otherwise, .
        """
        ...

    @staticmethod
    def MinNumber(x: System_Numerics_INumber_TSelf, y: System_Numerics_INumber_TSelf) -> System_Numerics_INumber_TSelf:
        """
        Compares two values to compute which is lesser and returning the other value if an input is NaN.
        
        :param x: The value to compare with .
        :param y: The value to compare with .
        :returns: if it is less than ; otherwise, .
        """
        ...

    @staticmethod
    def Sign(value: System_Numerics_INumber_TSelf) -> int:
        """
        Computes the sign of a value.
        
        :param value: The value whose sign is to be computed.
        :returns: A positive value if  is positive, INumberBase{TSelf}.Zero if  is zero, and a negative value if  is negative.
        """
        ...


class ISignedNumber(typing.Generic[System_Numerics_ISignedNumber_TSelf], System.Numerics.INumberBase[System_Numerics_ISignedNumber_TSelf], metaclass=abc.ABCMeta):
    """Defines a number type which can represent both positive and negative values."""

    NegativeOne: System_Numerics_ISignedNumber_TSelf
    """Gets the value -1 for the type."""


class IFloatingPoint(typing.Generic[System_Numerics_IFloatingPoint_TSelf], System.Numerics.IFloatingPointConstants[System_Numerics_IFloatingPoint_TSelf], System.Numerics.INumber[System_Numerics_IFloatingPoint_TSelf], System.Numerics.ISignedNumber[System_Numerics_IFloatingPoint_TSelf], metaclass=abc.ABCMeta):
    """Defines a floating-point type."""

    @staticmethod
    def Ceiling(x: System_Numerics_IFloatingPoint_TSelf) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Computes the ceiling of a value.
        
        :param x: The value whose ceiling is to be computed.
        :returns: The ceiling of .
        """
        ...

    @staticmethod
    def Floor(x: System_Numerics_IFloatingPoint_TSelf) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Computes the floor of a value.
        
        :param x: The value whose floor is to be computed.
        :returns: The floor of .
        """
        ...

    def GetExponentByteCount(self) -> int:
        """
        Gets the number of bytes that will be written as part of TryWriteExponentLittleEndian(Span{byte}, out int).
        
        :returns: The number of bytes that will be written as part of TryWriteExponentLittleEndian(Span{byte}, out int).
        """
        ...

    def GetExponentShortestBitLength(self) -> int:
        """
        Gets the length, in bits, of the shortest two's complement representation of the current exponent.
        
        :returns: The length, in bits, of the shortest two's complement representation of the current exponent.
        """
        ...

    def GetSignificandBitLength(self) -> int:
        """
        Gets the length, in bits, of the current significand.
        
        :returns: The length, in bits, of the current significand.
        """
        ...

    def GetSignificandByteCount(self) -> int:
        """
        Gets the number of bytes that will be written as part of TryWriteSignificandLittleEndian(Span{byte}, out int).
        
        :returns: The number of bytes that will be written as part of TryWriteSignificandLittleEndian(Span{byte}, out int).
        """
        ...

    @staticmethod
    @overload
    def Round(x: System_Numerics_IFloatingPoint_TSelf) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Rounds a value to the nearest integer using the default rounding mode (MidpointRounding.ToEven).
        
        :param x: The value to round.
        :returns: The result of rounding  to the nearest integer using the default rounding mode.
        """
        ...

    @staticmethod
    @overload
    def Round(x: System_Numerics_IFloatingPoint_TSelf, digits: int) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Rounds a value to a specified number of fractional-digits using the default rounding mode (MidpointRounding.ToEven).
        
        :param x: The value to round.
        :param digits: The number of fractional digits to which  should be rounded.
        :returns: The result of rounding  to  fractional-digits using the default rounding mode.
        """
        ...

    @staticmethod
    @overload
    def Round(x: System_Numerics_IFloatingPoint_TSelf, mode: System.MidpointRounding) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Rounds a value to the nearest integer using the specified rounding mode.
        
        :param x: The value to round.
        :param mode: The mode under which  should be rounded.
        :returns: The result of rounding  to the nearest integer using .
        """
        ...

    @staticmethod
    @overload
    def Round(x: System_Numerics_IFloatingPoint_TSelf, digits: int, mode: System.MidpointRounding) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Rounds a value to a specified number of fractional-digits using the default rounding mode (MidpointRounding.ToEven).
        
        :param x: The value to round.
        :param digits: The number of fractional digits to which  should be rounded.
        :param mode: The mode under which  should be rounded.
        :returns: The result of rounding  to  fractional-digits using .
        """
        ...

    @staticmethod
    def Truncate(x: System_Numerics_IFloatingPoint_TSelf) -> System_Numerics_IFloatingPoint_TSelf:
        """
        Truncates a value.
        
        :param x: The value to truncate.
        :returns: The truncation of .
        """
        ...

    def TryWriteExponentBigEndian(self, destination: System.Span[int], bytesWritten: typing.Optional[int]) -> typing.Union[bool, int]:
        """
        Tries to write the current exponent, in big-endian format, to a given span.
        
        :param destination: The span to which the current exponent should be written.
        :param bytesWritten: The number of bytes written to .
        :returns: true if the exponent was successfully written to ; otherwise, false.
        """
        ...

    def TryWriteExponentLittleEndian(self, destination: System.Span[int], bytesWritten: typing.Optional[int]) -> typing.Union[bool, int]:
        """
        Tries to write the current exponent, in little-endian format, to a given span.
        
        :param destination: The span to which the current exponent should be written.
        :param bytesWritten: The number of bytes written to .
        :returns: true if the exponent was successfully written to ; otherwise, false.
        """
        ...

    def TryWriteSignificandBigEndian(self, destination: System.Span[int], bytesWritten: typing.Optional[int]) -> typing.Union[bool, int]:
        """
        Tries to write the current significand, in big-endian format, to a given span.
        
        :param destination: The span to which the current significand should be written.
        :param bytesWritten: The number of bytes written to .
        :returns: true if the significand was successfully written to ; otherwise, false.
        """
        ...

    def TryWriteSignificandLittleEndian(self, destination: System.Span[int], bytesWritten: typing.Optional[int]) -> typing.Union[bool, int]:
        """
        Tries to write the current significand, in little-endian format, to a given span.
        
        :param destination: The span to which the current significand should be written.
        :param bytesWritten: The number of bytes written to .
        :returns: true if the significand was successfully written to ; otherwise, false.
        """
        ...

    @overload
    def WriteExponentBigEndian(self, destination: typing.List[int]) -> int:
        """
        Writes the current exponent, in big-endian format, to a given array.
        
        :param destination: The array to which the current exponent should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteExponentBigEndian(self, destination: typing.List[int], startIndex: int) -> int:
        """
        Writes the current exponent, in big-endian format, to a given array.
        
        :param destination: The array to which the current exponent should be written.
        :param startIndex: The starting index at which the exponent should be written.
        :returns: The number of bytes written to  starting at .
        """
        ...

    @overload
    def WriteExponentBigEndian(self, destination: System.Span[int]) -> int:
        """
        Writes the current exponent, in big-endian format, to a given span.
        
        :param destination: The span to which the current exponent should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteExponentLittleEndian(self, destination: typing.List[int]) -> int:
        """
        Writes the current exponent, in little-endian format, to a given array.
        
        :param destination: The array to which the current exponent should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteExponentLittleEndian(self, destination: typing.List[int], startIndex: int) -> int:
        """
        Writes the current exponent, in little-endian format, to a given array.
        
        :param destination: The array to which the current exponent should be written.
        :param startIndex: The starting index at which the exponent should be written.
        :returns: The number of bytes written to  starting at .
        """
        ...

    @overload
    def WriteExponentLittleEndian(self, destination: System.Span[int]) -> int:
        """
        Writes the current exponent, in little-endian format, to a given span.
        
        :param destination: The span to which the current exponent should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteSignificandBigEndian(self, destination: typing.List[int]) -> int:
        """
        Writes the current significand, in big-endian format, to a given array.
        
        :param destination: The array to which the current significand should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteSignificandBigEndian(self, destination: typing.List[int], startIndex: int) -> int:
        """
        Writes the current significand, in big-endian format, to a given array.
        
        :param destination: The array to which the current significand should be written.
        :param startIndex: The starting index at which the significand should be written.
        :returns: The number of bytes written to  starting at .
        """
        ...

    @overload
    def WriteSignificandBigEndian(self, destination: System.Span[int]) -> int:
        """
        Writes the current significand, in big-endian format, to a given span.
        
        :param destination: The span to which the current significand should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteSignificandLittleEndian(self, destination: typing.List[int]) -> int:
        """
        Writes the current significand, in little-endian format, to a given array.
        
        :param destination: The array to which the current significand should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteSignificandLittleEndian(self, destination: typing.List[int], startIndex: int) -> int:
        """
        Writes the current significand, in little-endian format, to a given array.
        
        :param destination: The array to which the current significand should be written.
        :param startIndex: The starting index at which the significand should be written.
        :returns: The number of bytes written to  starting at .
        """
        ...

    @overload
    def WriteSignificandLittleEndian(self, destination: System.Span[int]) -> int:
        """
        Writes the current significand, in little-endian format, to a given span.
        
        :param destination: The span to which the current significand should be written.
        :returns: The number of bytes written to .
        """
        ...


class Vector3(System.IEquatable[System_Numerics_Vector3], System.IFormattable):
    """Represents a vector with three  single-precision floating-point values."""

    @property
    def X(self) -> float:
        """The X component of the vector."""
        ...

    @X.setter
    def X(self, value: float):
        """The X component of the vector."""
        ...

    @property
    def Y(self) -> float:
        """The Y component of the vector."""
        ...

    @Y.setter
    def Y(self, value: float):
        """The Y component of the vector."""
        ...

    @property
    def Z(self) -> float:
        """The Z component of the vector."""
        ...

    @Z.setter
    def Z(self, value: float):
        """The Z component of the vector."""
        ...

    Count: int = 3

    Zero: System.Numerics.Vector3
    """Gets a vector whose 3 elements are equal to zero."""

    One: System.Numerics.Vector3
    """Gets a vector whose 3 elements are equal to one."""

    UnitX: System.Numerics.Vector3
    """Gets the vector (1,0,0)."""

    UnitY: System.Numerics.Vector3
    """Gets the vector (0,1,0)."""

    UnitZ: System.Numerics.Vector3
    """Gets the vector (0,0,1)."""

    def __getitem__(self, index: int) -> float:
        ...

    @overload
    def __init__(self, value: float) -> None:
        """
        Creates a new System.Numerics.Vector3 object whose three elements have the same value.
        
        :param value: The value to assign to all three elements.
        """
        ...

    @overload
    def __init__(self, value: System.Numerics.Vector2, z: float) -> None:
        """
        Creates a   new System.Numerics.Vector3 object from the specified System.Numerics.Vector2 object and the specified value.
        
        :param value: The vector with two elements.
        :param z: The additional value to assign to the System.Numerics.Vector3.Z field.
        """
        ...

    @overload
    def __init__(self, x: float, y: float, z: float) -> None:
        """
        Creates a vector whose elements have the specified values.
        
        :param x: The value to assign to the System.Numerics.Vector3.X field.
        :param y: The value to assign to the System.Numerics.Vector3.Y field.
        :param z: The value to assign to the System.Numerics.Vector3.Z field.
        """
        ...

    @overload
    def __init__(self, values: System.ReadOnlySpan[float]) -> None:
        """
        Constructs a vector from the given ReadOnlySpan{Single}. The span must contain at least 3 elements.
        
        :param values: The span of elements to assign to the vector.
        """
        ...

    def __setitem__(self, index: int, value: float) -> None:
        ...

    @staticmethod
    def Abs(value: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns a vector whose elements are the absolute values of each of the specified vector's elements.
        
        :param value: A vector.
        :returns: The absolute value vector.
        """
        ...

    @staticmethod
    def Add(left: System.Numerics.Vector3, right: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Adds two vectors together.
        
        :param left: The first vector to add.
        :param right: The second vector to add.
        :returns: The summed vector.
        """
        ...

    @staticmethod
    def Clamp(value1: System.Numerics.Vector3, min: System.Numerics.Vector3, max: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Restricts a vector between a minimum and a maximum value.
        
        :param value1: The vector to restrict.
        :param min: The minimum value.
        :param max: The maximum value.
        :returns: The restricted vector.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[float]) -> None:
        """
        Copies the elements of the vector to a specified array.
        
        :param array: The destination array.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[float], index: int) -> None:
        """
        Copies the elements of the vector to a specified array starting at a specified index position.
        
        :param array: The destination array.
        :param index: The index at which to copy the first element of the vector.
        """
        ...

    @overload
    def CopyTo(self, destination: System.Span[float]) -> None:
        """
        Copies the vector to the given Span{T}. The length of the destination span must be at least 3.
        
        :param destination: The destination span which the values are copied into.
        """
        ...

    @staticmethod
    def Cross(vector1: System.Numerics.Vector3, vector2: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Computes the cross product of two vectors.
        
        :param vector1: The first vector.
        :param vector2: The second vector.
        :returns: The cross product.
        """
        ...

    @staticmethod
    def Distance(value1: System.Numerics.Vector3, value2: System.Numerics.Vector3) -> float:
        """
        Computes the Euclidean distance between the two given points.
        
        :param value1: The first point.
        :param value2: The second point.
        :returns: The distance.
        """
        ...

    @staticmethod
    def DistanceSquared(value1: System.Numerics.Vector3, value2: System.Numerics.Vector3) -> float:
        """
        Returns the Euclidean distance squared between two specified points.
        
        :param value1: The first point.
        :param value2: The second point.
        :returns: The distance squared.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Numerics.Vector3, right: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Divides the first vector by the second.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The vector resulting from the division.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Numerics.Vector3, divisor: float) -> System.Numerics.Vector3:
        """
        Divides the specified vector by a specified scalar value.
        
        :param left: The vector.
        :param divisor: The scalar value.
        :returns: The vector that results from the division.
        """
        ...

    @staticmethod
    def Dot(vector1: System.Numerics.Vector3, vector2: System.Numerics.Vector3) -> float:
        """
        Returns the dot product of two vectors.
        
        :param vector1: The first vector.
        :param vector2: The second vector.
        :returns: The dot product.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Vector3) -> bool:
        """
        Returns a value that indicates whether this instance and another vector are equal.
        
        :param other: The other vector.
        :returns: true if the two vectors are equal; otherwise, false.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    def Length(self) -> float:
        """
        Returns the length of this vector object.
        
        :returns: The vector's length.
        """
        ...

    def LengthSquared(self) -> float:
        """
        Returns the length of the vector squared.
        
        :returns: The vector's length squared.
        """
        ...

    @staticmethod
    def Lerp(value1: System.Numerics.Vector3, value2: System.Numerics.Vector3, amount: float) -> System.Numerics.Vector3:
        """
        Performs a linear interpolation between two vectors based on the given weighting.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :param amount: A value between 0 and 1 that indicates the weight of .
        :returns: The interpolated vector.
        """
        ...

    @staticmethod
    def Max(value1: System.Numerics.Vector3, value2: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns a vector whose elements are the maximum of each of the pairs of elements in two specified vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The maximized vector.
        """
        ...

    @staticmethod
    def Min(value1: System.Numerics.Vector3, value2: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns a vector whose elements are the minimum of each of the pairs of elements in two specified vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The minimized vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector3, right: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns a new vector whose values are the product of each pair of elements in two specified vectors.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The element-wise product vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector3, right: float) -> System.Numerics.Vector3:
        """
        Multiplies a vector by a specified scalar.
        
        :param left: The vector to multiply.
        :param right: The scalar value.
        :returns: The scaled vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: float, right: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Multiplies a scalar value by a specified vector.
        
        :param left: The scaled value.
        :param right: The vector.
        :returns: The scaled vector.
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Negates a specified vector.
        
        :param value: The vector to negate.
        :returns: The negated vector.
        """
        ...

    @staticmethod
    def Normalize(value: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns a vector with the same direction as the specified vector, but with a length of one.
        
        :param value: The vector to normalize.
        :returns: The normalized vector.
        """
        ...

    @staticmethod
    def Reflect(vector: System.Numerics.Vector3, normal: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns the reflection of a vector off a surface that has the specified normal.
        
        :param vector: The source vector.
        :param normal: The normal of the surface being reflected off.
        :returns: The reflected vector.
        """
        ...

    @staticmethod
    def SquareRoot(value: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Returns a vector whose elements are the square root of each of a specified vector's elements.
        
        :param value: A vector.
        :returns: The square root vector.
        """
        ...

    @staticmethod
    def Subtract(left: System.Numerics.Vector3, right: System.Numerics.Vector3) -> System.Numerics.Vector3:
        """
        Subtracts the second vector from the first.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The difference vector.
        """
        ...

    @overload
    def ToString(self) -> str:
        """
        Returns the string representation of the current instance using default formatting.
        
        :returns: The string representation of the current instance.
        """
        ...

    @overload
    def ToString(self, format: str) -> str:
        """
        Returns the string representation of the current instance using the specified format string to format individual elements.
        
        :param format: A standard or custom numeric format string that defines the format of individual elements.
        :returns: The string representation of the current instance.
        """
        ...

    @overload
    def ToString(self, format: str, formatProvider: System.IFormatProvider) -> str:
        """
        Returns the string representation of the current instance using the specified format string to format individual elements and the specified format provider to define culture-specific formatting.
        
        :param format: A standard or custom numeric format string that defines the format of individual elements.
        :param formatProvider: A format provider that supplies culture-specific formatting information.
        :returns: The string representation of the current instance.
        """
        ...

    @staticmethod
    @overload
    def Transform(position: System.Numerics.Vector3, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector3:
        """
        Transforms a vector by a specified 4x4 matrix.
        
        :param position: The vector to transform.
        :param matrix: The transformation matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(value: System.Numerics.Vector3, rotation: System.Numerics.Quaternion) -> System.Numerics.Vector3:
        """
        Transforms a vector by the specified Quaternion rotation value.
        
        :param value: The vector to rotate.
        :param rotation: The rotation to apply.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    def TransformNormal(normal: System.Numerics.Vector3, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector3:
        """
        Transforms a vector normal by the given 4x4 matrix.
        
        :param normal: The source vector.
        :param matrix: The matrix.
        :returns: The transformed vector.
        """
        ...

    def TryCopyTo(self, destination: System.Span[float]) -> bool:
        """
        Attempts to copy the vector to the given Span{Single}. The length of the destination span must be at least 3.
        
        :param destination: The destination span which the values are copied into.
        :returns: true if the source vector was successfully copied to . false if  is not large enough to hold the source vector.
        """
        ...


class Plane(System.IEquatable[System_Numerics_Plane]):
    """Represents a plane in three-dimensional space."""

    @property
    def Normal(self) -> System.Numerics.Vector3:
        """The normal vector of the plane."""
        ...

    @Normal.setter
    def Normal(self, value: System.Numerics.Vector3):
        """The normal vector of the plane."""
        ...

    @property
    def D(self) -> float:
        """The distance of the plane along its normal from the origin."""
        ...

    @D.setter
    def D(self, value: float):
        """The distance of the plane along its normal from the origin."""
        ...

    @overload
    def __init__(self, x: float, y: float, z: float, d: float) -> None:
        """
        Creates a System.Numerics.Plane object from the X, Y, and Z components of its normal, and its distance from the origin on that normal.
        
        :param x: The X component of the normal.
        :param y: The Y component of the normal.
        :param z: The Z component of the normal.
        :param d: The distance of the plane along its normal from the origin.
        """
        ...

    @overload
    def __init__(self, normal: System.Numerics.Vector3, d: float) -> None:
        """
        Creates a System.Numerics.Plane object from a specified normal and the distance along the normal from the origin.
        
        :param normal: The plane's normal vector.
        :param d: The plane's distance from the origin along its normal vector.
        """
        ...

    @overload
    def __init__(self, value: System.Numerics.Vector4) -> None:
        """
        Creates a System.Numerics.Plane object from a specified four-dimensional vector.
        
        :param value: A vector whose first three elements describe the normal vector, and whose System.Numerics.Vector4.W defines the distance along that normal from the origin.
        """
        ...

    @staticmethod
    def CreateFromVertices(point1: System.Numerics.Vector3, point2: System.Numerics.Vector3, point3: System.Numerics.Vector3) -> System.Numerics.Plane:
        """
        Creates a System.Numerics.Plane object that contains three specified points.
        
        :param point1: The first point defining the plane.
        :param point2: The second point defining the plane.
        :param point3: The third point defining the plane.
        :returns: The plane containing the three points.
        """
        ...

    @staticmethod
    def Dot(plane: System.Numerics.Plane, value: System.Numerics.Vector4) -> float:
        """
        Calculates the dot product of a plane and a 4-dimensional vector.
        
        :param plane: The plane.
        :param value: The four-dimensional vector.
        :returns: The dot product.
        """
        ...

    @staticmethod
    def DotCoordinate(plane: System.Numerics.Plane, value: System.Numerics.Vector3) -> float:
        """
        Returns the dot product of a specified three-dimensional vector and the normal vector of this plane plus the distance (System.Numerics.Plane.D) value of the plane.
        
        :param plane: The plane.
        :param value: The 3-dimensional vector.
        :returns: The dot product.
        """
        ...

    @staticmethod
    def DotNormal(plane: System.Numerics.Plane, value: System.Numerics.Vector3) -> float:
        """
        Returns the dot product of a specified three-dimensional vector and the System.Numerics.Plane.Normal vector of this plane.
        
        :param plane: The plane.
        :param value: The three-dimensional vector.
        :returns: The dot product.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Plane) -> bool:
        """
        Returns a value that indicates whether this instance and another plane object are equal.
        
        :param other: The other plane.
        :returns: true if the two planes are equal; otherwise, false.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    @staticmethod
    def Normalize(value: System.Numerics.Plane) -> System.Numerics.Plane:
        """
        Creates a new System.Numerics.Plane object whose normal vector is the source plane's normal vector normalized.
        
        :param value: The source plane.
        :returns: The normalized plane.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string representation of this plane object.
        
        :returns: A string that represents this System.Numerics.Plane object.
        """
        ...

    @staticmethod
    @overload
    def Transform(plane: System.Numerics.Plane, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Plane:
        """
        Transforms a normalized plane by a 4x4 matrix.
        
        :param plane: The normalized plane to transform.
        :param matrix: The transformation matrix to apply to .
        :returns: The transformed plane.
        """
        ...

    @staticmethod
    @overload
    def Transform(plane: System.Numerics.Plane, rotation: System.Numerics.Quaternion) -> System.Numerics.Plane:
        """
        Transforms a normalized plane by a Quaternion rotation.
        
        :param plane: The normalized plane to transform.
        :param rotation: The Quaternion rotation to apply to the plane.
        :returns: A new plane that results from applying the Quaternion rotation.
        """
        ...


class Matrix4x4(System.IEquatable[System_Numerics_Matrix4x4]):
    """Represents a 4x4 matrix."""

    @property
    def M11(self) -> float:
        """The first element of the first row."""
        ...

    @M11.setter
    def M11(self, value: float):
        """The first element of the first row."""
        ...

    @property
    def M12(self) -> float:
        """The second element of the first row."""
        ...

    @M12.setter
    def M12(self, value: float):
        """The second element of the first row."""
        ...

    @property
    def M13(self) -> float:
        """The third element of the first row."""
        ...

    @M13.setter
    def M13(self, value: float):
        """The third element of the first row."""
        ...

    @property
    def M14(self) -> float:
        """The fourth element of the first row."""
        ...

    @M14.setter
    def M14(self, value: float):
        """The fourth element of the first row."""
        ...

    @property
    def M21(self) -> float:
        """The first element of the second row."""
        ...

    @M21.setter
    def M21(self, value: float):
        """The first element of the second row."""
        ...

    @property
    def M22(self) -> float:
        """The second element of the second row."""
        ...

    @M22.setter
    def M22(self, value: float):
        """The second element of the second row."""
        ...

    @property
    def M23(self) -> float:
        """The third element of the second row."""
        ...

    @M23.setter
    def M23(self, value: float):
        """The third element of the second row."""
        ...

    @property
    def M24(self) -> float:
        """The fourth element of the second row."""
        ...

    @M24.setter
    def M24(self, value: float):
        """The fourth element of the second row."""
        ...

    @property
    def M31(self) -> float:
        """The first element of the third row."""
        ...

    @M31.setter
    def M31(self, value: float):
        """The first element of the third row."""
        ...

    @property
    def M32(self) -> float:
        """The second element of the third row."""
        ...

    @M32.setter
    def M32(self, value: float):
        """The second element of the third row."""
        ...

    @property
    def M33(self) -> float:
        """The third element of the third row."""
        ...

    @M33.setter
    def M33(self, value: float):
        """The third element of the third row."""
        ...

    @property
    def M34(self) -> float:
        """The fourth element of the third row."""
        ...

    @M34.setter
    def M34(self, value: float):
        """The fourth element of the third row."""
        ...

    @property
    def M41(self) -> float:
        """The first element of the fourth row."""
        ...

    @M41.setter
    def M41(self, value: float):
        """The first element of the fourth row."""
        ...

    @property
    def M42(self) -> float:
        """The second element of the fourth row."""
        ...

    @M42.setter
    def M42(self, value: float):
        """The second element of the fourth row."""
        ...

    @property
    def M43(self) -> float:
        """The third element of the fourth row."""
        ...

    @M43.setter
    def M43(self, value: float):
        """The third element of the fourth row."""
        ...

    @property
    def M44(self) -> float:
        """The fourth element of the fourth row."""
        ...

    @M44.setter
    def M44(self, value: float):
        """The fourth element of the fourth row."""
        ...

    Identity: System.Numerics.Matrix4x4
    """Gets the multiplicative identity matrix."""

    @property
    def IsIdentity(self) -> bool:
        """Indicates whether the current matrix is the identity matrix."""
        ...

    @property
    def Translation(self) -> System.Numerics.Vector3:
        """Gets or sets the translation component of this matrix."""
        ...

    @Translation.setter
    def Translation(self, value: System.Numerics.Vector3):
        """Gets or sets the translation component of this matrix."""
        ...

    def __getitem__(self, row: int, column: int) -> float:
        ...

    @overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None:
        """
        Creates a 4x4 matrix from the specified components.
        
        :param m11: The value to assign to the first element in the first row.
        :param m12: The value to assign to the second element in the first row.
        :param m13: The value to assign to the third element in the first row.
        :param m14: The value to assign to the fourth element in the first row.
        :param m21: The value to assign to the first element in the second row.
        :param m22: The value to assign to the second element in the second row.
        :param m23: The value to assign to the third element in the second row.
        :param m24: The value to assign to the third element in the second row.
        :param m31: The value to assign to the first element in the third row.
        :param m32: The value to assign to the second element in the third row.
        :param m33: The value to assign to the third element in the third row.
        :param m34: The value to assign to the fourth element in the third row.
        :param m41: The value to assign to the first element in the fourth row.
        :param m42: The value to assign to the second element in the fourth row.
        :param m43: The value to assign to the third element in the fourth row.
        :param m44: The value to assign to the fourth element in the fourth row.
        """
        ...

    @overload
    def __init__(self, value: System.Numerics.Matrix3x2) -> None:
        """
        Creates a System.Numerics.Matrix4x4 object from a specified System.Numerics.Matrix3x2 object.
        
        :param value: A 3x2 matrix.
        """
        ...

    def __setitem__(self, row: int, column: int, value: float) -> None:
        ...

    @staticmethod
    def Add(value1: System.Numerics.Matrix4x4, value2: System.Numerics.Matrix4x4) -> System.Numerics.Matrix4x4:
        """
        Adds each element in one matrix with its corresponding element in a second matrix.
        
        :param value1: The first matrix.
        :param value2: The second matrix.
        :returns: The matrix that contains the summed values of  and .
        """
        ...

    @staticmethod
    def CreateBillboard(objectPosition: System.Numerics.Vector3, cameraPosition: System.Numerics.Vector3, cameraUpVector: System.Numerics.Vector3, cameraForwardVector: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a spherical billboard that rotates around a specified object position.
        
        :param objectPosition: The position of the object that the billboard will rotate around.
        :param cameraPosition: The position of the camera.
        :param cameraUpVector: The up vector of the camera.
        :param cameraForwardVector: The forward vector of the camera.
        :returns: The created billboard.
        """
        ...

    @staticmethod
    def CreateConstrainedBillboard(objectPosition: System.Numerics.Vector3, cameraPosition: System.Numerics.Vector3, rotateAxis: System.Numerics.Vector3, cameraForwardVector: System.Numerics.Vector3, objectForwardVector: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a cylindrical billboard that rotates around a specified axis.
        
        :param objectPosition: The position of the object that the billboard will rotate around.
        :param cameraPosition: The position of the camera.
        :param rotateAxis: The axis to rotate the billboard around.
        :param cameraForwardVector: The forward vector of the camera.
        :param objectForwardVector: The forward vector of the object.
        :returns: The billboard matrix.
        """
        ...

    @staticmethod
    def CreateFromAxisAngle(axis: System.Numerics.Vector3, angle: float) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix that rotates around an arbitrary vector.
        
        :param axis: The axis to rotate around.
        :param angle: The angle to rotate around , in radians.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    def CreateFromQuaternion(quaternion: System.Numerics.Quaternion) -> System.Numerics.Matrix4x4:
        """
        Creates a rotation matrix from the specified Quaternion rotation value.
        
        :param quaternion: The source Quaternion.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    def CreateFromYawPitchRoll(yaw: float, pitch: float, roll: float) -> System.Numerics.Matrix4x4:
        """
        Creates a rotation matrix from the specified yaw, pitch, and roll.
        
        :param yaw: The angle of rotation, in radians, around the Y axis.
        :param pitch: The angle of rotation, in radians, around the X axis.
        :param roll: The angle of rotation, in radians, around the Z axis.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    def CreateLookAt(cameraPosition: System.Numerics.Vector3, cameraTarget: System.Numerics.Vector3, cameraUpVector: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a view matrix.
        
        :param cameraPosition: The position of the camera.
        :param cameraTarget: The target towards which the camera is pointing.
        :param cameraUpVector: The direction that is "up" from the camera's point of view.
        :returns: The view matrix.
        """
        ...

    @staticmethod
    def CreateOrthographic(width: float, height: float, zNearPlane: float, zFarPlane: float) -> System.Numerics.Matrix4x4:
        """
        Creates an orthographic perspective matrix from the given view volume dimensions.
        
        :param width: The width of the view volume.
        :param height: The height of the view volume.
        :param zNearPlane: The minimum Z-value of the view volume.
        :param zFarPlane: The maximum Z-value of the view volume.
        :returns: The orthographic projection matrix.
        """
        ...

    @staticmethod
    def CreateOrthographicOffCenter(left: float, right: float, bottom: float, top: float, zNearPlane: float, zFarPlane: float) -> System.Numerics.Matrix4x4:
        """
        Creates a customized orthographic projection matrix.
        
        :param left: The minimum X-value of the view volume.
        :param right: The maximum X-value of the view volume.
        :param bottom: The minimum Y-value of the view volume.
        :param top: The maximum Y-value of the view volume.
        :param zNearPlane: The minimum Z-value of the view volume.
        :param zFarPlane: The maximum Z-value of the view volume.
        :returns: The orthographic projection matrix.
        """
        ...

    @staticmethod
    def CreatePerspective(width: float, height: float, nearPlaneDistance: float, farPlaneDistance: float) -> System.Numerics.Matrix4x4:
        """
        Creates a perspective projection matrix from the given view volume dimensions.
        
        :param width: The width of the view volume at the near view plane.
        :param height: The height of the view volume at the near view plane.
        :param nearPlaneDistance: The distance to the near view plane.
        :param farPlaneDistance: The distance to the far view plane.
        :returns: The perspective projection matrix.
        """
        ...

    @staticmethod
    def CreatePerspectiveFieldOfView(fieldOfView: float, aspectRatio: float, nearPlaneDistance: float, farPlaneDistance: float) -> System.Numerics.Matrix4x4:
        """
        Creates a perspective projection matrix based on a field of view, aspect ratio, and near and far view plane distances.
        
        :param fieldOfView: The field of view in the y direction, in radians.
        :param aspectRatio: The aspect ratio, defined as view space width divided by height.
        :param nearPlaneDistance: The distance to the near view plane.
        :param farPlaneDistance: The distance to the far view plane.
        :returns: The perspective projection matrix.
        """
        ...

    @staticmethod
    def CreatePerspectiveOffCenter(left: float, right: float, bottom: float, top: float, nearPlaneDistance: float, farPlaneDistance: float) -> System.Numerics.Matrix4x4:
        """
        Creates a customized perspective projection matrix.
        
        :param left: The minimum x-value of the view volume at the near view plane.
        :param right: The maximum x-value of the view volume at the near view plane.
        :param bottom: The minimum y-value of the view volume at the near view plane.
        :param top: The maximum y-value of the view volume at the near view plane.
        :param nearPlaneDistance: The distance to the near view plane.
        :param farPlaneDistance: The distance to the far view plane.
        :returns: The perspective projection matrix.
        """
        ...

    @staticmethod
    def CreateReflection(value: System.Numerics.Plane) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix that reflects the coordinate system about a specified plane.
        
        :param value: The plane about which to create a reflection.
        :returns: A new matrix expressing the reflection.
        """
        ...

    @staticmethod
    @overload
    def CreateRotationX(radians: float) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix for rotating points around the X axis.
        
        :param radians: The amount, in radians, by which to rotate around the X axis.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateRotationX(radians: float, centerPoint: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix for rotating points around the X axis from a center point.
        
        :param radians: The amount, in radians, by which to rotate around the X axis.
        :param centerPoint: The center point.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateRotationY(radians: float) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix for rotating points around the Y axis.
        
        :param radians: The amount, in radians, by which to rotate around the Y-axis.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateRotationY(radians: float, centerPoint: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        The amount, in radians, by which to rotate around the Y axis from a center point.
        
        :param radians: The amount, in radians, by which to rotate around the Y-axis.
        :param centerPoint: The center point.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateRotationZ(radians: float) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix for rotating points around the Z axis.
        
        :param radians: The amount, in radians, by which to rotate around the Z-axis.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateRotationZ(radians: float, centerPoint: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix for rotating points around the Z axis from a center point.
        
        :param radians: The amount, in radians, by which to rotate around the Z-axis.
        :param centerPoint: The center point.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(xScale: float, yScale: float, zScale: float) -> System.Numerics.Matrix4x4:
        """
        Creates a scaling matrix from the specified X, Y, and Z components.
        
        :param xScale: The value to scale by on the X axis.
        :param yScale: The value to scale by on the Y axis.
        :param zScale: The value to scale by on the Z axis.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(xScale: float, yScale: float, zScale: float, centerPoint: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a scaling matrix that is offset by a given center point.
        
        :param xScale: The value to scale by on the X axis.
        :param yScale: The value to scale by on the Y axis.
        :param zScale: The value to scale by on the Z axis.
        :param centerPoint: The center point.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scales: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a scaling matrix from the specified vector scale.
        
        :param scales: The scale to use.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scales: System.Numerics.Vector3, centerPoint: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a scaling matrix with a center point.
        
        :param scales: The vector that contains the amount to scale on each axis.
        :param centerPoint: The center point.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scale: float) -> System.Numerics.Matrix4x4:
        """
        Creates a uniform scaling matrix that scale equally on each axis.
        
        :param scale: The uniform scaling factor.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scale: float, centerPoint: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a uniform scaling matrix that scales equally on each axis with a center point.
        
        :param scale: The uniform scaling factor.
        :param centerPoint: The center point.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    def CreateShadow(lightDirection: System.Numerics.Vector3, plane: System.Numerics.Plane) -> System.Numerics.Matrix4x4:
        """
        Creates a matrix that flattens geometry into a specified plane as if casting a shadow from a specified light source.
        
        :param lightDirection: The direction from which the light that will cast the shadow is coming.
        :param plane: The plane onto which the new matrix should flatten geometry so as to cast a shadow.
        :returns: A new matrix that can be used to flatten geometry onto the specified plane from the specified direction.
        """
        ...

    @staticmethod
    @overload
    def CreateTranslation(position: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a translation matrix from the specified 3-dimensional vector.
        
        :param position: The amount to translate in each axis.
        :returns: The translation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateTranslation(xPosition: float, yPosition: float, zPosition: float) -> System.Numerics.Matrix4x4:
        """
        Creates a translation matrix from the specified X, Y, and Z components.
        
        :param xPosition: The amount to translate on the X axis.
        :param yPosition: The amount to translate on the Y axis.
        :param zPosition: The amount to translate on the Z axis.
        :returns: The translation matrix.
        """
        ...

    @staticmethod
    def CreateWorld(position: System.Numerics.Vector3, forward: System.Numerics.Vector3, up: System.Numerics.Vector3) -> System.Numerics.Matrix4x4:
        """
        Creates a world matrix with the specified parameters.
        
        :param position: The position of the object.
        :param forward: The forward direction of the object.
        :param up: The upward direction of the object. Its value is usually [0, 1, 0].
        :returns: The world matrix.
        """
        ...

    @staticmethod
    def Decompose(matrix: System.Numerics.Matrix4x4, scale: typing.Optional[System.Numerics.Vector3], rotation: typing.Optional[System.Numerics.Quaternion], translation: typing.Optional[System.Numerics.Vector3]) -> typing.Union[bool, System.Numerics.Vector3, System.Numerics.Quaternion, System.Numerics.Vector3]:
        """
        Attempts to extract the scale, translation, and rotation components from the given scale, rotation, or translation matrix. The return value indicates whether the operation succeeded.
        
        :param matrix: The source matrix.
        :param scale: When this method returns, contains the scaling component of the transformation matrix if the operation succeeded.
        :param rotation: When this method returns, contains the rotation component of the transformation matrix if the operation succeeded.
        :param translation: When the method returns, contains the translation component of the transformation matrix if the operation succeeded.
        :returns: true if  was decomposed successfully; otherwise,  false.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Matrix4x4) -> bool:
        """
        Returns a value that indicates whether this instance and another 4x4 matrix are equal.
        
        :param other: The other matrix.
        :returns: true if the two matrices are equal; otherwise, false.
        """
        ...

    def GetDeterminant(self) -> float:
        """
        Calculates the determinant of the current 4x4 matrix.
        
        :returns: The determinant.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    @staticmethod
    def Invert(matrix: System.Numerics.Matrix4x4, result: typing.Optional[System.Numerics.Matrix4x4]) -> typing.Union[bool, System.Numerics.Matrix4x4]:
        """
        Tries to invert the specified matrix. The return value indicates whether the operation succeeded.
        
        :param matrix: The matrix to invert.
        :param result: When this method returns, contains the inverted matrix if the operation succeeded.
        :returns: true if  was converted successfully; otherwise,  false.
        """
        ...

    @staticmethod
    def Lerp(matrix1: System.Numerics.Matrix4x4, matrix2: System.Numerics.Matrix4x4, amount: float) -> System.Numerics.Matrix4x4:
        """
        Performs a linear interpolation from one matrix to a second matrix based on a value that specifies the weighting of the second matrix.
        
        :param matrix1: The first matrix.
        :param matrix2: The second matrix.
        :param amount: The relative weighting of .
        :returns: The interpolated matrix.
        """
        ...

    @staticmethod
    @overload
    def Multiply(value1: System.Numerics.Matrix4x4, value2: System.Numerics.Matrix4x4) -> System.Numerics.Matrix4x4:
        """
        Multiplies two matrices together to compute the product.
        
        :param value1: The first matrix.
        :param value2: The second matrix.
        :returns: The product matrix.
        """
        ...

    @staticmethod
    @overload
    def Multiply(value1: System.Numerics.Matrix4x4, value2: float) -> System.Numerics.Matrix4x4:
        """
        Multiplies a matrix by a float to compute the product.
        
        :param value1: The matrix to scale.
        :param value2: The scaling value to use.
        :returns: The scaled matrix.
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Matrix4x4) -> System.Numerics.Matrix4x4:
        """
        Negates the specified matrix by multiplying all its values by -1.
        
        :param value: The matrix to negate.
        :returns: The negated matrix.
        """
        ...

    @staticmethod
    def Subtract(value1: System.Numerics.Matrix4x4, value2: System.Numerics.Matrix4x4) -> System.Numerics.Matrix4x4:
        """
        Subtracts each element in a second matrix from its corresponding element in a first matrix.
        
        :param value1: The first matrix.
        :param value2: The second matrix.
        :returns: The matrix containing the values that result from subtracting each element in  from its corresponding element in .
        """
        ...

    def ToString(self) -> str:
        """
        Returns a string that represents this matrix.
        
        :returns: The string representation of this matrix.
        """
        ...

    @staticmethod
    def Transform(value: System.Numerics.Matrix4x4, rotation: System.Numerics.Quaternion) -> System.Numerics.Matrix4x4:
        """
        Transforms the specified matrix by applying the specified Quaternion rotation.
        
        :param value: The matrix to transform.
        :param rotation: The rotation t apply.
        :returns: The transformed matrix.
        """
        ...

    @staticmethod
    def Transpose(matrix: System.Numerics.Matrix4x4) -> System.Numerics.Matrix4x4:
        """
        Transposes the rows and columns of a matrix.
        
        :param matrix: The matrix to transpose.
        :returns: The transposed matrix.
        """
        ...


class Quaternion(System.IEquatable[System_Numerics_Quaternion]):
    """Represents a vector that is used to encode three-dimensional physical rotations."""

    @property
    def X(self) -> float:
        """The X value of the vector component of the quaternion."""
        ...

    @X.setter
    def X(self, value: float):
        """The X value of the vector component of the quaternion."""
        ...

    @property
    def Y(self) -> float:
        """The Y value of the vector component of the quaternion."""
        ...

    @Y.setter
    def Y(self, value: float):
        """The Y value of the vector component of the quaternion."""
        ...

    @property
    def Z(self) -> float:
        """The Z value of the vector component of the quaternion."""
        ...

    @Z.setter
    def Z(self, value: float):
        """The Z value of the vector component of the quaternion."""
        ...

    @property
    def W(self) -> float:
        """The rotation component of the quaternion."""
        ...

    @W.setter
    def W(self, value: float):
        """The rotation component of the quaternion."""
        ...

    Count: int = 4

    Zero: System.Numerics.Quaternion
    """Gets a quaternion that represents a zero."""

    Identity: System.Numerics.Quaternion
    """Gets a quaternion that represents no rotation."""

    @property
    def IsIdentity(self) -> bool:
        """Gets a value that indicates whether the current instance is the identity quaternion."""
        ...

    def __getitem__(self, index: int) -> float:
        ...

    @overload
    def __init__(self, x: float, y: float, z: float, w: float) -> None:
        """
        Constructs a quaternion from the specified components.
        
        :param x: The value to assign to the X component of the quaternion.
        :param y: The value to assign to the Y component of the quaternion.
        :param z: The value to assign to the Z component of the quaternion.
        :param w: The value to assign to the W component of the quaternion.
        """
        ...

    @overload
    def __init__(self, vectorPart: System.Numerics.Vector3, scalarPart: float) -> None:
        """
        Creates a quaternion from the specified vector and rotation parts.
        
        :param vectorPart: The vector part of the quaternion.
        :param scalarPart: The rotation part of the quaternion.
        """
        ...

    def __setitem__(self, index: int, value: float) -> None:
        ...

    @staticmethod
    def Add(value1: System.Numerics.Quaternion, value2: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Adds each element in one quaternion with its corresponding element in a second quaternion.
        
        :param value1: The first quaternion.
        :param value2: The second quaternion.
        :returns: The quaternion that contains the summed values of  and .
        """
        ...

    @staticmethod
    def Concatenate(value1: System.Numerics.Quaternion, value2: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Concatenates two quaternions.
        
        :param value1: The first quaternion rotation in the series.
        :param value2: The second quaternion rotation in the series.
        :returns: A new quaternion representing the concatenation of the  rotation followed by the  rotation.
        """
        ...

    @staticmethod
    def Conjugate(value: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Returns the conjugate of a specified quaternion.
        
        :param value: The quaternion.
        :returns: A new quaternion that is the conjugate of value.
        """
        ...

    @staticmethod
    def CreateFromAxisAngle(axis: System.Numerics.Vector3, angle: float) -> System.Numerics.Quaternion:
        """
        Creates a quaternion from a unit vector and an angle to rotate around the vector.
        
        :param axis: The unit vector to rotate around.
        :param angle: The angle, in radians, to rotate around the vector.
        :returns: The newly created quaternion.
        """
        ...

    @staticmethod
    def CreateFromRotationMatrix(matrix: System.Numerics.Matrix4x4) -> System.Numerics.Quaternion:
        """
        Creates a quaternion from the specified rotation matrix.
        
        :param matrix: The rotation matrix.
        :returns: The newly created quaternion.
        """
        ...

    @staticmethod
    def CreateFromYawPitchRoll(yaw: float, pitch: float, roll: float) -> System.Numerics.Quaternion:
        """
        Creates a new quaternion from the given yaw, pitch, and roll.
        
        :param yaw: The yaw angle, in radians, around the Y axis.
        :param pitch: The pitch angle, in radians, around the X axis.
        :param roll: The roll angle, in radians, around the Z axis.
        :returns: The resulting quaternion.
        """
        ...

    @staticmethod
    def Divide(value1: System.Numerics.Quaternion, value2: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Divides one quaternion by a second quaternion.
        
        :param value1: The dividend.
        :param value2: The divisor.
        :returns: The quaternion that results from dividing  by .
        """
        ...

    @staticmethod
    def Dot(quaternion1: System.Numerics.Quaternion, quaternion2: System.Numerics.Quaternion) -> float:
        """
        Calculates the dot product of two quaternions.
        
        :param quaternion1: The first quaternion.
        :param quaternion2: The second quaternion.
        :returns: The dot product.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Quaternion) -> bool:
        """
        Returns a value that indicates whether this instance and another quaternion are equal.
        
        :param other: The other quaternion.
        :returns: true if the two quaternions are equal; otherwise, false.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    @staticmethod
    def Inverse(value: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Returns the inverse of a quaternion.
        
        :param value: The quaternion.
        :returns: The inverted quaternion.
        """
        ...

    def Length(self) -> float:
        """
        Calculates the length of the quaternion.
        
        :returns: The computed length of the quaternion.
        """
        ...

    def LengthSquared(self) -> float:
        """
        Calculates the squared length of the quaternion.
        
        :returns: The length squared of the quaternion.
        """
        ...

    @staticmethod
    def Lerp(quaternion1: System.Numerics.Quaternion, quaternion2: System.Numerics.Quaternion, amount: float) -> System.Numerics.Quaternion:
        """
        Performs a linear interpolation between two quaternions based on a value that specifies the weighting of the second quaternion.
        
        :param quaternion1: The first quaternion.
        :param quaternion2: The second quaternion.
        :param amount: The relative weight of  in the interpolation.
        :returns: The interpolated quaternion.
        """
        ...

    @staticmethod
    @overload
    def Multiply(value1: System.Numerics.Quaternion, value2: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Returns the quaternion that results from multiplying two quaternions together.
        
        :param value1: The first quaternion.
        :param value2: The second quaternion.
        :returns: The product quaternion.
        """
        ...

    @staticmethod
    @overload
    def Multiply(value1: System.Numerics.Quaternion, value2: float) -> System.Numerics.Quaternion:
        """
        Returns the quaternion that results from scaling all the components of a specified quaternion by a scalar factor.
        
        :param value1: The source quaternion.
        :param value2: The scalar value.
        :returns: The scaled quaternion.
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Reverses the sign of each component of the quaternion.
        
        :param value: The quaternion to negate.
        :returns: The negated quaternion.
        """
        ...

    @staticmethod
    def Normalize(value: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Divides each component of a specified System.Numerics.Quaternion by its length.
        
        :param value: The quaternion to normalize.
        :returns: The normalized quaternion.
        """
        ...

    @staticmethod
    def Slerp(quaternion1: System.Numerics.Quaternion, quaternion2: System.Numerics.Quaternion, amount: float) -> System.Numerics.Quaternion:
        """
        Interpolates between two quaternions, using spherical linear interpolation.
        
        :param quaternion1: The first quaternion.
        :param quaternion2: The second quaternion.
        :param amount: The relative weight of the second quaternion in the interpolation.
        :returns: The interpolated quaternion.
        """
        ...

    @staticmethod
    def Subtract(value1: System.Numerics.Quaternion, value2: System.Numerics.Quaternion) -> System.Numerics.Quaternion:
        """
        Subtracts each element in a second quaternion from its corresponding element in a first quaternion.
        
        :param value1: The first quaternion.
        :param value2: The second quaternion.
        :returns: The quaternion containing the values that result from subtracting each element in  from its corresponding element in .
        """
        ...

    def ToString(self) -> str:
        """
        Returns a string that represents this quaternion.
        
        :returns: The string representation of this quaternion.
        """
        ...


class Vector2(System.IEquatable[System_Numerics_Vector2], System.IFormattable):
    """Represents a vector with two single-precision floating-point values."""

    @property
    def X(self) -> float:
        """The X component of the vector."""
        ...

    @X.setter
    def X(self, value: float):
        """The X component of the vector."""
        ...

    @property
    def Y(self) -> float:
        """The Y component of the vector."""
        ...

    @Y.setter
    def Y(self, value: float):
        """The Y component of the vector."""
        ...

    Count: int = 2

    Zero: System.Numerics.Vector2
    """Returns a vector whose 2 elements are equal to zero."""

    One: System.Numerics.Vector2
    """Gets a vector whose 2 elements are equal to one."""

    UnitX: System.Numerics.Vector2
    """Gets the vector (1,0)."""

    UnitY: System.Numerics.Vector2
    """Gets the vector (0,1)."""

    def __getitem__(self, index: int) -> float:
        ...

    @overload
    def __init__(self, value: float) -> None:
        """
        Creates a new System.Numerics.Vector2 object whose two elements have the same value.
        
        :param value: The value to assign to both elements.
        """
        ...

    @overload
    def __init__(self, x: float, y: float) -> None:
        """
        Creates a vector whose elements have the specified values.
        
        :param x: The value to assign to the System.Numerics.Vector2.X field.
        :param y: The value to assign to the System.Numerics.Vector2.Y field.
        """
        ...

    @overload
    def __init__(self, values: System.ReadOnlySpan[float]) -> None:
        """
        Constructs a vector from the given ReadOnlySpan{Single}. The span must contain at least 2 elements.
        
        :param values: The span of elements to assign to the vector.
        """
        ...

    def __setitem__(self, index: int, value: float) -> None:
        ...

    @staticmethod
    def Abs(value: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns a vector whose elements are the absolute values of each of the specified vector's elements.
        
        :param value: A vector.
        :returns: The absolute value vector.
        """
        ...

    @staticmethod
    def Add(left: System.Numerics.Vector2, right: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Adds two vectors together.
        
        :param left: The first vector to add.
        :param right: The second vector to add.
        :returns: The summed vector.
        """
        ...

    @staticmethod
    def Clamp(value1: System.Numerics.Vector2, min: System.Numerics.Vector2, max: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Restricts a vector between a minimum and a maximum value.
        
        :param value1: The vector to restrict.
        :param min: The minimum value.
        :param max: The maximum value.
        :returns: The restricted vector.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[float]) -> None:
        """
        Copies the elements of the vector to a specified array.
        
        :param array: The destination array.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[float], index: int) -> None:
        """
        Copies the elements of the vector to a specified array starting at a specified index position.
        
        :param array: The destination array.
        :param index: The index at which to copy the first element of the vector.
        """
        ...

    @overload
    def CopyTo(self, destination: System.Span[float]) -> None:
        """
        Copies the vector to the given Span{T}.The length of the destination span must be at least 2.
        
        :param destination: The destination span which the values are copied into.
        """
        ...

    @staticmethod
    def Distance(value1: System.Numerics.Vector2, value2: System.Numerics.Vector2) -> float:
        """
        Computes the Euclidean distance between the two given points.
        
        :param value1: The first point.
        :param value2: The second point.
        :returns: The distance.
        """
        ...

    @staticmethod
    def DistanceSquared(value1: System.Numerics.Vector2, value2: System.Numerics.Vector2) -> float:
        """
        Returns the Euclidean distance squared between two specified points.
        
        :param value1: The first point.
        :param value2: The second point.
        :returns: The distance squared.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Numerics.Vector2, right: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Divides the first vector by the second.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The vector resulting from the division.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Numerics.Vector2, divisor: float) -> System.Numerics.Vector2:
        """
        Divides the specified vector by a specified scalar value.
        
        :param left: The vector.
        :param divisor: The scalar value.
        :returns: The vector that results from the division.
        """
        ...

    @staticmethod
    def Dot(value1: System.Numerics.Vector2, value2: System.Numerics.Vector2) -> float:
        """
        Returns the dot product of two vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The dot product.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Vector2) -> bool:
        """
        Returns a value that indicates whether this instance and another vector are equal.
        
        :param other: The other vector.
        :returns: true if the two vectors are equal; otherwise, false.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    def Length(self) -> float:
        """
        Returns the length of the vector.
        
        :returns: The vector's length.
        """
        ...

    def LengthSquared(self) -> float:
        """
        Returns the length of the vector squared.
        
        :returns: The vector's length squared.
        """
        ...

    @staticmethod
    def Lerp(value1: System.Numerics.Vector2, value2: System.Numerics.Vector2, amount: float) -> System.Numerics.Vector2:
        """
        Performs a linear interpolation between two vectors based on the given weighting.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :param amount: A value between 0 and 1 that indicates the weight of .
        :returns: The interpolated vector.
        """
        ...

    @staticmethod
    def Max(value1: System.Numerics.Vector2, value2: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns a vector whose elements are the maximum of each of the pairs of elements in two specified vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The maximized vector.
        """
        ...

    @staticmethod
    def Min(value1: System.Numerics.Vector2, value2: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns a vector whose elements are the minimum of each of the pairs of elements in two specified vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The minimized vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector2, right: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns a new vector whose values are the product of each pair of elements in two specified vectors.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The element-wise product vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector2, right: float) -> System.Numerics.Vector2:
        """
        Multiplies a vector by a specified scalar.
        
        :param left: The vector to multiply.
        :param right: The scalar value.
        :returns: The scaled vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: float, right: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Multiplies a scalar value by a specified vector.
        
        :param left: The scaled value.
        :param right: The vector.
        :returns: The scaled vector.
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Negates a specified vector.
        
        :param value: The vector to negate.
        :returns: The negated vector.
        """
        ...

    @staticmethod
    def Normalize(value: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns a vector with the same direction as the specified vector, but with a length of one.
        
        :param value: The vector to normalize.
        :returns: The normalized vector.
        """
        ...

    @staticmethod
    def Reflect(vector: System.Numerics.Vector2, normal: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns the reflection of a vector off a surface that has the specified normal.
        
        :param vector: The source vector.
        :param normal: The normal of the surface being reflected off.
        :returns: The reflected vector.
        """
        ...

    @staticmethod
    def SquareRoot(value: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Returns a vector whose elements are the square root of each of a specified vector's elements.
        
        :param value: A vector.
        :returns: The square root vector.
        """
        ...

    @staticmethod
    def Subtract(left: System.Numerics.Vector2, right: System.Numerics.Vector2) -> System.Numerics.Vector2:
        """
        Subtracts the second vector from the first.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The difference vector.
        """
        ...

    @overload
    def ToString(self) -> str:
        """
        Returns the string representation of the current instance using default formatting.
        
        :returns: The string representation of the current instance.
        """
        ...

    @overload
    def ToString(self, format: str) -> str:
        """
        Returns the string representation of the current instance using the specified format string to format individual elements.
        
        :param format: A standard or custom numeric format string that defines the format of individual elements.
        :returns: The string representation of the current instance.
        """
        ...

    @overload
    def ToString(self, format: str, formatProvider: System.IFormatProvider) -> str:
        """
        Returns the string representation of the current instance using the specified format string to format individual elements and the specified format provider to define culture-specific formatting.
        
        :param format: A standard or custom numeric format string that defines the format of individual elements.
        :param formatProvider: A format provider that supplies culture-specific formatting information.
        :returns: The string representation of the current instance.
        """
        ...

    @staticmethod
    @overload
    def Transform(position: System.Numerics.Vector2, matrix: System.Numerics.Matrix3x2) -> System.Numerics.Vector2:
        """
        Transforms a vector by a specified 3x2 matrix.
        
        :param position: The vector to transform.
        :param matrix: The transformation matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(position: System.Numerics.Vector2, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector2:
        """
        Transforms a vector by a specified 4x4 matrix.
        
        :param position: The vector to transform.
        :param matrix: The transformation matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(value: System.Numerics.Vector2, rotation: System.Numerics.Quaternion) -> System.Numerics.Vector2:
        """
        Transforms a vector by the specified Quaternion rotation value.
        
        :param value: The vector to rotate.
        :param rotation: The rotation to apply.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def TransformNormal(normal: System.Numerics.Vector2, matrix: System.Numerics.Matrix3x2) -> System.Numerics.Vector2:
        """
        Transforms a vector normal by the given 3x2 matrix.
        
        :param normal: The source vector.
        :param matrix: The matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def TransformNormal(normal: System.Numerics.Vector2, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector2:
        """
        Transforms a vector normal by the given 4x4 matrix.
        
        :param normal: The source vector.
        :param matrix: The matrix.
        :returns: The transformed vector.
        """
        ...

    def TryCopyTo(self, destination: System.Span[float]) -> bool:
        """
        Attempts to copy the vector to the given Span{Single}. The length of the destination span must be at least 2.
        
        :param destination: The destination span which the values are copied into.
        :returns: true if the source vector was successfully copied to . false if  is not large enough to hold the source vector.
        """
        ...


class Vector4(System.IEquatable[System_Numerics_Vector4], System.IFormattable):
    """Represents a vector with four single-precision floating-point values."""

    @property
    def X(self) -> float:
        """The X component of the vector."""
        ...

    @X.setter
    def X(self, value: float):
        """The X component of the vector."""
        ...

    @property
    def Y(self) -> float:
        """The Y component of the vector."""
        ...

    @Y.setter
    def Y(self, value: float):
        """The Y component of the vector."""
        ...

    @property
    def Z(self) -> float:
        """The Z component of the vector."""
        ...

    @Z.setter
    def Z(self, value: float):
        """The Z component of the vector."""
        ...

    @property
    def W(self) -> float:
        """The W component of the vector."""
        ...

    @W.setter
    def W(self, value: float):
        """The W component of the vector."""
        ...

    Count: int = 4

    Zero: System.Numerics.Vector4
    """Gets a vector whose 4 elements are equal to zero."""

    One: System.Numerics.Vector4
    """Gets a vector whose 4 elements are equal to one."""

    UnitX: System.Numerics.Vector4
    """Gets the vector (1,0,0,0)."""

    UnitY: System.Numerics.Vector4
    """Gets the vector (0,1,0,0)."""

    UnitZ: System.Numerics.Vector4
    """Gets the vector (0,0,1,0)."""

    UnitW: System.Numerics.Vector4
    """Gets the vector (0,0,0,1)."""

    def __getitem__(self, index: int) -> float:
        ...

    @overload
    def __init__(self, value: float) -> None:
        """
        Creates a new System.Numerics.Vector4 object whose four elements have the same value.
        
        :param value: The value to assign to all four elements.
        """
        ...

    @overload
    def __init__(self, value: System.Numerics.Vector2, z: float, w: float) -> None:
        """
        Creates a   new System.Numerics.Vector4 object from the specified System.Numerics.Vector2 object and a Z and a W component.
        
        :param value: The vector to use for the X and Y components.
        :param z: The Z component.
        :param w: The W component.
        """
        ...

    @overload
    def __init__(self, value: System.Numerics.Vector3, w: float) -> None:
        """
        Constructs a new System.Numerics.Vector4 object from the specified System.Numerics.Vector3 object and a W component.
        
        :param value: The vector to use for the X, Y, and Z components.
        :param w: The W component.
        """
        ...

    @overload
    def __init__(self, x: float, y: float, z: float, w: float) -> None:
        """
        Creates a vector whose elements have the specified values.
        
        :param x: The value to assign to the System.Numerics.Vector4.X field.
        :param y: The value to assign to the System.Numerics.Vector4.Y field.
        :param z: The value to assign to the System.Numerics.Vector4.Z field.
        :param w: The value to assign to the System.Numerics.Vector4.W field.
        """
        ...

    @overload
    def __init__(self, values: System.ReadOnlySpan[float]) -> None:
        """
        Constructs a vector from the given ReadOnlySpan{Single}. The span must contain at least 4 elements.
        
        :param values: The span of elements to assign to the vector.
        """
        ...

    def __setitem__(self, index: int, value: float) -> None:
        ...

    @staticmethod
    def Abs(value: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Returns a vector whose elements are the absolute values of each of the specified vector's elements.
        
        :param value: A vector.
        :returns: The absolute value vector.
        """
        ...

    @staticmethod
    def Add(left: System.Numerics.Vector4, right: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Adds two vectors together.
        
        :param left: The first vector to add.
        :param right: The second vector to add.
        :returns: The summed vector.
        """
        ...

    @staticmethod
    def Clamp(value1: System.Numerics.Vector4, min: System.Numerics.Vector4, max: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Restricts a vector between a minimum and a maximum value.
        
        :param value1: The vector to restrict.
        :param min: The minimum value.
        :param max: The maximum value.
        :returns: The restricted vector.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[float]) -> None:
        """
        Copies the elements of the vector to a specified array.
        
        :param array: The destination array.
        """
        ...

    @overload
    def CopyTo(self, array: typing.List[float], index: int) -> None:
        """
        Copies the elements of the vector to a specified array starting at a specified index position.
        
        :param array: The destination array.
        :param index: The index at which to copy the first element of the vector.
        """
        ...

    @overload
    def CopyTo(self, destination: System.Span[float]) -> None:
        """
        Copies the vector to the given Span{T}. The length of the destination span must be at least 4.
        
        :param destination: The destination span which the values are copied into.
        """
        ...

    @staticmethod
    def Distance(value1: System.Numerics.Vector4, value2: System.Numerics.Vector4) -> float:
        """
        Computes the Euclidean distance between the two given points.
        
        :param value1: The first point.
        :param value2: The second point.
        :returns: The distance.
        """
        ...

    @staticmethod
    def DistanceSquared(value1: System.Numerics.Vector4, value2: System.Numerics.Vector4) -> float:
        """
        Returns the Euclidean distance squared between two specified points.
        
        :param value1: The first point.
        :param value2: The second point.
        :returns: The distance squared.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Numerics.Vector4, right: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Divides the first vector by the second.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The vector resulting from the division.
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Numerics.Vector4, divisor: float) -> System.Numerics.Vector4:
        """
        Divides the specified vector by a specified scalar value.
        
        :param left: The vector.
        :param divisor: The scalar value.
        :returns: The vector that results from the division.
        """
        ...

    @staticmethod
    def Dot(vector1: System.Numerics.Vector4, vector2: System.Numerics.Vector4) -> float:
        """
        Returns the dot product of two vectors.
        
        :param vector1: The first vector.
        :param vector2: The second vector.
        :returns: The dot product.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Vector4) -> bool:
        """
        Returns a value that indicates whether this instance and another vector are equal.
        
        :param other: The other vector.
        :returns: true if the two vectors are equal; otherwise, false.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    def Length(self) -> float:
        """
        Returns the length of this vector object.
        
        :returns: The vector's length.
        """
        ...

    def LengthSquared(self) -> float:
        """
        Returns the length of the vector squared.
        
        :returns: The vector's length squared.
        """
        ...

    @staticmethod
    def Lerp(value1: System.Numerics.Vector4, value2: System.Numerics.Vector4, amount: float) -> System.Numerics.Vector4:
        """
        Performs a linear interpolation between two vectors based on the given weighting.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :param amount: A value between 0 and 1 that indicates the weight of .
        :returns: The interpolated vector.
        """
        ...

    @staticmethod
    def Max(value1: System.Numerics.Vector4, value2: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Returns a vector whose elements are the maximum of each of the pairs of elements in two specified vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The maximized vector.
        """
        ...

    @staticmethod
    def Min(value1: System.Numerics.Vector4, value2: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Returns a vector whose elements are the minimum of each of the pairs of elements in two specified vectors.
        
        :param value1: The first vector.
        :param value2: The second vector.
        :returns: The minimized vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector4, right: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Returns a new vector whose values are the product of each pair of elements in two specified vectors.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The element-wise product vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector4, right: float) -> System.Numerics.Vector4:
        """
        Multiplies a vector by a specified scalar.
        
        :param left: The vector to multiply.
        :param right: The scalar value.
        :returns: The scaled vector.
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: float, right: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Multiplies a scalar value by a specified vector.
        
        :param left: The scaled value.
        :param right: The vector.
        :returns: The scaled vector.
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Negates a specified vector.
        
        :param value: The vector to negate.
        :returns: The negated vector.
        """
        ...

    @staticmethod
    def Normalize(vector: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Returns a vector with the same direction as the specified vector, but with a length of one.
        
        :param vector: The vector to normalize.
        :returns: The normalized vector.
        """
        ...

    @staticmethod
    def SquareRoot(value: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Returns a vector whose elements are the square root of each of a specified vector's elements.
        
        :param value: A vector.
        :returns: The square root vector.
        """
        ...

    @staticmethod
    def Subtract(left: System.Numerics.Vector4, right: System.Numerics.Vector4) -> System.Numerics.Vector4:
        """
        Subtracts the second vector from the first.
        
        :param left: The first vector.
        :param right: The second vector.
        :returns: The difference vector.
        """
        ...

    @overload
    def ToString(self) -> str:
        """
        Returns the string representation of the current instance using default formatting.
        
        :returns: The string representation of the current instance.
        """
        ...

    @overload
    def ToString(self, format: str) -> str:
        """
        Returns the string representation of the current instance using the specified format string to format individual elements.
        
        :param format: A standard or custom numeric format string that defines the format of individual elements.
        :returns: The string representation of the current instance.
        """
        ...

    @overload
    def ToString(self, format: str, formatProvider: System.IFormatProvider) -> str:
        """
        Returns the string representation of the current instance using the specified format string to format individual elements and the specified format provider to define culture-specific formatting.
        
        :param format: A standard or custom numeric format string that defines the format of individual elements.
        :param formatProvider: A format provider that supplies culture-specific formatting information.
        :returns: The string representation of the current instance.
        """
        ...

    @staticmethod
    @overload
    def Transform(position: System.Numerics.Vector2, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector4:
        """
        Transforms a two-dimensional vector by a specified 4x4 matrix.
        
        :param position: The vector to transform.
        :param matrix: The transformation matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(value: System.Numerics.Vector2, rotation: System.Numerics.Quaternion) -> System.Numerics.Vector4:
        """
        Transforms a two-dimensional vector by the specified Quaternion rotation value.
        
        :param value: The vector to rotate.
        :param rotation: The rotation to apply.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(position: System.Numerics.Vector3, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector4:
        """
        Transforms a three-dimensional vector by a specified 4x4 matrix.
        
        :param position: The vector to transform.
        :param matrix: The transformation matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(value: System.Numerics.Vector3, rotation: System.Numerics.Quaternion) -> System.Numerics.Vector4:
        """
        Transforms a three-dimensional vector by the specified Quaternion rotation value.
        
        :param value: The vector to rotate.
        :param rotation: The rotation to apply.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(vector: System.Numerics.Vector4, matrix: System.Numerics.Matrix4x4) -> System.Numerics.Vector4:
        """
        Transforms a four-dimensional vector by a specified 4x4 matrix.
        
        :param vector: The vector to transform.
        :param matrix: The transformation matrix.
        :returns: The transformed vector.
        """
        ...

    @staticmethod
    @overload
    def Transform(value: System.Numerics.Vector4, rotation: System.Numerics.Quaternion) -> System.Numerics.Vector4:
        """
        Transforms a four-dimensional vector by the specified Quaternion rotation value.
        
        :param value: The vector to rotate.
        :param rotation: The rotation to apply.
        :returns: The transformed vector.
        """
        ...

    def TryCopyTo(self, destination: System.Span[float]) -> bool:
        """
        Attempts to copy the vector to the given Span{Single}. The length of the destination span must be at least 4.
        
        :param destination: The destination span which the values are copied into.
        :returns: true if the source vector was successfully copied to . false if  is not large enough to hold the source vector.
        """
        ...


class ILogarithmicFunctions(typing.Generic[System_Numerics_ILogarithmicFunctions_TSelf], System.Numerics.IFloatingPointConstants[System_Numerics_ILogarithmicFunctions_TSelf], metaclass=abc.ABCMeta):
    """Defines support for logarithmic functions."""

    @staticmethod
    @overload
    def Log(x: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the natural (base-E) logarithm of a value.
        
        :param x: The value whose natural logarithm is to be computed.
        :returns: loge().
        """
        ...

    @staticmethod
    @overload
    def Log(x: System_Numerics_ILogarithmicFunctions_TSelf, newBase: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the logarithm of a value in the specified base.
        
        :param x: The value whose logarithm is to be computed.
        :param newBase: The base in which the logarithm is to be computed.
        :returns: log().
        """
        ...

    @staticmethod
    def Log10(x: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the base-10 logarithm of a value.
        
        :param x: The value whose base-10 logarithm is to be computed.
        :returns: log10().
        """
        ...

    @staticmethod
    def Log10P1(x: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the base-10 logarithm of a value plus one.
        
        :param x: The value to which one is added before computing the base-10 logarithm.
        :returns: log10( + 1).
        """
        ...

    @staticmethod
    def Log2(x: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the base-2 logarithm of a value.
        
        :param x: The value whose base-2 logarithm is to be computed.
        :returns: log2().
        """
        ...

    @staticmethod
    def Log2P1(x: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the base-2 logarithm of a value plus one.
        
        :param x: The value to which one is added before computing the base-2 logarithm.
        :returns: log2( + 1).
        """
        ...

    @staticmethod
    def LogP1(x: System_Numerics_ILogarithmicFunctions_TSelf) -> System_Numerics_ILogarithmicFunctions_TSelf:
        """
        Computes the natural (base-E) logarithm of a value plus one.
        
        :param x: The value to which one is added before computing the natural logarithm.
        :returns: loge( + 1).
        """
        ...


class IExponentialFunctions(typing.Generic[System_Numerics_IExponentialFunctions_TSelf], System.Numerics.IFloatingPointConstants[System_Numerics_IExponentialFunctions_TSelf], metaclass=abc.ABCMeta):
    """Defines support for exponential functions."""

    @staticmethod
    def Exp(x: System_Numerics_IExponentialFunctions_TSelf) -> System_Numerics_IExponentialFunctions_TSelf:
        """
        Computes E raised to a given power.
        
        :param x: The power to which E is raised.
        :returns: E.
        """
        ...

    @staticmethod
    def Exp10(x: System_Numerics_IExponentialFunctions_TSelf) -> System_Numerics_IExponentialFunctions_TSelf:
        """
        Computes 10 raised to a given power.
        
        :param x: The power to which 10 is raised.
        :returns: 10.
        """
        ...

    @staticmethod
    def Exp10M1(x: System_Numerics_IExponentialFunctions_TSelf) -> System_Numerics_IExponentialFunctions_TSelf:
        """
        Computes 10 raised to a given power and subtracts one.
        
        :param x: The power to which 10 is raised.
        :returns: 10 - 1.
        """
        ...

    @staticmethod
    def Exp2(x: System_Numerics_IExponentialFunctions_TSelf) -> System_Numerics_IExponentialFunctions_TSelf:
        """
        Computes 2 raised to a given power.
        
        :param x: The power to which 2 is raised.
        :returns: 2.
        """
        ...

    @staticmethod
    def Exp2M1(x: System_Numerics_IExponentialFunctions_TSelf) -> System_Numerics_IExponentialFunctions_TSelf:
        """
        Computes 2 raised to a given power and subtracts one.
        
        :param x: The power to which 2 is raised.
        :returns: 2 - 1.
        """
        ...

    @staticmethod
    def ExpM1(x: System_Numerics_IExponentialFunctions_TSelf) -> System_Numerics_IExponentialFunctions_TSelf:
        """
        Computes E raised to a given power and subtracts one.
        
        :param x: The power to which E is raised.
        :returns: E - 1.
        """
        ...


class IRootFunctions(typing.Generic[System_Numerics_IRootFunctions_TSelf], System.Numerics.IFloatingPointConstants[System_Numerics_IRootFunctions_TSelf], metaclass=abc.ABCMeta):
    """Defines support for root functions."""

    @staticmethod
    def Cbrt(x: System_Numerics_IRootFunctions_TSelf) -> System_Numerics_IRootFunctions_TSelf:
        """
        Computes the cube-root of a value.
        
        :param x: The value whose cube-root is to be computed.
        :returns: The cube-root of .
        """
        ...

    @staticmethod
    def Hypot(x: System_Numerics_IRootFunctions_TSelf, y: System_Numerics_IRootFunctions_TSelf) -> System_Numerics_IRootFunctions_TSelf:
        """
        Computes the hypotenuse given two values representing the lengths of the shorter sides in a right-angled triangle.
        
        :param x: The value to square and add to .
        :param y: The value to square and add to .
        :returns: The square root of -squared plus -squared.
        """
        ...

    @staticmethod
    def RootN(x: System_Numerics_IRootFunctions_TSelf, n: int) -> System_Numerics_IRootFunctions_TSelf:
        """
        Computes the n-th root of a value.
        
        :param x: The value whose -th root is to be computed.
        :param n: The degree of the root to be computed.
        :returns: The -th root of .
        """
        ...

    @staticmethod
    def Sqrt(x: System_Numerics_IRootFunctions_TSelf) -> System_Numerics_IRootFunctions_TSelf:
        """
        Computes the square-root of a value.
        
        :param x: The value whose square-root is to be computed.
        :returns: The square-root of .
        """
        ...


class IBitwiseOperators(typing.Generic[System_Numerics_IBitwiseOperators_TSelf, System_Numerics_IBitwiseOperators_TOther, System_Numerics_IBitwiseOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for performing bitwise operations over two values."""


class IBinaryNumber(typing.Generic[System_Numerics_IBinaryNumber_TSelf], System.Numerics.IBitwiseOperators[System_Numerics_IBinaryNumber_TSelf, System_Numerics_IBinaryNumber_TSelf, System_Numerics_IBinaryNumber_TSelf], System.Numerics.INumber[System_Numerics_IBinaryNumber_TSelf], metaclass=abc.ABCMeta):
    """Defines a number that is represented in a base-2 format."""

    AllBitsSet: System_Numerics_IBinaryNumber_TSelf
    """Gets an instance of the binary type in which all bits are set."""

    @staticmethod
    def IsPow2(value: System_Numerics_IBinaryNumber_TSelf) -> bool:
        """
        Determines if a value is a power of two.
        
        :param value: The value to be checked.
        :returns: true if  is a power of two; otherwise, false.
        """
        ...

    @staticmethod
    def Log2(value: System_Numerics_IBinaryNumber_TSelf) -> System_Numerics_IBinaryNumber_TSelf:
        """
        Computes the log2 of a value.
        
        :param value: The value whose log2 is to be computed.
        :returns: The log2 of .
        """
        ...


class ITrigonometricFunctions(typing.Generic[System_Numerics_ITrigonometricFunctions_TSelf], System.Numerics.IFloatingPointConstants[System_Numerics_ITrigonometricFunctions_TSelf], metaclass=abc.ABCMeta):
    """Defines support for trigonometric functions."""

    @staticmethod
    def Acos(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the arc-cosine of a value.
        
        :param x: The value whose arc-cosine is to be computed.
        :returns: The arc-cosine of .
        """
        ...

    @staticmethod
    def AcosPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the arc-cosine of a value and divides the result by pi.
        
        :param x: The value whose arc-cosine is to be computed.
        :returns: The arc-cosine of , divided by pi.
        """
        ...

    @staticmethod
    def Asin(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the arc-sine of a value.
        
        :param x: The value whose arc-sine is to be computed.
        :returns: The arc-sine of .
        """
        ...

    @staticmethod
    def AsinPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the arc-sine of a value and divides the result by pi.
        
        :param x: The value whose arc-sine is to be computed.
        :returns: The arc-sine of , divided by pi.
        """
        ...

    @staticmethod
    def Atan(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the arc-tangent of a value.
        
        :param x: The value whose arc-tangent is to be computed.
        :returns: The arc-tangent of .
        """
        ...

    @staticmethod
    def AtanPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the arc-tangent of a value and divides the result by pi.
        
        :param x: The value whose arc-tangent is to be computed.
        :returns: The arc-tangent of , divided by pi.
        """
        ...

    @staticmethod
    def Cos(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the cosine of a value.
        
        :param x: The value, in radians, whose cosine is to be computed.
        :returns: The cosine of .
        """
        ...

    @staticmethod
    def CosPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the cosine of a value that has been multipled by pi.
        
        :param x: The value, in half-revolutions, whose cosine is to be computed.
        :returns: The cosine of  multiplied-by pi.
        """
        ...

    @staticmethod
    def Sin(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the sine of a value.
        
        :param x: The value, in radians, whose sine is to be computed.
        :returns: The sine of .
        """
        ...

    @staticmethod
    def SinCos(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System.ValueTuple[System_Numerics_ITrigonometricFunctions_TSelf, System_Numerics_ITrigonometricFunctions_TSelf]:
        """
        Computes the sine and cosine of a value.
        
        :param x: The value, in radians, whose sine and cosine are to be computed.
        :returns: The sine and cosine of .
        """
        ...

    @staticmethod
    def SinCosPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System.ValueTuple[System_Numerics_ITrigonometricFunctions_TSelf, System_Numerics_ITrigonometricFunctions_TSelf]:
        """
        Computes the sine and cosine of a value that has been multiplied by pi.
        
        :param x: The value, in half-revolutions, that is multipled by pi before computing its sine and cosine.
        :returns: The sine and cosine of multiplied-by pi.
        """
        ...

    @staticmethod
    def SinPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the sine of a value that has been multiplied by pi.
        
        :param x: The value, in half-revolutions, that is multipled by pi before computing its sine.
        :returns: The sine of  multiplied-by pi.
        """
        ...

    @staticmethod
    def Tan(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the tangent of a value.
        
        :param x: The value, in radians, whose tangent is to be computed.
        :returns: The tangent of .
        """
        ...

    @staticmethod
    def TanPi(x: System_Numerics_ITrigonometricFunctions_TSelf) -> System_Numerics_ITrigonometricFunctions_TSelf:
        """
        Computes the tangent of a value that has been multipled by pi.
        
        :param x: The value, in half-revolutions, that is multipled by pi before computing its tangent.
        :returns: The tangent of  multiplied-by pi.
        """
        ...


class IShiftOperators(typing.Generic[System_Numerics_IShiftOperators_TSelf, System_Numerics_IShiftOperators_TOther, System_Numerics_IShiftOperators_TResult], metaclass=abc.ABCMeta):
    """Defines a mechanism for shifting a value by another value."""


class Matrix3x2(System.IEquatable[System_Numerics_Matrix3x2]):
    """Represents a 3x2 matrix."""

    @property
    def M11(self) -> float:
        """The first element of the first row."""
        ...

    @M11.setter
    def M11(self, value: float):
        """The first element of the first row."""
        ...

    @property
    def M12(self) -> float:
        """The second element of the first row."""
        ...

    @M12.setter
    def M12(self, value: float):
        """The second element of the first row."""
        ...

    @property
    def M21(self) -> float:
        """The first element of the second row."""
        ...

    @M21.setter
    def M21(self, value: float):
        """The first element of the second row."""
        ...

    @property
    def M22(self) -> float:
        """The second element of the second row."""
        ...

    @M22.setter
    def M22(self, value: float):
        """The second element of the second row."""
        ...

    @property
    def M31(self) -> float:
        """The first element of the third row."""
        ...

    @M31.setter
    def M31(self, value: float):
        """The first element of the third row."""
        ...

    @property
    def M32(self) -> float:
        """The second element of the third row."""
        ...

    @M32.setter
    def M32(self, value: float):
        """The second element of the third row."""
        ...

    Identity: System.Numerics.Matrix3x2
    """Gets the multiplicative identity matrix."""

    @property
    def IsIdentity(self) -> bool:
        """Gets a value that indicates whether the current matrix is the identity matrix."""
        ...

    @property
    def Translation(self) -> System.Numerics.Vector2:
        """Gets or sets the translation component of this matrix."""
        ...

    @Translation.setter
    def Translation(self, value: System.Numerics.Vector2):
        """Gets or sets the translation component of this matrix."""
        ...

    def __getitem__(self, row: int, column: int) -> float:
        ...

    def __init__(self, m11: float, m12: float, m21: float, m22: float, m31: float, m32: float) -> None:
        """
        Creates a 3x2 matrix from the specified components.
        
        :param m11: The value to assign to the first element in the first row.
        :param m12: The value to assign to the second element in the first row.
        :param m21: The value to assign to the first element in the second row.
        :param m22: The value to assign to the second element in the second row.
        :param m31: The value to assign to the first element in the third row.
        :param m32: The value to assign to the second element in the third row.
        """
        ...

    def __setitem__(self, row: int, column: int, value: float) -> None:
        ...

    @staticmethod
    def Add(value1: System.Numerics.Matrix3x2, value2: System.Numerics.Matrix3x2) -> System.Numerics.Matrix3x2:
        """
        Adds each element in one matrix with its corresponding element in a second matrix.
        
        :param value1: The first matrix.
        :param value2: The second matrix.
        :returns: The matrix that contains the summed values of  and .
        """
        ...

    @staticmethod
    @overload
    def CreateRotation(radians: float) -> System.Numerics.Matrix3x2:
        """
        Creates a rotation matrix using the given rotation in radians.
        
        :param radians: The amount of rotation, in radians.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateRotation(radians: float, centerPoint: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a rotation matrix using the specified rotation in radians and a center point.
        
        :param radians: The amount of rotation, in radians.
        :param centerPoint: The center point.
        :returns: The rotation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scales: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a scaling matrix from the specified vector scale.
        
        :param scales: The scale to use.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(xScale: float, yScale: float) -> System.Numerics.Matrix3x2:
        """
        Creates a scaling matrix from the specified X and Y components.
        
        :param xScale: The value to scale by on the X axis.
        :param yScale: The value to scale by on the Y axis.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(xScale: float, yScale: float, centerPoint: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a scaling matrix that is offset by a given center point.
        
        :param xScale: The value to scale by on the X axis.
        :param yScale: The value to scale by on the Y axis.
        :param centerPoint: The center point.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scales: System.Numerics.Vector2, centerPoint: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a scaling matrix from the specified vector scale with an offset from the specified center point.
        
        :param scales: The scale to use.
        :param centerPoint: The center offset.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scale: float) -> System.Numerics.Matrix3x2:
        """
        Creates a scaling matrix that scales uniformly with the given scale.
        
        :param scale: The uniform scale to use.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateScale(scale: float, centerPoint: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a scaling matrix that scales uniformly with the specified scale with an offset from the specified center.
        
        :param scale: The uniform scale to use.
        :param centerPoint: The center offset.
        :returns: The scaling matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateSkew(radiansX: float, radiansY: float) -> System.Numerics.Matrix3x2:
        """
        Creates a skew matrix from the specified angles in radians.
        
        :param radiansX: The X angle, in radians.
        :param radiansY: The Y angle, in radians.
        :returns: The skew matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateSkew(radiansX: float, radiansY: float, centerPoint: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a skew matrix from the specified angles in radians and a center point.
        
        :param radiansX: The X angle, in radians.
        :param radiansY: The Y angle, in radians.
        :param centerPoint: The center point.
        :returns: The skew matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateTranslation(position: System.Numerics.Vector2) -> System.Numerics.Matrix3x2:
        """
        Creates a translation matrix from the specified 2-dimensional vector.
        
        :param position: The translation position.
        :returns: The translation matrix.
        """
        ...

    @staticmethod
    @overload
    def CreateTranslation(xPosition: float, yPosition: float) -> System.Numerics.Matrix3x2:
        """
        Creates a translation matrix from the specified X and Y components.
        
        :param xPosition: The X position.
        :param yPosition: The Y position.
        :returns: The translation matrix.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a value that indicates whether this instance and a specified object are equal.
        
        :param obj: The object to compare with the current instance.
        :returns: true if the current instance and  are equal; otherwise, false. If  is null, the method returns false.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Matrix3x2) -> bool:
        """
        Returns a value that indicates whether this instance and another 3x2 matrix are equal.
        
        :param other: The other matrix.
        :returns: true if the two matrices are equal; otherwise, false.
        """
        ...

    def GetDeterminant(self) -> float:
        """
        Calculates the determinant for this matrix.
        
        :returns: The determinant.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    @staticmethod
    def Invert(matrix: System.Numerics.Matrix3x2, result: typing.Optional[System.Numerics.Matrix3x2]) -> typing.Union[bool, System.Numerics.Matrix3x2]:
        """
        Tries to invert the specified matrix. The return value indicates whether the operation succeeded.
        
        :param matrix: The matrix to invert.
        :param result: When this method returns, contains the inverted matrix if the operation succeeded.
        :returns: true if  was converted successfully; otherwise,  false.
        """
        ...

    @staticmethod
    def Lerp(matrix1: System.Numerics.Matrix3x2, matrix2: System.Numerics.Matrix3x2, amount: float) -> System.Numerics.Matrix3x2:
        """
        Performs a linear interpolation from one matrix to a second matrix based on a value that specifies the weighting of the second matrix.
        
        :param matrix1: The first matrix.
        :param matrix2: The second matrix.
        :param amount: The relative weighting of .
        :returns: The interpolated matrix.
        """
        ...

    @staticmethod
    @overload
    def Multiply(value1: System.Numerics.Matrix3x2, value2: System.Numerics.Matrix3x2) -> System.Numerics.Matrix3x2:
        """
        Multiplies two matrices together to compute the product.
        
        :param value1: The first matrix.
        :param value2: The second matrix.
        :returns: The product matrix.
        """
        ...

    @staticmethod
    @overload
    def Multiply(value1: System.Numerics.Matrix3x2, value2: float) -> System.Numerics.Matrix3x2:
        """
        Multiplies a matrix by a float to compute the product.
        
        :param value1: The matrix to scale.
        :param value2: The scaling value to use.
        :returns: The scaled matrix.
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Matrix3x2) -> System.Numerics.Matrix3x2:
        """
        Negates the specified matrix by multiplying all its values by -1.
        
        :param value: The matrix to negate.
        :returns: The negated matrix.
        """
        ...

    @staticmethod
    def Subtract(value1: System.Numerics.Matrix3x2, value2: System.Numerics.Matrix3x2) -> System.Numerics.Matrix3x2:
        """
        Subtracts each element in a second matrix from its corresponding element in a first matrix.
        
        :param value1: The first matrix.
        :param value2: The second matrix.
        :returns: The matrix containing the values that result from subtracting each element in  from its corresponding element in .
        """
        ...

    def ToString(self) -> str:
        """
        Returns a string that represents this matrix.
        
        :returns: The string representation of this matrix.
        """
        ...


class Vector(typing.Generic[System_Numerics_Vector_T], System.IEquatable[System_Numerics_Vector], System.IFormattable):
    """This class has no documentation."""

    IsHardwareAccelerated: bool
    """Gets a value that indicates whether vector operations are subject to hardware acceleration through JIT intrinsic support."""

    @property
    def _00(self) -> int:
        ...

    @property
    def _01(self) -> int:
        ...

    AllBitsSet: System.Numerics.Vector[System_Numerics_Vector_T]
    """Gets a new Vector{T} with all bits set to 1."""

    Count: int
    """Gets the number of T that are in a Vector{T}."""

    IsSupported: bool
    """Gets true if T is supported; otherwise, false."""

    One: System.Numerics.Vector[System_Numerics_Vector_T]
    """Gets a new Vector{T} with all elements initialized to one."""

    Zero: System.Numerics.Vector[System_Numerics_Vector_T]
    """Gets a new Vector{T} with all elements initialized to zero."""

    @property
    def DisplayString(self) -> str:
        ...

    def __getitem__(self, index: int) -> System_Numerics_Vector_T:
        """
        Gets the element at the specified index.
        
        :param index: The index of the element to get.
        :returns: The value of the element at .
        """
        ...

    @overload
    def __init__(self, value: System_Numerics_Vector_T) -> None:
        """
        Creates a new Vector{T} instance with all elements initialized to the specified value.
        
        :param value: The value that all elements will be initialized to.
        :returns: A new Vector{T} with all elements initialized to .
        """
        ...

    @overload
    def __init__(self, values: typing.List[System_Numerics_Vector_T]) -> None:
        """
        Creates a new Vector{T} from a given array.
        
        :param values: The array from which the vector is created.
        :returns: A new Vector{T} with its elements set to the first Vector{T}.Count elements from .
        """
        ...

    @overload
    def __init__(self, values: typing.List[System_Numerics_Vector_T], index: int) -> None:
        """
        Creates a new Vector{T} from a given array.
        
        :param values: The array from which the vector is created.
        :param index: The index in  at which to being reading elements.
        :returns: A new Vector{T} with its elements set to the first Vector{T}.Count elements from .
        """
        ...

    @overload
    def __init__(self, values: System.ReadOnlySpan[System_Numerics_Vector_T]) -> None:
        """
        Creates a new Vector{T} from a given readonly span.
        
        :param values: The readonly span from which the vector is created.
        :returns: A new Vector{T} with its elements set to the first Vector{T}.Count elements from .
        """
        ...

    @overload
    def __init__(self, values: System.ReadOnlySpan[int]) -> None:
        """
        Creates a new Vector{T} from a given readonly span.
        
        :param values: The readonly span from which the vector is created.
        :returns: A new Vector{T} with its elements set to the first sizeof() elements from .
        """
        ...

    @overload
    def __init__(self, values: System.Span[System_Numerics_Vector_T]) -> None:
        """
        Creates a new Vector{T} from a given span.
        
        :param values: The span from which the vector is created.
        :returns: A new Vector{T} with its elements set to the first Vector{T}.Count elements from .
        """
        ...

    @staticmethod
    def Abs(value: System.Numerics.Vector[System_Numerics_Vector_Abs_T]) -> System.Numerics.Vector[System_Numerics_Vector_Abs_T]:
        """
        Computes the absolute value of each element in a vector.
        
        :param value: The vector that will have its absolute value computed.
        :returns: A vector whose elements are the absolute value of the elements in .
        """
        ...

    @staticmethod
    def Add(left: System.Numerics.Vector[System_Numerics_Vector_Add_T], right: System.Numerics.Vector[System_Numerics_Vector_Add_T]) -> System.Numerics.Vector[System_Numerics_Vector_Add_T]:
        """
        Adds two vectors to compute their sum.
        
        :param left: The vector to add with .
        :param right: The vector to add with .
        :returns: The sum of  and .
        """
        ...

    @staticmethod
    def AndNot(left: System.Numerics.Vector[System_Numerics_Vector_AndNot_T], right: System.Numerics.Vector[System_Numerics_Vector_AndNot_T]) -> System.Numerics.Vector[System_Numerics_Vector_AndNot_T]:
        """
        Computes the bitwise-and of a given vector and the ones complement of another vector.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to that is ones-complemented before being bitwise-and with .
        :returns: The bitwise-and of  and the ones-complement of .
        """
        ...

    @staticmethod
    def As(vector: System.Numerics.Vector[System_Numerics_Vector_As_TFrom]) -> System.Numerics.Vector[System_Numerics_Vector_As_TTo]:
        """
        Reinterprets a Vector64{T} as a new Vector64{U}.
        
        :param vector: The vector to reinterpret.
        :returns: reinterpreted as a new Vector64{U}.
        """
        ...

    @staticmethod
    def AsVectorByte(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorByte_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{Byte}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{Byte}.
        """
        ...

    @staticmethod
    def AsVectorDouble(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorDouble_T]) -> System.Numerics.Vector[float]:
        """
        Reinterprets a Vector{T} as a new Vector{Double}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{Double}.
        """
        ...

    @staticmethod
    def AsVectorInt16(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorInt16_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{Int16}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{Int16}.
        """
        ...

    @staticmethod
    def AsVectorInt32(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorInt32_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{Int32}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{Int32}.
        """
        ...

    @staticmethod
    def AsVectorInt64(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorInt64_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{Int64}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{Int64}.
        """
        ...

    @staticmethod
    def AsVectorNInt(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorNInt_T]) -> System.Numerics.Vector[System.IntPtr]:
        """
        Reinterprets a Vector{T} as a new Vector{IntPtr}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{IntPtr}.
        """
        ...

    @staticmethod
    def AsVectorNUInt(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorNUInt_T]) -> System.Numerics.Vector[System.UIntPtr]:
        """
        Reinterprets a Vector{T} as a new Vector{UIntPtr}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{UIntPtr}.
        """
        ...

    @staticmethod
    def AsVectorSByte(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorSByte_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{SByte}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{SByte}.
        """
        ...

    @staticmethod
    def AsVectorSingle(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorSingle_T]) -> System.Numerics.Vector[float]:
        """
        Reinterprets a Vector{T} as a new Vector{Single}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{Single}.
        """
        ...

    @staticmethod
    def AsVectorUInt16(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorUInt16_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{UInt16}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{UInt16}.
        """
        ...

    @staticmethod
    def AsVectorUInt32(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorUInt32_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{UInt32}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{UInt32}.
        """
        ...

    @staticmethod
    def AsVectorUInt64(value: System.Numerics.Vector[System_Numerics_Vector_AsVectorUInt64_T]) -> System.Numerics.Vector[int]:
        """
        Reinterprets a Vector{T} as a new Vector{UInt64}.
        
        :param value: The vector to reinterpret.
        :returns: reinterpreted as a new Vector{UInt64}.
        """
        ...

    @staticmethod
    def BitwiseAnd(left: System.Numerics.Vector[System_Numerics_Vector_BitwiseAnd_T], right: System.Numerics.Vector[System_Numerics_Vector_BitwiseAnd_T]) -> System.Numerics.Vector[System_Numerics_Vector_BitwiseAnd_T]:
        """
        Computes the bitwise-and of two vectors.
        
        :param left: The vector to bitwise-and with .
        :param right: The vector to bitwise-and with .
        :returns: The bitwise-and of  and .
        """
        ...

    @staticmethod
    def BitwiseOr(left: System.Numerics.Vector[System_Numerics_Vector_BitwiseOr_T], right: System.Numerics.Vector[System_Numerics_Vector_BitwiseOr_T]) -> System.Numerics.Vector[System_Numerics_Vector_BitwiseOr_T]:
        """
        Computes the bitwise-or of two vectors.
        
        :param left: The vector to bitwise-or with .
        :param right: The vector to bitwise-or with .
        :returns: The bitwise-or of  and .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param value: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Computes the ceiling of each element in a vector.
        
        :param value: The vector that will have its ceiling computed.
        :returns: A vector whose elements are the ceiling of the elements in .
        """
        ...

    @staticmethod
    @overload
    def ConditionalSelect(condition: System.Numerics.Vector[System_Numerics_Vector_ConditionalSelect_T], left: System.Numerics.Vector[System_Numerics_Vector_ConditionalSelect_T], right: System.Numerics.Vector[System_Numerics_Vector_ConditionalSelect_T]) -> System.Numerics.Vector[System_Numerics_Vector_ConditionalSelect_T]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConditionalSelect(condition: System.Numerics.Vector[int], left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConditionalSelect(condition: System.Numerics.Vector[int], left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Conditionally selects a value from two vectors on a bitwise basis.
        
        :param condition: The mask that is used to select a value from  or .
        :param left: The vector that is selected when the corresponding bit in  is one.
        :param right: The vector that is selected when the corresponding bit in  is zero.
        :returns: A vector whose bits come from  or  based on the value of .
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(value: System.Numerics.Vector[int]) -> System.Numerics.Vector[float]:
        """
        Converts a Vector{Int64} to a Vector{Double}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToDouble(value: System.Numerics.Vector[int]) -> System.Numerics.Vector[float]:
        """
        Converts a Vector{UInt64} to a Vector{Double}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt32(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Converts a Vector{Single} to a Vector{Int32}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToInt64(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Converts a Vector{Double} to a Vector{Int64}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(value: System.Numerics.Vector[int]) -> System.Numerics.Vector[float]:
        """
        Converts a Vector{Int32} to a Vector{Single}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    @overload
    def ConvertToSingle(value: System.Numerics.Vector[int]) -> System.Numerics.Vector[float]:
        """
        Converts a Vector{UInt32} to a Vector{Single}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt32(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Converts a Vector{Single} to a Vector{UInt32}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @staticmethod
    def ConvertToUInt64(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Converts a Vector{Double} to a Vector{UInt64}.
        
        :param value: The vector to convert.
        :returns: The converted vector.
        """
        ...

    @overload
    def CopyTo(self, destination: typing.List[System_Numerics_Vector_T]) -> None:
        """
        Copies a Vector{T} to a given array.
        
        :param destination: The array to which the current instance is copied.
        """
        ...

    @overload
    def CopyTo(self, destination: typing.List[System_Numerics_Vector_T], startIndex: int) -> None:
        """
        Copies a Vector{T} to a given array starting at the specified index.
        
        :param destination: The array to which the current instance is copied.
        :param startIndex: The starting index of  which current instance will be copied to.
        """
        ...

    @overload
    def CopyTo(self, destination: System.Span[int]) -> None:
        """
        Copies a Vector{T} to a given span.
        
        :param destination: The span to which the current instance is copied.
        """
        ...

    @overload
    def CopyTo(self, destination: System.Span[System_Numerics_Vector_T]) -> None:
        """
        Copies a Vector{T} to a given span.
        
        :param destination: The span to which the current instance is copied.
        """
        ...

    @staticmethod
    def Divide(left: System.Numerics.Vector[System_Numerics_Vector_Divide_T], right: System.Numerics.Vector[System_Numerics_Vector_Divide_T]) -> System.Numerics.Vector[System_Numerics_Vector_Divide_T]:
        """
        Divides two vectors to compute their quotient.
        
        :param left: The vector that will be divided by .
        :param right: The vector that will divide .
        :returns: The quotient of  divided by .
        """
        ...

    @staticmethod
    def Dot(left: System.Numerics.Vector[System_Numerics_Vector_Dot_T], right: System.Numerics.Vector[System_Numerics_Vector_Dot_T]) -> System_Numerics_Vector_Dot_T:
        """
        Computes the dot product of two vectors.
        
        :param left: The vector that will be dotted with .
        :param right: The vector that will be dotted with .
        :returns: The dot product of  and .
        """
        ...

    @staticmethod
    @overload
    def Equals(left: System.Numerics.Vector[System_Numerics_Vector_Equals_T], right: System.Numerics.Vector[System_Numerics_Vector_Equals_T]) -> System.Numerics.Vector[System_Numerics_Vector_Equals_T]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    @overload
    def Equals(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    @overload
    def Equals(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    @overload
    def Equals(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @staticmethod
    @overload
    def Equals(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine if they are equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if the corresponding elements in  and  were equal.
        """
        ...

    @overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns a boolean indicating whether the given Object is equal to this vector instance.
        
        :param obj: The Object to compare against.
        :returns: True if the Object is equal to this vector; False otherwise.
        """
        ...

    @overload
    def Equals(self, other: System.Numerics.Vector[System_Numerics_Vector_T]) -> bool:
        """
        Returns a boolean indicating whether the given vector is equal to this vector instance.
        
        :param other: The vector to compare this instance to.
        :returns: True if the other vector is equal to this instance; False otherwise.
        """
        ...

    @staticmethod
    def EqualsAll(left: System.Numerics.Vector[System_Numerics_Vector_EqualsAll_T], right: System.Numerics.Vector[System_Numerics_Vector_EqualsAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were equal to the corresponding element in .
        """
        ...

    @staticmethod
    def EqualsAny(left: System.Numerics.Vector[System_Numerics_Vector_EqualsAny_T], right: System.Numerics.Vector[System_Numerics_Vector_EqualsAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was equal to the corresponding element in .
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Computes the floor of each element in a vector.
        
        :param value: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Computes the floor of each element in a vector.
        
        :param value: The vector that will have its floor computed.
        :returns: A vector whose elements are the floor of the elements in .
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: The hash code.
        """
        ...

    @staticmethod
    @overload
    def GreaterThan(left: System.Numerics.Vector[System_Numerics_Vector_GreaterThan_T], right: System.Numerics.Vector[System_Numerics_Vector_GreaterThan_T]) -> System.Numerics.Vector[System_Numerics_Vector_GreaterThan_T]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    @overload
    def GreaterThan(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    @overload
    def GreaterThan(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    @overload
    def GreaterThan(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    @overload
    def GreaterThan(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater.
        """
        ...

    @staticmethod
    def GreaterThanAll(left: System.Numerics.Vector[System_Numerics_Vector_GreaterThanAll_T], right: System.Numerics.Vector[System_Numerics_Vector_GreaterThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanAny(left: System.Numerics.Vector[System_Numerics_Vector_GreaterThanAny_T], right: System.Numerics.Vector[System_Numerics_Vector_GreaterThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than the corresponding element in .
        """
        ...

    @staticmethod
    @overload
    def GreaterThanOrEqual(left: System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqual_T], right: System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqual_T]) -> System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqual_T]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    @overload
    def GreaterThanOrEqual(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    @overload
    def GreaterThanOrEqual(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    @overload
    def GreaterThanOrEqual(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    @overload
    def GreaterThanOrEqual(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is greater or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were greater or equal.
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAll(left: System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqualAll_T], right: System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def GreaterThanOrEqualAny(left: System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqualAny_T], right: System.Numerics.Vector[System_Numerics_Vector_GreaterThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are greater or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was greater than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    @overload
    def LessThan(left: System.Numerics.Vector[System_Numerics_Vector_LessThan_T], right: System.Numerics.Vector[System_Numerics_Vector_LessThan_T]) -> System.Numerics.Vector[System_Numerics_Vector_LessThan_T]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    @overload
    def LessThan(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    @overload
    def LessThan(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    @overload
    def LessThan(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    @overload
    def LessThan(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less.
        """
        ...

    @staticmethod
    def LessThanAll(left: System.Numerics.Vector[System_Numerics_Vector_LessThanAll_T], right: System.Numerics.Vector[System_Numerics_Vector_LessThanAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanAny(left: System.Numerics.Vector[System_Numerics_Vector_LessThanAny_T], right: System.Numerics.Vector[System_Numerics_Vector_LessThanAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than the corresponding element in .
        """
        ...

    @staticmethod
    @overload
    def LessThanOrEqual(left: System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqual_T], right: System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqual_T]) -> System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqual_T]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    @overload
    def LessThanOrEqual(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    @overload
    def LessThanOrEqual(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    @overload
    def LessThanOrEqual(left: System.Numerics.Vector[int], right: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    @overload
    def LessThanOrEqual(left: System.Numerics.Vector[float], right: System.Numerics.Vector[float]) -> System.Numerics.Vector[int]:
        """
        Compares two vectors to determine which is less or equal on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are all-bits-set or zero, depending on if which of the corresponding elements in  and  were less or equal.
        """
        ...

    @staticmethod
    def LessThanOrEqualAll(left: System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqualAll_T], right: System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqualAll_T]) -> bool:
        """
        Compares two vectors to determine if all elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if all elements in  were less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def LessThanOrEqualAny(left: System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqualAny_T], right: System.Numerics.Vector[System_Numerics_Vector_LessThanOrEqualAny_T]) -> bool:
        """
        Compares two vectors to determine if any elements are less or equal.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: true if any elements in  was less than or equal to the corresponding element in .
        """
        ...

    @staticmethod
    def Max(left: System.Numerics.Vector[System_Numerics_Vector_Max_T], right: System.Numerics.Vector[System_Numerics_Vector_Max_T]) -> System.Numerics.Vector[System_Numerics_Vector_Max_T]:
        """
        Computes the maximum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the maximum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    def Min(left: System.Numerics.Vector[System_Numerics_Vector_Min_T], right: System.Numerics.Vector[System_Numerics_Vector_Min_T]) -> System.Numerics.Vector[System_Numerics_Vector_Min_T]:
        """
        Computes the minimum of two vectors on a per-element basis.
        
        :param left: The vector to compare with .
        :param right: The vector to compare with .
        :returns: A vector whose elements are the minimum of the corresponding elements in  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector[System_Numerics_Vector_Multiply_T], right: System.Numerics.Vector[System_Numerics_Vector_Multiply_T]) -> System.Numerics.Vector[System_Numerics_Vector_Multiply_T]:
        """
        Multiplies two vectors to compute their element-wise product.
        
        :param left: The vector to multiply with .
        :param right: The vector to multiply with .
        :returns: The element-wise product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Numerics.Vector[System_Numerics_Vector_Multiply_T], right: System_Numerics_Vector_Multiply_T) -> System.Numerics.Vector[System_Numerics_Vector_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The vector to multiply with .
        :param right: The scalar to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System_Numerics_Vector_Multiply_T, right: System.Numerics.Vector[System_Numerics_Vector_Multiply_T]) -> System.Numerics.Vector[System_Numerics_Vector_Multiply_T]:
        """
        Multiplies a vector by a scalar to compute their product.
        
        :param left: The scalar to multiply with .
        :param right: The vector to multiply with .
        :returns: The product of  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[float], high: System.Numerics.Vector[float]) -> System.Numerics.Vector[float]:
        """
        Narrows two Vector{Double} instances into one Vector{Single}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{Single} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[int], high: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Narrows two Vector{Int16} instances into one Vector{SByte}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{SByte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[int], high: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Narrows two Vector{Int32} instances into one Vector{Int16}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{Int16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[int], high: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Narrows two Vector{Int64} instances into one Vector{Int32}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{Int32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[int], high: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Narrows two Vector{UInt16} instances into one Vector{Byte}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{Byte} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[int], high: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Narrows two Vector{UInt32} instances into one Vector{UInt16}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{UInt16} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    @overload
    def Narrow(low: System.Numerics.Vector[int], high: System.Numerics.Vector[int]) -> System.Numerics.Vector[int]:
        """
        Narrows two Vector{UInt64} instances into one Vector{UInt32}.
        
        :param low: The vector that will be narrowed to the lower half of the result vector.
        :param high: The vector that will be narrowed to the upper half of the result vector.
        :returns: A Vector{UInt32} containing elements narrowed from  and .
        """
        ...

    @staticmethod
    def Negate(value: System.Numerics.Vector[System_Numerics_Vector_Negate_T]) -> System.Numerics.Vector[System_Numerics_Vector_Negate_T]:
        """
        Computes the unary negation of a vector.
        
        :param value: The vector to negate.
        :returns: A vector whose elements are the unary negation of the corresponding elements in .
        """
        ...

    @staticmethod
    def OnesComplement(value: System.Numerics.Vector[System_Numerics_Vector_OnesComplement_T]) -> System.Numerics.Vector[System_Numerics_Vector_OnesComplement_T]:
        """
        Computes the ones-complement of a vector.
        
        :param value: The vector whose ones-complement is to be computed.
        :returns: A vector whose elements are the ones-complement of the corresponding elements in .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[System.IntPtr], shiftCount: int) -> System.Numerics.Vector[System.IntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[System.UIntPtr], shiftCount: int) -> System.Numerics.Vector[System.UIntPtr]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftLeft(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts each element of a vector left by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted left by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Numerics.Vector[System.IntPtr], shiftCount: int) -> System.Numerics.Vector[System.IntPtr]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (signed) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[System.IntPtr], shiftCount: int) -> System.Numerics.Vector[System.IntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[System.UIntPtr], shiftCount: int) -> System.Numerics.Vector[System.UIntPtr]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Numerics.Vector[int], shiftCount: int) -> System.Numerics.Vector[int]:
        """
        Shifts (unsigned) each element of a vector right by the specified amount.
        
        :param value: The vector whose elements are to be shifted.
        :param shiftCount: The number of bits by which to shift each element.
        :returns: A vector whose elements where shifted right by .
        """
        ...

    @staticmethod
    def SquareRoot(value: System.Numerics.Vector[System_Numerics_Vector_SquareRoot_T]) -> System.Numerics.Vector[System_Numerics_Vector_SquareRoot_T]:
        """
        Computes the square root of a vector on a per-element basis.
        
        :param value: The vector whose square root is to be computed.
        :returns: A vector whose elements are the square root of the corresponding elements in .
        """
        ...

    @staticmethod
    def Subtract(left: System.Numerics.Vector[System_Numerics_Vector_Subtract_T], right: System.Numerics.Vector[System_Numerics_Vector_Subtract_T]) -> System.Numerics.Vector[System_Numerics_Vector_Subtract_T]:
        """
        Subtracts two vectors to compute their difference.
        
        :param left: The vector from which  will be subtracted.
        :param right: The vector to subtract from .
        :returns: The difference of  and .
        """
        ...

    @staticmethod
    def Sum(value: System.Numerics.Vector[System_Numerics_Vector_Sum_T]) -> System_Numerics_Vector_Sum_T:
        """Returns the sum of all elements inside the vector."""
        ...

    @overload
    def ToString(self) -> str:
        """
        Returns a String representing this vector.
        
        :returns: The string representation.
        """
        ...

    @overload
    def ToString(self, format: str) -> str:
        """
        Returns a String representing this vector, using the specified format string to format individual elements.
        
        :param format: The format of individual elements.
        :returns: The string representation.
        """
        ...

    @overload
    def ToString(self, format: str, formatProvider: System.IFormatProvider) -> str:
        """
        Returns a String representing this vector, using the specified format string to format individual elements and the given IFormatProvider.
        
        :param format: The format of individual elements.
        :param formatProvider: The format provider to use when formatting elements.
        :returns: The string representation.
        """
        ...

    @overload
    def TryCopyTo(self, destination: System.Span[int]) -> bool:
        """
        Tries to copy a Vector{T} to a given span.
        
        :param destination: The span to which the current instance is copied.
        :returns: true if the current instance was successfully copied to ; otherwise, false if the length of  is less than sizeof().
        """
        ...

    @overload
    def TryCopyTo(self, destination: System.Span[System_Numerics_Vector_T]) -> bool:
        """
        Tries to copy a Vector{T} to a given span.
        
        :param destination: The span to which the current instance is copied.
        :returns: true if the current instance was successfully copied to ; otherwise, false if the length of  is less than Vector{T}.Count.
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[int], low: typing.Optional[System.Numerics.Vector[int]], high: typing.Optional[System.Numerics.Vector[int]]) -> typing.Union[None, System.Numerics.Vector[int], System.Numerics.Vector[int]]:
        """
        Widens a Vector{Byte} into two Vector{UInt16} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[int], low: typing.Optional[System.Numerics.Vector[int]], high: typing.Optional[System.Numerics.Vector[int]]) -> typing.Union[None, System.Numerics.Vector[int], System.Numerics.Vector[int]]:
        """
        Widens a Vector{Int16} into two Vector{Int32} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[int], low: typing.Optional[System.Numerics.Vector[int]], high: typing.Optional[System.Numerics.Vector[int]]) -> typing.Union[None, System.Numerics.Vector[int], System.Numerics.Vector[int]]:
        """
        Widens a Vector{Int32} into two Vector{Int64} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[int], low: typing.Optional[System.Numerics.Vector[int]], high: typing.Optional[System.Numerics.Vector[int]]) -> typing.Union[None, System.Numerics.Vector[int], System.Numerics.Vector[int]]:
        """
        Widens a Vector{SByte} into two Vector{Int16} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[float], low: typing.Optional[System.Numerics.Vector[float]], high: typing.Optional[System.Numerics.Vector[float]]) -> typing.Union[None, System.Numerics.Vector[float], System.Numerics.Vector[float]]:
        """
        Widens a Vector{Single} into two Vector{Double} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[int], low: typing.Optional[System.Numerics.Vector[int]], high: typing.Optional[System.Numerics.Vector[int]]) -> typing.Union[None, System.Numerics.Vector[int], System.Numerics.Vector[int]]:
        """
        Widens a Vector{UInt16} into two Vector{UInt32} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    @overload
    def Widen(source: System.Numerics.Vector[int], low: typing.Optional[System.Numerics.Vector[int]], high: typing.Optional[System.Numerics.Vector[int]]) -> typing.Union[None, System.Numerics.Vector[int], System.Numerics.Vector[int]]:
        """
        Widens a Vector{UInt32} into two Vector{UInt64} .
        
        :param source: The vector whose elements are to be widened.
        :param low: A vector that will contain the widened result of the lower half of .
        :param high: A vector that will contain the widened result of the upper half of .
        """
        ...

    @staticmethod
    def Xor(left: System.Numerics.Vector[System_Numerics_Vector_Xor_T], right: System.Numerics.Vector[System_Numerics_Vector_Xor_T]) -> System.Numerics.Vector[System_Numerics_Vector_Xor_T]:
        """
        Computes the exclusive-or of two vectors.
        
        :param left: The vector to exclusive-or with .
        :param right: The vector to exclusive-or with .
        :returns: The exclusive-or of  and .
        """
        ...


class IUnsignedNumber(typing.Generic[System_Numerics_IUnsignedNumber_TSelf], System.Numerics.INumberBase[System_Numerics_IUnsignedNumber_TSelf], metaclass=abc.ABCMeta):
    """Defines a number type which can only represent positive values, that is it cannot represent negative values."""


class IPowerFunctions(typing.Generic[System_Numerics_IPowerFunctions_TSelf], System.Numerics.INumberBase[System_Numerics_IPowerFunctions_TSelf], metaclass=abc.ABCMeta):
    """Defines support for power functions."""

    @staticmethod
    def Pow(x: System_Numerics_IPowerFunctions_TSelf, y: System_Numerics_IPowerFunctions_TSelf) -> System_Numerics_IPowerFunctions_TSelf:
        """
        Computes a value raised to a given power.
        
        :param x: The value which is raised to the power of .
        :param y: The power to which  is raised.
        :returns: raised to the power of .
        """
        ...


class IHyperbolicFunctions(typing.Generic[System_Numerics_IHyperbolicFunctions_TSelf], System.Numerics.IFloatingPointConstants[System_Numerics_IHyperbolicFunctions_TSelf], metaclass=abc.ABCMeta):
    """Defines support for hyperbolic functions."""

    @staticmethod
    def Acosh(x: System_Numerics_IHyperbolicFunctions_TSelf) -> System_Numerics_IHyperbolicFunctions_TSelf:
        """
        Computes the hyperbolic arc-cosine of a value.
        
        :param x: The value, in radians, whose hyperbolic arc-cosine is to be computed.
        :returns: The hyperbolic arc-cosine of .
        """
        ...

    @staticmethod
    def Asinh(x: System_Numerics_IHyperbolicFunctions_TSelf) -> System_Numerics_IHyperbolicFunctions_TSelf:
        """
        Computes the hyperbolic arc-sine of a value.
        
        :param x: The value, in radians, whose hyperbolic arc-sine is to be computed.
        :returns: The hyperbolic arc-sine of .
        """
        ...

    @staticmethod
    def Atanh(x: System_Numerics_IHyperbolicFunctions_TSelf) -> System_Numerics_IHyperbolicFunctions_TSelf:
        """
        Computes the hyperbolic arc-tangent of a value.
        
        :param x: The value, in radians, whose hyperbolic arc-tangent is to be computed.
        :returns: The hyperbolic arc-tangent of .
        """
        ...

    @staticmethod
    def Cosh(x: System_Numerics_IHyperbolicFunctions_TSelf) -> System_Numerics_IHyperbolicFunctions_TSelf:
        """
        Computes the hyperbolic cosine of a value.
        
        :param x: The value, in radians, whose hyperbolic cosine is to be computed.
        :returns: The hyperbolic cosine of .
        """
        ...

    @staticmethod
    def Sinh(x: System_Numerics_IHyperbolicFunctions_TSelf) -> System_Numerics_IHyperbolicFunctions_TSelf:
        """
        Computes the hyperbolic sine of a value.
        
        :param x: The value, in radians, whose hyperbolic sine is to be computed.
        :returns: The hyperbolic sine of .
        """
        ...

    @staticmethod
    def Tanh(x: System_Numerics_IHyperbolicFunctions_TSelf) -> System_Numerics_IHyperbolicFunctions_TSelf:
        """
        Computes the hyperbolic tangent of a value.
        
        :param x: The value, in radians, whose hyperbolic tangent is to be computed.
        :returns: The hyperbolic tangent of .
        """
        ...


class IFloatingPointIeee754(typing.Generic[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.IExponentialFunctions[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.IFloatingPoint[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.IHyperbolicFunctions[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.ILogarithmicFunctions[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.IPowerFunctions[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.IRootFunctions[System_Numerics_IFloatingPointIeee754_TSelf], System.Numerics.ITrigonometricFunctions[System_Numerics_IFloatingPointIeee754_TSelf], metaclass=abc.ABCMeta):
    """Defines an IEEE 754 floating-point type."""

    Epsilon: System_Numerics_IFloatingPointIeee754_TSelf
    """Gets the smallest value such that can be added to 0 that does not result in 0."""

    NaN: System_Numerics_IFloatingPointIeee754_TSelf
    """Gets a value that represents NaN."""

    NegativeInfinity: System_Numerics_IFloatingPointIeee754_TSelf
    """Gets a value that represents negative infinity."""

    NegativeZero: System_Numerics_IFloatingPointIeee754_TSelf
    """Gets a value that represents negative zero."""

    PositiveInfinity: System_Numerics_IFloatingPointIeee754_TSelf
    """Gets a value that represents positive infinity."""

    @staticmethod
    def Atan2(y: System_Numerics_IFloatingPointIeee754_TSelf, x: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes the arc-tangent for the quotient of two values.
        
        :param y: The y-coordinate of a point.
        :param x: The x-coordinate of a point.
        :returns: The arc-tangent of  divided-by .
        """
        ...

    @staticmethod
    def Atan2Pi(y: System_Numerics_IFloatingPointIeee754_TSelf, x: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes the arc-tangent for the quotient of two values and divides the result by pi.
        
        :param y: The y-coordinate of a point.
        :param x: The x-coordinate of a point.
        :returns: The arc-tangent of  divided-by , divided by pi.
        """
        ...

    @staticmethod
    def BitDecrement(x: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Decrements a value to the largest value that compares less than a given value.
        
        :param x: The value to be bitwise decremented.
        :returns: The largest value that compares less than .
        """
        ...

    @staticmethod
    def BitIncrement(x: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Increments a value to the smallest value that compares greater than a given value.
        
        :param x: The value to be bitwise incremented.
        :returns: The smallest value that compares greater than .
        """
        ...

    @staticmethod
    def FusedMultiplyAdd(left: System_Numerics_IFloatingPointIeee754_TSelf, right: System_Numerics_IFloatingPointIeee754_TSelf, addend: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes the fused multiply-add of three values.
        
        :param left: The value which  multiplies.
        :param right: The value which multiplies .
        :param addend: The value that is added to the product of  and .
        :returns: The result of  times  plus  computed as one ternary operation.
        """
        ...

    @staticmethod
    def Ieee754Remainder(left: System_Numerics_IFloatingPointIeee754_TSelf, right: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes the remainder of two values as specified by IEEE 754.
        
        :param left: The value which  divides.
        :param right: The value which divides .
        :returns: The remainder of  divided-by  as specified by IEEE 754.
        """
        ...

    @staticmethod
    def ILogB(x: System_Numerics_IFloatingPointIeee754_TSelf) -> int:
        """
        Computes the integer logarithm of a value.
        
        :param x: The value whose integer logarithm is to be computed.
        :returns: The integer logarithm of .
        """
        ...

    @staticmethod
    def ReciprocalEstimate(x: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes an estimate of the reciprocal of a value.
        
        :param x: The value whose estimate of the reciprocal is to be computed.
        :returns: An estimate of the reciprocal of .
        """
        ...

    @staticmethod
    def ReciprocalSqrtEstimate(x: System_Numerics_IFloatingPointIeee754_TSelf) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes an estimate of the reciprocal square root of a value.
        
        :param x: The value whose estimate of the reciprocal square root is to be computed.
        :returns: An estimate of the reciprocal square root of .
        """
        ...

    @staticmethod
    def ScaleB(x: System_Numerics_IFloatingPointIeee754_TSelf, n: int) -> System_Numerics_IFloatingPointIeee754_TSelf:
        """
        Computes the product of a value and its base-radix raised to the specified power.
        
        :param x: The value which base-radix raised to the power of  multiplies.
        :param n: The value to which base-radix is raised before multipliying .
        :returns: The product of  and base-radix raised to the power of .
        """
        ...


class IBinaryFloatingPointIeee754(typing.Generic[System_Numerics_IBinaryFloatingPointIeee754_TSelf], System.Numerics.IBinaryNumber[System_Numerics_IBinaryFloatingPointIeee754_TSelf], System.Numerics.IFloatingPointIeee754[System_Numerics_IBinaryFloatingPointIeee754_TSelf], metaclass=abc.ABCMeta):
    """Defines an IEEE 754 floating-point type that is represented in a base-2 format."""


class BitOperations(System.Object):
    """
    Utility methods for intrinsic bit-twiddling operations.
    The methods use hardware intrinsics when available on the underlying platform,
    otherwise they use optimized software fallbacks.
    """

    @staticmethod
    @overload
    def IsPow2(value: int) -> bool:
        """
        Evaluate whether a given integral value is a power of 2.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def IsPow2(value: int) -> bool:
        """
        Evaluate whether a given integral value is a power of 2.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def IsPow2(value: int) -> bool:
        """
        Evaluate whether a given integral value is a power of 2.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def IsPow2(value: int) -> bool:
        """
        Evaluate whether a given integral value is a power of 2.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def IsPow2(value: System.IntPtr) -> bool:
        """
        Evaluate whether a given integral value is a power of 2.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def IsPow2(value: System.UIntPtr) -> bool:
        """
        Evaluate whether a given integral value is a power of 2.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def LeadingZeroCount(value: int) -> int:
        """
        Count the number of leading zero bits in a mask.
        Similar in behavior to the x86 instruction LZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def LeadingZeroCount(value: int) -> int:
        """
        Count the number of leading zero bits in a mask.
        Similar in behavior to the x86 instruction LZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def LeadingZeroCount(value: System.UIntPtr) -> int:
        """
        Count the number of leading zero bits in a mask.
        Similar in behavior to the x86 instruction LZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def Log2(value: int) -> int:
        """
        Returns the integer (floor) log of the specified value, base 2.
        Note that by convention, input value 0 returns 0 since log(0) is undefined.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def Log2(value: int) -> int:
        """
        Returns the integer (floor) log of the specified value, base 2.
        Note that by convention, input value 0 returns 0 since log(0) is undefined.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def Log2(value: System.UIntPtr) -> int:
        """
        Returns the integer (floor) log of the specified value, base 2.
        Note that by convention, input value 0 returns 0 since log(0) is undefined.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def PopCount(value: int) -> int:
        """
        Returns the population count (number of bits set) of a mask.
        Similar in behavior to the x86 instruction POPCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def PopCount(value: int) -> int:
        """
        Returns the population count (number of bits set) of a mask.
        Similar in behavior to the x86 instruction POPCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def PopCount(value: System.UIntPtr) -> int:
        """
        Returns the population count (number of bits set) of a mask.
        Similar in behavior to the x86 instruction POPCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def RotateLeft(value: int, offset: int) -> int:
        """
        Rotates the specified value left by the specified number of bits.
        Similar in behavior to the x86 instruction ROL.
        
        :param value: The value to rotate.
        :param offset: The number of bits to rotate by. Any value outside the range [0..31] is treated as congruent mod 32.
        :returns: The rotated value.
        """
        ...

    @staticmethod
    @overload
    def RotateLeft(value: int, offset: int) -> int:
        """
        Rotates the specified value left by the specified number of bits.
        Similar in behavior to the x86 instruction ROL.
        
        :param value: The value to rotate.
        :param offset: The number of bits to rotate by. Any value outside the range [0..63] is treated as congruent mod 64.
        :returns: The rotated value.
        """
        ...

    @staticmethod
    @overload
    def RotateLeft(value: System.UIntPtr, offset: int) -> System.UIntPtr:
        """
        Rotates the specified value left by the specified number of bits.
        Similar in behavior to the x86 instruction ROL.
        
        :param value: The value to rotate.
        :param offset: The number of bits to rotate by. Any value outside the range [0..31] is treated as congruent mod 32 on a 32-bit process, and any value outside the range [0..63] is treated as congruent mod 64 on a 64-bit process.
        :returns: The rotated value.
        """
        ...

    @staticmethod
    @overload
    def RotateRight(value: int, offset: int) -> int:
        """
        Rotates the specified value right by the specified number of bits.
        Similar in behavior to the x86 instruction ROR.
        
        :param value: The value to rotate.
        :param offset: The number of bits to rotate by. Any value outside the range [0..31] is treated as congruent mod 32.
        :returns: The rotated value.
        """
        ...

    @staticmethod
    @overload
    def RotateRight(value: int, offset: int) -> int:
        """
        Rotates the specified value right by the specified number of bits.
        Similar in behavior to the x86 instruction ROR.
        
        :param value: The value to rotate.
        :param offset: The number of bits to rotate by. Any value outside the range [0..63] is treated as congruent mod 64.
        :returns: The rotated value.
        """
        ...

    @staticmethod
    @overload
    def RotateRight(value: System.UIntPtr, offset: int) -> System.UIntPtr:
        """
        Rotates the specified value right by the specified number of bits.
        Similar in behavior to the x86 instruction ROR.
        
        :param value: The value to rotate.
        :param offset: The number of bits to rotate by. Any value outside the range [0..31] is treated as congruent mod 32 on a 32-bit process, and any value outside the range [0..63] is treated as congruent mod 64 on a 64-bit process.
        :returns: The rotated value.
        """
        ...

    @staticmethod
    @overload
    def RoundUpToPowerOf2(value: int) -> int:
        """
        Round the given integral value up to a power of 2.
        
        :param value: The value.
        :returns: The smallest power of 2 which is greater than or equal to . If  is 0 or the result overflows, returns 0.
        """
        ...

    @staticmethod
    @overload
    def RoundUpToPowerOf2(value: int) -> int:
        """
        Round the given integral value up to a power of 2.
        
        :param value: The value.
        :returns: The smallest power of 2 which is greater than or equal to . If  is 0 or the result overflows, returns 0.
        """
        ...

    @staticmethod
    @overload
    def RoundUpToPowerOf2(value: System.UIntPtr) -> System.UIntPtr:
        """
        Round the given integral value up to a power of 2.
        
        :param value: The value.
        :returns: The smallest power of 2 which is greater than or equal to . If  is 0 or the result overflows, returns 0.
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: int) -> int:
        """
        Count the number of trailing zero bits in an integer value.
        Similar in behavior to the x86 instruction TZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: int) -> int:
        """
        Count the number of trailing zero bits in an integer value.
        Similar in behavior to the x86 instruction TZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: int) -> int:
        """
        Count the number of trailing zero bits in a mask.
        Similar in behavior to the x86 instruction TZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: int) -> int:
        """
        Count the number of trailing zero bits in a mask.
        Similar in behavior to the x86 instruction TZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: System.IntPtr) -> int:
        """
        Count the number of trailing zero bits in a mask.
        Similar in behavior to the x86 instruction TZCNT.
        
        :param value: The value.
        """
        ...

    @staticmethod
    @overload
    def TrailingZeroCount(value: System.UIntPtr) -> int:
        """
        Count the number of trailing zero bits in a mask.
        Similar in behavior to the x86 instruction TZCNT.
        
        :param value: The value.
        """
        ...


class IMinMaxValue(typing.Generic[System_Numerics_IMinMaxValue_TSelf], metaclass=abc.ABCMeta):
    """Defines a mechanism for getting the minimum and maximum value of a type."""

    MinValue: System_Numerics_IMinMaxValue_TSelf
    """Gets the minimum value of the current type."""

    MaxValue: System_Numerics_IMinMaxValue_TSelf
    """Gets the maximum value of the current type."""


class IBinaryInteger(typing.Generic[System_Numerics_IBinaryInteger_TSelf], System.Numerics.IBinaryNumber[System_Numerics_IBinaryInteger_TSelf], System.Numerics.IShiftOperators[System_Numerics_IBinaryInteger_TSelf, int, System_Numerics_IBinaryInteger_TSelf], metaclass=abc.ABCMeta):
    """Defines an integer type that is represented in a base-2 format."""

    @staticmethod
    def DivRem(left: System_Numerics_IBinaryInteger_TSelf, right: System_Numerics_IBinaryInteger_TSelf) -> System.ValueTuple[System_Numerics_IBinaryInteger_TSelf, System_Numerics_IBinaryInteger_TSelf]:
        """
        Computes the quotient and remainder of two values.
        
        :param left: The value which  divides.
        :param right: The value which divides .
        :returns: The quotient and remainder of  divided-by .
        """
        ...

    def GetByteCount(self) -> int:
        """
        Gets the number of bytes that will be written as part of TryWriteLittleEndian(Span{byte}, out int).
        
        :returns: The number of bytes that will be written as part of TryWriteLittleEndian(Span{byte}, out int).
        """
        ...

    def GetShortestBitLength(self) -> int:
        """
        Gets the length, in bits, of the shortest two's complement representation of the current value.
        
        :returns: The length, in bits, of the shortest two's complement representation of the current value.
        """
        ...

    @staticmethod
    def LeadingZeroCount(value: System_Numerics_IBinaryInteger_TSelf) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Computes the number of leading zeros in a value.
        
        :param value: The value whose leading zeroes are to be counted.
        :returns: The number of leading zeros in .
        """
        ...

    @staticmethod
    def PopCount(value: System_Numerics_IBinaryInteger_TSelf) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Computes the number of bits that are set in a value.
        
        :param value: The value whose set bits are to be counted.
        :returns: The number of set bits in .
        """
        ...

    @staticmethod
    @overload
    def ReadBigEndian(source: typing.List[int], isUnsigned: bool) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Reads a two's complement number from a given array, in big-endian format, and converts it to an instance of the current type.
        
        :param source: The array from which the two's complement number should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :returns: The value read from .
        """
        ...

    @staticmethod
    @overload
    def ReadBigEndian(source: typing.List[int], startIndex: int, isUnsigned: bool) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Reads a two's complement number from a given array, in big-endian format, and converts it to an instance of the current type.
        
        :param source: The array from which the two's complement number should be read.
        :param startIndex: The starting index from which the value should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :returns: The value read from  starting at .
        """
        ...

    @staticmethod
    @overload
    def ReadBigEndian(source: System.ReadOnlySpan[int], isUnsigned: bool) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Reads a two's complement number from a given span, in big-endian format, and converts it to an instance of the current type.
        
        :param source: The array from which the two's complement number should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :returns: The value read from .
        """
        ...

    @staticmethod
    @overload
    def ReadLittleEndian(source: typing.List[int], isUnsigned: bool) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Reads a two's complement number from a given array, in little-endian format, and converts it to an instance of the current type.
        
        :param source: The array from which the two's complement number should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :returns: The value read from .
        """
        ...

    @staticmethod
    @overload
    def ReadLittleEndian(source: typing.List[int], startIndex: int, isUnsigned: bool) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Reads a two's complement number from a given array, in little-endian format, and converts it to an instance of the current type.
        
        :param source: The array from which the two's complement number should be read.
        :param startIndex: The starting index from which the value should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :returns: The value read from  starting at .
        """
        ...

    @staticmethod
    @overload
    def ReadLittleEndian(source: System.ReadOnlySpan[int], isUnsigned: bool) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Reads a two's complement number from a given span, in little-endian format, and converts it to an instance of the current type.
        
        :param source: The array from which the two's complement number should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :returns: The value read from .
        """
        ...

    @staticmethod
    def RotateLeft(value: System_Numerics_IBinaryInteger_TSelf, rotateAmount: int) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Rotates a value left by a given amount.
        
        :param value: The value which is rotated left by .
        :param rotateAmount: The amount by which  is rotated left.
        :returns: The result of rotating  left by .
        """
        ...

    @staticmethod
    def RotateRight(value: System_Numerics_IBinaryInteger_TSelf, rotateAmount: int) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Rotates a value right by a given amount.
        
        :param value: The value which is rotated right by .
        :param rotateAmount: The amount by which  is rotated right.
        :returns: The result of rotating  right by .
        """
        ...

    @staticmethod
    def TrailingZeroCount(value: System_Numerics_IBinaryInteger_TSelf) -> System_Numerics_IBinaryInteger_TSelf:
        """
        Computes the number of trailing zeros in a value.
        
        :param value: The value whose trailing zeroes are to be counted.
        :returns: The number of trailing zeros in .
        """
        ...

    @staticmethod
    def TryReadBigEndian(source: System.ReadOnlySpan[int], isUnsigned: bool, value: typing.Optional[System_Numerics_IBinaryInteger_TSelf]) -> typing.Union[bool, System_Numerics_IBinaryInteger_TSelf]:
        """
        Tries to read a two's complement number from a span, in big-endian format, and convert it to an instance of the current type.
        
        :param source: The span from which the two's complement number should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :param value: On return, contains the value read from  or default if a value could not be read.
        :returns: true if the value was succesfully read from ; otherwise, false.
        """
        ...

    @staticmethod
    def TryReadLittleEndian(source: System.ReadOnlySpan[int], isUnsigned: bool, value: typing.Optional[System_Numerics_IBinaryInteger_TSelf]) -> typing.Union[bool, System_Numerics_IBinaryInteger_TSelf]:
        """
        Tries to read a two's complement number from a span, in little-endian format, and convert it to an instance of the current type.
        
        :param source: The span from which the two's complement number should be read.
        :param isUnsigned: true if  represents an unsigned two's complement number; otherwise, false to indicate it represents a signed two's complement number.
        :param value: On return, contains the value read from  or default if a value could not be read.
        :returns: true if the value was succesfully read from ; otherwise, false.
        """
        ...

    def TryWriteBigEndian(self, destination: System.Span[int], bytesWritten: typing.Optional[int]) -> typing.Union[bool, int]:
        """
        Tries to write the current value, in big-endian format, to a given span.
        
        :param destination: The span to which the current value should be written.
        :param bytesWritten: The number of bytes written to .
        :returns: true if the value was successfully written to ; otherwise, false.
        """
        ...

    def TryWriteLittleEndian(self, destination: System.Span[int], bytesWritten: typing.Optional[int]) -> typing.Union[bool, int]:
        """
        Tries to write the current value, in little-endian format, to a given span.
        
        :param destination: The span to which the current value should be written.
        :param bytesWritten: The number of bytes written to .
        :returns: true if the value was successfully written to ; otherwise, false.
        """
        ...

    @overload
    def WriteBigEndian(self, destination: typing.List[int]) -> int:
        """
        Writes the current value, in big-endian format, to a given array.
        
        :param destination: The array to which the current value should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteBigEndian(self, destination: typing.List[int], startIndex: int) -> int:
        """
        Writes the current value, in big-endian format, to a given array.
        
        :param destination: The array to which the current value should be written.
        :param startIndex: The starting index at which the value should be written.
        :returns: The number of bytes written to  starting at .
        """
        ...

    @overload
    def WriteBigEndian(self, destination: System.Span[int]) -> int:
        """
        Writes the current value, in big-endian format, to a given span.
        
        :param destination: The span to which the current value should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteLittleEndian(self, destination: typing.List[int]) -> int:
        """
        Writes the current value, in little-endian format, to a given array.
        
        :param destination: The array to which the current value should be written.
        :returns: The number of bytes written to .
        """
        ...

    @overload
    def WriteLittleEndian(self, destination: typing.List[int], startIndex: int) -> int:
        """
        Writes the current value, in little-endian format, to a given array.
        
        :param destination: The array to which the current value should be written.
        :param startIndex: The starting index at which the value should be written.
        :returns: The number of bytes written to  starting at .
        """
        ...

    @overload
    def WriteLittleEndian(self, destination: System.Span[int]) -> int:
        """
        Writes the current value, in little-endian format, to a given span.
        
        :param destination: The span to which the current value should be written.
        :returns: The number of bytes written to .
        """
        ...


