"""
URL configuration for server_rest_example project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from rest_framework import routers
from django.urls.conf import include
from rest_api.application.apps import django_application_inst  # @UnresolvedImport
from holado_core.common.exceptions.technical_exception import TechnicalException

router = routers.DefaultRouter()
if django_application_inst is not None:
    django_application_inst.register_urls(router)
    print(f"router urls: {router.urls}")
else:
    raise TechnicalException("Django application instance is not set")

urlpatterns = [
    path('', include(router.urls)),
    path('api-auth/', include('rest_framework.urls', namespace='rest_framework')),
    path('admin/', admin.site.urls),
]
