# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from ..types.letta_batch_messages import LettaBatchMessages
from ..core.jsonable_encoder import jsonable_encoder
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper


class MessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_batch_messages(
        self,
        batch_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        sort_descending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LettaBatchMessages:
        """
        Get messages for a specific batch job.

        Returns messages associated with the batch in chronological order.

        Pagination:
        - For the first page, omit the cursor parameter
        - For subsequent pages, use the ID of the last message from the previous response as the cursor
        - Results will include messages before/after the cursor based on sort_descending

        Parameters
        ----------
        batch_id : str

        limit : typing.Optional[int]
            Maximum number of messages to return

        cursor : typing.Optional[str]
            Message ID to use as pagination cursor (get messages before/after this ID) depending on sort_descending.

        agent_id : typing.Optional[str]
            Filter messages by agent ID

        sort_descending : typing.Optional[bool]
            Sort messages by creation time (true=newest first)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LettaBatchMessages
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.messages.list_batch_messages(
            batch_id="batch_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/messages/batches/{jsonable_encoder(batch_id)}/messages",
            method="GET",
            params={
                "limit": limit,
                "cursor": cursor,
                "agent_id": agent_id,
                "sort_descending": sort_descending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    LettaBatchMessages,
                    construct_type(
                        type_=LettaBatchMessages,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_batch_messages(
        self,
        batch_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        sort_descending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LettaBatchMessages:
        """
        Get messages for a specific batch job.

        Returns messages associated with the batch in chronological order.

        Pagination:
        - For the first page, omit the cursor parameter
        - For subsequent pages, use the ID of the last message from the previous response as the cursor
        - Results will include messages before/after the cursor based on sort_descending

        Parameters
        ----------
        batch_id : str

        limit : typing.Optional[int]
            Maximum number of messages to return

        cursor : typing.Optional[str]
            Message ID to use as pagination cursor (get messages before/after this ID) depending on sort_descending.

        agent_id : typing.Optional[str]
            Filter messages by agent ID

        sort_descending : typing.Optional[bool]
            Sort messages by creation time (true=newest first)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LettaBatchMessages
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.messages.list_batch_messages(
                batch_id="batch_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/messages/batches/{jsonable_encoder(batch_id)}/messages",
            method="GET",
            params={
                "limit": limit,
                "cursor": cursor,
                "agent_id": agent_id,
                "sort_descending": sort_descending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    LettaBatchMessages,
                    construct_type(
                        type_=LettaBatchMessages,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
