# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
from .agents.client import AgentsClient
import typing
from ..core.request_options import RequestOptions
from .types.templates_list_response import TemplatesListResponse
from ..core.unchecked_base_model import construct_type
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper
from .agents.client import AsyncAgentsClient


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.agents = AgentsClient(client_wrapper=self._client_wrapper)

    def list(
        self,
        *,
        offset: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListResponse:
        """
        List all templates

        Parameters
        ----------
        offset : typing.Optional[str]

        limit : typing.Optional[str]

        name : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListResponse
            200

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.templates.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/templates",
            method="GET",
            params={
                "offset": offset,
                "limit": limit,
                "name": name,
                "projectId": project_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    TemplatesListResponse,
                    construct_type(
                        type_=TemplatesListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.agents = AsyncAgentsClient(client_wrapper=self._client_wrapper)

    async def list(
        self,
        *,
        offset: typing.Optional[str] = None,
        limit: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TemplatesListResponse:
        """
        List all templates

        Parameters
        ----------
        offset : typing.Optional[str]

        limit : typing.Optional[str]

        name : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplatesListResponse
            200

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.templates.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/templates",
            method="GET",
            params={
                "offset": offset,
                "limit": limit,
                "name": name,
                "projectId": project_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    TemplatesListResponse,
                    construct_type(
                        type_=TemplatesListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
