# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ConditionalToolRule(UncheckedBaseModel):
    """
    A ToolRule that conditionally maps to different child tools based on the output.
    """

    tool_name: str = pydantic.Field()
    """
    The name of the tool. Must exist in the database for the user's organization.
    """

    type: typing.Literal["conditional"] = "conditional"
    prompt_template: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional Jinja2 template for generating agent prompt about this tool rule.
    """

    default_child: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default child tool to be called. If None, any tool can be called.
    """

    child_output_mapping: typing.Dict[str, str] = pydantic.Field()
    """
    The output case to check for mapping
    """

    require_output_mapping: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to throw an error when output doesn't match any case
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
