# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class GenerateToolInput(UncheckedBaseModel):
    tool_name: str = pydantic.Field()
    """
    Name of the tool to generate code for
    """

    prompt: str = pydantic.Field()
    """
    User prompt to generate code
    """

    handle: typing.Optional[str] = pydantic.Field(default=None)
    """
    Handle of the tool to generate code for
    """

    starter_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Python source code to parse for JSON schema
    """

    validation_errors: typing.List[str] = pydantic.Field()
    """
    List of validation errors
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
