# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import typing_extensions
from ..core.serialization import FieldMetadata
from .tool_annotations import ToolAnnotations
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class McpTool(UncheckedBaseModel):
    """
    A simple wrapper around MCP's tool definition (to avoid conflict with our own)
    """

    name: str
    title: typing.Optional[str] = None
    description: typing.Optional[str] = None
    input_schema: typing_extensions.Annotated[
        typing.Dict[str, typing.Optional[typing.Any]], FieldMetadata(alias="inputSchema")
    ]
    output_schema: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="outputSchema")
    ] = None
    annotations: typing.Optional[ToolAnnotations] = None
    meta: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="_meta")
    ] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
