# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .mcp_server_type import McpServerType
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class StdioServerConfig(UncheckedBaseModel):
    server_name: str = pydantic.Field()
    """
    The name of the server
    """

    type: typing.Optional[McpServerType] = None
    command: str = pydantic.Field()
    """
    The command to run (MCP 'local' client will run this command)
    """

    args: typing.List[str] = pydantic.Field()
    """
    The arguments to pass to the command
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Environment variables to set
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
