# ANSI COLORS
COLOR_RESET = 0

COLOR_BOLD = 1
COLOR_FAINT = 2
COLOR_ITALIC = 3
COLOR_UNDERLINE = 4
COLOR_RAPID_BLINK = 5
COLOR_SLOW_BLINK = 6
COLOR_REVERSED = 7
COLOR_NOT_UNDERLINE = 24

COLOR_BLACK = 30
COLOR_RED = 31
COLOR_GREEN = 32
COLOR_YELLOW = 33
COLOR_BLUE = 34
COLOR_MAGENTA = 35
COLOR_CYAN = 36
COLOR_WHITE = 37
COLOR_DEFAULT = 39

COLOR_BRIGHT_BLACK = 90
COLOR_BRIGHT_RED = 91
COLOR_BRIGHT_GREEN = 92
COLOR_BRIGHT_YELLOW = 93
COLOR_BRIGHT_BLUE = 94
COLOR_BRIGHT_MAGENTA = 95
COLOR_BRIGHT_CYAN = 96
COLOR_BRIGHT_WHITE = 97

COLOR_BACKGROUND_BLACK = 40
COLOR_BACKGROUND_RED = 41
COLOR_BACKGROUND_GREEN = 42
COLOR_BACKGROUND_YELLOW = 43
COLOR_BACKGROUND_BLUE = 44
COLOR_BACKGROUND_MAGENTA = 45
COLOR_BACKGROUND_CYAN = 46
COLOR_BACKGROUND_WHITE = 47
COLOR_BACKGROUND_DEFAULT = 49

COLOR_BACKGROUND_BRIGHT_BLACK = 100
COLOR_BACKGROUND_BRIGHT_RED = 101
COLOR_BACKGROUND_BRIGHT_GREEN = 102
COLOR_BACKGROUND_BRIGHT_YELLOW = 103
COLOR_BACKGROUND_BRIGHT_BLUE = 104
COLOR_BACKGROUND_BRIGHT_MAGENTA = 105
COLOR_BACKGROUND_BRIGHT_CYAN = 106
COLOR_BACKGROUND_BRIGHT_WHITE = 107


def ansi_color(*colors):
    color = ";".join(str(c) for c in colors if c is not None)
    return f"\033[{color}m"


def paint(text, *colors):
    return ansi_color(*colors) + str(text) + ansi_color(COLOR_DEFAULT)

