# package file
"""
Tools to translate StationXML to MT Metadata
"""

try:
    import obspy
except ImportError:
    raise ImportError("StationXML requires obspy to be installed.")

from .xml_network_mt_survey import XMLNetworkMTSurvey
from .xml_equipment_mt_run import XMLEquipmentMTRun
from .xml_station_mt_station import XMLStationMTStation
from .xml_channel_mt_channel import XMLChannelMTChannel
from .xml_inventory_mt_experiment import XMLInventoryMTExperiment


__all__ = [
    "XMLNetworkMTSurvey",
    "XMLStationMTStation",
    "XMLEquipmentMTRun",
    "XMLChannelMTChannel",
    "XMLInventoryMTExperiment",
]
