try:
    from ._version import version as __version__
    from ._version import version_tuple
except ImportError:
    __version__ = "unknown version"
    version_tuple = (0, 0, "unknown version")

# Configure package-wide logging
import logging

# Disable DEBUG logs from urllib3
logging.getLogger('urllib3').setLevel(logging.INFO)

# Create the root package logger
logger = logging.getLogger("synthegrator")

# Only configure if not already set up
if not logger.handlers:
    handler = logging.StreamHandler()
    formatter = logging.Formatter('%(asctime)s [%(name)s:%(lineno)d] %(levelname)s: %(message)s')
    formatter.datefmt = '%H:%M:%S'  # Just hours:minutes:seconds
    handler.setFormatter(formatter)
    logger.setLevel(logging.INFO)
    logger.addHandler(handler)
