# Defects4J-bug-repair

This repository contains the script to patch one liner bugs in Defects4J

The script is `defects4j_script.py`.

The approach to how the script works is as follows:

1. It reads data from the `Defects4J_oneliner_metadata.csv`.

    The format of the data should be as follows:

    - col1: The bug suite of Defects4J, for example, Lang, Chart, etc.
    - col2: The number of the buggy project to checkout, for example, 1, 2, 3, etc.
    - col3: Source to the buggy program.
    - col4: Line in the buggy program to replace.

2. A new folder called `Defects4J_patches` is created and the bug is checked out into that folder.

3. To generate the patch, the part of the code above the line specified in `col4` is extracted, the line text specified in `new_content` is put in place of that line. And the remaining part of the code is attached after that line.

4. Then, `defects4j` test is run to validate the changes.

A current limitation is that only single-line fixes can be made and tested through one run of this Python script.

## Acknowledgments

This pipeline is inspired from [this repository](https://github.com/ASSERT-KTH/sequencer/tree/master), and this paper [SEQUENCER: Sequence-to-Sequence Learning
for End-to-End Program Repair](https://arxiv.org/pdf/1901.01808.pdf). The one-liner bugs are taken from [this csv file](https://github.com/ASSERT-KTH/sequencer/blob/master/src/Defects4J_Experiment/Defects4J_oneLiner_metadata.csv) in the SEQUENCER repository.
