from synthegrator.synthdatasets.livecodebench import yield_livecode_problems
from synthegrator.code_problems import TestCase, TestCase, TestCaseArbitraryMethod
from synthegrator.lang_specs.lang_spec_python import PythonLangSpec

def main():
    probs = yield_livecode_problems(max_problems=100)
    invalid_tcs = []
    for prob in probs:
        print(dir(prob))
        for tc in prob.test_cases:
            print(type(tc))
            formatted_tc = tc.format_for_test_framework(lang_spec=PythonLangSpec())
            # Assert that formatted_tc is compilable python code
            try:
                compile(formatted_tc, '<string>', 'exec')
            except SyntaxError as e:
                #raise AssertionError(f"Formatted test case is not valid Python code: {e}") from e
                invalid_tcs.append(prob)
                break
            if "LCB STDIN TEST CASE" in formatted_tc:
                continue
            if len(formatted_tc) > 500:
                formatted_tc = formatted_tc[:500] + "..."
            print(formatted_tc)
            break
    print(len(invalid_tcs))
            

if __name__ == "__main__":
    main()