from collections.abc import Sequence

from synthegrator.code_problems import DiscoveredTestsuite
from synthegrator.sandboxing import CmdExecResult, TestsuiteExecResult


def custom_suite_extractor(cmds: Sequence[CmdExecResult]) -> TestsuiteExecResult:
    return TestsuiteExecResult()


def test_discovered_suite_hashing():
    tc = DiscoveredTestsuite(["pytest", "cat result"])
    assert tc.get_hash() == tc.get_hash()
    print(tc.get_hash())
    # NOTE: This is just verifying that it's stable between runs.
    #     Going to be a bit of pain to maintain (have to just copy new value
    #     anytime the default extractor changes). If it becomes a problem can
    #     just remove this part.
    assert tc.get_hash() == "9390d2b96f83cb97"
    tc2 = DiscoveredTestsuite(["pytest", "cat not"])
    assert tc.get_hash() != tc2.get_hash()

    tc3 = DiscoveredTestsuite(
        ["pytest", "cat not"],
        cmds_results_to_suite=custom_suite_extractor,
    )

    assert tc3.get_hash() != tc2.get_hash()
