from synthegrator.util import MultilineString

FIXTURE = """# shebang
import pandas

class Hello():
    ...

def method(blah):
    # hi
    x = 1+2
    y = x+3

    return x+y
"""


def test_line_range():
    string = MultilineString(FIXTURE)
    assert (
        string[9:]
        == """    y = x+3

    return x+y
"""
    )


def test_str_eq():
    string = MultilineString("test")
    assert string == "test"


def test_str_rep():
    string = MultilineString("test")
    assert str(string) == "test"


def test_str():
    string = MultilineString(FIXTURE)
    expected = [
        "# shebang\n",  # 1
        "import pandas\n",  # 2
        "\n",  # 3
        "class Hello():\n",  # 4
        "    ...\n",  # 5
        "\n",  # 6
        "def method(blah):\n",  # 7
        "    # hi\n",  # 8
        "    x = 1+2\n",  # 9
        "    y = x+3\n",  # 10
        "\n",  # 11
        "    return x+y\n",  # 12
    ]
    assert string.lines == expected
    assert string.line_count == 12
    assert len(string) == 12
    new_code = """    x = 20
"""
    string[8] = new_code
    expected = """# shebang
import pandas

class Hello():
    ...

def method(blah):
    # hi
    x = 20
    y = x+3

    return x+y
"""
    assert string == expected


def test_insert():
    string = MultilineString(FIXTURE)

    new_code = """    z = 30
"""
    expected = """# shebang
import pandas

class Hello():
    ...

def method(blah):
    # hi
    x = 1+2
    z = 30
    y = x+3

    return x+y
"""
    string.insert(9, new_code)
    assert string == expected


def test_multiline_replace():
    string = MultilineString(FIXTURE)

    new_code = """    x = 20
    z = 1
    y = 5+x
"""
    string[8:11] = new_code
    expected = """# shebang
import pandas

class Hello():
    ...

def method(blah):
    # hi
    x = 20
    z = 1
    y = 5+x
    return x+y
"""
    assert string == expected
