# Generated by Django 5.0.7 on 2024-08-19 18:45

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Album',
            fields=[
                ('key', models.CharField(primary_key=True, serialize=False, validators=[django.core.validators.RegexValidator('^[a-zA-Z0-9._-]+$', 'Album key must only contain alphanumeric characters, dots, underscores and hyphens.')])),
                ('title', models.CharField(blank=True)),
                ('description', models.TextField(blank=True)),
                ('visibility', models.CharField(blank=True, choices=[('public', 'Public'), ('hidden', 'Hidden'), ('private', 'Private')], db_default='private', default='private')),
                ('first_timestamp', models.DateTimeField(null=True)),
                ('last_timestamp', models.DateTimeField(null=True)),
            ],
            options={
                'ordering': ['-first_timestamp', '-last_timestamp', 'key'],
            },
        ),
        migrations.CreateModel(
            name='Photo',
            fields=[
                ('key', models.CharField(primary_key=True, serialize=False, validators=[django.core.validators.RegexValidator('^[a-zA-Z0-9._-]+/[a-zA-Z0-9._-]+$', 'Photo key must contain album key and filename. These must be separated with slash. Both parts must only contain alphanumeric characters, dots, underscores and hyphens.')])),
                ('timestamp', models.DateTimeField()),
                ('title', models.CharField(blank=True)),
                ('description', models.TextField(blank=True)),
                ('tiny_base64', models.TextField(blank=True)),
                ('album', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='photo_objects.album')),
                ('height', models.PositiveIntegerField()),
                ('width', models.PositiveIntegerField()),
            ],
            options={
                'ordering': ['timestamp'],
            },
        ),
        migrations.AddField(
            model_name='album',
            name='cover_photo',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='photo_objects.photo'),
        ),
    ]
