# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SettingsArgs', 'Settings']

@pulumi.input_type
class SettingsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 grace_period: pulumi.Input[_builtins.str],
                 lookback_period: pulumi.Input[_builtins.str],
                 ruleset_limit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Settings resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the automated archival is enabled for this organization or not
        :param pulumi.Input[_builtins.str] grace_period: Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.str] lookback_period: This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.int] ruleset_limit: Org limit for the number of rulesets that can be created
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "grace_period", grace_period)
        pulumi.set(__self__, "lookback_period", lookback_period)
        if ruleset_limit is not None:
            pulumi.set(__self__, "ruleset_limit", ruleset_limit)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the automated archival is enabled for this organization or not
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> pulumi.Input[_builtins.str]:
        """
        Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grace_period", value)

    @_builtins.property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> pulumi.Input[_builtins.str]:
        """
        This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        """
        return pulumi.get(self, "lookback_period")

    @lookback_period.setter
    def lookback_period(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lookback_period", value)

    @_builtins.property
    @pulumi.getter(name="rulesetLimit")
    def ruleset_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Org limit for the number of rulesets that can be created
        """
        return pulumi.get(self, "ruleset_limit")

    @ruleset_limit.setter
    def ruleset_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ruleset_limit", value)


@pulumi.input_type
class _SettingsState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.int]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 lookback_period: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Settings resources.
        :param pulumi.Input[_builtins.int] created: Timestamp of when the automated archival setting was created
        :param pulumi.Input[_builtins.str] creator: ID of the creator of the automated archival setting
        :param pulumi.Input[_builtins.bool] enabled: Whether the automated archival is enabled for this organization or not
        :param pulumi.Input[_builtins.str] grace_period: Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.int] last_updated: Timestamp of when the automated archival setting was last updated
        :param pulumi.Input[_builtins.str] last_updated_by: ID of user who last updated the automated archival setting
        :param pulumi.Input[_builtins.str] lookback_period: This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.int] ruleset_limit: Org limit for the number of rulesets that can be created
        :param pulumi.Input[_builtins.str] version: Version of the automated archival setting
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if lookback_period is not None:
            pulumi.set(__self__, "lookback_period", lookback_period)
        if ruleset_limit is not None:
            pulumi.set(__self__, "ruleset_limit", ruleset_limit)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp of when the automated archival setting was created
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the creator of the automated archival setting
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the automated archival is enabled for this organization or not
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        """
        return pulumi.get(self, "grace_period")

    @grace_period.setter
    def grace_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grace_period", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp of when the automated archival setting was last updated
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of user who last updated the automated archival setting
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        """
        return pulumi.get(self, "lookback_period")

    @lookback_period.setter
    def lookback_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lookback_period", value)

    @_builtins.property
    @pulumi.getter(name="rulesetLimit")
    def ruleset_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Org limit for the number of rulesets that can be created
        """
        return pulumi.get(self, "ruleset_limit")

    @ruleset_limit.setter
    def ruleset_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ruleset_limit", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the automated archival setting
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("signalfx:automatedarchival/settings:Settings")
class Settings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 lookback_period: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a Settings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the automated archival is enabled for this organization or not
        :param pulumi.Input[_builtins.str] grace_period: Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.str] lookback_period: This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.int] ruleset_limit: Org limit for the number of rulesets that can be created
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Settings resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 grace_period: Optional[pulumi.Input[_builtins.str]] = None,
                 lookback_period: Optional[pulumi.Input[_builtins.str]] = None,
                 ruleset_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingsArgs.__new__(SettingsArgs)

            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if grace_period is None and not opts.urn:
                raise TypeError("Missing required property 'grace_period'")
            __props__.__dict__["grace_period"] = grace_period
            if lookback_period is None and not opts.urn:
                raise TypeError("Missing required property 'lookback_period'")
            __props__.__dict__["lookback_period"] = lookback_period
            __props__.__dict__["ruleset_limit"] = ruleset_limit
            __props__.__dict__["created"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["last_updated"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["version"] = None
        super(Settings, __self__).__init__(
            'signalfx:automatedarchival/settings:Settings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[_builtins.int]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            grace_period: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated: Optional[pulumi.Input[_builtins.int]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            lookback_period: Optional[pulumi.Input[_builtins.str]] = None,
            ruleset_limit: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Settings':
        """
        Get an existing Settings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] created: Timestamp of when the automated archival setting was created
        :param pulumi.Input[_builtins.str] creator: ID of the creator of the automated archival setting
        :param pulumi.Input[_builtins.bool] enabled: Whether the automated archival is enabled for this organization or not
        :param pulumi.Input[_builtins.str] grace_period: Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.int] last_updated: Timestamp of when the automated archival setting was last updated
        :param pulumi.Input[_builtins.str] last_updated_by: ID of user who last updated the automated archival setting
        :param pulumi.Input[_builtins.str] lookback_period: This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        :param pulumi.Input[_builtins.int] ruleset_limit: Org limit for the number of rulesets that can be created
        :param pulumi.Input[_builtins.str] version: Version of the automated archival setting
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingsState.__new__(_SettingsState)

        __props__.__dict__["created"] = created
        __props__.__dict__["creator"] = creator
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["grace_period"] = grace_period
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["lookback_period"] = lookback_period
        __props__.__dict__["ruleset_limit"] = ruleset_limit
        __props__.__dict__["version"] = version
        return Settings(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp of when the automated archival setting was created
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the creator of the automated archival setting
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the automated archival is enabled for this organization or not
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> pulumi.Output[_builtins.str]:
        """
        Grace period is an org level setting that applies to the newly created metrics. This allows customers to protect newly added metrics that users haven’t had the time to use in charts and detectors from being automatically archived The value here uses ISO 8061 duration format. Examples - 'P0D', 'P15D', 'P30D', 'P45D', 'P60D'
        """
        return pulumi.get(self, "grace_period")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp of when the automated archival setting was last updated
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        ID of user who last updated the automated archival setting
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="lookbackPeriod")
    def lookback_period(self) -> pulumi.Output[_builtins.str]:
        """
        This tracks if a metric was unused in the past N number of days (N one of 30, 45, or 60). We’ll archive a metric if it wasn’t used in the lookback period. The value here uses ISO 8061 duration format. Examples - 'P30D', 'P45D', 'P60D'
        """
        return pulumi.get(self, "lookback_period")

    @_builtins.property
    @pulumi.getter(name="rulesetLimit")
    def ruleset_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Org limit for the number of rulesets that can be created
        """
        return pulumi.get(self, "ruleset_limit")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the automated archival setting
        """
        return pulumi.get(self, "version")

