# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExternalIntegrationArgs', 'ExternalIntegration']

@pulumi.input_type
class ExternalIntegrationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExternalIntegration resource.
        :param pulumi.Input[_builtins.str] name: The name of this integration
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ExternalIntegrationState:
    def __init__(__self__, *,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalfx_aws_account: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalIntegration resources.
        :param pulumi.Input[_builtins.str] external_id: The external ID to use with your IAM role and with `aws.Integration`.
        :param pulumi.Input[_builtins.str] name: The name of this integration
        :param pulumi.Input[_builtins.str] signalfx_aws_account: The AWS Account ARN to use with your policies/roles, provided by Splunk Observability Cloud.
        """
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signalfx_aws_account is not None:
            pulumi.set(__self__, "signalfx_aws_account", signalfx_aws_account)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The external ID to use with your IAM role and with `aws.Integration`.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="signalfxAwsAccount")
    def signalfx_aws_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS Account ARN to use with your policies/roles, provided by Splunk Observability Cloud.
        """
        return pulumi.get(self, "signalfx_aws_account")

    @signalfx_aws_account.setter
    def signalfx_aws_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signalfx_aws_account", value)


@pulumi.type_token("signalfx:aws/externalIntegration:ExternalIntegration")
class ExternalIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a ExternalIntegration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of this integration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ExternalIntegrationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ExternalIntegration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ExternalIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalIntegrationArgs.__new__(ExternalIntegrationArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["external_id"] = None
            __props__.__dict__["signalfx_aws_account"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["externalId", "signalfxAwsAccount"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ExternalIntegration, __self__).__init__(
            'signalfx:aws/externalIntegration:ExternalIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            signalfx_aws_account: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExternalIntegration':
        """
        Get an existing ExternalIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] external_id: The external ID to use with your IAM role and with `aws.Integration`.
        :param pulumi.Input[_builtins.str] name: The name of this integration
        :param pulumi.Input[_builtins.str] signalfx_aws_account: The AWS Account ARN to use with your policies/roles, provided by Splunk Observability Cloud.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalIntegrationState.__new__(_ExternalIntegrationState)

        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["name"] = name
        __props__.__dict__["signalfx_aws_account"] = signalfx_aws_account
        return ExternalIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[_builtins.str]:
        """
        The external ID to use with your IAM role and with `aws.Integration`.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of this integration
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signalfxAwsAccount")
    def signalfx_aws_account(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS Account ARN to use with your policies/roles, provided by Splunk Observability Cloud.
        """
        return pulumi.get(self, "signalfx_aws_account")

