# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 integration_id: pulumi.Input[_builtins.str],
                 regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 collect_only_recommended_stats: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_cloudwatch_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]]] = None,
                 enable_aws_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_check_large_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logs_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 import_cloud_watch: Optional[pulumi.Input[_builtins.bool]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stats_to_syncs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]]] = None,
                 metric_streams_managed_externally: Optional[pulumi.Input[_builtins.bool]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_custom_namespaces_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 use_metric_streams_sync: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] integration_id: The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        :param pulumi.Input[_builtins.bool] collect_only_recommended_stats: The integration will only ingest the recommended statistics published by AWS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_cloudwatch_namespaces: List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]] custom_namespace_sync_rules: Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        :param pulumi.Input[_builtins.bool] enable_aws_usage: Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        :param pulumi.Input[_builtins.bool] enable_check_large_volume: Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        :param pulumi.Input[_builtins.bool] enable_logs_sync: Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        :param pulumi.Input[_builtins.str] external_id: The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        :param pulumi.Input[_builtins.bool] import_cloud_watch: Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        :param pulumi.Input[_builtins.str] key: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]] metric_stats_to_syncs: Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        :param pulumi.Input[_builtins.bool] metric_streams_managed_externally: If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]] namespace_sync_rules: Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        :param pulumi.Input[_builtins.int] poll_rate: AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] sync_custom_namespaces_only: Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        :param pulumi.Input[_builtins.str] token: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        :param pulumi.Input[_builtins.bool] use_metric_streams_sync: Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "integration_id", integration_id)
        pulumi.set(__self__, "regions", regions)
        if collect_only_recommended_stats is not None:
            pulumi.set(__self__, "collect_only_recommended_stats", collect_only_recommended_stats)
        if custom_cloudwatch_namespaces is not None:
            pulumi.set(__self__, "custom_cloudwatch_namespaces", custom_cloudwatch_namespaces)
        if custom_namespace_sync_rules is not None:
            pulumi.set(__self__, "custom_namespace_sync_rules", custom_namespace_sync_rules)
        if enable_aws_usage is not None:
            pulumi.set(__self__, "enable_aws_usage", enable_aws_usage)
        if enable_check_large_volume is not None:
            pulumi.set(__self__, "enable_check_large_volume", enable_check_large_volume)
        if enable_logs_sync is not None:
            pulumi.set(__self__, "enable_logs_sync", enable_logs_sync)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if import_cloud_watch is not None:
            pulumi.set(__self__, "import_cloud_watch", import_cloud_watch)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metric_stats_to_syncs is not None:
            pulumi.set(__self__, "metric_stats_to_syncs", metric_stats_to_syncs)
        if metric_streams_managed_externally is not None:
            pulumi.set(__self__, "metric_streams_managed_externally", metric_streams_managed_externally)
        if named_token is not None:
            pulumi.set(__self__, "named_token", named_token)
        if namespace_sync_rules is not None:
            pulumi.set(__self__, "namespace_sync_rules", namespace_sync_rules)
        if poll_rate is not None:
            pulumi.set(__self__, "poll_rate", poll_rate)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if sync_custom_namespaces_only is not None:
            pulumi.set(__self__, "sync_custom_namespaces_only", sync_custom_namespaces_only)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_metric_streams_sync is not None:
            pulumi.set(__self__, "use_metric_streams_sync", use_metric_streams_sync)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "integration_id", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="collectOnlyRecommendedStats")
    def collect_only_recommended_stats(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The integration will only ingest the recommended statistics published by AWS
        """
        return pulumi.get(self, "collect_only_recommended_stats")

    @collect_only_recommended_stats.setter
    def collect_only_recommended_stats(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "collect_only_recommended_stats", value)

    @_builtins.property
    @pulumi.getter(name="customCloudwatchNamespaces")
    def custom_cloudwatch_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        """
        return pulumi.get(self, "custom_cloudwatch_namespaces")

    @custom_cloudwatch_namespaces.setter
    def custom_cloudwatch_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_cloudwatch_namespaces", value)

    @_builtins.property
    @pulumi.getter(name="customNamespaceSyncRules")
    def custom_namespace_sync_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]]]:
        """
        Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        """
        return pulumi.get(self, "custom_namespace_sync_rules")

    @custom_namespace_sync_rules.setter
    def custom_namespace_sync_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]]]):
        pulumi.set(self, "custom_namespace_sync_rules", value)

    @_builtins.property
    @pulumi.getter(name="enableAwsUsage")
    def enable_aws_usage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        """
        return pulumi.get(self, "enable_aws_usage")

    @enable_aws_usage.setter
    def enable_aws_usage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_aws_usage", value)

    @_builtins.property
    @pulumi.getter(name="enableCheckLargeVolume")
    def enable_check_large_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        """
        return pulumi.get(self, "enable_check_large_volume")

    @enable_check_large_volume.setter
    def enable_check_large_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_check_large_volume", value)

    @_builtins.property
    @pulumi.getter(name="enableLogsSync")
    def enable_logs_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        """
        return pulumi.get(self, "enable_logs_sync")

    @enable_logs_sync.setter
    def enable_logs_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_logs_sync", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="importCloudWatch")
    def import_cloud_watch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        """
        return pulumi.get(self, "import_cloud_watch")

    @import_cloud_watch.setter
    def import_cloud_watch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_cloud_watch", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="metricStatsToSyncs")
    def metric_stats_to_syncs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]]]:
        """
        Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        """
        return pulumi.get(self, "metric_stats_to_syncs")

    @metric_stats_to_syncs.setter
    def metric_stats_to_syncs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]]]):
        pulumi.set(self, "metric_stats_to_syncs", value)

    @_builtins.property
    @pulumi.getter(name="metricStreamsManagedExternally")
    def metric_streams_managed_externally(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        """
        return pulumi.get(self, "metric_streams_managed_externally")

    @metric_streams_managed_externally.setter
    def metric_streams_managed_externally(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "metric_streams_managed_externally", value)

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @named_token.setter
    def named_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "named_token", value)

    @_builtins.property
    @pulumi.getter(name="namespaceSyncRules")
    def namespace_sync_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]]]:
        """
        Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        """
        return pulumi.get(self, "namespace_sync_rules")

    @namespace_sync_rules.setter
    def namespace_sync_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]]]):
        pulumi.set(self, "namespace_sync_rules", value)

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @poll_rate.setter
    def poll_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poll_rate", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="syncCustomNamespacesOnly")
    def sync_custom_namespaces_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        """
        return pulumi.get(self, "sync_custom_namespaces_only")

    @sync_custom_namespaces_only.setter
    def sync_custom_namespaces_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_custom_namespaces_only", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="useMetricStreamsSync")
    def use_metric_streams_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        return pulumi.get(self, "use_metric_streams_sync")

    @use_metric_streams_sync.setter
    def use_metric_streams_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_metric_streams_sync", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 auth_method: Optional[pulumi.Input[_builtins.str]] = None,
                 collect_only_recommended_stats: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_cloudwatch_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]]] = None,
                 enable_aws_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_check_large_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logs_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 import_cloud_watch: Optional[pulumi.Input[_builtins.bool]] = None,
                 integration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stats_to_syncs: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]]] = None,
                 metric_streams_managed_externally: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_custom_namespaces_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 use_metric_streams_sync: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[_builtins.str] auth_method: The mechanism used to authenticate with AWS. Use one of `aws.ExternalIntegration` or `aws.TokenIntegration` to define this
        :param pulumi.Input[_builtins.bool] collect_only_recommended_stats: The integration will only ingest the recommended statistics published by AWS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_cloudwatch_namespaces: List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]] custom_namespace_sync_rules: Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        :param pulumi.Input[_builtins.bool] enable_aws_usage: Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        :param pulumi.Input[_builtins.bool] enable_check_large_volume: Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        :param pulumi.Input[_builtins.bool] enable_logs_sync: Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] external_id: The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        :param pulumi.Input[_builtins.bool] import_cloud_watch: Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        :param pulumi.Input[_builtins.str] integration_id: The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        :param pulumi.Input[_builtins.str] key: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]] metric_stats_to_syncs: Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        :param pulumi.Input[_builtins.bool] metric_streams_managed_externally: If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]] namespace_sync_rules: Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        :param pulumi.Input[_builtins.int] poll_rate: AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] sync_custom_namespaces_only: Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        :param pulumi.Input[_builtins.str] token: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        :param pulumi.Input[_builtins.bool] use_metric_streams_sync: Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        if auth_method is not None:
            pulumi.set(__self__, "auth_method", auth_method)
        if collect_only_recommended_stats is not None:
            pulumi.set(__self__, "collect_only_recommended_stats", collect_only_recommended_stats)
        if custom_cloudwatch_namespaces is not None:
            pulumi.set(__self__, "custom_cloudwatch_namespaces", custom_cloudwatch_namespaces)
        if custom_namespace_sync_rules is not None:
            pulumi.set(__self__, "custom_namespace_sync_rules", custom_namespace_sync_rules)
        if enable_aws_usage is not None:
            pulumi.set(__self__, "enable_aws_usage", enable_aws_usage)
        if enable_check_large_volume is not None:
            pulumi.set(__self__, "enable_check_large_volume", enable_check_large_volume)
        if enable_logs_sync is not None:
            pulumi.set(__self__, "enable_logs_sync", enable_logs_sync)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if import_cloud_watch is not None:
            pulumi.set(__self__, "import_cloud_watch", import_cloud_watch)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metric_stats_to_syncs is not None:
            pulumi.set(__self__, "metric_stats_to_syncs", metric_stats_to_syncs)
        if metric_streams_managed_externally is not None:
            pulumi.set(__self__, "metric_streams_managed_externally", metric_streams_managed_externally)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_token is not None:
            pulumi.set(__self__, "named_token", named_token)
        if namespace_sync_rules is not None:
            pulumi.set(__self__, "namespace_sync_rules", namespace_sync_rules)
        if poll_rate is not None:
            pulumi.set(__self__, "poll_rate", poll_rate)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if sync_custom_namespaces_only is not None:
            pulumi.set(__self__, "sync_custom_namespaces_only", sync_custom_namespaces_only)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_metric_streams_sync is not None:
            pulumi.set(__self__, "use_metric_streams_sync", use_metric_streams_sync)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mechanism used to authenticate with AWS. Use one of `aws.ExternalIntegration` or `aws.TokenIntegration` to define this
        """
        return pulumi.get(self, "auth_method")

    @auth_method.setter
    def auth_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_method", value)

    @_builtins.property
    @pulumi.getter(name="collectOnlyRecommendedStats")
    def collect_only_recommended_stats(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The integration will only ingest the recommended statistics published by AWS
        """
        return pulumi.get(self, "collect_only_recommended_stats")

    @collect_only_recommended_stats.setter
    def collect_only_recommended_stats(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "collect_only_recommended_stats", value)

    @_builtins.property
    @pulumi.getter(name="customCloudwatchNamespaces")
    def custom_cloudwatch_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        """
        return pulumi.get(self, "custom_cloudwatch_namespaces")

    @custom_cloudwatch_namespaces.setter
    def custom_cloudwatch_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_cloudwatch_namespaces", value)

    @_builtins.property
    @pulumi.getter(name="customNamespaceSyncRules")
    def custom_namespace_sync_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]]]:
        """
        Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        """
        return pulumi.get(self, "custom_namespace_sync_rules")

    @custom_namespace_sync_rules.setter
    def custom_namespace_sync_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespaceSyncRuleArgs']]]]):
        pulumi.set(self, "custom_namespace_sync_rules", value)

    @_builtins.property
    @pulumi.getter(name="enableAwsUsage")
    def enable_aws_usage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        """
        return pulumi.get(self, "enable_aws_usage")

    @enable_aws_usage.setter
    def enable_aws_usage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_aws_usage", value)

    @_builtins.property
    @pulumi.getter(name="enableCheckLargeVolume")
    def enable_check_large_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        """
        return pulumi.get(self, "enable_check_large_volume")

    @enable_check_large_volume.setter
    def enable_check_large_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_check_large_volume", value)

    @_builtins.property
    @pulumi.getter(name="enableLogsSync")
    def enable_logs_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        """
        return pulumi.get(self, "enable_logs_sync")

    @enable_logs_sync.setter
    def enable_logs_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_logs_sync", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="importCloudWatch")
    def import_cloud_watch(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        """
        return pulumi.get(self, "import_cloud_watch")

    @import_cloud_watch.setter
    def import_cloud_watch(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_cloud_watch", value)

    @_builtins.property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_id", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="metricStatsToSyncs")
    def metric_stats_to_syncs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]]]:
        """
        Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        """
        return pulumi.get(self, "metric_stats_to_syncs")

    @metric_stats_to_syncs.setter
    def metric_stats_to_syncs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationMetricStatsToSyncArgs']]]]):
        pulumi.set(self, "metric_stats_to_syncs", value)

    @_builtins.property
    @pulumi.getter(name="metricStreamsManagedExternally")
    def metric_streams_managed_externally(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        """
        return pulumi.get(self, "metric_streams_managed_externally")

    @metric_streams_managed_externally.setter
    def metric_streams_managed_externally(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "metric_streams_managed_externally", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @named_token.setter
    def named_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "named_token", value)

    @_builtins.property
    @pulumi.getter(name="namespaceSyncRules")
    def namespace_sync_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]]]:
        """
        Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        """
        return pulumi.get(self, "namespace_sync_rules")

    @namespace_sync_rules.setter
    def namespace_sync_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationNamespaceSyncRuleArgs']]]]):
        pulumi.set(self, "namespace_sync_rules", value)

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @poll_rate.setter
    def poll_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poll_rate", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter(name="syncCustomNamespacesOnly")
    def sync_custom_namespaces_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        """
        return pulumi.get(self, "sync_custom_namespaces_only")

    @sync_custom_namespaces_only.setter
    def sync_custom_namespaces_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_custom_namespaces_only", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="useMetricStreamsSync")
    def use_metric_streams_sync(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        return pulumi.get(self, "use_metric_streams_sync")

    @use_metric_streams_sync.setter
    def use_metric_streams_sync(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_metric_streams_sync", value)


@pulumi.type_token("signalfx:aws/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collect_only_recommended_stats: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_cloudwatch_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespaceSyncRuleArgs', 'IntegrationCustomNamespaceSyncRuleArgsDict']]]]] = None,
                 enable_aws_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_check_large_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logs_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 import_cloud_watch: Optional[pulumi.Input[_builtins.bool]] = None,
                 integration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stats_to_syncs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMetricStatsToSyncArgs', 'IntegrationMetricStatsToSyncArgsDict']]]]] = None,
                 metric_streams_managed_externally: Optional[pulumi.Input[_builtins.bool]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationNamespaceSyncRuleArgs', 'IntegrationNamespaceSyncRuleArgsDict']]]]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_custom_namespaces_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 use_metric_streams_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        AWS CloudWatch integrations for Splunk Observability Cloud. For help with this integration see [Monitoring Amazon Web Services](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/aws/get-awstoc.html).

        This resource implements a part of a workflow. Use it with one of either `aws.ExternalIntegration` or `aws.TokenIntegration`.

        > **NOTE** When managing integrations, use a session token of an administrator to authenticate the Splunk Observability provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator).

        ## Example

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_signalfx as signalfx

        #  This resource returns an account id in `external_id`…
        aws_myteam_external = signalfx.aws.ExternalIntegration("aws_myteam_external", name="My AWS integration")
        # Make yourself an AWS IAM role here, use `signalfx_aws_external_integration.aws_myteam_external.external_id`
        aws_sfx_example = aws.index.IamRole("aws_sfx_example")
        aws_myteam = signalfx.aws.Integration("aws_myteam",
            enabled=True,
            integration_id=aws_myteam_external.id,
            external_id=aws_myteam_external.external_id,
            role_arn=aws_sfx_role["arn"],
            regions=["us-east-1"],
            poll_rate=300,
            import_cloud_watch=True,
            enable_aws_usage=True,
            custom_namespace_sync_rules=[{
                "default_action": "Exclude",
                "filter_action": "Include",
                "filter_source": "filter('code', '200')",
                "namespace": "my-custom-namespace",
            }],
            namespace_sync_rules=[{
                "default_action": "Exclude",
                "filter_action": "Include",
                "filter_source": "filter('code', '200')",
                "namespace": "AWS/EC2",
            }],
            metric_stats_to_syncs=[{
                "namespace": "AWS/EC2",
                "metric": "NetworkPacketsIn",
                "stats": ["upper"],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] collect_only_recommended_stats: The integration will only ingest the recommended statistics published by AWS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_cloudwatch_namespaces: List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespaceSyncRuleArgs', 'IntegrationCustomNamespaceSyncRuleArgsDict']]]] custom_namespace_sync_rules: Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        :param pulumi.Input[_builtins.bool] enable_aws_usage: Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        :param pulumi.Input[_builtins.bool] enable_check_large_volume: Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        :param pulumi.Input[_builtins.bool] enable_logs_sync: Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] external_id: The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        :param pulumi.Input[_builtins.bool] import_cloud_watch: Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        :param pulumi.Input[_builtins.str] integration_id: The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        :param pulumi.Input[_builtins.str] key: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMetricStatsToSyncArgs', 'IntegrationMetricStatsToSyncArgsDict']]]] metric_stats_to_syncs: Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        :param pulumi.Input[_builtins.bool] metric_streams_managed_externally: If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationNamespaceSyncRuleArgs', 'IntegrationNamespaceSyncRuleArgsDict']]]] namespace_sync_rules: Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        :param pulumi.Input[_builtins.int] poll_rate: AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] sync_custom_namespaces_only: Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        :param pulumi.Input[_builtins.str] token: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        :param pulumi.Input[_builtins.bool] use_metric_streams_sync: Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS CloudWatch integrations for Splunk Observability Cloud. For help with this integration see [Monitoring Amazon Web Services](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/aws/get-awstoc.html).

        This resource implements a part of a workflow. Use it with one of either `aws.ExternalIntegration` or `aws.TokenIntegration`.

        > **NOTE** When managing integrations, use a session token of an administrator to authenticate the Splunk Observability provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator).

        ## Example

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_signalfx as signalfx

        #  This resource returns an account id in `external_id`…
        aws_myteam_external = signalfx.aws.ExternalIntegration("aws_myteam_external", name="My AWS integration")
        # Make yourself an AWS IAM role here, use `signalfx_aws_external_integration.aws_myteam_external.external_id`
        aws_sfx_example = aws.index.IamRole("aws_sfx_example")
        aws_myteam = signalfx.aws.Integration("aws_myteam",
            enabled=True,
            integration_id=aws_myteam_external.id,
            external_id=aws_myteam_external.external_id,
            role_arn=aws_sfx_role["arn"],
            regions=["us-east-1"],
            poll_rate=300,
            import_cloud_watch=True,
            enable_aws_usage=True,
            custom_namespace_sync_rules=[{
                "default_action": "Exclude",
                "filter_action": "Include",
                "filter_source": "filter('code', '200')",
                "namespace": "my-custom-namespace",
            }],
            namespace_sync_rules=[{
                "default_action": "Exclude",
                "filter_action": "Include",
                "filter_source": "filter('code', '200')",
                "namespace": "AWS/EC2",
            }],
            metric_stats_to_syncs=[{
                "namespace": "AWS/EC2",
                "metric": "NetworkPacketsIn",
                "stats": ["upper"],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collect_only_recommended_stats: Optional[pulumi.Input[_builtins.bool]] = None,
                 custom_cloudwatch_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespaceSyncRuleArgs', 'IntegrationCustomNamespaceSyncRuleArgsDict']]]]] = None,
                 enable_aws_usage: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_check_large_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_logs_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 import_cloud_watch: Optional[pulumi.Input[_builtins.bool]] = None,
                 integration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_stats_to_syncs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMetricStatsToSyncArgs', 'IntegrationMetricStatsToSyncArgsDict']]]]] = None,
                 metric_streams_managed_externally: Optional[pulumi.Input[_builtins.bool]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationNamespaceSyncRuleArgs', 'IntegrationNamespaceSyncRuleArgsDict']]]]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_custom_namespaces_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 use_metric_streams_sync: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["collect_only_recommended_stats"] = collect_only_recommended_stats
            __props__.__dict__["custom_cloudwatch_namespaces"] = custom_cloudwatch_namespaces
            __props__.__dict__["custom_namespace_sync_rules"] = custom_namespace_sync_rules
            __props__.__dict__["enable_aws_usage"] = enable_aws_usage
            __props__.__dict__["enable_check_large_volume"] = enable_check_large_volume
            __props__.__dict__["enable_logs_sync"] = enable_logs_sync
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["external_id"] = None if external_id is None else pulumi.Output.secret(external_id)
            __props__.__dict__["import_cloud_watch"] = import_cloud_watch
            if integration_id is None and not opts.urn:
                raise TypeError("Missing required property 'integration_id'")
            __props__.__dict__["integration_id"] = integration_id
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            __props__.__dict__["metric_stats_to_syncs"] = metric_stats_to_syncs
            __props__.__dict__["metric_streams_managed_externally"] = metric_streams_managed_externally
            __props__.__dict__["named_token"] = named_token
            __props__.__dict__["namespace_sync_rules"] = namespace_sync_rules
            __props__.__dict__["poll_rate"] = poll_rate
            if regions is None and not opts.urn:
                raise TypeError("Missing required property 'regions'")
            __props__.__dict__["regions"] = regions
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["services"] = services
            __props__.__dict__["sync_custom_namespaces_only"] = sync_custom_namespaces_only
            __props__.__dict__["token"] = token
            __props__.__dict__["use_metric_streams_sync"] = use_metric_streams_sync
            __props__.__dict__["auth_method"] = None
            __props__.__dict__["name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["externalId", "key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'signalfx:aws/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_method: Optional[pulumi.Input[_builtins.str]] = None,
            collect_only_recommended_stats: Optional[pulumi.Input[_builtins.bool]] = None,
            custom_cloudwatch_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            custom_namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespaceSyncRuleArgs', 'IntegrationCustomNamespaceSyncRuleArgsDict']]]]] = None,
            enable_aws_usage: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_check_large_volume: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_logs_sync: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            import_cloud_watch: Optional[pulumi.Input[_builtins.bool]] = None,
            integration_id: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            metric_stats_to_syncs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMetricStatsToSyncArgs', 'IntegrationMetricStatsToSyncArgsDict']]]]] = None,
            metric_streams_managed_externally: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            named_token: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_sync_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationNamespaceSyncRuleArgs', 'IntegrationNamespaceSyncRuleArgsDict']]]]] = None,
            poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sync_custom_namespaces_only: Optional[pulumi.Input[_builtins.bool]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            use_metric_streams_sync: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auth_method: The mechanism used to authenticate with AWS. Use one of `aws.ExternalIntegration` or `aws.TokenIntegration` to define this
        :param pulumi.Input[_builtins.bool] collect_only_recommended_stats: The integration will only ingest the recommended statistics published by AWS
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_cloudwatch_namespaces: List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespaceSyncRuleArgs', 'IntegrationCustomNamespaceSyncRuleArgsDict']]]] custom_namespace_sync_rules: Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        :param pulumi.Input[_builtins.bool] enable_aws_usage: Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        :param pulumi.Input[_builtins.bool] enable_check_large_volume: Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        :param pulumi.Input[_builtins.bool] enable_logs_sync: Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] external_id: The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        :param pulumi.Input[_builtins.bool] import_cloud_watch: Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        :param pulumi.Input[_builtins.str] integration_id: The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        :param pulumi.Input[_builtins.str] key: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationMetricStatsToSyncArgs', 'IntegrationMetricStatsToSyncArgsDict']]]] metric_stats_to_syncs: Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        :param pulumi.Input[_builtins.bool] metric_streams_managed_externally: If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationNamespaceSyncRuleArgs', 'IntegrationNamespaceSyncRuleArgsDict']]]] namespace_sync_rules: Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        :param pulumi.Input[_builtins.int] poll_rate: AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        :param pulumi.Input[_builtins.str] role_arn: Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        :param pulumi.Input[_builtins.bool] sync_custom_namespaces_only: Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        :param pulumi.Input[_builtins.str] token: If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        :param pulumi.Input[_builtins.bool] use_metric_streams_sync: Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["auth_method"] = auth_method
        __props__.__dict__["collect_only_recommended_stats"] = collect_only_recommended_stats
        __props__.__dict__["custom_cloudwatch_namespaces"] = custom_cloudwatch_namespaces
        __props__.__dict__["custom_namespace_sync_rules"] = custom_namespace_sync_rules
        __props__.__dict__["enable_aws_usage"] = enable_aws_usage
        __props__.__dict__["enable_check_large_volume"] = enable_check_large_volume
        __props__.__dict__["enable_logs_sync"] = enable_logs_sync
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["import_cloud_watch"] = import_cloud_watch
        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["key"] = key
        __props__.__dict__["metric_stats_to_syncs"] = metric_stats_to_syncs
        __props__.__dict__["metric_streams_managed_externally"] = metric_streams_managed_externally
        __props__.__dict__["name"] = name
        __props__.__dict__["named_token"] = named_token
        __props__.__dict__["namespace_sync_rules"] = namespace_sync_rules
        __props__.__dict__["poll_rate"] = poll_rate
        __props__.__dict__["regions"] = regions
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["services"] = services
        __props__.__dict__["sync_custom_namespaces_only"] = sync_custom_namespaces_only
        __props__.__dict__["token"] = token
        __props__.__dict__["use_metric_streams_sync"] = use_metric_streams_sync
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authMethod")
    def auth_method(self) -> pulumi.Output[_builtins.str]:
        """
        The mechanism used to authenticate with AWS. Use one of `aws.ExternalIntegration` or `aws.TokenIntegration` to define this
        """
        return pulumi.get(self, "auth_method")

    @_builtins.property
    @pulumi.getter(name="collectOnlyRecommendedStats")
    def collect_only_recommended_stats(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The integration will only ingest the recommended statistics published by AWS
        """
        return pulumi.get(self, "collect_only_recommended_stats")

    @_builtins.property
    @pulumi.getter(name="customCloudwatchNamespaces")
    def custom_cloudwatch_namespaces(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of custom AWS CloudWatch namespaces to monitor. Custom namespaces contain custom metrics that you define in AWS; Splunk Observability Cloud imports the metrics so you can monitor them.
        """
        return pulumi.get(self, "custom_cloudwatch_namespaces")

    @_builtins.property
    @pulumi.getter(name="customNamespaceSyncRules")
    def custom_namespace_sync_rules(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationCustomNamespaceSyncRule']]]:
        """
        Each element controls the data collected by Splunk Observability Cloud for the specified namespace. Conflicts with the `custom_cloudwatch_namespaces` property.
        """
        return pulumi.get(self, "custom_namespace_sync_rules")

    @_builtins.property
    @pulumi.getter(name="enableAwsUsage")
    def enable_aws_usage(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that controls how Splunk Observability Cloud imports usage metrics from AWS to use with AWS Cost Optimizer. If `true`, Splunk Observability Cloud imports the metrics.
        """
        return pulumi.get(self, "enable_aws_usage")

    @_builtins.property
    @pulumi.getter(name="enableCheckLargeVolume")
    def enable_check_large_volume(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Controls how Splunk Observability Cloud checks for large amounts of data for this AWS integration. If `true`, Splunk Observability Cloud monitors the amount of data coming in from the integration.
        """
        return pulumi.get(self, "enable_check_large_volume")

    @_builtins.property
    @pulumi.getter(name="enableLogsSync")
    def enable_logs_sync(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable the AWS logs synchronization. Note that this requires the inclusion of `"logs:DescribeLogGroups"`, `"logs:DeleteSubscriptionFilter"`, `"logs:DescribeSubscriptionFilters"`, `"logs:PutSubscriptionFilter"`, and `"s3:GetBucketLogging"`, `"s3:GetBucketNotification"`, `"s3:PutBucketNotification"` permissions. Additional permissions may be required to capture logs from specific AWS services.
        """
        return pulumi.get(self, "enable_logs_sync")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `external_id` property from one of a `aws.ExternalIntegration` or `aws.TokenIntegration`
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="importCloudWatch")
    def import_cloud_watch(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that controls how Splunk Observability Cloud imports Cloud Watch metrics. If true, Splunk Observability Cloud imports Cloud Watch metrics from AWS.
        """
        return pulumi.get(self, "import_cloud_watch")

    @_builtins.property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of one of a `aws.ExternalIntegration` or `aws.TokenIntegration`.
        """
        return pulumi.get(self, "integration_id")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the key (this is typically equivalent to the `AWS_SECRET_ACCESS_KEY` environment variable).
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="metricStatsToSyncs")
    def metric_stats_to_syncs(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationMetricStatsToSync']]]:
        """
        Each element in the array is an object that contains an AWS namespace name, AWS metric name and a list of statistics that Splunk Observability Cloud collects for this metric. If you specify this property, Splunk Observability Cloud retrieves only specified AWS statistics when AWS metric streams are not used. When AWS metric streams are used this property specifies additional extended statistics to collect (please note that AWS metric streams API supports percentile stats only; other stats are ignored). If you don't specify this property, Splunk Observability Cloud retrieves the AWS standard set of statistics.
        """
        return pulumi.get(self, "metric_stats_to_syncs")

    @_builtins.property
    @pulumi.getter(name="metricStreamsManagedExternally")
    def metric_streams_managed_externally(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, Splunk Observability Cloud accepts data from Metric Streams managed from the AWS console. The AWS account sending the Metric Streams and the AWS account in the Splunk Observability Cloud integration have to match. Requires `use_metric_streams_sync` set to true to work.
        """
        return pulumi.get(self, "metric_streams_managed_externally")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @_builtins.property
    @pulumi.getter(name="namespaceSyncRules")
    def namespace_sync_rules(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationNamespaceSyncRule']]]:
        """
        Each element in the array is an object that contains an AWS namespace name and a filter that controls the data that Splunk Observability Cloud collects for the namespace. Conflicts with the `services` property. If you don't specify either property, Splunk Observability Cloud syncs all data in all AWS namespaces.
        """
        return pulumi.get(self, "namespace_sync_rules")

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        AWS poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of AWS regions that Splunk Observability Cloud should monitor. It cannot be empty.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Role ARN that you add to an existing AWS integration object. **Note**: Ensure you use the `arn` property of your role, not the id!
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of AWS services that you want Splunk Observability Cloud to monitor. Each element is a string designating an AWS service. Can be an empty list to import data for all supported services. Conflicts with `namespace_sync_rule`. See [Amazon Web Services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#amazon-web-services) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter(name="syncCustomNamespacesOnly")
    def sync_custom_namespaces_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates that Splunk Observability Cloud should sync metrics and metadata from custom AWS namespaces only (see the `custom_namespace_sync_rule` above). Defaults to `false`.
        """
        return pulumi.get(self, "sync_custom_namespaces_only")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If you specify `auth_method = \\"SecurityToken\\"` in your request to create an AWS integration object, use this property to specify the token (this is typically equivalent to the `AWS_ACCESS_KEY_ID` environment variable).
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="useMetricStreamsSync")
    def use_metric_streams_sync(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable the use of Amazon Cloudwatch Metric Streams for ingesting metrics.<br> Note that this requires the inclusion of `"cloudwatch:ListMetricStreams"`,`"cloudwatch:GetMetricStream"`, `"cloudwatch:PutMetricStream"`, `"cloudwatch:DeleteMetricStream"`, `"cloudwatch:StartMetricStreams"`, `"cloudwatch:StopMetricStreams"` and `"iam:PassRole"` permissions.<br> Note you need to deploy additional resources on your AWS account to enable CloudWatch metrics streaming. Select one of the [CloudFormation templates](https://docs.splunk.com/Observability/gdi/get-data-in/connect/aws/aws-cloudformation.html) to deploy all the required resources.
        """
        return pulumi.get(self, "use_metric_streams_sync")

