# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 secret_key: pulumi.Input[_builtins.str],
                 services: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 subscriptions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 tenant_id: pulumi.Input[_builtins.str],
                 additional_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_namespaces_per_services: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 import_azure_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]]] = None,
                 sync_guest_os_namespaces: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_batch_api: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[_builtins.str] app_id: Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] secret_key: Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of Azure subscriptions that Splunk Observability Cloud should monitor.
        :param pulumi.Input[_builtins.str] tenant_id: Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_services: Additional Azure resource types that you want to sync with Observability Cloud.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]] custom_namespaces_per_services: Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        :param pulumi.Input[_builtins.str] environment: What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        :param pulumi.Input[_builtins.bool] import_azure_monitor: If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]] resource_filter_rules: List of rules for filtering Azure resources by their tags.
        :param pulumi.Input[_builtins.bool] sync_guest_os_namespaces: If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        :param pulumi.Input[_builtins.bool] use_batch_api: If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "subscriptions", subscriptions)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if additional_services is not None:
            pulumi.set(__self__, "additional_services", additional_services)
        if custom_namespaces_per_services is not None:
            pulumi.set(__self__, "custom_namespaces_per_services", custom_namespaces_per_services)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if import_azure_monitor is not None:
            pulumi.set(__self__, "import_azure_monitor", import_azure_monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_token is not None:
            pulumi.set(__self__, "named_token", named_token)
        if poll_rate is not None:
            pulumi.set(__self__, "poll_rate", poll_rate)
        if resource_filter_rules is not None:
            pulumi.set(__self__, "resource_filter_rules", resource_filter_rules)
        if sync_guest_os_namespaces is not None:
            pulumi.set(__self__, "sync_guest_os_namespaces", sync_guest_os_namespaces)
        if use_batch_api is not None:
            pulumi.set(__self__, "use_batch_api", use_batch_api)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of Azure subscriptions that Splunk Observability Cloud should monitor.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subscriptions", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalServices")
    def additional_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Additional Azure resource types that you want to sync with Observability Cloud.
        """
        return pulumi.get(self, "additional_services")

    @additional_services.setter
    def additional_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_services", value)

    @_builtins.property
    @pulumi.getter(name="customNamespacesPerServices")
    def custom_namespaces_per_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]]]:
        """
        Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        """
        return pulumi.get(self, "custom_namespaces_per_services")

    @custom_namespaces_per_services.setter
    def custom_namespaces_per_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]]]):
        pulumi.set(self, "custom_namespaces_per_services", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="importAzureMonitor")
    def import_azure_monitor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        """
        return pulumi.get(self, "import_azure_monitor")

    @import_azure_monitor.setter
    def import_azure_monitor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_azure_monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @named_token.setter
    def named_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "named_token", value)

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @poll_rate.setter
    def poll_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poll_rate", value)

    @_builtins.property
    @pulumi.getter(name="resourceFilterRules")
    def resource_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]]]:
        """
        List of rules for filtering Azure resources by their tags.
        """
        return pulumi.get(self, "resource_filter_rules")

    @resource_filter_rules.setter
    def resource_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]]]):
        pulumi.set(self, "resource_filter_rules", value)

    @_builtins.property
    @pulumi.getter(name="syncGuestOsNamespaces")
    def sync_guest_os_namespaces(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        """
        return pulumi.get(self, "sync_guest_os_namespaces")

    @sync_guest_os_namespaces.setter
    def sync_guest_os_namespaces(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_guest_os_namespaces", value)

    @_builtins.property
    @pulumi.getter(name="useBatchApi")
    def use_batch_api(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        return pulumi.get(self, "use_batch_api")

    @use_batch_api.setter
    def use_batch_api(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_batch_api", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 additional_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_namespaces_per_services: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 import_azure_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_guest_os_namespaces: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_batch_api: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_services: Additional Azure resource types that you want to sync with Observability Cloud.
        :param pulumi.Input[_builtins.str] app_id: Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]] custom_namespaces_per_services: Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] environment: What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        :param pulumi.Input[_builtins.bool] import_azure_monitor: If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]] resource_filter_rules: List of rules for filtering Azure resources by their tags.
        :param pulumi.Input[_builtins.str] secret_key: Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of Azure subscriptions that Splunk Observability Cloud should monitor.
        :param pulumi.Input[_builtins.bool] sync_guest_os_namespaces: If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        :param pulumi.Input[_builtins.str] tenant_id: Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[_builtins.bool] use_batch_api: If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        if additional_services is not None:
            pulumi.set(__self__, "additional_services", additional_services)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if custom_namespaces_per_services is not None:
            pulumi.set(__self__, "custom_namespaces_per_services", custom_namespaces_per_services)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if import_azure_monitor is not None:
            pulumi.set(__self__, "import_azure_monitor", import_azure_monitor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_token is not None:
            pulumi.set(__self__, "named_token", named_token)
        if poll_rate is not None:
            pulumi.set(__self__, "poll_rate", poll_rate)
        if resource_filter_rules is not None:
            pulumi.set(__self__, "resource_filter_rules", resource_filter_rules)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)
        if sync_guest_os_namespaces is not None:
            pulumi.set(__self__, "sync_guest_os_namespaces", sync_guest_os_namespaces)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_batch_api is not None:
            pulumi.set(__self__, "use_batch_api", use_batch_api)

    @_builtins.property
    @pulumi.getter(name="additionalServices")
    def additional_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Additional Azure resource types that you want to sync with Observability Cloud.
        """
        return pulumi.get(self, "additional_services")

    @additional_services.setter
    def additional_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_services", value)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="customNamespacesPerServices")
    def custom_namespaces_per_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]]]:
        """
        Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        """
        return pulumi.get(self, "custom_namespaces_per_services")

    @custom_namespaces_per_services.setter
    def custom_namespaces_per_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationCustomNamespacesPerServiceArgs']]]]):
        pulumi.set(self, "custom_namespaces_per_services", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="importAzureMonitor")
    def import_azure_monitor(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        """
        return pulumi.get(self, "import_azure_monitor")

    @import_azure_monitor.setter
    def import_azure_monitor(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "import_azure_monitor", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @named_token.setter
    def named_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "named_token", value)

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @poll_rate.setter
    def poll_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "poll_rate", value)

    @_builtins.property
    @pulumi.getter(name="resourceFilterRules")
    def resource_filter_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]]]:
        """
        List of rules for filtering Azure resources by their tags.
        """
        return pulumi.get(self, "resource_filter_rules")

    @resource_filter_rules.setter
    def resource_filter_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResourceFilterRuleArgs']]]]):
        pulumi.set(self, "resource_filter_rules", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Azure subscriptions that Splunk Observability Cloud should monitor.
        """
        return pulumi.get(self, "subscriptions")

    @subscriptions.setter
    def subscriptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subscriptions", value)

    @_builtins.property
    @pulumi.getter(name="syncGuestOsNamespaces")
    def sync_guest_os_namespaces(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        """
        return pulumi.get(self, "sync_guest_os_namespaces")

    @sync_guest_os_namespaces.setter
    def sync_guest_os_namespaces(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_guest_os_namespaces", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="useBatchApi")
    def use_batch_api(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        return pulumi.get(self, "use_batch_api")

    @use_batch_api.setter
    def use_batch_api(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_batch_api", value)


@pulumi.type_token("signalfx:azure/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_namespaces_per_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespacesPerServiceArgs', 'IntegrationCustomNamespacesPerServiceArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 import_azure_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResourceFilterRuleArgs', 'IntegrationResourceFilterRuleArgsDict']]]]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_guest_os_namespaces: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_batch_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Splunk Observability Cloud Azure integrations. For help with this integration see [Monitoring Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html).

        > **NOTE** When managing integrations, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator). Otherwise you'll receive a 4xx error.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        azure_myteam = signalfx.azure.Integration("azure_myteam",
            name="Azure Foo",
            enabled=True,
            environment="azure",
            poll_rate=300,
            secret_key="XXX",
            app_id="YYY",
            tenant_id="ZZZ",
            services=["microsoft.sql/servers/elasticpools"],
            subscriptions=["sub-guid-here"],
            additional_services=[
                "some/service",
                "another/service",
            ],
            custom_namespaces_per_services=[{
                "service": "Microsoft.Compute/virtualMachines",
                "namespaces": [
                    "monitoringAgent",
                    "customNamespace",
                ],
            }],
            resource_filter_rules=[
                {
                    "filter_source": "filter('azure_tag_service', 'payment') and (filter('azure_tag_env', 'prod-us') or filter('azure_tag_env', 'prod-eu'))",
                },
                {
                    "filter_source": "filter('azure_tag_service', 'notification') and (filter('azure_tag_env', 'prod-us') or filter('azure_tag_env', 'prod-eu'))",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_services: Additional Azure resource types that you want to sync with Observability Cloud.
        :param pulumi.Input[_builtins.str] app_id: Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespacesPerServiceArgs', 'IntegrationCustomNamespacesPerServiceArgsDict']]]] custom_namespaces_per_services: Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] environment: What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        :param pulumi.Input[_builtins.bool] import_azure_monitor: If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResourceFilterRuleArgs', 'IntegrationResourceFilterRuleArgsDict']]]] resource_filter_rules: List of rules for filtering Azure resources by their tags.
        :param pulumi.Input[_builtins.str] secret_key: Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of Azure subscriptions that Splunk Observability Cloud should monitor.
        :param pulumi.Input[_builtins.bool] sync_guest_os_namespaces: If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        :param pulumi.Input[_builtins.str] tenant_id: Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[_builtins.bool] use_batch_api: If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Splunk Observability Cloud Azure integrations. For help with this integration see [Monitoring Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html).

        > **NOTE** When managing integrations, use a session token of an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator). Otherwise you'll receive a 4xx error.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        azure_myteam = signalfx.azure.Integration("azure_myteam",
            name="Azure Foo",
            enabled=True,
            environment="azure",
            poll_rate=300,
            secret_key="XXX",
            app_id="YYY",
            tenant_id="ZZZ",
            services=["microsoft.sql/servers/elasticpools"],
            subscriptions=["sub-guid-here"],
            additional_services=[
                "some/service",
                "another/service",
            ],
            custom_namespaces_per_services=[{
                "service": "Microsoft.Compute/virtualMachines",
                "namespaces": [
                    "monitoringAgent",
                    "customNamespace",
                ],
            }],
            resource_filter_rules=[
                {
                    "filter_source": "filter('azure_tag_service', 'payment') and (filter('azure_tag_env', 'prod-us') or filter('azure_tag_env', 'prod-eu'))",
                },
                {
                    "filter_source": "filter('azure_tag_service', 'notification') and (filter('azure_tag_env', 'prod-us') or filter('azure_tag_env', 'prod-eu'))",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_namespaces_per_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespacesPerServiceArgs', 'IntegrationCustomNamespacesPerServiceArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 import_azure_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_token: Optional[pulumi.Input[_builtins.str]] = None,
                 poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResourceFilterRuleArgs', 'IntegrationResourceFilterRuleArgsDict']]]]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sync_guest_os_namespaces: Optional[pulumi.Input[_builtins.bool]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_batch_api: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["additional_services"] = additional_services
            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = None if app_id is None else pulumi.Output.secret(app_id)
            __props__.__dict__["custom_namespaces_per_services"] = custom_namespaces_per_services
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["environment"] = None if environment is None else pulumi.Output.secret(environment)
            __props__.__dict__["import_azure_monitor"] = import_azure_monitor
            __props__.__dict__["name"] = name
            __props__.__dict__["named_token"] = named_token
            __props__.__dict__["poll_rate"] = poll_rate
            __props__.__dict__["resource_filter_rules"] = resource_filter_rules
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            if subscriptions is None and not opts.urn:
                raise TypeError("Missing required property 'subscriptions'")
            __props__.__dict__["subscriptions"] = subscriptions
            __props__.__dict__["sync_guest_os_namespaces"] = sync_guest_os_namespaces
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_batch_api"] = use_batch_api
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["appId", "environment", "secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Integration, __self__).__init__(
            'signalfx:azure/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_namespaces_per_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespacesPerServiceArgs', 'IntegrationCustomNamespacesPerServiceArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            import_azure_monitor: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            named_token: Optional[pulumi.Input[_builtins.str]] = None,
            poll_rate: Optional[pulumi.Input[_builtins.int]] = None,
            resource_filter_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResourceFilterRuleArgs', 'IntegrationResourceFilterRuleArgsDict']]]]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subscriptions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sync_guest_os_namespaces: Optional[pulumi.Input[_builtins.bool]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            use_batch_api: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_services: Additional Azure resource types that you want to sync with Observability Cloud.
        :param pulumi.Input[_builtins.str] app_id: Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationCustomNamespacesPerServiceArgs', 'IntegrationCustomNamespacesPerServiceArgsDict']]]] custom_namespaces_per_services: Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        :param pulumi.Input[_builtins.bool] enabled: Whether the integration is enabled.
        :param pulumi.Input[_builtins.str] environment: What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        :param pulumi.Input[_builtins.bool] import_azure_monitor: If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        :param pulumi.Input[_builtins.str] name: Name of the integration.
        :param pulumi.Input[_builtins.str] named_token: Name of the org token to be used for data ingestion. If not specified then default access token is used.
        :param pulumi.Input[_builtins.int] poll_rate: Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResourceFilterRuleArgs', 'IntegrationResourceFilterRuleArgsDict']]]] resource_filter_rules: List of rules for filtering Azure resources by their tags.
        :param pulumi.Input[_builtins.str] secret_key: Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subscriptions: List of Azure subscriptions that Splunk Observability Cloud should monitor.
        :param pulumi.Input[_builtins.bool] sync_guest_os_namespaces: If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        :param pulumi.Input[_builtins.str] tenant_id: Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        :param pulumi.Input[_builtins.bool] use_batch_api: If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["additional_services"] = additional_services
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["custom_namespaces_per_services"] = custom_namespaces_per_services
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["environment"] = environment
        __props__.__dict__["import_azure_monitor"] = import_azure_monitor
        __props__.__dict__["name"] = name
        __props__.__dict__["named_token"] = named_token
        __props__.__dict__["poll_rate"] = poll_rate
        __props__.__dict__["resource_filter_rules"] = resource_filter_rules
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["services"] = services
        __props__.__dict__["subscriptions"] = subscriptions
        __props__.__dict__["sync_guest_os_namespaces"] = sync_guest_os_namespaces
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["use_batch_api"] = use_batch_api
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalServices")
    def additional_services(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Additional Azure resource types that you want to sync with Observability Cloud.
        """
        return pulumi.get(self, "additional_services")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        Azure application ID for the Splunk Observability Cloud app. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="customNamespacesPerServices")
    def custom_namespaces_per_services(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationCustomNamespacesPerService']]]:
        """
        Allows for more fine-grained control of syncing of custom namespaces, should the boolean convenience parameter `sync_guest_os_namespaces` be not enough. The customer may specify a map of services to custom namespaces. If they do so, for each service which is a key in this map, we will attempt to sync metrics from namespaces in the value list in addition to the default namespaces.
        """
        return pulumi.get(self, "custom_namespaces_per_services")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        What type of Azure integration this is. The allowed values are `\\"azure_us_government\\"` and `\\"azure\\"`. Defaults to `\\"azure\\"`.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="importAzureMonitor")
    def import_azure_monitor(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will sync also Azure Monitor data. If disabled, Splunk Observability Cloud will import only metadata. Defaults to true.
        """
        return pulumi.get(self, "import_azure_monitor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the integration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namedToken")
    def named_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the org token to be used for data ingestion. If not specified then default access token is used.
        """
        return pulumi.get(self, "named_token")

    @_builtins.property
    @pulumi.getter(name="pollRate")
    def poll_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Azure poll rate (in seconds). Value between `60` and `600`. Default: `300`.
        """
        return pulumi.get(self, "poll_rate")

    @_builtins.property
    @pulumi.getter(name="resourceFilterRules")
    def resource_filter_rules(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationResourceFilterRule']]]:
        """
        List of rules for filtering Azure resources by their tags.
        """
        return pulumi.get(self, "resource_filter_rules")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        Azure secret key that associates the Splunk Observability Cloud app in Azure with the Azure tenant ID. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of Microsoft Azure service names for the Azure services you want Splunk Observability Cloud to monitor. Can be an empty list to import data for all supported services. See [Microsoft Azure services](https://docs.splunk.com/Observability/gdi/get-data-in/integrations.html#azure-integrations) for a list of valid values.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def subscriptions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of Azure subscriptions that Splunk Observability Cloud should monitor.
        """
        return pulumi.get(self, "subscriptions")

    @_builtins.property
    @pulumi.getter(name="syncGuestOsNamespaces")
    def sync_guest_os_namespaces(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will try to sync additional namespaces for VMs (including VMs in scale sets): telegraf/mem, telegraf/cpu, azure.vm.windows.guest (these are namespaces recommended by Azure when enabling their Diagnostic Extension). If there are no metrics there, no new datapoints will be ingested. Defaults to false.
        """
        return pulumi.get(self, "sync_guest_os_namespaces")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Azure ID of the Azure tenant. To learn how to get this ID, see the topic [Connect to Microsoft Azure](https://docs.splunk.com/observability/en/gdi/get-data-in/connect/azure/azure.html) in the product documentation.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="useBatchApi")
    def use_batch_api(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If enabled, Splunk Observability Cloud will collect datapoints using Azure Metrics Batch API. Consider this option if you are synchronizing high loads of data and you want to avoid throttling issues. Contrary to the default Metrics List API, Metrics Batch API is paid. Refer to [Azure documentation](https://azure.microsoft.com/en-us/pricing/details/api-management/) for pricing info.
        """
        return pulumi.get(self, "use_batch_api")

