# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HeatmapChartArgs', 'HeatmapChart']

@pulumi.input_type
class HeatmapChartArgs:
    def __init__(__self__, *,
                 program_text: pulumi.Input[_builtins.str],
                 color_range: Optional[pulumi.Input['HeatmapChartColorRangeArgs']] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hide_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HeatmapChart resource.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        :param pulumi.Input['HeatmapChartColorRangeArgs'] color_range: Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]] color_scales: One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Properties to group by in the heatmap (in nesting order).
        :param pulumi.Input[_builtins.bool] hide_timestamp: Whether to show the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the heatmap.
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        pulumi.set(__self__, "program_text", program_text)
        if color_range is not None:
            pulumi.set(__self__, "color_range", color_range)
        if color_scales is not None:
            pulumi.set(__self__, "color_scales", color_scales)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if hide_timestamp is not None:
            pulumi.set(__self__, "hide_timestamp", hide_timestamp)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if minimum_resolution is not None:
            pulumi.set(__self__, "minimum_resolution", minimum_resolution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if sort_by is not None:
            pulumi.set(__self__, "sort_by", sort_by)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Input[_builtins.str]:
        """
        Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="colorRange")
    def color_range(self) -> Optional[pulumi.Input['HeatmapChartColorRangeArgs']]:
        """
        Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_range")

    @color_range.setter
    def color_range(self, value: Optional[pulumi.Input['HeatmapChartColorRangeArgs']]):
        pulumi.set(self, "color_range", value)

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]]]:
        """
        One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_scales")

    @color_scales.setter
    def color_scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]]]):
        pulumi.set(self, "color_scales", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Properties to group by in the heatmap (in nesting order).
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter(name="hideTimestamp")
    def hide_timestamp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to show the timestamp in the chart. `false` by default.
        """
        return pulumi.get(self, "hide_timestamp")

    @hide_timestamp.setter
    def hide_timestamp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="minimumResolution")
    def minimum_resolution(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum resolution (in seconds) to use for computing the underlying program.
        """
        return pulumi.get(self, "minimum_resolution")

    @minimum_resolution.setter
    def minimum_resolution(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_resolution", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to refresh the values of the heatmap.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        """
        return pulumi.get(self, "sort_by")

    @sort_by.setter
    def sort_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sort_by", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)


@pulumi.input_type
class _HeatmapChartState:
    def __init__(__self__, *,
                 color_range: Optional[pulumi.Input['HeatmapChartColorRangeArgs']] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hide_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HeatmapChart resources.
        :param pulumi.Input['HeatmapChartColorRangeArgs'] color_range: Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]] color_scales: One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Properties to group by in the heatmap (in nesting order).
        :param pulumi.Input[_builtins.bool] hide_timestamp: Whether to show the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the heatmap.
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        """
        if color_range is not None:
            pulumi.set(__self__, "color_range", color_range)
        if color_scales is not None:
            pulumi.set(__self__, "color_scales", color_scales)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_sampling is not None:
            pulumi.set(__self__, "disable_sampling", disable_sampling)
        if group_bies is not None:
            pulumi.set(__self__, "group_bies", group_bies)
        if hide_timestamp is not None:
            pulumi.set(__self__, "hide_timestamp", hide_timestamp)
        if max_delay is not None:
            pulumi.set(__self__, "max_delay", max_delay)
        if minimum_resolution is not None:
            pulumi.set(__self__, "minimum_resolution", minimum_resolution)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if program_text is not None:
            pulumi.set(__self__, "program_text", program_text)
        if refresh_interval is not None:
            pulumi.set(__self__, "refresh_interval", refresh_interval)
        if sort_by is not None:
            pulumi.set(__self__, "sort_by", sort_by)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if unit_prefix is not None:
            pulumi.set(__self__, "unit_prefix", unit_prefix)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="colorRange")
    def color_range(self) -> Optional[pulumi.Input['HeatmapChartColorRangeArgs']]:
        """
        Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_range")

    @color_range.setter
    def color_range(self, value: Optional[pulumi.Input['HeatmapChartColorRangeArgs']]):
        pulumi.set(self, "color_range", value)

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]]]:
        """
        One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_scales")

    @color_scales.setter
    def color_scales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeatmapChartColorScaleArgs']]]]):
        pulumi.set(self, "color_scales", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @disable_sampling.setter
    def disable_sampling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_sampling", value)

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Properties to group by in the heatmap (in nesting order).
        """
        return pulumi.get(self, "group_bies")

    @group_bies.setter
    def group_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_bies", value)

    @_builtins.property
    @pulumi.getter(name="hideTimestamp")
    def hide_timestamp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to show the timestamp in the chart. `false` by default.
        """
        return pulumi.get(self, "hide_timestamp")

    @hide_timestamp.setter
    def hide_timestamp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @max_delay.setter
    def max_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delay", value)

    @_builtins.property
    @pulumi.getter(name="minimumResolution")
    def minimum_resolution(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum resolution (in seconds) to use for computing the underlying program.
        """
        return pulumi.get(self, "minimum_resolution")

    @minimum_resolution.setter
    def minimum_resolution(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum_resolution", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        """
        return pulumi.get(self, "program_text")

    @program_text.setter
    def program_text(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "program_text", value)

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How often (in seconds) to refresh the values of the heatmap.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "refresh_interval", value)

    @_builtins.property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        """
        return pulumi.get(self, "sort_by")

    @sort_by.setter
    def sort_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sort_by", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @unit_prefix.setter
    def unit_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit_prefix", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("signalfx:index/heatmapChart:HeatmapChart")
class HeatmapChart(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color_range: Optional[pulumi.Input[Union['HeatmapChartColorRangeArgs', 'HeatmapChartColorRangeArgsDict']]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeatmapChartColorScaleArgs', 'HeatmapChartColorScaleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hide_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This chart type shows the specified plot in a heat map fashion. This format is similar to the [Infrastructure Navigator](https://signalfx-product-docs.readthedocs-hosted.com/en/latest/built-in-content/infra-nav.html#infra), with squares representing each source for the selected metric, and the color of each square representing the value range of the metric.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        myheatmapchart0 = signalfx.HeatmapChart("myheatmapchart0",
            name="CPU Total Idle - Heatmap",
            program_text=\"\"\"myfilters = filter("cluster_name", "prod") and filter("role", "search")
        data("cpu.total.idle", filter=myfilters).publish()
        \"\"\",
            description="Very cool Heatmap",
            disable_sampling=True,
            sort_by="+host",
            group_bies=[
                "hostname",
                "host",
            ],
            hide_timestamp=True,
            timezone="Europe/Paris",
            color_range={
                "min_value": 0,
                "max_value": 100,
                "color": "#ff0000",
            },
            color_scales=[
                {
                    "gte": 99,
                    "color": "green",
                },
                {
                    "lt": 99,
                    "gte": 95,
                    "color": "yellow",
                },
                {
                    "lt": 95,
                    "color": "red",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HeatmapChartColorRangeArgs', 'HeatmapChartColorRangeArgsDict']] color_range: Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['HeatmapChartColorScaleArgs', 'HeatmapChartColorScaleArgsDict']]]] color_scales: One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Properties to group by in the heatmap (in nesting order).
        :param pulumi.Input[_builtins.bool] hide_timestamp: Whether to show the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the heatmap.
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HeatmapChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This chart type shows the specified plot in a heat map fashion. This format is similar to the [Infrastructure Navigator](https://signalfx-product-docs.readthedocs-hosted.com/en/latest/built-in-content/infra-nav.html#infra), with squares representing each source for the selected metric, and the color of each square representing the value range of the metric.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        myheatmapchart0 = signalfx.HeatmapChart("myheatmapchart0",
            name="CPU Total Idle - Heatmap",
            program_text=\"\"\"myfilters = filter("cluster_name", "prod") and filter("role", "search")
        data("cpu.total.idle", filter=myfilters).publish()
        \"\"\",
            description="Very cool Heatmap",
            disable_sampling=True,
            sort_by="+host",
            group_bies=[
                "hostname",
                "host",
            ],
            hide_timestamp=True,
            timezone="Europe/Paris",
            color_range={
                "min_value": 0,
                "max_value": 100,
                "color": "#ff0000",
            },
            color_scales=[
                {
                    "gte": 99,
                    "color": "green",
                },
                {
                    "lt": 99,
                    "gte": 95,
                    "color": "yellow",
                },
                {
                    "lt": 95,
                    "color": "red",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param HeatmapChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HeatmapChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color_range: Optional[pulumi.Input[Union['HeatmapChartColorRangeArgs', 'HeatmapChartColorRangeArgsDict']]] = None,
                 color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeatmapChartColorScaleArgs', 'HeatmapChartColorScaleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hide_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 program_text: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 sort_by: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HeatmapChartArgs.__new__(HeatmapChartArgs)

            __props__.__dict__["color_range"] = color_range
            __props__.__dict__["color_scales"] = color_scales
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_sampling"] = disable_sampling
            __props__.__dict__["group_bies"] = group_bies
            __props__.__dict__["hide_timestamp"] = hide_timestamp
            __props__.__dict__["max_delay"] = max_delay
            __props__.__dict__["minimum_resolution"] = minimum_resolution
            __props__.__dict__["name"] = name
            if program_text is None and not opts.urn:
                raise TypeError("Missing required property 'program_text'")
            __props__.__dict__["program_text"] = program_text
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["sort_by"] = sort_by
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["unit_prefix"] = unit_prefix
            __props__.__dict__["url"] = None
        super(HeatmapChart, __self__).__init__(
            'signalfx:index/heatmapChart:HeatmapChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color_range: Optional[pulumi.Input[Union['HeatmapChartColorRangeArgs', 'HeatmapChartColorRangeArgsDict']]] = None,
            color_scales: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeatmapChartColorScaleArgs', 'HeatmapChartColorScaleArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_sampling: Optional[pulumi.Input[_builtins.bool]] = None,
            group_bies: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hide_timestamp: Optional[pulumi.Input[_builtins.bool]] = None,
            max_delay: Optional[pulumi.Input[_builtins.int]] = None,
            minimum_resolution: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            program_text: Optional[pulumi.Input[_builtins.str]] = None,
            refresh_interval: Optional[pulumi.Input[_builtins.int]] = None,
            sort_by: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            unit_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'HeatmapChart':
        """
        Get an existing HeatmapChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HeatmapChartColorRangeArgs', 'HeatmapChartColorRangeArgsDict']] color_range: Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['HeatmapChartColorScaleArgs', 'HeatmapChartColorScaleArgsDict']]]] color_scales: One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        :param pulumi.Input[_builtins.str] description: Description of the chart.
        :param pulumi.Input[_builtins.bool] disable_sampling: If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_bies: Properties to group by in the heatmap (in nesting order).
        :param pulumi.Input[_builtins.bool] hide_timestamp: Whether to show the timestamp in the chart. `false` by default.
        :param pulumi.Input[_builtins.int] max_delay: How long (in seconds) to wait for late datapoints.
        :param pulumi.Input[_builtins.int] minimum_resolution: The minimum resolution (in seconds) to use for computing the underlying program.
        :param pulumi.Input[_builtins.str] name: Name of the chart.
        :param pulumi.Input[_builtins.str] program_text: Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        :param pulumi.Input[_builtins.int] refresh_interval: How often (in seconds) to refresh the values of the heatmap.
        :param pulumi.Input[_builtins.str] sort_by: The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the resource
        :param pulumi.Input[_builtins.str] timezone: The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        :param pulumi.Input[_builtins.str] unit_prefix: Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HeatmapChartState.__new__(_HeatmapChartState)

        __props__.__dict__["color_range"] = color_range
        __props__.__dict__["color_scales"] = color_scales
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_sampling"] = disable_sampling
        __props__.__dict__["group_bies"] = group_bies
        __props__.__dict__["hide_timestamp"] = hide_timestamp
        __props__.__dict__["max_delay"] = max_delay
        __props__.__dict__["minimum_resolution"] = minimum_resolution
        __props__.__dict__["name"] = name
        __props__.__dict__["program_text"] = program_text
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["sort_by"] = sort_by
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["unit_prefix"] = unit_prefix
        __props__.__dict__["url"] = url
        return HeatmapChart(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="colorRange")
    def color_range(self) -> pulumi.Output[Optional['outputs.HeatmapChartColorRange']]:
        """
        Values and color for the color range. Example: `color_range : { min : 0, max : 100, color : "#0000ff" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_range")

    @_builtins.property
    @pulumi.getter(name="colorScales")
    def color_scales(self) -> pulumi.Output[Optional[Sequence['outputs.HeatmapChartColorScale']]]:
        """
        One to N blocks, each defining a single color range including both the color to display for that range and the borders of the range. Example: `color_scale { gt = 60, color = "blue" } color_scale { lte = 60, color = "yellow" }`. Look at this [link](https://docs.splunk.com/observability/en/data-visualization/charts/chart-options.html).
        """
        return pulumi.get(self, "color_scales")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableSampling")
    def disable_sampling(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `false`, samples a subset of the output MTS, which improves UI performance. `false` by default.
        """
        return pulumi.get(self, "disable_sampling")

    @_builtins.property
    @pulumi.getter(name="groupBies")
    def group_bies(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Properties to group by in the heatmap (in nesting order).
        """
        return pulumi.get(self, "group_bies")

    @_builtins.property
    @pulumi.getter(name="hideTimestamp")
    def hide_timestamp(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to show the timestamp in the chart. `false` by default.
        """
        return pulumi.get(self, "hide_timestamp")

    @_builtins.property
    @pulumi.getter(name="maxDelay")
    def max_delay(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long (in seconds) to wait for late datapoints.
        """
        return pulumi.get(self, "max_delay")

    @_builtins.property
    @pulumi.getter(name="minimumResolution")
    def minimum_resolution(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum resolution (in seconds) to use for computing the underlying program.
        """
        return pulumi.get(self, "minimum_resolution")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the chart.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="programText")
    def program_text(self) -> pulumi.Output[_builtins.str]:
        """
        Signalflow program text for the chart. More info at https://dev.splunk.com/observability/docs/signalflow/.
        """
        return pulumi.get(self, "program_text")

    @_builtins.property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How often (in seconds) to refresh the values of the heatmap.
        """
        return pulumi.get(self, "refresh_interval")

    @_builtins.property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property to use when sorting the elements. Must be prepended with `+` for ascending or `-` for descending (e.g. `-foo`).
        """
        return pulumi.get(self, "sort_by")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags associated with the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The property value is a string that denotes the geographic region associated with the time zone, (default UTC).
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="unitPrefix")
    def unit_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Must be `"Metric"` or `"Binary`". `"Metric"` by default.
        """
        return pulumi.get(self, "unit_prefix")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

