# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricRulesetArgs', 'MetricRuleset']

@pulumi.input_type
class MetricRulesetArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[_builtins.str],
                 routing_rules: pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]],
                 aggregation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]]] = None):
        """
        The set of arguments for constructing a MetricRuleset resource.
        :param pulumi.Input[_builtins.str] metric_name: Name of the input metric
        :param pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]] routing_rules: Routing Rule object
        :param pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]] aggregation_rules: List of aggregation rules for the metric
        :param pulumi.Input[_builtins.str] description: Information about the metric ruleset
        :param pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]] exception_rules: List of exception rules for the metric
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "routing_rules", routing_rules)
        if aggregation_rules is not None:
            pulumi.set(__self__, "aggregation_rules", aggregation_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exception_rules is not None:
            pulumi.set(__self__, "exception_rules", exception_rules)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the input metric
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]]:
        """
        Routing Rule object
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]]):
        pulumi.set(self, "routing_rules", value)

    @_builtins.property
    @pulumi.getter(name="aggregationRules")
    def aggregation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]]]:
        """
        List of aggregation rules for the metric
        """
        return pulumi.get(self, "aggregation_rules")

    @aggregation_rules.setter
    def aggregation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]]]):
        pulumi.set(self, "aggregation_rules", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Information about the metric ruleset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exceptionRules")
    def exception_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]]]:
        """
        List of exception rules for the metric
        """
        return pulumi.get(self, "exception_rules")

    @exception_rules.setter
    def exception_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]]]):
        pulumi.set(self, "exception_rules", value)


@pulumi.input_type
class _MetricRulesetState:
    def __init__(__self__, *,
                 aggregation_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]]] = None,
                 last_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 last_updated_by_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetricRuleset resources.
        :param pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]] aggregation_rules: List of aggregation rules for the metric
        :param pulumi.Input[_builtins.str] created: Timestamp of when the metric ruleset was created
        :param pulumi.Input[_builtins.str] creator: ID of the creator of the metric ruleset
        :param pulumi.Input[_builtins.str] description: Information about the metric ruleset
        :param pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]] exception_rules: List of exception rules for the metric
        :param pulumi.Input[_builtins.str] last_updated: Timestamp of when the metric ruleset was last updated
        :param pulumi.Input[_builtins.str] last_updated_by: ID of user who last updated the metric ruleset
        :param pulumi.Input[_builtins.str] last_updated_by_name: Name of user who last updated this metric ruleset
        :param pulumi.Input[_builtins.str] metric_name: Name of the input metric
        :param pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]] routing_rules: Routing Rule object
        :param pulumi.Input[_builtins.str] version: Version of the ruleset
        """
        if aggregation_rules is not None:
            pulumi.set(__self__, "aggregation_rules", aggregation_rules)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exception_rules is not None:
            pulumi.set(__self__, "exception_rules", exception_rules)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if last_updated_by_name is not None:
            pulumi.set(__self__, "last_updated_by_name", last_updated_by_name)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="aggregationRules")
    def aggregation_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]]]:
        """
        List of aggregation rules for the metric
        """
        return pulumi.get(self, "aggregation_rules")

    @aggregation_rules.setter
    def aggregation_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetAggregationRuleArgs']]]]):
        pulumi.set(self, "aggregation_rules", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the metric ruleset was created
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the creator of the metric ruleset
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Information about the metric ruleset
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exceptionRules")
    def exception_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]]]:
        """
        List of exception rules for the metric
        """
        return pulumi.get(self, "exception_rules")

    @exception_rules.setter
    def exception_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetExceptionRuleArgs']]]]):
        pulumi.set(self, "exception_rules", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the metric ruleset was last updated
        """
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of user who last updated the metric ruleset
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedByName")
    def last_updated_by_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of user who last updated this metric ruleset
        """
        return pulumi.get(self, "last_updated_by_name")

    @last_updated_by_name.setter
    def last_updated_by_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_updated_by_name", value)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the input metric
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]]]:
        """
        Routing Rule object
        """
        return pulumi.get(self, "routing_rules")

    @routing_rules.setter
    def routing_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRulesetRoutingRuleArgs']]]]):
        pulumi.set(self, "routing_rules", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the ruleset
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("signalfx:index/metricRuleset:MetricRuleset")
class MetricRuleset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetAggregationRuleArgs', 'MetricRulesetAggregationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetExceptionRuleArgs', 'MetricRulesetExceptionRuleArgsDict']]]]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetRoutingRuleArgs', 'MetricRulesetRoutingRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides an Observability Cloud resource for managing metric rulesets.

        > **NOTE** When managing metric rulesets to drop data use a session token for an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator). Otherwise you'll receive a 4xx error.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        cpu_utilization_metric_ruleset = signalfx.MetricRuleset("cpu_utilization_metric_ruleset",
            metric_name="cpu.utilization",
            description="Routing ruleset for cpu.utilization",
            aggregation_rules=[{
                "name": "cpu.utilization by service rule",
                "description": "Aggregates cpu.utilization data by service",
                "enabled": True,
                "matchers": [{
                    "type": "dimension",
                    "filters": [{
                        "property": "realm",
                        "property_values": ["us-east-1"],
                        "not_": False,
                    }],
                }],
                "aggregators": [{
                    "type": "rollup",
                    "dimensions": ["service"],
                    "drop_dimensions": False,
                    "output_name": "cpu.utilization.by.service.agg",
                }],
            }],
            exception_rules=[{
                "name": "Exception rule us-east-2",
                "description": "Routes us-east-2 data to real-time",
                "enabled": True,
                "matchers": [{
                    "type": "dimension",
                    "filters": [{
                        "property": "realm",
                        "property_values": ["us-east-2"],
                        "not_": False,
                    }],
                }],
            }],
            routing_rules=[{
                "destination": "Archived",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetAggregationRuleArgs', 'MetricRulesetAggregationRuleArgsDict']]]] aggregation_rules: List of aggregation rules for the metric
        :param pulumi.Input[_builtins.str] description: Information about the metric ruleset
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetExceptionRuleArgs', 'MetricRulesetExceptionRuleArgsDict']]]] exception_rules: List of exception rules for the metric
        :param pulumi.Input[_builtins.str] metric_name: Name of the input metric
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetRoutingRuleArgs', 'MetricRulesetRoutingRuleArgsDict']]]] routing_rules: Routing Rule object
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricRulesetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Observability Cloud resource for managing metric rulesets.

        > **NOTE** When managing metric rulesets to drop data use a session token for an administrator to authenticate the Splunk Observability Cloud provider. See [Operations that require a session token for an administrator](https://dev.splunk.com/observability/docs/administration/authtokens#Operations-that-require-a-session-token-for-an-administrator). Otherwise you'll receive a 4xx error.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        cpu_utilization_metric_ruleset = signalfx.MetricRuleset("cpu_utilization_metric_ruleset",
            metric_name="cpu.utilization",
            description="Routing ruleset for cpu.utilization",
            aggregation_rules=[{
                "name": "cpu.utilization by service rule",
                "description": "Aggregates cpu.utilization data by service",
                "enabled": True,
                "matchers": [{
                    "type": "dimension",
                    "filters": [{
                        "property": "realm",
                        "property_values": ["us-east-1"],
                        "not_": False,
                    }],
                }],
                "aggregators": [{
                    "type": "rollup",
                    "dimensions": ["service"],
                    "drop_dimensions": False,
                    "output_name": "cpu.utilization.by.service.agg",
                }],
            }],
            exception_rules=[{
                "name": "Exception rule us-east-2",
                "description": "Routes us-east-2 data to real-time",
                "enabled": True,
                "matchers": [{
                    "type": "dimension",
                    "filters": [{
                        "property": "realm",
                        "property_values": ["us-east-2"],
                        "not_": False,
                    }],
                }],
            }],
            routing_rules=[{
                "destination": "Archived",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param MetricRulesetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricRulesetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetAggregationRuleArgs', 'MetricRulesetAggregationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exception_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetExceptionRuleArgs', 'MetricRulesetExceptionRuleArgsDict']]]]] = None,
                 metric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetRoutingRuleArgs', 'MetricRulesetRoutingRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricRulesetArgs.__new__(MetricRulesetArgs)

            __props__.__dict__["aggregation_rules"] = aggregation_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["exception_rules"] = exception_rules
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            if routing_rules is None and not opts.urn:
                raise TypeError("Missing required property 'routing_rules'")
            __props__.__dict__["routing_rules"] = routing_rules
            __props__.__dict__["created"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["last_updated"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["last_updated_by_name"] = None
            __props__.__dict__["version"] = None
        super(MetricRuleset, __self__).__init__(
            'signalfx:index/metricRuleset:MetricRuleset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetAggregationRuleArgs', 'MetricRulesetAggregationRuleArgsDict']]]]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exception_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetExceptionRuleArgs', 'MetricRulesetExceptionRuleArgsDict']]]]] = None,
            last_updated: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            last_updated_by_name: Optional[pulumi.Input[_builtins.str]] = None,
            metric_name: Optional[pulumi.Input[_builtins.str]] = None,
            routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetRoutingRuleArgs', 'MetricRulesetRoutingRuleArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'MetricRuleset':
        """
        Get an existing MetricRuleset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetAggregationRuleArgs', 'MetricRulesetAggregationRuleArgsDict']]]] aggregation_rules: List of aggregation rules for the metric
        :param pulumi.Input[_builtins.str] created: Timestamp of when the metric ruleset was created
        :param pulumi.Input[_builtins.str] creator: ID of the creator of the metric ruleset
        :param pulumi.Input[_builtins.str] description: Information about the metric ruleset
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetExceptionRuleArgs', 'MetricRulesetExceptionRuleArgsDict']]]] exception_rules: List of exception rules for the metric
        :param pulumi.Input[_builtins.str] last_updated: Timestamp of when the metric ruleset was last updated
        :param pulumi.Input[_builtins.str] last_updated_by: ID of user who last updated the metric ruleset
        :param pulumi.Input[_builtins.str] last_updated_by_name: Name of user who last updated this metric ruleset
        :param pulumi.Input[_builtins.str] metric_name: Name of the input metric
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricRulesetRoutingRuleArgs', 'MetricRulesetRoutingRuleArgsDict']]]] routing_rules: Routing Rule object
        :param pulumi.Input[_builtins.str] version: Version of the ruleset
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricRulesetState.__new__(_MetricRulesetState)

        __props__.__dict__["aggregation_rules"] = aggregation_rules
        __props__.__dict__["created"] = created
        __props__.__dict__["creator"] = creator
        __props__.__dict__["description"] = description
        __props__.__dict__["exception_rules"] = exception_rules
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["last_updated_by_name"] = last_updated_by_name
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["routing_rules"] = routing_rules
        __props__.__dict__["version"] = version
        return MetricRuleset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aggregationRules")
    def aggregation_rules(self) -> pulumi.Output[Optional[Sequence['outputs.MetricRulesetAggregationRule']]]:
        """
        List of aggregation rules for the metric
        """
        return pulumi.get(self, "aggregation_rules")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the metric ruleset was created
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the creator of the metric ruleset
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Information about the metric ruleset
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="exceptionRules")
    def exception_rules(self) -> pulumi.Output[Optional[Sequence['outputs.MetricRulesetExceptionRule']]]:
        """
        List of exception rules for the metric
        """
        return pulumi.get(self, "exception_rules")

    @_builtins.property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the metric ruleset was last updated
        """
        return pulumi.get(self, "last_updated")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        ID of user who last updated the metric ruleset
        """
        return pulumi.get(self, "last_updated_by")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedByName")
    def last_updated_by_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of user who last updated this metric ruleset
        """
        return pulumi.get(self, "last_updated_by_name")

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the input metric
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> pulumi.Output[Sequence['outputs.MetricRulesetRoutingRule']]:
        """
        Routing Rule object
        """
        return pulumi.get(self, "routing_rules")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the ruleset
        """
        return pulumi.get(self, "version")

