# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SloChartArgs', 'SloChart']

@pulumi.input_type
class SloChartArgs:
    def __init__(__self__, *,
                 slo_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SloChart resource.
        :param pulumi.Input[_builtins.str] slo_id: ID of SLO object.
        """
        pulumi.set(__self__, "slo_id", slo_id)

    @_builtins.property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of SLO object.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slo_id", value)


@pulumi.input_type
class _SloChartState:
    def __init__(__self__, *,
                 slo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SloChart resources.
        :param pulumi.Input[_builtins.str] slo_id: ID of SLO object.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        """
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of SLO object.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slo_id", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("signalfx:index/sloChart:SloChart")
class SloChart(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 slo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This chart type displays an overview of your SLO and can give more specific insights into your SLI performance using different filter and customized time ranges.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        myslochart0 = signalfx.SloChart("myslochart0", slo_id="GbOHXbSAEAA")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] slo_id: ID of SLO object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SloChartArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This chart type displays an overview of your SLO and can give more specific insights into your SLI performance using different filter and customized time ranges.

        ## Example

        ```python
        import pulumi
        import pulumi_signalfx as signalfx

        myslochart0 = signalfx.SloChart("myslochart0", slo_id="GbOHXbSAEAA")
        ```

        :param str resource_name: The name of the resource.
        :param SloChartArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SloChartArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 slo_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SloChartArgs.__new__(SloChartArgs)

            if slo_id is None and not opts.urn:
                raise TypeError("Missing required property 'slo_id'")
            __props__.__dict__["slo_id"] = slo_id
            __props__.__dict__["url"] = None
        super(SloChart, __self__).__init__(
            'signalfx:index/sloChart:SloChart',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            slo_id: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'SloChart':
        """
        Get an existing SloChart resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] slo_id: ID of SLO object.
        :param pulumi.Input[_builtins.str] url: The URL of the chart.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SloChartState.__new__(_SloChartState)

        __props__.__dict__["slo_id"] = slo_id
        __props__.__dict__["url"] = url
        return SloChart(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of SLO object.
        """
        return pulumi.get(self, "slo_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the chart.
        """
        return pulumi.get(self, "url")

