from __future__ import annotations

from dataclasses import dataclass
from pathlib import Path


@dataclass
class SessionOptions:
    outdir: Path | None
    rate: int
    channels: int
    recording_format: str
    model: str
    # backend: str  # whisper|faster|whispercpp
    # device: str  # auto|cpu|cuda|mps
    lang: str | None
    translate: bool
    translate_to: list[str]
    native_segmentation: bool
    verbose: bool
    edit: bool
    debounce_ms: int
    buffer_sec: float
    overlap_ms: int
    profile: bool
    keep_chunks: bool
    prompt: bool
