# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .config_values import ConfigValues


class AuthProviderConnectionCreate(UniversalBaseModel):
    """
    Schema for creating an auth provider connection with credentials.
    """

    name: str = pydantic.Field()
    """
    Human-readable name for this auth provider connection
    """

    readable_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL-safe unique identifier for the connection. Must contain only lowercase letters, numbers, and hyphens. If not provided, it will be automatically generated from the connection name with a random suffix for uniqueness (e.g., 'composio-connection-ab123').
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional detailed description of what this auth provider connection provides.
    """

    short_name: str = pydantic.Field()
    """
    Technical identifier of the auth provider
    """

    auth_fields: typing.Optional[ConfigValues] = pydantic.Field(default=None)
    """
    Authentication credentials required to access the auth provider. The required fields vary by auth provider type.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
