# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .authentication_method import AuthenticationMethod


class AuthenticationDetails(UniversalBaseModel):
    """
    Authentication information.
    """

    method: AuthenticationMethod
    authenticated: bool
    authenticated_at: typing.Optional[dt.datetime] = None
    expires_at: typing.Optional[dt.datetime] = None
    auth_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    For pending OAuth flows
    """

    auth_url_expires: typing.Optional[dt.datetime] = None
    redirect_url: typing.Optional[str] = None
    provider_readable_id: typing.Optional[str] = None
    provider_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
