# MD005 - List indentation should be consistent

## What this rule does

Ensures all list items at the same level use the same indentation (0 spaces for top level, 2 spaces per nested level).

## Why this matters

- **Visual alignment**: Consistent indentation makes lists easier to scan
- **Readability**: Clear hierarchy helps readers understand list structure
- **Rendering**: Some Markdown processors require specific indentation
- **Maintenance**: Consistent spacing is easier to edit and update

## Examples

### ✅ Correct

```markdown
* Item 1
* Item 2
  * Nested item (2 spaces)
  * Another nested item
    * Deep nested (4 spaces)
* Item 3

1. First item
2. Second item
   1. Nested ordered (2 spaces)
   2. Another nested
3. Third item
```

### ❌ Incorrect

```markdown
* Item 1
 * Item 2 (wrong: 1 space)
   * Nested (wrong: 3 spaces)
    * Another (wrong: 4 spaces for level 2)

1. First item
 2. Second item (wrong: 1 space)
    1. Nested (wrong: 4 spaces)

```

### 🔧 Fixed

```markdown
* Item 1
* Item 2
  * Nested
  * Another

1. First item
2. Second item
   1. Nested
```

## Configuration

This rule has no configuration options. It enforces:
- 0 spaces for top-level items
- 2 spaces per nested level

## Automatic fixes

This rule automatically adjusts list item indentation to the correct number of spaces for each level.

## Learn more

- [CommonMark lists](https://spec.commonmark.org/0.31.2/#lists) - Technical specification
- [Markdown Guide - Lists](https://www.markdownguide.org/basic-syntax/#lists) - List formatting guide

## Related rules

- [MD004](md004.md) - Unordered list style should be consistent
- [MD007](md007.md) - Unordered list indentation
- [MD030](md030.md) - Spaces after list markers
