# MD054 - Use consistent link and image style

## What this rule does

Ensures all links and images in your document use the same formatting style for better consistency and readability.

## Why this matters

- **Professional appearance**: Mixed link styles make documents look disorganized
- **Easier maintenance**: Consistent style makes it easier to find and update links
- **Better readability**: Readers can quickly recognize and understand link patterns
- **Team consistency**: Everyone follows the same linking conventions

## Examples

<!-- rumdl-disable MD054 -->

### ✅ Correct (all inline style)

```markdown
Check out [our website](https://example.com) for more info.

See the [documentation](https://docs.example.com) for details.

View our ![company logo](https://example.com/logo.png).
```

### ✅ Correct (all reference style)

```markdown
Check out [our website][site] for more info.

See the [documentation][docs] for details.

View our ![company logo][logo].

[site]: https://example.com
[docs]: https://docs.example.com
[logo]: https://example.com/logo.png
```

### ❌ Incorrect (mixed styles)

```markdown
Check out [our website](https://example.com) for more info.

See the [documentation][docs] for details.

View our <https://example.com/contact> page.

[docs]: https://docs.example.com
```

### 🔧 Fixed

```markdown
Check out [our website](https://example.com) for more info.

See the [documentation](https://docs.example.com) for details.

View our [contact page](https://example.com/contact).
```

<!-- rumdl-enable MD054 -->

## Configuration

```yaml
MD054:
  style: "consistent"  # or "specified"
  styles: ["inline"]   # when style is "specified"
```

### Style options

- **`consistent`** (default): Use whatever style appears first in the document
- **`specified`**: Only allow the styles listed in the `styles` array

### Available link styles

- **`inline`**: `[text](url)` - Direct links
- **`full`**: `[text][ref]` - Full reference style
- **`collapsed`**: `[text][]` - Collapsed reference
- **`shortcut`**: `[text]` - Shortcut reference
- **`autolink`**: `<url>` - Automatic links

## Automatic fixes

This rule can automatically fix issues by:

- Converting all links to match the required style
- For "consistent" mode, converting to match the first style found
- Handling both links and images consistently

## Learn more

- [Markdown Guide: Links](https://www.markdownguide.org/basic-syntax/#links)
- [CommonMark: Links](https://spec.commonmark.org/0.31.2/#links)

## Related rules

- [MD042 - Ensure links have content](md042.md)
- [MD034 - Format bare URLs properly](md034.md)
- [MD052 - Fix broken reference links](md052.md)
