# HMM databases used by `bigecyhmm`

This database has been generated by using the HMM databases and files from [METABOLIC](https://github.com/AnantharamanLab/METABOLIC) as a foundation. These databases have been modified to create the one use by bigecyhmm. Several of the modification are presented below.

## Carbon cycle

Add `C-S-10:Acetogenesis WL` by adding new enzyme `fthfs` and using other already existing enzyme.

## Nitrogen cycle

Add a test HMM for the `nitric oxide dismutase` (nod). Due to the lack of known sequences for this enzyme, I think it is not that accurate to predict this function. I will try to update it when finding other sequences.

## Phosphorus cycle

The phosphorus cycle has been created from several souces by combining sources on the enzymes and major part of this cycles.

Two articles have been used to add enzymes:
- [Boden et al. (2024)](https://doi.org/10.1038/s41467-024-47914-0): `PhnD`, `PhnJ`, `PstS`, `PtxD`, `PitA`, `PNaS`, `PhnZ`, `PhnX`, `PhnA`, `PhnM`, `PhnW`, `PepM`, `Ppd`, `HtxB`, `HtxA` and `ptxB`. For enzymes `HtxB`, `HtxA` and `ptxB`, I have made their HMMs but I think they need more work (as with `nod`, because I did not find a lot of sequences annotated with this function).
- [Siles et al. (2022)](https://doi.org/10.1016/j.soilbio.2022.108826): `phoA`, `phoD`, `phoX`, `phoN`, `aphA`, `olpA`, `appA`, `phnG`, `phnH`, `phnI`, `phnK`, `phnL`, `ppa`, `ppx`, `ppk1`, `gcd`, `pqqC`, `phoB`, `phoR` and `phoU`.

These enzymes encompass steps of (1) `Organic P mineralization` (converting organic P into inorganic P), (2) `Inorganic P solubilization` (converting Insoluble P into Inorganic P), (3) `Inorganic P immobilisation` (converting inorganic P into organic P) and (4) `P-starvation response regulation`.
A first template figure has been generated to show all these different enzymes in a figure by combining these two articles.
Enzymes for `Organic P mineralization` has been selected as hydrolysis of organic P were limited by the presence of these enzymes ([Jarosch et al. (2019)](https://doi.org/10.1016/j.soilbio.2019.107628)).
Other sources for the search on these enzymes are: [Villarreal-Chiu et al. (2012)](https://doi.org/10.3389/fmicb.2012.00019).

The phosphorus cycle template has been generated by mergining information from several other articles:
- Figure 1 from [Zhao et al. (2024)](https://doi.org/10.1038/s43017-024-00603-4).
- Figure 1 from [Silva et al. (2023)](https://doi.org/10.3390/agriculture13020462).
- Figure 2 from [Zheng et al. (2022)](https://doi.org/10.1186/s40168-022-01292-1).
- Figure 5 from [Wang et al. (2023)](https://doi.org/10.1038/s41467-023-43297-w).
- Figure 1 from [Boden et al. (2024)](https://doi.org/10.1038/s41467-024-47914-0).
- Graphical Abstract and Supplementary Figure S2 from [Li et al. (2022)](https://doi.org/10.1016/j.isci.2022.105170).

A `Weathering` step was added as it is a main step towards generation of inorganic P ([Walker et al. (1976)](https://doi.org/10.1016/0016-7061(76)90066-5)).
`Dissolution` step has been added to take into account Phosphate Solubilizing Microorganisms as they increase the amount of available P ([Kalayu (2019)](https://doi.org/10.1155/2019/4917256)).