"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HugoDeploy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_certificatemanager_1 = require("aws-cdk-lib/aws-certificatemanager");
const aws_cloudfront_1 = require("aws-cdk-lib/aws-cloudfront");
const aws_cloudfront_origins_1 = require("aws-cdk-lib/aws-cloudfront-origins");
const aws_route53_1 = require("aws-cdk-lib/aws-route53");
const aws_route53_targets_1 = require("aws-cdk-lib/aws-route53-targets");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const aws_s3_deployment_1 = require("aws-cdk-lib/aws-s3-deployment");
const constructs_1 = require("constructs");
class HugoDeploy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.publicDir = props.publicDir;
        this.domainName = props.domainName;
        this.region = props.region ? props.region : 'us-east-1';
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            publicReadAccess: false,
        });
        const zone = props.zone
            ? props.zone
            : aws_route53_1.HostedZone.fromLookup(this, 'HostedZone', {
                domainName: this.domainName,
            });
        const certificate = new aws_certificatemanager_1.DnsValidatedCertificate(this, 'Certificate', {
            hostedZone: zone,
            domainName: this.domainName,
            region: this.region,
        });
        const cfFunction = new aws_cloudfront_1.Function(this, 'HugoPaths', {
            code: aws_cloudfront_1.FunctionCode.fromInline(`function handler(event) {
  var request = event.request;
  var uri = request.uri;
  if (uri.endsWith('/')) {
    request.uri += 'index.html';
  } else if (!uri.includes('.')) {
    request.uri += '/index.html';
  }
  return request;
}
`),
        });
        const distribution = new aws_cloudfront_1.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cloudfront_origins_1.S3Origin(bucket),
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                allowedMethods: aws_cloudfront_1.AllowedMethods.ALLOW_GET_HEAD,
                cachePolicy: aws_cloudfront_1.CachePolicy.CACHING_OPTIMIZED,
                functionAssociations: [
                    {
                        function: cfFunction,
                        eventType: aws_cloudfront_1.FunctionEventType.VIEWER_REQUEST,
                    },
                ],
            },
            domainNames: [this.domainName],
            certificate,
            minimumProtocolVersion: aws_cloudfront_1.SecurityPolicyProtocol.TLS_V1_2_2021,
            errorResponses: [
                {
                    httpStatus: 403,
                    responsePagePath: '/index.html',
                    responseHttpStatus: 200,
                },
                {
                    httpStatus: 404,
                    responsePagePath: '/index.html',
                    responseHttpStatus: 200,
                },
            ],
        });
        // deploy code
        new aws_s3_deployment_1.BucketDeployment(this, 'BucketDeployment', {
            sources: [aws_s3_deployment_1.Source.asset(`${this.publicDir}/`)],
            destinationBucket: bucket,
            distribution,
            distributionPaths: ['/', '/index.html'],
        });
        // Route53
        new aws_route53_1.ARecord(this, 'Alias', {
            zone,
            recordName: this.domainName,
            target: aws_route53_1.RecordTarget.fromAlias(new aws_route53_targets_1.CloudFrontTarget(distribution)),
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
HugoDeploy[_a] = { fqn: "cdk-hugo-deploy.HugoDeploy", version: "0.0.330" };
exports.HugoDeploy = HugoDeploy;
//# sourceMappingURL=data:application/json;base64,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