# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List, Optional
from typing_extensions import Literal

import httpx

from .. import _legacy_response
from ..types import (
    account_collection_flow_list_params,
    account_collection_flow_create_params,
    account_collection_flow_update_params,
)
from .._types import Body, Omit, Query, Headers, NotGiven, SequenceNotStr, omit, not_given
from .._utils import maybe_transform, async_maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import to_streamed_response_wrapper, async_to_streamed_response_wrapper
from ..pagination import SyncPage, AsyncPage
from .._base_client import AsyncPaginator, make_request_options
from ..types.account_collection_flow import AccountCollectionFlow

__all__ = ["AccountCollectionFlows", "AsyncAccountCollectionFlows"]


class AccountCollectionFlows(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AccountCollectionFlowsWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#accessing-raw-response-data-eg-headers
        """
        return AccountCollectionFlowsWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AccountCollectionFlowsWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#with_streaming_response
        """
        return AccountCollectionFlowsWithStreamingResponse(self)

    def create(
        self,
        *,
        counterparty_id: str,
        payment_types: SequenceNotStr[str],
        receiving_countries: List[
            Literal[
                "USA",
                "AUS",
                "BEL",
                "CAN",
                "CHL",
                "CHN",
                "COL",
                "FRA",
                "DEU",
                "HKG",
                "IND",
                "IRL",
                "ITA",
                "MEX",
                "NLD",
                "PER",
                "ESP",
                "GBR",
            ]
        ]
        | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> AccountCollectionFlow:
        """
        create account_collection_flow

        Args:
          counterparty_id: Required.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        return self._post(
            "/api/account_collection_flows",
            body=maybe_transform(
                {
                    "counterparty_id": counterparty_id,
                    "payment_types": payment_types,
                    "receiving_countries": receiving_countries,
                },
                account_collection_flow_create_params.AccountCollectionFlowCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=AccountCollectionFlow,
        )

    def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AccountCollectionFlow:
        """
        get account_collection_flow

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._get(
            f"/api/account_collection_flows/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AccountCollectionFlow,
        )

    def update(
        self,
        id: str,
        *,
        status: Literal["cancelled"],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> AccountCollectionFlow:
        """update account_collection_flow

        Args:
          status: Required.

        The updated status of the account collection flow. Can only be used to
              mark a flow as `cancelled`.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._patch(
            f"/api/account_collection_flows/{id}",
            body=maybe_transform(
                {"status": status}, account_collection_flow_update_params.AccountCollectionFlowUpdateParams
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=AccountCollectionFlow,
        )

    def list(
        self,
        *,
        after_cursor: Optional[str] | Omit = omit,
        client_token: str | Omit = omit,
        counterparty_id: str | Omit = omit,
        external_account_id: str | Omit = omit,
        per_page: int | Omit = omit,
        status: str | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> SyncPage[AccountCollectionFlow]:
        """
        list account_collection_flows

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/api/account_collection_flows",
            page=SyncPage[AccountCollectionFlow],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "after_cursor": after_cursor,
                        "client_token": client_token,
                        "counterparty_id": counterparty_id,
                        "external_account_id": external_account_id,
                        "per_page": per_page,
                        "status": status,
                    },
                    account_collection_flow_list_params.AccountCollectionFlowListParams,
                ),
            ),
            model=AccountCollectionFlow,
        )


class AsyncAccountCollectionFlows(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncAccountCollectionFlowsWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#accessing-raw-response-data-eg-headers
        """
        return AsyncAccountCollectionFlowsWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncAccountCollectionFlowsWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#with_streaming_response
        """
        return AsyncAccountCollectionFlowsWithStreamingResponse(self)

    async def create(
        self,
        *,
        counterparty_id: str,
        payment_types: SequenceNotStr[str],
        receiving_countries: List[
            Literal[
                "USA",
                "AUS",
                "BEL",
                "CAN",
                "CHL",
                "CHN",
                "COL",
                "FRA",
                "DEU",
                "HKG",
                "IND",
                "IRL",
                "ITA",
                "MEX",
                "NLD",
                "PER",
                "ESP",
                "GBR",
            ]
        ]
        | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> AccountCollectionFlow:
        """
        create account_collection_flow

        Args:
          counterparty_id: Required.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        return await self._post(
            "/api/account_collection_flows",
            body=await async_maybe_transform(
                {
                    "counterparty_id": counterparty_id,
                    "payment_types": payment_types,
                    "receiving_countries": receiving_countries,
                },
                account_collection_flow_create_params.AccountCollectionFlowCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=AccountCollectionFlow,
        )

    async def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AccountCollectionFlow:
        """
        get account_collection_flow

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._get(
            f"/api/account_collection_flows/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AccountCollectionFlow,
        )

    async def update(
        self,
        id: str,
        *,
        status: Literal["cancelled"],
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> AccountCollectionFlow:
        """update account_collection_flow

        Args:
          status: Required.

        The updated status of the account collection flow. Can only be used to
              mark a flow as `cancelled`.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._patch(
            f"/api/account_collection_flows/{id}",
            body=await async_maybe_transform(
                {"status": status}, account_collection_flow_update_params.AccountCollectionFlowUpdateParams
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=AccountCollectionFlow,
        )

    def list(
        self,
        *,
        after_cursor: Optional[str] | Omit = omit,
        client_token: str | Omit = omit,
        counterparty_id: str | Omit = omit,
        external_account_id: str | Omit = omit,
        per_page: int | Omit = omit,
        status: str | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AsyncPaginator[AccountCollectionFlow, AsyncPage[AccountCollectionFlow]]:
        """
        list account_collection_flows

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/api/account_collection_flows",
            page=AsyncPage[AccountCollectionFlow],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "after_cursor": after_cursor,
                        "client_token": client_token,
                        "counterparty_id": counterparty_id,
                        "external_account_id": external_account_id,
                        "per_page": per_page,
                        "status": status,
                    },
                    account_collection_flow_list_params.AccountCollectionFlowListParams,
                ),
            ),
            model=AccountCollectionFlow,
        )


class AccountCollectionFlowsWithRawResponse:
    def __init__(self, account_collection_flows: AccountCollectionFlows) -> None:
        self._account_collection_flows = account_collection_flows

        self.create = _legacy_response.to_raw_response_wrapper(
            account_collection_flows.create,
        )
        self.retrieve = _legacy_response.to_raw_response_wrapper(
            account_collection_flows.retrieve,
        )
        self.update = _legacy_response.to_raw_response_wrapper(
            account_collection_flows.update,
        )
        self.list = _legacy_response.to_raw_response_wrapper(
            account_collection_flows.list,
        )


class AsyncAccountCollectionFlowsWithRawResponse:
    def __init__(self, account_collection_flows: AsyncAccountCollectionFlows) -> None:
        self._account_collection_flows = account_collection_flows

        self.create = _legacy_response.async_to_raw_response_wrapper(
            account_collection_flows.create,
        )
        self.retrieve = _legacy_response.async_to_raw_response_wrapper(
            account_collection_flows.retrieve,
        )
        self.update = _legacy_response.async_to_raw_response_wrapper(
            account_collection_flows.update,
        )
        self.list = _legacy_response.async_to_raw_response_wrapper(
            account_collection_flows.list,
        )


class AccountCollectionFlowsWithStreamingResponse:
    def __init__(self, account_collection_flows: AccountCollectionFlows) -> None:
        self._account_collection_flows = account_collection_flows

        self.create = to_streamed_response_wrapper(
            account_collection_flows.create,
        )
        self.retrieve = to_streamed_response_wrapper(
            account_collection_flows.retrieve,
        )
        self.update = to_streamed_response_wrapper(
            account_collection_flows.update,
        )
        self.list = to_streamed_response_wrapper(
            account_collection_flows.list,
        )


class AsyncAccountCollectionFlowsWithStreamingResponse:
    def __init__(self, account_collection_flows: AsyncAccountCollectionFlows) -> None:
        self._account_collection_flows = account_collection_flows

        self.create = async_to_streamed_response_wrapper(
            account_collection_flows.create,
        )
        self.retrieve = async_to_streamed_response_wrapper(
            account_collection_flows.retrieve,
        )
        self.update = async_to_streamed_response_wrapper(
            account_collection_flows.update,
        )
        self.list = async_to_streamed_response_wrapper(
            account_collection_flows.list,
        )
