# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Optional
from typing_extensions import Literal

import httpx

from .. import _legacy_response
from ..types import bulk_result_list_params
from .._types import Body, Omit, Query, Headers, NotGiven, omit, not_given
from .._utils import maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import to_streamed_response_wrapper, async_to_streamed_response_wrapper
from ..pagination import SyncPage, AsyncPage
from .._base_client import AsyncPaginator, make_request_options
from ..types.bulk_result import BulkResult

__all__ = ["BulkResults", "AsyncBulkResults"]


class BulkResults(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> BulkResultsWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#accessing-raw-response-data-eg-headers
        """
        return BulkResultsWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> BulkResultsWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#with_streaming_response
        """
        return BulkResultsWithStreamingResponse(self)

    def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> BulkResult:
        """
        get bulk_result

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._get(
            f"/api/bulk_results/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=BulkResult,
        )

    def list(
        self,
        *,
        after_cursor: Optional[str] | Omit = omit,
        entity_id: str | Omit = omit,
        entity_type: Literal[
            "payment_order",
            "ledger_account",
            "ledger_transaction",
            "expected_payment",
            "transaction",
            "entity_link",
            "transaction_line_item",
            "bulk_error",
        ]
        | Omit = omit,
        per_page: int | Omit = omit,
        request_id: str | Omit = omit,
        request_type: Literal["bulk_request"] | Omit = omit,
        status: Literal["pending", "successful", "failed"] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> SyncPage[BulkResult]:
        """
        list bulk_results

        Args:
          entity_id: Unique identifier for the result entity object.

          entity_type: The type of the request that created this result. bulk_request is the only
              supported `request_type`

          request_id: Unique identifier for the request that created this bulk result. This is the ID
              of the bulk request when `request_type` is bulk_request

          request_type: The type of the request that created this result. bulk_request is the only
              supported `request_type`

          status: One of successful or failed.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/api/bulk_results",
            page=SyncPage[BulkResult],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "after_cursor": after_cursor,
                        "entity_id": entity_id,
                        "entity_type": entity_type,
                        "per_page": per_page,
                        "request_id": request_id,
                        "request_type": request_type,
                        "status": status,
                    },
                    bulk_result_list_params.BulkResultListParams,
                ),
            ),
            model=BulkResult,
        )


class AsyncBulkResults(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncBulkResultsWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#accessing-raw-response-data-eg-headers
        """
        return AsyncBulkResultsWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncBulkResultsWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Modern-Treasury/modern-treasury-python#with_streaming_response
        """
        return AsyncBulkResultsWithStreamingResponse(self)

    async def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> BulkResult:
        """
        get bulk_result

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._get(
            f"/api/bulk_results/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=BulkResult,
        )

    def list(
        self,
        *,
        after_cursor: Optional[str] | Omit = omit,
        entity_id: str | Omit = omit,
        entity_type: Literal[
            "payment_order",
            "ledger_account",
            "ledger_transaction",
            "expected_payment",
            "transaction",
            "entity_link",
            "transaction_line_item",
            "bulk_error",
        ]
        | Omit = omit,
        per_page: int | Omit = omit,
        request_id: str | Omit = omit,
        request_type: Literal["bulk_request"] | Omit = omit,
        status: Literal["pending", "successful", "failed"] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AsyncPaginator[BulkResult, AsyncPage[BulkResult]]:
        """
        list bulk_results

        Args:
          entity_id: Unique identifier for the result entity object.

          entity_type: The type of the request that created this result. bulk_request is the only
              supported `request_type`

          request_id: Unique identifier for the request that created this bulk result. This is the ID
              of the bulk request when `request_type` is bulk_request

          request_type: The type of the request that created this result. bulk_request is the only
              supported `request_type`

          status: One of successful or failed.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/api/bulk_results",
            page=AsyncPage[BulkResult],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "after_cursor": after_cursor,
                        "entity_id": entity_id,
                        "entity_type": entity_type,
                        "per_page": per_page,
                        "request_id": request_id,
                        "request_type": request_type,
                        "status": status,
                    },
                    bulk_result_list_params.BulkResultListParams,
                ),
            ),
            model=BulkResult,
        )


class BulkResultsWithRawResponse:
    def __init__(self, bulk_results: BulkResults) -> None:
        self._bulk_results = bulk_results

        self.retrieve = _legacy_response.to_raw_response_wrapper(
            bulk_results.retrieve,
        )
        self.list = _legacy_response.to_raw_response_wrapper(
            bulk_results.list,
        )


class AsyncBulkResultsWithRawResponse:
    def __init__(self, bulk_results: AsyncBulkResults) -> None:
        self._bulk_results = bulk_results

        self.retrieve = _legacy_response.async_to_raw_response_wrapper(
            bulk_results.retrieve,
        )
        self.list = _legacy_response.async_to_raw_response_wrapper(
            bulk_results.list,
        )


class BulkResultsWithStreamingResponse:
    def __init__(self, bulk_results: BulkResults) -> None:
        self._bulk_results = bulk_results

        self.retrieve = to_streamed_response_wrapper(
            bulk_results.retrieve,
        )
        self.list = to_streamed_response_wrapper(
            bulk_results.list,
        )


class AsyncBulkResultsWithStreamingResponse:
    def __init__(self, bulk_results: AsyncBulkResults) -> None:
        self._bulk_results = bulk_results

        self.retrieve = async_to_streamed_response_wrapper(
            bulk_results.retrieve,
        )
        self.list = async_to_streamed_response_wrapper(
            bulk_results.list,
        )
