[![pypi](https://img.shields.io/pypi/v/ShuttleASGI.svg?color=blue)](https://pypi.org/project/ShuttleASGI/)
[![versions](https://img.shields.io/pypi/pyversions/shuttleasgi.svg)](https://github.com/shuttleai/shuttleasgi)
[![license](https://img.shields.io/github/license/shuttleai/ShuttleASGI.svg)](https://github.com/Neoteroi/blacksheep/blob/main/LICENSE)
[![black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![discord](https://img.shields.io/discord/1152262611291869237?style=plastic&logo=discord&logoColor=violet&label=Discord&labelColor=white&color=7289DA)](https://discord.gg/shuttleai)
[![documentation](https://img.shields.io/badge/📖-docs-purple?label=BlackSheep)](https://www.neoteroi.dev/blacksheep/)
[![docs](https://img.shields.io/badge/📖-docs-purple?label=ShuttleAI%20API)](https://docs.shuttleai.app/)

# ShuttleASGI

ShuttleASGI is a high-performance ASGI framework, forked from BlackSheep and optimized for building fast web applications in Python.

The official framework used and made by the [ShuttleAI API](https://api.shuttleai.app/).

## Features

- 🚀 Optimized for performance and developer productivity

- 🔍 Enhanced JSON parsing and serialization

- 🔧 Extra features disabled by default to improve speed

- 📝 Proper handling of 405 Method Not Allowed responses

- 📡 OpenAI-formatted SSE responses

- 🐍 Built on top of the super fast [BlackSheep](https://github.com/Neoteroi/BlackSheep) framework

## Installation

To get started with ShuttleASGI, make sure you have Python 3.7 or later installed. Then run:

```shell

pip install -U shuttleasgi

```

## Quickstart

Want to create your own AI API in under a minute? Check out the [ShuttleASGI-AIAPI Cookie Cutter Template](https://herumes/ShuttleASGI-AIAPI) for a quick and easy setup!

## Documentation

You can also find helpful information in the [BlackSheep documentation](https://www.neoteroi.dev/blacksheep/).
You may also reach out to me directly for assistance.

## Community

Join our [Discord community](https://discord.gg/shuttleai) to connect with other developers, ask questions, and stay updated on the latest news and releases.

## License

ShuttleASGI is released under the [MIT License](https://github.com/Neoteroi/blacksheep/blob/main/LICENSE).
