from typing import Any, Callable, Dict, Generator, List, Optional, Sequence, Union

from guardpost import Identity

from .asgi import ASGIScopeInterface
from .contents import Content, FormPart
from .cookies import Cookie
from .headers import Headers, HeaderType
from .sessions import Session
from .settings.json import json_settings
from .url import URL

class Message:
    @property
    def headers(self) -> Headers: ...
    def content_type(self) -> bytes: ...
    def get_first_header(self, key: bytes) -> Optional[bytes]: ...
    def get_headers(self, key: bytes) -> List[bytes]: ...
    def get_single_header(self, key: bytes) -> bytes: ...
    def remove_header(self, key: bytes) -> None: ...
    def has_header(self, key: bytes) -> bool: ...
    def add_header(self, name: bytes, value: bytes) -> None: ...
    def set_header(self, key: bytes, value: bytes) -> None: ...
    async def read(self) -> Optional[bytes]: ...
    async def stream(self) -> Generator[bytes, None, None]: ...
    async def text(self) -> str: ...
    async def form(self) -> Union[Dict[str, str], Dict[str, List[str]], None]:
        """
        Returns values read either from multipart or www-form-urlencoded
        payload.

        This function adopts some compromises to provide a consistent api,
        returning a dictionary of key: values pairs.
        If a key is unique, the value is a single string; if a key is
        duplicated (licit in both form types), the value is a list of strings.

        Multipart form parts values that can be decoded as UTF8 are decoded,
        otherwise kept as raw bytes.
        In case of ambiguity, use the dedicated `multiparts()` method.
        """

    async def multipart(self) -> List[FormPart]:
        """
        Returns parts read from multipart/form-data, if present, otherwise
        None
        """

    def declares_content_type(self, type: bytes) -> bool: ...
    def declares_json(self) -> bool: ...
    def declares_xml(self) -> bool: ...
    async def files(self, name: Optional[str] = None) -> List[FormPart]: ...
    async def json(self, loads: Callable[[str], Any] = json_settings.loads) -> Any: ...
    def has_body(self) -> bool: ...
    @property
    def charset(self) -> str: ...

Cookies = Dict[str, Cookie]

def method_without_body(method: str) -> bool: ...

class Request(Message):
    def __init__(
        self, method: str, url: bytes, headers: Optional[List[HeaderType]]
    ) -> None:
        self.method: str = ...
        self._url: URL = ...
        self.route_values: Optional[Dict[str, str]] = ...
        self.content: Optional[Content] = ...
        self.identity: Optional[Identity] = ...
        self.user: Optional[Identity] = ...
        self.scope: ASGIScopeInterface = ...
        self._session: Optional[Session]

    @classmethod
    def incoming(
        cls, method: str, path: bytes, query: bytes, headers: List[HeaderType]
    ) -> "Request": ...
    @property
    def query(self) -> Dict[str, List[str]]: ...
    @query.setter
    def query(self, value: Dict[str, Union[str, Sequence[str]]]): ...
    @property
    def url(self) -> URL: ...
    @url.setter
    def url(self, value: Union[URL, bytes, str]) -> None: ...
    def __repr__(self) -> str: ...
    @property
    def session(self) -> Session: ...
    @session.setter
    def session(self, value: Session) -> None: ...
    @property
    def cookies(self) -> Dict[str, str]: ...
    def get_cookie(self, name: str) -> Optional[str]: ...
    def set_cookie(self, name: str, value: str) -> None: ...
    @property
    def etag(self) -> Optional[bytes]: ...
    @property
    def if_none_match(self) -> Optional[bytes]: ...
    def expect_100_continue(self) -> bool: ...
    def with_content(self, content: Content) -> "Request": ...
    @property
    def session(self) -> Session: ...
    @session.setter
    def session(self, value: Session) -> None: ...
    @property
    def base_path(self) -> str:
        """
        Gets or sets the base_path of the request, if any. A base_path can be specified
        in two ways: when using the `root_path` of the ASGI specification, the base_path
        returns the root_path from the scope. Alternatively, when using a prefix for
        the ShuttleASGI application (e.g. using the env variable `APP_ROUTE_PREFIX`), the
        base_path is populated automatically with that value.
        ASGI `root_path` and route prefix in ShuttleASGI are two alternative ways to
        address the same issue and should not be used together.
        """

    @base_path.setter
    def base_path(self, value: str) -> None: ...
    @property
    def scheme(self) -> str: ...
    @scheme.setter
    def scheme(self, value: str) -> None: ...
    @property
    def host(self) -> str: ...
    @host.setter
    def host(self, value: str) -> None: ...
    @property
    def client_ip(self) -> str: ...
    @property
    def original_client_ip(self) -> str: ...
    @original_client_ip.setter
    def original_client_ip(self, value: str) -> None: ...
    @property
    def path(self) -> str: ...
    async def is_disconnected(self) -> bool:
        """
        Returns a value indicating whether the web request is still bound to an active
        connection. In case of long-polling, this method returns True if the client
        closed the original connection. For requests originated from a web browser, this
        method returns True also if the user refreshed a page that originated a web
        request, or the connection got lost and a page initiated a new request.

        Because this method relies on reading incoming ASGI messages, it can only be
        used for incoming web requests handled through an ASGI server, and it must not
        be used when reading the request stream, as it cannot be read more than once.
        When reading the request stream, catch instead MessageAborted exceptions to
        detect if the client closed the original connection.
        """

class Response(Message):
    def __init__(
        self,
        status: int,
        headers: Optional[List[HeaderType]] = None,
        content: Optional[Content] = None,
    ) -> None:
        self.status = status
        self.content = content

    def __repr__(self) -> str: ...
    @property
    def cookies(self) -> Cookies: ...
    @property
    def reason(self) -> str: ...
    def get_cookies(self) -> Cookies: ...
    def get_cookie(self, name: str) -> Optional[Cookie]: ...
    def set_cookie(self, cookie: Cookie) -> None: ...
    def set_cookies(self, cookies: List[Cookie]) -> None: ...
    def unset_cookie(self, name: str) -> None: ...
    def remove_cookie(self, name: str) -> None: ...
    def is_redirect(self) -> bool: ...
    def with_content(self, content: Content) -> "Response": ...
    async def raise_for_status(self) -> None: ...

def is_cors_request(request: Request) -> bool: ...
def is_cors_preflight_request(request: Request) -> bool: ...
def get_request_absolute_url(request: Request) -> URL: ...
def get_absolute_url_to_path(request: Request, path: str) -> URL: ...
def parse_charset(value: bytes) -> str: ...
