# Generated by Django 4.1.7 on 2023-04-19 05:38

import django.db.models.deletion
import django_fsm
import wbaccounting.models
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("dynamic_preferences", "0006_auto_20191001_2236"),
        ("directory", "0001_initial"),
        ("currency", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Invoice",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("PENDING", "Pending"),
                            ("EXTERNAL", "External"),
                            ("SENT", "Sent"),
                            ("PAID", "Paid"),
                        ],
                        default="DRAFT",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                ("resolved", models.BooleanField(default=False, verbose_name="Resolved")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("invoice_date", models.DateField(verbose_name="Date")),
                ("text_above", models.TextField(blank=True, null=True)),
                ("text_below", models.TextField(blank=True, null=True)),
                ("is_counterparty_invoice", models.BooleanField(default=False)),
                (
                    "invoice_currency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="invoices",
                        to="currency.currency",
                        verbose_name="Curency",
                    ),
                ),
            ],
            options={
                "verbose_name": "Invoice",
                "verbose_name_plural": "Invoices",
                "permissions": (("can_generate_invoice", "Can Generate Invoice"),),
            },
        ),
        migrations.CreateModel(
            name="BookingEntry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("resolved", models.BooleanField(default=False, verbose_name="Resolved")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("booking_date", models.DateField(verbose_name="Booking Date")),
                ("accrual_date", models.DateField(blank=True, null=True, verbose_name="Real Date")),
                ("from_date", models.DateField(blank=True, null=True, verbose_name="From")),
                ("to_date", models.DateField(blank=True, null=True, verbose_name="To")),
                (
                    "gross_value",
                    models.DecimalField(
                        blank=True, decimal_places=4, max_digits=16, null=True, verbose_name="Gross Value"
                    ),
                ),
                ("vat", models.DecimalField(decimal_places=4, default=0.0, max_digits=4, verbose_name="VAT")),
                (
                    "net_value",
                    models.DecimalField(
                        blank=True, decimal_places=4, max_digits=16, null=True, verbose_name="Net Value"
                    ),
                ),
                ("resolved_date", models.DateField(blank=True, null=True, verbose_name="Resolved Date")),
                (
                    "invoice",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="booking_entries",
                        to="wbaccounting.invoice",
                        verbose_name="Invoice",
                    ),
                ),
                ("related_data", models.JSONField(default=dict, verbose_name="Related Data")),
                (
                    "calculated_value",
                    models.DecimalField(
                        blank=True, decimal_places=4, max_digits=16, null=True, verbose_name="Final Value"
                    ),
                ),
                (
                    "main_booking_entry",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="appended_booking_entries",
                        to="wbaccounting.bookingentry",
                        verbose_name="Main Booking Entry",
                    ),
                ),
                (
                    "currency",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="booking_entries",
                        to="currency.currency",
                        verbose_name="Currency",
                    ),
                ),
            ],
            options={
                "verbose_name": "Booking Entry",
                "verbose_name_plural": "Booking Entries",
            },
        ),
        migrations.CreateModel(
            name="EntryAccountingInformation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("tax_id", models.CharField(blank=True, max_length=512, null=True, verbose_name="Tax ID")),
                ("vat", models.FloatField(blank=True, null=True, verbose_name="VAT")),
                ("social_charges", models.FloatField(blank=True, null=True, verbose_name="Social Charges")),
                (
                    "label_mapping",
                    models.JSONField(default=dict, verbose_name="Label Mapping"),
                ),
                ("email_subject", models.TextField(default="{{invoice.title}}", verbose_name="Subject")),
                ("email_body", models.TextField(default="", verbose_name="Body")),
                (
                    "default_currency",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="entry_accounting_informations",
                        to="currency.currency",
                        verbose_name="Default Currency",
                    ),
                ),
            ],
            options={
                "verbose_name": "Entry Accounting Information",
                "verbose_name_plural": "Entry Accounting Information",
            },
        ),
        migrations.AddField(
            model_name="bookingentry",
            name="counterparty",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="booking_entries",
                to="directory.entry",
                verbose_name="Counterparty",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="entryaccountinginformation",
            name="email_bcc",
            field=models.ManyToManyField(
                blank=True,
                related_name="entry_accounting_informations_bcc",
                to="directory.emailcontact",
                verbose_name="BCC",
            ),
        ),
        migrations.AddField(
            model_name="entryaccountinginformation",
            name="email_cc",
            field=models.ManyToManyField(
                blank=True,
                related_name="entry_accounting_informations_cc",
                to="directory.emailcontact",
                verbose_name="CC",
            ),
        ),
        migrations.AddField(
            model_name="entryaccountinginformation",
            name="email_to",
            field=models.ManyToManyField(
                blank=True,
                related_name="entry_accounting_informations_to",
                to="directory.emailcontact",
                verbose_name="To",
            ),
        ),
        migrations.AddField(
            model_name="entryaccountinginformation",
            name="entry",
            field=models.OneToOneField(
                default=None,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="entry_accounting_information",
                to="directory.entry",
                verbose_name="Entry",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="invoice",
            name="counterparty",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="accounting_invoices",
                to="directory.entry",
                verbose_name="Counterparty",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="bookingentry",
            name="counterparty",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="booking_entries",
                to="directory.entry",
                verbose_name="Counterparty",
            ),
        ),
        migrations.AlterField(
            model_name="entryaccountinginformation",
            name="email_bcc",
            field=models.ManyToManyField(
                blank=True,
                related_name="entry_accounting_informations_bcc",
                to="directory.emailcontact",
                verbose_name="BCC",
            ),
        ),
        migrations.AlterField(
            model_name="entryaccountinginformation",
            name="email_cc",
            field=models.ManyToManyField(
                blank=True,
                related_name="entry_accounting_informations_cc",
                to="directory.emailcontact",
                verbose_name="CC",
            ),
        ),
        migrations.AlterField(
            model_name="entryaccountinginformation",
            name="email_to",
            field=models.ManyToManyField(
                blank=True,
                related_name="entry_accounting_informations_to",
                to="directory.emailcontact",
                verbose_name="To",
            ),
        ),
        migrations.AlterField(
            model_name="entryaccountinginformation",
            name="entry",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="entry_accounting_information",
                to="directory.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="invoice",
            name="counterparty",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="accounting_invoices",
                to="directory.entry",
                verbose_name="Counterparty",
            ),
        ),
    ]
