# generated by LLM based from swagger configuration.
# There may be inaccuracies in the data types of the fields.
from typing import List, Optional, Any, Dict, Tuple, Generic, TypeVar
from typing_extensions import TypedDict, NamedTuple
import httpx

# Types
T = TypeVar("T")

# TypedDict definitions
T_VastUrl = TypedDict("T_VastUrl", {"url": str})

T_Vast = TypedDict(
    "T_Vast",
    {
        "preroll": List[str],
        "prerolls": List[T_VastUrl],
        "pauseroll": List[str],
        "pauserolls": List[T_VastUrl],
        "midroll": Optional[Any],
    },
)

T_PlaylistItem = TypedDict(
    "T_PlaylistItem",
    {"cvhId": str, "name": str, "vkId": str, "voiceStudio": str, "voiceType": str, "season": int, "episode": int},
)

T_PlaylistResponse = TypedDict(
    "T_PlaylistResponse",
    {
        "titleName": str,
        "isSerial": bool,
        "items": List[T_PlaylistItem],
        "trailers": Optional[Any],  # real signature type returns null
        "vast": T_Vast,
    },
)

T_VideoSources = TypedDict(
    "T_VideoSources",
    {
        "hlsUrl": str,
        "dashUrl": str,
        "mpegQhdUrl": str,
        "mpeg2kUrl": str,
        "mpeg4kUrl": str,
        "mpegHighUrl": str,
        "mpegFullHdUrl": str,
        "mpegMediumUrl": str,
        "mpegLowUrl": str,
        "mpegLowestUrl": str,
        "mpegTinyUrl": str,
    },
)

T_VideoResponse = TypedDict(
    "T_VideoResponse",
    {"unitedVideoId": int, "duration": int, "failoverHost": str, "thumbUrl": str, "sources": T_VideoSources},
)

T_ErrorResponse = TypedDict("T_ErrorResponse", {"code": int, "message": str})


# APIResponse class
class APIResponse(NamedTuple, Generic[T]):
    """Monad-like response wrapper"""

    success: bool
    data: T
    status_code: int
    headers: Dict[str, str]
    error: Optional[Exception]  # populated if success=False AND raise_on_error=False

    def raise_for_status(self) -> None:
        if not self.success and self.error:
            raise self.error


# Exception class
class ApiError(Exception):
    """API error raised when raise_on_error=True and request fails"""

    pass


# Sync Client
class CdnVideoHubSync:
    def __init__(
        self,
        base_url: str = "https://plapi.cdnvideohub.com",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.Client] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.Client(timeout=self._timeout)

    def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Make HTTP request and return APIResponse"""
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        try:
            response = self._client.request(
                method=method,
                url=f"{self.base_url}{path}",
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=self._basic,
            )

            success = 200 <= response.status_code < 300
            data = response.json() if response.content else None

            if not success and self.raise_on_error:
                error_data = data if isinstance(data, dict) else {}
                error_message = error_data.get("message", f"HTTP {response.status_code}")
                raise ApiError(error_message)

            return APIResponse(
                success=success,
                data=data,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None if success else Exception(f"HTTP {response.status_code}"),
            )
        except Exception as e:
            if self.raise_on_error:
                raise
            return APIResponse(success=False, data=None, status_code=0, headers={}, error=e)

    def get_playlist(
        self, pub: Optional[int] = None, aggr: Optional[str] = None, id: Optional[int] = None
    ) -> APIResponse[T_PlaylistResponse]:
        """GET playlist

        Args:
            pub: Publisher id (optional)
            aggr: Aggregation parameter (optional)
            id: Request query id (optional)

        Returns:
            APIResponse[T_PlaylistResponse]: Playlist response

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if pub is not None:
            params["pub"] = pub
        if aggr is not None:
            params["aggr"] = aggr
        if id is not None:
            params["id"] = id

        return self._request(method="GET", path="/api/v1/player/sv/playlist", params=params)

    def get_video_by_id(self, id: str) -> APIResponse[T_VideoResponse]:
        """GET video by id

        Args:
            id: Video identifier (path parameter)

        Returns:
            APIResponse[T_VideoResponse]: Video response

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request(method="GET", path=f"/api/v1/player/sv/video/{id}")


# Async Client
class CdnVideoHubAsync:
    def __init__(
        self,
        base_url: str = "https://plapi.cdnvideohub.com",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.AsyncClient] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.AsyncClient(timeout=self._timeout)

    async def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Make async HTTP request and return APIResponse"""
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        try:
            response = await self._client.request(
                method=method,
                url=f"{self.base_url}{path}",
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=self._basic,
            )

            success = 200 <= response.status_code < 300
            data = response.json() if response.content else None

            if not success and self.raise_on_error:
                error_data = data if isinstance(data, dict) else {}
                error_message = error_data.get("message", f"HTTP {response.status_code}")
                raise ApiError(error_message)

            return APIResponse(
                success=success,
                data=data,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None if success else Exception(f"HTTP {response.status_code}"),
            )
        except Exception as e:
            if self.raise_on_error:
                raise
            return APIResponse(success=False, data=None, status_code=0, headers={}, error=e)

    async def get_playlist(
        self, pub: Optional[int] = None, aggr: Optional[str] = None, id: Optional[int] = None
    ) -> APIResponse[T_PlaylistResponse]:
        """GET playlist

        Args:
            pub: Publisher id (optional)
            aggr: Aggregation parameter (optional)
            id: Request query id (optional)

        Returns:
            APIResponse[T_PlaylistResponse]: Playlist response

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if pub is not None:
            params["pub"] = pub
        if aggr is not None:
            params["aggr"] = aggr
        if id is not None:
            params["id"] = id

        return await self._request(method="GET", path="/api/v1/player/sv/playlist", params=params)

    async def get_video_by_id(self, id: str) -> APIResponse[T_VideoResponse]:
        """GET video by id

        Args:
            id: Video identifier (path parameter)

        Returns:
            APIResponse[T_VideoResponse]: Video response

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request(method="GET", path=f"/api/v1/player/sv/video/{id}")
