# autogenerated by ssc-gen DO NOT EDIT

import re
import json
from html import unescape as _html_unescape
from typing import Dict, TypedDict, Union
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


J_Dash = TypedDict(
    "J_Dash",
    {
        "src": str,
        "type": str,
    },
)
J_Hls = TypedDict(
    "J_Hls",
    {
        "src": str,
        "type": str,
    },
)
J_DataParameters = TypedDict(
    "J_DataParameters",
    {
        "id": str,
        "error": str,
        "domain": str,
        "cdn": str,
        "counter": str,
        "duration": str,
        "poster": str,
        "thumbnails": str,
        "dash": J_Dash,
        "hls": J_Hls,
        "quality": bool,
        "qualityVideo": int,
        "vast": bool,
        "country": str,
        "platform": str,
        "rating": str,
        "nshowbl": bool,
        "limitRate": bool,
        "aBlocklimitRate": bool,
    },
)
T_PageAniboom = TypedDict(
    "T_PageAniboom",
    {
        "data_parameters": J_DataParameters,
        "hls": str,
        "dash": str,
    },
)


class PageAniboom:
    """Extract MPD and M3U8 urls

        NOTE: use data_parameters instead hls and dash keys for get urls

        Required `referer="https://animego.org/` HEADER (.me, .club?)

        USAGE:
            1. GET <PLAYER_LINK> (e.g. https://aniboom.one/embed/6BmMbB7MxWO?episode=1&translation=30)
            2. PARSE. If pre-unescape response before parse - css selector may not find attribute
            3. For video playing, url required next headers:

            - Referer="https://aniboom.one/"
            - Accept-Language="ru-RU"  # INCREASE DOWNLOAD SPEED with this static value
            - Origin="https://aniboom.one"
        ISSUES:
            - 403 Forbidden if request sent not from CIS region
            - KEYS SHOULD BE STARTED IN Title Case else hls/mpd links returns 403 error
            - Sometimes, aniboom backend missing MPD key and returns M3U8 url. Check this value before usage:

            https://github.com/vypivshiy/ani-cli-ru/issues/29

            Expected json signature (LOOK at dash.src and hls.src keys):

            { ...
            "dash":"{"src":"https:.../abcdef.mpd",        "type":"application\\/dash+xml"}",
            "hls":"{"src":"https:...\\/master_device.m3u8",
            "type":"application\\/x-mpegURL"}"

            ... }

            MAYBE returns this:

             { ...
            "dash":"{"src":"https:...master_device.m3u8",        "type":"application\\/dash+xml"}",
            "hls":"{"src":"https:...master_device.m3u8",
            "type":"application\\/x-mpegURL"}"

            ... }


    {
        "data_parameters": {
            "id": "String",
            "error": "String",
            "domain": "String",
            "cdn": "String",
            "counter": "String",
            "duration": "String",
            "poster": "String",
            "thumbnails": "String",
            "dash": {
                "src": "String",
                "type": "String"
            },
            "hls": {
                "src": "String",
                "type": "String"
            },
            "quality": "Bool",
            "qualityVideo": "Int",
            "vast": "Bool",
            "country": "String",
            "platform": "String",
            "rating": "String",
            "nshowbl": "Bool",
            "limitRate": "Bool",
            "aBlocklimitRate": "Bool"
        },
        "hls": "String",
        "dash": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_data_parameters(self, v: html.HtmlElement) -> J_DataParameters:
        v0 = v.cssselect("#video[data-parameters]")[0]
        v1 = v0.get("data-parameters")
        v2 = v1.replace("\\", "")
        v3 = v2.replace("&quot;}", "}")
        v4 = v3.replace("&quot;{", "{")
        v5 = v4.replace("&quot;", '"')
        v6 = v5.replace('}"', "}")
        v7 = v6.replace('"{', "{")

        return json.loads(v7)

    def _parse_hls(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("#video")[0]
        v1 = v0.get("data-parameters")
        v2 = v1.replace("\\", "")
        v3 = v2.replace("&quot;", '"')

        return re.search('"hls":"{"src":"(https?.*?\\.m3u8)"', v3)[1]

    def _parse_dash(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("#video[data-parameters]")[0]
        v1 = v0.get("data-parameters")
        v2 = v1.replace("\\", "")
        v3 = v2.replace("&quot;", '"')

        return re.search('"dash":"{"src":"(https?.*?\\.(?:mpd|m3u8))"', v3)[1]

    def parse(self) -> T_PageAniboom:
        return {
            "data_parameters": self._parse_data_parameters(self._document),
            "hls": self._parse_hls(self._document),
            "dash": self._parse_dash(self._document),
        }
