# autogenerated by ssc-gen DO NOT EDIT

import re
from html import unescape as _html_unescape
from typing import Dict, TypedDict, Union
from contextlib import suppress
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


T_PageAnimegoIframe = TypedDict(
    "T_PageAnimegoIframe",
    {
        "id": str,
        "data_title_id": str,
        "data_publisher_id": str,
        "ident": str,
        "data_aggregator": str,
        "is_show_voice_only": bool,
        "is_show_banner": bool,
        "episode": int,
        "priority_voice": str,
    },
)
T_PageParseCdnVideoData = TypedDict(
    "T_PageParseCdnVideoData",
    {
        "id": str,
        "data_title_id": str,
        "data_publisher_id": str,
        "ident": str,
        "data_aggregator": str,
    },
)


class PageAnimegoIframe:
    """A parser for extracting parameters for the cdnvideohub API.

        used in animego

        USAGE:

            - data_title_id for 'id=' param
            - data_publisher_id for 'pub=' param
            - data_aggregator for 'aggr=' param

        GET https://plapi.cdnvideohub.com/api/v1/player/sv/playlist?pub={data_publisher_id}&aggr={data_aggregator}&id={id}

        EXAMPLE:

            GET https://animego.me/cdn-iframe/60254/Dream%20Cast/1/1
            Referer: https://animego.me


    {
        "id": "String",
        "data_title_id": "String",
        "data_publisher_id": "String",
        "ident": "String",
        "data_aggregator": "String",
        "is_show_voice_only": "Bool",
        "is_show_banner": "Bool",
        "episode": "Int",
        "priority_voice": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player-cvh > video-player")[0]

        return v0.get("id")

    def _parse_data_title_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player-cvh > video-player")[0]

        return v0.get("data-title-id")

    def _parse_data_publisher_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player-cvh > video-player")[0]

        return v0.get("data-publisher-id")

    def _parse_ident(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player-cvh > video-player")[0]

        return v0.get("ident")

    def _parse_data_aggregator(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player-cvh > video-player")[0]

        return v0.get("data-aggregator")

    def _parse_is_show_voice_only(self, v: html.HtmlElement) -> bool:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".player-cvh > video-player")[0]
            v2 = v1.get("is-show-voice-only")
            assert v2 != "true", ""
            v3 = v2

            return bool(v3 or v3 == 0)
        return False

    def _parse_is_show_banner(self, v: html.HtmlElement) -> bool:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".player-cvh > video-player")[0]
            v2 = v1.get("id")
            assert v2 != "true", ""
            v3 = v2

            return bool(v3 or v3 == 0)
        return False

    def _parse_episode(self, v: html.HtmlElement) -> int:
        v0 = v.cssselect(".player-cvh > video-player")[0]
        v1 = v0.get("episode")

        return int(v1)

    def _parse_priority_voice(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player-cvh > video-player")[0]

        return v0.get("priority-voice")

    def parse(self) -> T_PageAnimegoIframe:
        return {
            "id": self._parse_id(self._document),
            "data_title_id": self._parse_data_title_id(self._document),
            "data_publisher_id": self._parse_data_publisher_id(self._document),
            "ident": self._parse_ident(self._document),
            "data_aggregator": self._parse_data_aggregator(self._document),
            "is_show_voice_only": self._parse_is_show_voice_only(self._document),
            "is_show_banner": self._parse_is_show_banner(self._document),
            "episode": self._parse_episode(self._document),
            "priority_voice": self._parse_priority_voice(self._document),
        }


class PageParseCdnVideoData:
    """universal extractor cdnvideohub API params

        page should be contains <video-player> tag


    {
        "id": "String",
        "data_title_id": "String",
        "data_publisher_id": "String",
        "ident": "String",
        "data_aggregator": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("video-player")[0]

        return v0.get("id")

    def _parse_data_title_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("video-player")[0]

        return v0.get("data-title-id")

    def _parse_data_publisher_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("video-player")[0]

        return v0.get("data-publisher-id")

    def _parse_ident(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("video-player")[0]

        return v0.get("ident")

    def _parse_data_aggregator(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("video-player")[0]

        return v0.get("data-aggregator")

    def parse(self) -> T_PageParseCdnVideoData:
        return {
            "id": self._parse_id(self._document),
            "data_title_id": self._parse_data_title_id(self._document),
            "data_publisher_id": self._parse_data_publisher_id(self._document),
            "ident": self._parse_ident(self._document),
            "data_aggregator": self._parse_data_aggregator(self._document),
        }
