# autogenerated by ssc-gen DO NOT EDIT
"""universal parser for kodik.info/serial entrypoint"""

import re
import json
from html import unescape as _html_unescape
from typing import List, Dict, TypedDict, Union
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


J_UrlParams = TypedDict(
    "J_UrlParams",
    {
        "d": str,
        "d_sign": str,
        "pd": str,
        "pd_sign": str,
        "ref": str,
        "ref_sign": str,
        "advert_debug": bool,
        "min_age": int,
        "first_url": bool,
    },
)
T_KodikAPIPayload = TypedDict(
    "T_KodikAPIPayload",
    {
        "d": str,
        "d_sign": str,
        "pd": str,
        "pd_sign": str,
        "ref": str,
        "ref_sign": str,
        "type": str,
        "hash": str,
        "id": str,
    },
)
T_PageMainKodikMin = TypedDict(
    "T_PageMainKodikMin",
    {
        "url_params": J_UrlParams,
        "api_payload": T_KodikAPIPayload,
        "player_js_path": str,
    },
)
T_SeasonBox = TypedDict(
    "T_SeasonBox",
    {
        "value": str,
        "data_serial_id": str,
        "data_serial_hash": str,
        "data_title": str,
        "data_translation_title": str,
    },
)
T_SeriesBox = TypedDict(
    "T_SeriesBox",
    {
        "value": str,
        "data_id": str,
        "data_hash": str,
        "data_title": str,
    },
)
T_SeriesOptionItem = TypedDict(
    "T_SeriesOptionItem",
    {
        "value": str,
        "data_id": str,
        "data_hash": str,
        "data_title": str,
    },
)
T_SeriesOptions = Dict[str, List[T_SeriesOptionItem]]
T_TranslationsBox = TypedDict(
    "T_TranslationsBox",
    {
        "value": str,
        "data_id": str,
        "data_translation_type": str,
        "data_media_id": str,
        "data_media_hash": str,
        "data_media_type": str,
        "data_title": str,
        "data_episode_count": str,
    },
)
T_PageMainKodikSerial = TypedDict(
    "T_PageMainKodikSerial",
    {
        "url_params": J_UrlParams,
        "api_payload": T_KodikAPIPayload,
        "player_js_path": str,
        "thumbnails": List[str],
        "season_box": List[T_SeasonBox],
        "series_box": List[T_SeriesBox],
        "series_options": T_SeriesOptions,
        "translations_box": List[T_TranslationsBox],
    },
)
T_MovieTranslationBox = TypedDict(
    "T_MovieTranslationBox",
    {
        "value": str,
        "data_id": str,
        "data_translation_type": str,
        "data_media_id": str,
        "data_media_hash": str,
        "data_media_type": str,
        "data_title": str,
    },
)
T_PageMainKodikVideo = TypedDict(
    "T_PageMainKodikVideo",
    {
        "url_params": J_UrlParams,
        "api_payload": T_KodikAPIPayload,
        "player_js_path": str,
        "thumbnails": List[str],
        "translation_box": List[T_MovieTranslationBox],
    },
)
T_PageMainKodikAPIPath = TypedDict(
    "T_PageMainKodikAPIPath",
    {
        "api_path": str,
    },
)


class KodikAPIPayload:
    """payload for Kodik API request

    {
        "d": "String",
        "d_sign": "String",
        "pd": "String",
        "pd_sign": "String",
        "ref": "String",
        "ref_sign": "String",
        "type": "String",
        "hash": "String",
        "id": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_d(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("var\\s*domain\\s+=\\s+['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_d_sign(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("var\\s*d_sign\\s+=\\s+['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_pd(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("var\\s*pd\\s+=\\s+['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_pd_sign(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("var\\s*pd_sign\\s+=\\s+['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_ref(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("var\\s*ref\\s+=\\s+['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_ref_sign(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("var\\s*ref_sign\\s+=\\s+['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_type(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("videoInfo\\.type\\s*=\\s*['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_hash(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("videoInfo\\.hash\\s*=\\s*['\\\"](.*?)['\\\"];", v0)[1]

    def _parse_id(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("videoInfo\\.id\\s*=\\s*['\\\"](.*?)['\\\"];", v0)[1]

    def parse(self) -> T_KodikAPIPayload:
        return {
            "d": self._parse_d(self._document),
            "d_sign": self._parse_d_sign(self._document),
            "pd": self._parse_pd(self._document),
            "pd_sign": self._parse_pd_sign(self._document),
            "ref": self._parse_ref(self._document),
            "ref_sign": self._parse_ref_sign(self._document),
            "type": self._parse_type(self._document),
            "hash": self._parse_hash(self._document),
            "id": self._parse_id(self._document),
        }


class PageMainKodikMin:
    """Universal parser for extract minimal data for next API reuqest

        For extract full detailed information (about attached playlists) use:

        - MainKodikSerialPage for serials, OVA
        - MainKodikVideoPage for films

        USAGE:

            1. GET <kodik-page-player>
            2. add base_url to <player_js_path>
            3. extract API (<API_PATH>) path from javascript file (use MainKodikAPIPath)
            3.1 decode <API_PATH> path (base64 cipher)
            4. <api_payload> required extra constant keys
                - bad_user = (true or false)
                - cdn_is_working = true
                - info "{}"
            4.1 required headers:
                - origin="https://<NETLOC>" // player page
                - referer=<PLAYER_LINK> // FIRST URL player entrypoint
                - accept= "application/json, text/javascript, */*; q=0.01"
            4.2 POST <kodik-base-url> + /<API_PATH>
               data=<api_payload> (<JSON>) + headers
            5. extract urls from ['links'] key
            6. video urls encoded in ROT_13 + BASE64 ciphers

        EXAMPLE:

            - GET https://kodik.info/serial/64218/890744b309ec026d43742995d0d49cd7/720p?season=1&episode=1
            - GET https://aniqit.com/video/72755/dc966c03a7cb719dac577d8004a9b091/720p
            - GET https://kodik.info/seria/1133512/04d5f7824ba3563bd78e44a22451bb45/720p

         ISSUES:

            - kodik maybe have another netloc (e.g.: anivod)
            - 403 Forbidden if request sent not from CIS region
            - 404 DELETED: eg: https://kodik.info/seria/310427/09985563d891b56b1e9b01142ae11872/720p
            - 500 Internal server error: eg: https://kodik.info/seria/1051016/af405efc5e061f5ac344d4811de3bc16/720p ('Cyberpunk: Edgerunners' ep5 Anilibria dub)



    {
        "url_params": {
            "d": "String",
            "d_sign": "String",
            "pd": "String",
            "pd_sign": "String",
            "ref": "String",
            "ref_sign": "String",
            "advert_debug": "Bool",
            "min_age": "Int",
            "first_url": "Bool"
        },
        "api_payload": {
            "d": "String",
            "d_sign": "String",
            "pd": "String",
            "pd_sign": "String",
            "ref": "String",
            "ref_sign": "String",
            "type": "String",
            "hash": "String",
            "id": "String"
        },
        "player_js_path": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_url_params(self, v: html.HtmlElement) -> J_UrlParams:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search("var\\s*urlParams\\s*=\\s*['\\\"](\\{.*\\})['\\\"]", v0)[1]

        return json.loads(v1)

    def _parse_api_payload(self, v: html.HtmlElement) -> T_KodikAPIPayload:
        return KodikAPIPayload(v).parse()

    def _parse_player_js_path(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect('head > script[type="text/javascript"][src*="assets/js"]')[0]

        return v0.get("src")

    def parse(self) -> T_PageMainKodikMin:
        return {
            "url_params": self._parse_url_params(self._document),
            "api_payload": self._parse_api_payload(self._document),
            "player_js_path": self._parse_player_js_path(self._document),
        }


class SeasonBox:
    """represent season select

    [
        {
            "value": "String",
            "data_serial_id": "String",
            "data_serial_hash": "String",
            "data_title": "String",
            "data_translation_title": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".serial-panel > .serial-seasons-box option")

    def _parse_value(self, v: html.HtmlElement) -> str:
        return v.get("value")

    def _parse_data_serial_id(self, v: html.HtmlElement) -> str:
        return v.get("data-serial-id")

    def _parse_data_serial_hash(self, v: html.HtmlElement) -> str:
        return v.get("data-serial-hash")

    def _parse_data_title(self, v: html.HtmlElement) -> str:
        return v.get("data-title")

    def _parse_data_translation_title(self, v: html.HtmlElement) -> str:
        return v.get("data-translation-title")

    def parse(self) -> List[T_SeasonBox]:
        return [
            {
                "value": self._parse_value(el),
                "data_serial_id": self._parse_data_serial_id(el),
                "data_serial_hash": self._parse_data_serial_hash(el),
                "data_title": self._parse_data_title(el),
                "data_translation_title": self._parse_data_translation_title(el),
            }
            for el in self._split_doc(self._document)
        ]


class SeriesBox:
    """represent selected series in current page

    [
        {
            "value": "String",
            "data_id": "String",
            "data_hash": "String",
            "data_title": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".serial-panel > .serial-series-box option")

    def _parse_value(self, v: html.HtmlElement) -> str:
        return v.get("value")

    def _parse_data_id(self, v: html.HtmlElement) -> str:
        return v.get("data-id")

    def _parse_data_hash(self, v: html.HtmlElement) -> str:
        return v.get("data-hash")

    def _parse_data_title(self, v: html.HtmlElement) -> str:
        return v.get("data-title")

    def parse(self) -> List[T_SeriesBox]:
        return [
            {
                "value": self._parse_value(el),
                "data_id": self._parse_data_id(el),
                "data_hash": self._parse_data_hash(el),
                "data_title": self._parse_data_title(el),
            }
            for el in self._split_doc(self._document)
        ]


class SeriesOptionItem:
    """

    [
        {
            "value": "String",
            "data_id": "String",
            "data_hash": "String",
            "data_title": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("option")

    def _parse_value(self, v: html.HtmlElement) -> str:
        return v.get("value")

    def _parse_data_id(self, v: html.HtmlElement) -> str:
        return v.get("data-id")

    def _parse_data_hash(self, v: html.HtmlElement) -> str:
        return v.get("data-hash")

    def _parse_data_title(self, v: html.HtmlElement) -> str:
        return v.get("data-title")

    def parse(self) -> List[T_SeriesOptionItem]:
        return [
            {
                "value": self._parse_value(el),
                "data_id": self._parse_data_id(el),
                "data_hash": self._parse_data_hash(el),
                "data_title": self._parse_data_title(el),
            }
            for el in self._split_doc(self._document)
        ]


class SeriesOptions:
    """

    {
        "<k>": [
            {
                "value": "String",
                "data_id": "String",
                "data_hash": "String",
                "data_title": "String"
            },
            "..."
        ],
        "<k_N>": "..."
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".serial-panel > .series-options div")

    def _parse_key(self, v: html.HtmlElement) -> str:
        return v.get("class")

    def _parse_value(self, v: html.HtmlElement) -> List[T_SeriesOptionItem]:
        return SeriesOptionItem(v).parse()

    def parse(self) -> T_SeriesOptions:
        return {self._parse_key(el): self._parse_value(el) for el in self._split_doc(self._document)}


class TranslationsBox:
    """

    [
        {
            "value": "String",
            "data_id": "String",
            "data_translation_type": "String",
            "data_media_id": "String",
            "data_media_hash": "String",
            "data_media_type": "String",
            "data_title": "String",
            "data_episode_count": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".serial-panel > .serial-translations-box option")

    def _parse_value(self, v: html.HtmlElement) -> str:
        return v.get("value")

    def _parse_data_id(self, v: html.HtmlElement) -> str:
        return v.get("data-id")

    def _parse_data_translation_type(self, v: html.HtmlElement) -> str:
        return v.get("data-translation-type")

    def _parse_data_media_id(self, v: html.HtmlElement) -> str:
        return v.get("data-media-id")

    def _parse_data_media_hash(self, v: html.HtmlElement) -> str:
        return v.get("data-media-hash")

    def _parse_data_media_type(self, v: html.HtmlElement) -> str:
        return v.get("data-media-type")

    def _parse_data_title(self, v: html.HtmlElement) -> str:
        return v.get("data-title")

    def _parse_data_episode_count(self, v: html.HtmlElement) -> str:
        v0 = v.get("data-episode-count")

        return re.search("(\\d+)$", v0)[1]

    def parse(self) -> List[T_TranslationsBox]:
        return [
            {
                "value": self._parse_value(el),
                "data_id": self._parse_data_id(el),
                "data_translation_type": self._parse_data_translation_type(el),
                "data_media_id": self._parse_data_media_id(el),
                "data_media_hash": self._parse_data_media_hash(el),
                "data_media_type": self._parse_data_media_type(el),
                "data_title": self._parse_data_title(el),
                "data_episode_count": self._parse_data_episode_count(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageMainKodikSerial:
    """First extract data entrypoint for kodik.../serial/ entrypoint path


        EXAMPLE:
            GET - https://kodik.info/serial/64218/890744b309ec026d43742995d0d49cd7/720p?season=1&episode=1



    {
        "url_params": {
            "d": "String",
            "d_sign": "String",
            "pd": "String",
            "pd_sign": "String",
            "ref": "String",
            "ref_sign": "String",
            "advert_debug": "Bool",
            "min_age": "Int",
            "first_url": "Bool"
        },
        "api_payload": {
            "d": "String",
            "d_sign": "String",
            "pd": "String",
            "pd_sign": "String",
            "ref": "String",
            "ref_sign": "String",
            "type": "String",
            "hash": "String",
            "id": "String"
        },
        "player_js_path": "String",
        "thumbnails": "Array<String>",
        "season_box": [
            {
                "value": "String",
                "data_serial_id": "String",
                "data_serial_hash": "String",
                "data_title": "String",
                "data_translation_title": "String"
            },
            "..."
        ],
        "series_box": [
            {
                "value": "String",
                "data_id": "String",
                "data_hash": "String",
                "data_title": "String"
            },
            "..."
        ],
        "series_options": {
            "<k>": [
                {
                    "value": "String",
                    "data_id": "String",
                    "data_hash": "String",
                    "data_title": "String"
                },
                "..."
            ],
            "<k_N>": "..."
        },
        "translations_box": [
            {
                "value": "String",
                "data_id": "String",
                "data_translation_type": "String",
                "data_media_id": "String",
                "data_media_hash": "String",
                "data_media_type": "String",
                "data_title": "String",
                "data_episode_count": "String"
            },
            "..."
        ]
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_url_params(self, v: html.HtmlElement) -> J_UrlParams:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search("var\\s*urlParams\\s*=\\s*['\\\"](\\{.*\\})['\\\"]", v0)[1]

        return json.loads(v1)

    def _parse_api_payload(self, v: html.HtmlElement) -> T_KodikAPIPayload:
        return KodikAPIPayload(v).parse()

    def _parse_player_js_path(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect('head > script[type="text/javascript"][src*="assets/js"]')[0]

        return v0.get("src")

    def _parse_thumbnails(self, v: html.HtmlElement) -> List[str]:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search("var\\s*thumbnails\\s*=\\s*\\[(.*?)\\];", v0)[1]
        v2 = v1.replace('"', "")
        v3 = v2.split(",")
        v4 = [i.strip(" ") for i in v3]

        return [f"https:{i}" for i in v4]

    def _parse_season_box(self, v: html.HtmlElement) -> List[T_SeasonBox]:
        return SeasonBox(v).parse()

    def _parse_series_box(self, v: html.HtmlElement) -> List[T_SeriesBox]:
        return SeriesBox(v).parse()

    def _parse_series_options(self, v: html.HtmlElement) -> T_SeriesOptions:
        return SeriesOptions(v).parse()

    def _parse_translations_box(self, v: html.HtmlElement) -> List[T_TranslationsBox]:
        return TranslationsBox(v).parse()

    def parse(self) -> T_PageMainKodikSerial:
        return {
            "url_params": self._parse_url_params(self._document),
            "api_payload": self._parse_api_payload(self._document),
            "player_js_path": self._parse_player_js_path(self._document),
            "thumbnails": self._parse_thumbnails(self._document),
            "season_box": self._parse_season_box(self._document),
            "series_box": self._parse_series_box(self._document),
            "series_options": self._parse_series_options(self._document),
            "translations_box": self._parse_translations_box(self._document),
        }


class MovieTranslationBox:
    """PageMainKodikVideo /video/ (film) segment

    [
        {
            "value": "String",
            "data_id": "String",
            "data_translation_type": "String",
            "data_media_id": "String",
            "data_media_hash": "String",
            "data_media_type": "String",
            "data_title": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".movie-panel > .movie-translations-box option")

    def _parse_value(self, v: html.HtmlElement) -> str:
        return v.get("value")

    def _parse_data_id(self, v: html.HtmlElement) -> str:
        return v.get("data-id")

    def _parse_data_translation_type(self, v: html.HtmlElement) -> str:
        return v.get("data-translation-type")

    def _parse_data_media_id(self, v: html.HtmlElement) -> str:
        return v.get("data-media-id")

    def _parse_data_media_hash(self, v: html.HtmlElement) -> str:
        return v.get("data-media-hash")

    def _parse_data_media_type(self, v: html.HtmlElement) -> str:
        return v.get("data-media-type")

    def _parse_data_title(self, v: html.HtmlElement) -> str:
        return v.get("data-title")

    def parse(self) -> List[T_MovieTranslationBox]:
        return [
            {
                "value": self._parse_value(el),
                "data_id": self._parse_data_id(el),
                "data_translation_type": self._parse_data_translation_type(el),
                "data_media_id": self._parse_data_media_id(el),
                "data_media_hash": self._parse_data_media_hash(el),
                "data_media_type": self._parse_data_media_type(el),
                "data_title": self._parse_data_title(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageMainKodikVideo:
    """First extract data entrypoint for kodik.../video/ entrypoint path (FILMS, less often OVA)

        required for extract videos via kodik API

        EXAMPLE:

            - GET https://kodik.info/video/9935/313bc89421b094f6f374cc7420e00ad1/720p?translations=false&min_age=16 (Кланнад фильм)
            - GET https://kodik.info/video/72755/dc966c03a7cb719dac577d8004a9b091/720p?translations=false&min_age=16 (Вайолет Эвергарден. Фильм)


    {
        "url_params": {
            "d": "String",
            "d_sign": "String",
            "pd": "String",
            "pd_sign": "String",
            "ref": "String",
            "ref_sign": "String",
            "advert_debug": "Bool",
            "min_age": "Int",
            "first_url": "Bool"
        },
        "api_payload": {
            "d": "String",
            "d_sign": "String",
            "pd": "String",
            "pd_sign": "String",
            "ref": "String",
            "ref_sign": "String",
            "type": "String",
            "hash": "String",
            "id": "String"
        },
        "player_js_path": "String",
        "thumbnails": "Array<String>",
        "translation_box": [
            {
                "value": "String",
                "data_id": "String",
                "data_translation_type": "String",
                "data_media_id": "String",
                "data_media_hash": "String",
                "data_media_type": "String",
                "data_title": "String"
            },
            "..."
        ]
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_url_params(self, v: html.HtmlElement) -> J_UrlParams:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search("var\\s*urlParams\\s*=\\s*['\\\"](\\{.*\\})['\\\"]", v0)[1]

        return json.loads(v1)

    def _parse_api_payload(self, v: html.HtmlElement) -> T_KodikAPIPayload:
        return KodikAPIPayload(v).parse()

    def _parse_player_js_path(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect('head > script[type="text/javascript"][src*="assets/js"]')[0]

        return v0.get("src")

    def _parse_thumbnails(self, v: html.HtmlElement) -> List[str]:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search("var\\s*thumbnails\\s*=\\s*\\[(.*?)\\];", v0)[1]
        v2 = v1.replace('"', "")
        v3 = v2.split(",")
        v4 = [i.strip(" ") for i in v3]

        return [f"https:{i}" for i in v4]

    def _parse_translation_box(self, v: html.HtmlElement) -> List[T_MovieTranslationBox]:
        return MovieTranslationBox(v).parse()

    def parse(self) -> T_PageMainKodikVideo:
        return {
            "url_params": self._parse_url_params(self._document),
            "api_payload": self._parse_api_payload(self._document),
            "player_js_path": self._parse_player_js_path(self._document),
            "thumbnails": self._parse_thumbnails(self._document),
            "translation_box": self._parse_translation_box(self._document),
        }


class PageMainKodikAPIPath:
    """Extract actual API path from kodik player javascript sources

        after parse, required base64 decode string

        USAGE:
            GET MainKodikPage.player_js_path, MainKodikSerialPage.player_js_path

        EXAMPLE:

            - GET https://kodik.info/assets/js/app.serial.6721f2dd68501a625a518ea935006bd8f5cf5f4d037f2648a97a02dfd0fe5b85.js
            - GET https://aniqit.com/assets/js/app.player_single.3e2f9f0ae45d18b06cfd8b01181f85bab47fb9867cd1e73568c84dbe44ba7a44.js



    {
        "api_path": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_api_path(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search("\\$\\.ajax[^)]+atob\\([\\\"\\'](\\w+=)[\\'\\\"]\\)", v0)[1]

    def parse(self) -> T_PageMainKodikAPIPath:
        return {
            "api_path": self._parse_api_path(self._document),
        }
