# generated by LLM based on swagger configuration.
# There may be inaccuracies in the data types of the fields.
from typing import List, Optional, Any, Dict, Tuple, Generic, TypeVar
from typing_extensions import TypedDict, Literal
import httpx
from dataclasses import dataclass


# Type variable for APIResponse
T = TypeVar("T")


# APIResponse class
@dataclass
class APIResponse(Generic[T]):
    """Monad-like response wrapper"""

    success: bool
    data: Optional[T]  # None if success=False
    status_code: int
    headers: Dict[str, str]
    error: Optional[Exception]  # populated if success=False AND raise_on_error=False


class ApiError(Exception):
    """API Error exception"""

    pass


# Enums
E_AnimeCatalogFilterProductionStatus = Literal["IS_IN_PRODUCTION", "IS_NOT_IN_PRODUCTION"]
E_AnimeCatalogFilterPublishStatus = Literal["IS_ONGOING", "IS_NOT_ONGOING"]
E_AnimeCatalogFilterSorting = Literal[
    "FRESH_AT_DESC", "FRESH_AT_ASC", "RATING_DESC", "RATING_ASC", "YEAR_DESC", "YEAR_ASC"
]
E_AnimeReleasesReleaseAgeRating = Literal["R0_PLUS", "R6_PLUS", "R12_PLUS", "R16_PLUS", "R18_PLUS"]
E_AnimeReleasesReleasePublishDay = Literal[1, 2, 3, 4, 5, 6, 7]
E_AnimeReleasesReleaseSeason = Literal["winter", "spring", "summer", "autumn"]
E_AnimeReleasesReleaseType = Literal["TV", "ONA", "WEB", "OVA", "OAD", "MOVIE", "DORAMA", "SPECIAL"]
E_AnimeReleasesReleaseMemberRole = Literal["poster", "timing", "voicing", "editing", "decorating", "translating"]
E_AnimeTorrentsTorrentCodec = Literal["AV1", "x264/AVC", "x265/HEVC", "x265hq/HEVC-HQ"]
E_AnimeTorrentsTorrentColor = Literal["8bit", "10Bit"]
E_AnimeTorrentsTorrentQuality = Literal["360p", "480p", "576p", "720p", "1080p", "2k", "4k", "8k"]
E_AnimeTorrentsTorrentType = Literal[
    "BDRip", "HDRip", "TVRip", "WEBRip", "DTVRip", "DVDRip", "HDTVRip", "WEB-DL", "WEB-DLRip"
]
E_AnimeTorrentsTorrentMemberRole = Literal["HEVC"]
E_MediaVideosVideoOriginType = Literal["YOUTUBE_PLAYLIST"]

# TypedDict models
T_CommonsV1ModelsComponentsImage = TypedDict("T_CommonsV1ModelsComponentsImage", {"preview": str, "thumbnail": str})

T_CommonsV1ModelsComponentsImageWithOptimized = TypedDict(
    "T_CommonsV1ModelsComponentsImageWithOptimized",
    {"preview": str, "thumbnail": str, "optimized": T_CommonsV1ModelsComponentsImage},
)

T_CommonsV1UtilsPaginationSchemesMetaLinks = TypedDict(
    "T_CommonsV1UtilsPaginationSchemesMetaLinks", {"previous": Optional[str], "next": Optional[str]}
)

T_CommonsV1UtilsPaginationSchemesMetaPagination = TypedDict(
    "T_CommonsV1UtilsPaginationSchemesMetaPagination",
    {
        "total": int,
        "count": int,
        "per_page": int,
        "current_page": int,
        "total_pages": int,
        "links": T_CommonsV1UtilsPaginationSchemesMetaLinks,
    },
)


T_CommonsV1UtilsPaginationSchemesMeta = TypedDict(
    "T_CommonsV1UtilsPaginationSchemesMeta", {"pagination": T_CommonsV1UtilsPaginationSchemesMetaPagination}
)

T_ModelsAnimeFranchisesV1FranchiseRelease = TypedDict(
    "T_ModelsAnimeFranchisesV1FranchiseRelease", {"id": str, "sort_order": int, "release_id": int, "franchise_id": str}
)

T_ModelsAnimeFranchisesV1Franchise = TypedDict(
    "T_ModelsAnimeFranchisesV1Franchise",
    {
        "id": str,
        "name": str,
        "name_english": str,
        "image": T_CommonsV1ModelsComponentsImageWithOptimized,
        "rating": float,
        "last_year": int,
        "first_year": int,
        "total_releases": int,
        "total_episodes": int,
        "total_duration": Optional[str],
        "total_duration_in_seconds": int,
    },
)

T_ModelsAnimeGenresV1Genre = TypedDict(
    "T_ModelsAnimeGenresV1Genre",
    {"id": int, "name": str, "image": T_CommonsV1ModelsComponentsImageWithOptimized, "total_releases": int},
)

T_ModelsAnimeReleasesV1ReleaseMemberRole = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseMemberRole", {"value": E_AnimeReleasesReleaseMemberRole, "description": str}
)


T_ModelsAnimeReleasesV1ReleaseMemberResponse = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseMemberResponse", {"id": int, "avatar": T_CommonsV1ModelsComponentsImageWithOptimized}
)

T_ModelsAnimeReleasesV1ReleaseMember = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseMember",
    {
        "id": str,
        "role": T_ModelsAnimeReleasesV1ReleaseMemberRole,
        "user": Optional[T_ModelsAnimeReleasesV1ReleaseMemberResponse],
        "nickname": str,
    },
)

T_ModelsAnimeReleasesV1ReleaseMemberUser = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseMemberUser", {"id": int, "avatar": T_CommonsV1ModelsComponentsImageWithOptimized}
)

T_ModelsAnimeReleasesV1ReleaseType = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseType", {"value": E_AnimeReleasesReleaseType, "description": str}
)

T_ModelsAnimeReleasesV1ReleaseName = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseName", {"main": str, "english": str, "alternative": str}
)

T_ModelsAnimeReleasesV1ReleaseSeason = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseSeason", {"value": E_AnimeReleasesReleaseSeason, "description": str}
)

T_ModelsAnimeReleasesV1ReleaseAgeRating = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseAgeRating",
    {"value": E_AnimeReleasesReleaseAgeRating, "label": str, "is_adult": bool, "description": str},
)

T_ModelsAnimeReleasesV1ReleasePublishDay = TypedDict(
    "T_ModelsAnimeReleasesV1ReleasePublishDay", {"value": E_AnimeReleasesReleasePublishDay, "description": str}
)

T_ModelsAnimeReleasesV1ReleaseEpisodeSkip = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseEpisodeSkip", {"start": float, "stop": float}
)

T_ModelsAnimeReleasesV1ReleaseEpisode = TypedDict(
    "T_ModelsAnimeReleasesV1ReleaseEpisode",
    {
        "id": str,
        "name": str,
        "ordinal": float,
        "ending": Optional[T_ModelsAnimeReleasesV1ReleaseEpisodeSkip],
        "opening": Optional[T_ModelsAnimeReleasesV1ReleaseEpisodeSkip],
        "preview": T_CommonsV1ModelsComponentsImageWithOptimized,
        "hls_480": Optional[str],
        "hls_720": Optional[str],
        "hls_1080": Optional[str],
        "duration": int,
        "rutube_id": Optional[str],
        "youtube_id": Optional[str],
        "updated_at": str,  # date-time
        "sort_order": int,
        "release_id": int,
        "name_english": str,
    },
)

T_ModelsAnimeReleasesV1Release = TypedDict(
    "T_ModelsAnimeReleasesV1Release",
    {
        "id": int,
        "type": T_ModelsAnimeReleasesV1ReleaseType,
        "year": int,
        "name": T_ModelsAnimeReleasesV1ReleaseName,
        "alias": str,
        "season": T_ModelsAnimeReleasesV1ReleaseSeason,
        "poster": T_CommonsV1ModelsComponentsImageWithOptimized,
        "fresh_at": str,  # date-time
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_ongoing": bool,
        "age_rating": T_ModelsAnimeReleasesV1ReleaseAgeRating,
        "publish_day": T_ModelsAnimeReleasesV1ReleasePublishDay,
        "description": str,
        "notification": str,
        "episodes_total": int,
        "external_player": str,
        "is_in_production": bool,
        "is_blocked_by_geo": bool,
        "is_blocked_by_copyrights": bool,
        "added_in_users_favorites": int,
        "average_duration_of_episode": int,
        "added_in_planned_collection": int,
        "added_in_watched_collection": int,
        "added_in_watching_collection": int,
        "added_in_postponed_collection": int,
        "added_in_abandoned_collection": int,
    },
)

T_ModelsAnimeScheduleV1ReleaseInSchedule = TypedDict(
    "T_ModelsAnimeScheduleV1ReleaseInSchedule",
    {
        "release": T_ModelsAnimeReleasesV1Release,
        "full_season_is_released": bool,
        "published_release_episode": T_ModelsAnimeReleasesV1ReleaseEpisode,
        "next_release_episode_number": Optional[int],
    },
)

T_ModelsAnimeSponsorsV1Sponsor = TypedDict(
    "T_ModelsAnimeSponsorsV1Sponsor", {"id": str, "title": str, "description": str, "url_title": str, "url": str}
)

T_ModelsAnimeTorrentsV1TorrentMemberRole = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentMemberRole", {"value": E_AnimeTorrentsTorrentMemberRole, "description": str}
)

T_ModelsAnimeTorrentsV1TorrentMember = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentMember",
    {"id": str, "role": T_ModelsAnimeTorrentsV1TorrentMemberRole, "nickname": str, "external_url": str},
)

T_ModelsAnimeTorrentsV1TorrentMemberUser = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentMemberUser", {"id": int, "avatar": T_CommonsV1ModelsComponentsImageWithOptimized}
)

T_ModelsAnimeTorrentsV1TorrentType = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentType", {"value": E_AnimeTorrentsTorrentType, "description": str}
)

T_ModelsAnimeTorrentsV1TorrentQuality = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentQuality", {"value": E_AnimeTorrentsTorrentQuality, "description": str}
)

T_ModelsAnimeTorrentsV1TorrentCodec = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentCodec",
    {
        "value": E_AnimeTorrentsTorrentCodec,
        "label": str,
        "description": str,
        "label_color": str,
        "label_is_visible": bool,
    },
)

T_ModelsAnimeTorrentsV1TorrentColor = TypedDict(
    "T_ModelsAnimeTorrentsV1TorrentColor", {"value": E_AnimeTorrentsTorrentColor, "description": str}
)

T_ModelsAnimeTorrentsV1Torrent = TypedDict(
    "T_ModelsAnimeTorrentsV1Torrent",
    {
        "id": int,
        "hash": str,
        "size": int,
        "type": T_ModelsAnimeTorrentsV1TorrentType,
        "color": T_ModelsAnimeTorrentsV1TorrentColor,
        "codec": T_ModelsAnimeTorrentsV1TorrentCodec,
        "label": str,
        "quality": T_ModelsAnimeTorrentsV1TorrentQuality,
        "magnet": str,
        "filename": str,
        "seeders": int,
        "bitrate": int,
        "leechers": int,
        "sort_order": int,
        "updated_at": str,  # date-time
        "is_hardsub": bool,
        "description": str,
        "created_at": str,  # date-time
        "completed_times": int,
    },
)

T_ModelsMediaPromotionsV1Promotion = TypedDict(
    "T_ModelsMediaPromotionsV1Promotion",
    {
        "id": str,
        "url": str,
        "url_label": str,
        "image": T_CommonsV1ModelsComponentsImageWithOptimized,
        "title": str,
        "description": str,
        "is_ad": bool,
        "ad_erid": Optional[str],
        "ad_origin": Optional[str],
        "release": Optional[T_ModelsAnimeReleasesV1Release],
        "has_overlay": bool,
    },
)

T_ModelsMediaVideosV1VideoContent = TypedDict(
    "T_ModelsMediaVideosV1VideoContent",
    {
        "id": int,
        "url": str,
        "title": str,
        "views": int,
        "image": T_CommonsV1ModelsComponentsImageWithOptimized,
        "comments": int,
        "video_id": str,
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_announce": bool,
    },
)

T_ModelsMediaVideosV1VideoOriginType = TypedDict(
    "T_ModelsMediaVideosV1VideoOriginType", {"value": E_MediaVideosVideoOriginType, "description": str}
)

T_ModelsMediaVideosV1VideoOrigin = TypedDict(
    "T_ModelsMediaVideosV1VideoOrigin",
    {
        "id": str,
        "url": str,
        "type": T_ModelsMediaVideosV1VideoOriginType,
        "title": str,
        "description": str,
        "is_announce": bool,
    },
)

T_ModelsTeamsV1TeamRole = TypedDict(
    "T_ModelsTeamsV1TeamRole", {"id": str, "title": str, "color": str, "sort_order": int}
)

T_ModelsTeamsV1TeamUser = TypedDict(
    "T_ModelsTeamsV1TeamUser", {"id": str, "nickname": str, "is_intern": bool, "sort_order": int, "is_vacation": bool}
)

T_ModelsTeamsV1TeamUserAccount = TypedDict(
    "T_ModelsTeamsV1TeamUserAccount",
    {"id": int, "nickname": str, "avatar": T_CommonsV1ModelsComponentsImageWithOptimized},
)

T_ModelsTeamsV1Team = TypedDict("T_ModelsTeamsV1Team", {"id": str, "title": str, "sort_order": int, "description": str})

# Extracted nested TypedDict models
T_ReleaseWithGenres = TypedDict(
    "T_ReleaseWithGenres",
    {
        "id": int,
        "type": T_ModelsAnimeReleasesV1ReleaseType,
        "year": int,
        "name": T_ModelsAnimeReleasesV1ReleaseName,
        "alias": str,
        "season": T_ModelsAnimeReleasesV1ReleaseSeason,
        "poster": T_CommonsV1ModelsComponentsImageWithOptimized,
        "fresh_at": str,  # date-time
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_ongoing": bool,
        "age_rating": T_ModelsAnimeReleasesV1ReleaseAgeRating,
        "publish_day": T_ModelsAnimeReleasesV1ReleasePublishDay,
        "description": str,
        "notification": str,
        "episodes_total": int,
        "external_player": str,
        "is_in_production": bool,
        "is_blocked_by_geo": bool,
        "is_blocked_by_copyrights": bool,
        "added_in_users_favorites": int,
        "average_duration_of_episode": int,
        "added_in_planned_collection": int,
        "added_in_watched_collection": int,
        "added_in_watching_collection": int,
        "added_in_postponed_collection": int,
        "added_in_abandoned_collection": int,
        "genres": List[T_ModelsAnimeGenresV1Genre],
    },
)

T_FranchiseReleaseWithRelease = TypedDict(
    "T_FranchiseReleaseWithRelease",
    {"id": str, "sort_order": int, "release_id": int, "franchise_id": str, "release": T_ModelsAnimeReleasesV1Release},
)

T_FranchiseWithReleases = TypedDict(
    "T_FranchiseWithReleases",
    {
        "id": str,
        "name": str,
        "name_english": str,
        "image": T_CommonsV1ModelsComponentsImageWithOptimized,
        "rating": float,
        "last_year": int,
        "first_year": int,
        "total_releases": int,
        "total_episodes": int,
        "total_duration": Optional[str],
        "total_duration_in_seconds": int,
        "franchise_releases": List[T_FranchiseReleaseWithRelease],
    },
)

T_ReleaseWithGenresAndLatestEpisode = TypedDict(
    "T_ReleaseWithGenresAndLatestEpisode",
    {
        "id": int,
        "type": T_ModelsAnimeReleasesV1ReleaseType,
        "year": int,
        "name": T_ModelsAnimeReleasesV1ReleaseName,
        "alias": str,
        "season": T_ModelsAnimeReleasesV1ReleaseSeason,
        "poster": T_CommonsV1ModelsComponentsImageWithOptimized,
        "fresh_at": str,  # date-time
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_ongoing": bool,
        "age_rating": T_ModelsAnimeReleasesV1ReleaseAgeRating,
        "publish_day": T_ModelsAnimeReleasesV1ReleasePublishDay,
        "description": str,
        "notification": str,
        "episodes_total": int,
        "external_player": str,
        "is_in_production": bool,
        "is_blocked_by_geo": bool,
        "is_blocked_by_copyrights": bool,
        "added_in_users_favorites": int,
        "average_duration_of_episode": int,
        "added_in_planned_collection": int,
        "added_in_watched_collection": int,
        "added_in_watching_collection": int,
        "added_in_postponed_collection": int,
        "added_in_abandoned_collection": int,
        "genres": List[T_ModelsAnimeGenresV1Genre],
        "latest_episode": T_ModelsAnimeReleasesV1ReleaseEpisode,
    },
)

T_ReleaseWithAllDetails = TypedDict(
    "T_ReleaseWithAllDetails",
    {
        "id": int,
        "type": T_ModelsAnimeReleasesV1ReleaseType,
        "year": int,
        "name": T_ModelsAnimeReleasesV1ReleaseName,
        "alias": str,
        "season": T_ModelsAnimeReleasesV1ReleaseSeason,
        "poster": T_CommonsV1ModelsComponentsImageWithOptimized,
        "fresh_at": str,  # date-time
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_ongoing": bool,
        "age_rating": T_ModelsAnimeReleasesV1ReleaseAgeRating,
        "publish_day": T_ModelsAnimeReleasesV1ReleasePublishDay,
        "description": str,
        "notification": str,
        "episodes_total": int,
        "external_player": str,
        "is_in_production": bool,
        "is_blocked_by_geo": bool,
        "is_blocked_by_copyrights": bool,
        "added_in_users_favorites": int,
        "average_duration_of_episode": int,
        "added_in_planned_collection": int,
        "added_in_watched_collection": int,
        "added_in_watching_collection": int,
        "added_in_postponed_collection": int,
        "added_in_abandoned_collection": int,
        "genres": List[T_ModelsAnimeGenresV1Genre],
        "members": List[T_ModelsAnimeReleasesV1ReleaseMember],
        "episodes": List[T_ModelsAnimeReleasesV1ReleaseEpisode],
        "torrents": List[T_ModelsAnimeTorrentsV1Torrent],
        "sponsor": Optional[T_ModelsAnimeSponsorsV1Sponsor],
    },
)

T_UserView = TypedDict(
    "T_UserView", {"id": int, "nickname": str, "avatar": T_CommonsV1ModelsComponentsImageWithOptimized}
)

T_ReleaseWithEpisodes = TypedDict(
    "T_ReleaseWithEpisodes",
    {
        "id": int,
        "type": T_ModelsAnimeReleasesV1ReleaseType,
        "year": int,
        "name": T_ModelsAnimeReleasesV1ReleaseName,
        "alias": str,
        "season": T_ModelsAnimeReleasesV1ReleaseSeason,
        "poster": T_CommonsV1ModelsComponentsImageWithOptimized,
        "fresh_at": str,  # date-time
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_ongoing": bool,
        "age_rating": T_ModelsAnimeReleasesV1ReleaseAgeRating,
        "publish_day": T_ModelsAnimeReleasesV1ReleasePublishDay,
        "description": str,
        "notification": str,
        "episodes_total": int,
        "external_player": str,
        "is_in_production": bool,
        "is_blocked_by_geo": bool,
        "is_blocked_by_copyrights": bool,
        "added_in_users_favorites": int,
        "average_duration_of_episode": int,
        "added_in_planned_collection": int,
        "added_in_watched_collection": int,
        "added_in_watching_collection": int,
        "added_in_postponed_collection": int,
        "added_in_abandoned_collection": int,
        "episodes": List[T_ModelsAnimeReleasesV1ReleaseEpisode],
    },
)

T_TorrentMemberWithUser = TypedDict(
    "T_TorrentMemberWithUser",
    {
        "id": str,
        "role": T_ModelsAnimeTorrentsV1TorrentMemberRole,
        "nickname": str,
        "external_url": str,
        "user": Optional[T_ModelsAnimeTorrentsV1TorrentMemberUser],
    },
)

T_TorrentWithDetails = TypedDict(
    "T_TorrentWithDetails",
    {
        "id": int,
        "hash": str,
        "size": int,
        "type": T_ModelsAnimeTorrentsV1TorrentType,
        "color": T_ModelsAnimeTorrentsV1TorrentColor,
        "codec": T_ModelsAnimeTorrentsV1TorrentCodec,
        "label": str,
        "quality": T_ModelsAnimeTorrentsV1TorrentQuality,
        "magnet": str,
        "filename": str,
        "seeders": int,
        "bitrate": int,
        "leechers": int,
        "sort_order": int,
        "updated_at": str,  # date-time
        "is_hardsub": bool,
        "description": str,
        "created_at": str,  # date-time
        "completed_times": int,
        "torrent_members": List[T_TorrentMemberWithUser],
        "release": T_ModelsAnimeReleasesV1Release,
    },
)

# Response models
T_ResponsesApiV1AnimeCatalogReleases = TypedDict(
    "T_ResponsesApiV1AnimeCatalogReleases",
    {"data": List[T_ReleaseWithGenres], "meta": T_CommonsV1UtilsPaginationSchemesMeta},
)

T_ResponsesApiV1AnimeCatalogReferencesAgeRatings = TypedDict(
    "T_ResponsesApiV1AnimeCatalogReferencesAgeRatings",
    {"value": E_AnimeReleasesReleaseAgeRating, "label": str, "description": str},
)

T_ResponsesApiV1AnimeCatalogReferencesGenres = TypedDict(
    "T_ResponsesApiV1AnimeCatalogReferencesGenres", {"id": int, "name": str}
)

T_ResponsesApiV1AnimeCatalogReferencesProductionStatuses = TypedDict(
    "T_ResponsesApiV1AnimeCatalogReferencesProductionStatuses",
    {"value": E_AnimeCatalogFilterProductionStatus, "description": str},
)

T_ResponsesApiV1AnimeCatalogReferencesPublishStatuses = TypedDict(
    "T_ResponsesApiV1AnimeCatalogReferencesPublishStatuses",
    {"value": E_AnimeCatalogFilterPublishStatus, "description": str},
)

T_ResponsesV1AnimeCatalogReferencesSeasons = TypedDict(
    "T_ResponsesV1AnimeCatalogReferencesSeasons", {"value": E_AnimeReleasesReleaseSeason, "description": str}
)

T_ResponsesV1AnimeCatalogReferencesSorting = TypedDict(
    "T_ResponsesV1AnimeCatalogReferencesSorting",
    {"value": E_AnimeCatalogFilterSorting, "label": str, "description": str},
)

T_ResponsesV1AnimeCatalogReferencesTypes = TypedDict(
    "T_ResponsesV1AnimeCatalogReferencesTypes", {"value": E_AnimeReleasesReleaseType, "description": str}
)

T_ResponsesV1AnimeCatalogReferencesYears = TypedDict("T_ResponsesV1AnimeCatalogReferencesYears", {"items": List[int]})

T_ResponsesV1AnimeFranchises = TypedDict(
    "T_ResponsesV1AnimeFranchises", {"items": List[T_ModelsAnimeFranchisesV1Franchise]}
)

T_ResponsesV1AnimeFranchise = TypedDict(
    "T_ResponsesV1AnimeFranchise",
    {
        "id": str,
        "name": str,
        "name_english": str,
        "image": T_CommonsV1ModelsComponentsImageWithOptimized,
        "rating": float,
        "last_year": int,
        "first_year": int,
        "total_releases": int,
        "total_episodes": int,
        "total_duration": Optional[str],
        "total_duration_in_seconds": int,
        "franchise_releases": List[T_FranchiseReleaseWithRelease],
    },
)

T_ResponsesV1AnimeFranchisesRandom = TypedDict(
    "T_ResponsesV1AnimeFranchisesRandom", {"items": List[T_ModelsAnimeFranchisesV1Franchise]}
)

T_ResponsesV1AnimeFranchisesByRelease = TypedDict(
    "T_ResponsesV1AnimeFranchisesByRelease", {"items": List[T_FranchiseWithReleases]}
)

T_ResponsesApiV1AnimeGenres = TypedDict("T_ResponsesApiV1AnimeGenres", {"items": List[T_ModelsAnimeGenresV1Genre]})

T_ResponsesApiV1AnimeGenresItem = T_ModelsAnimeGenresV1Genre

T_ResponsesApiV1AnimeGenresList = TypedDict(
    "T_ResponsesApiV1AnimeGenresList", {"items": List[T_ModelsAnimeGenresV1Genre]}
)

T_ResponsesApiV1AnimeGenresReleases = TypedDict(
    "T_ResponsesApiV1AnimeGenresReleases",
    {"data": List[T_ModelsAnimeReleasesV1Release], "meta": T_CommonsV1UtilsPaginationSchemesMeta},
)

T_ResponsesApiV1AnimeReleasesLatest = TypedDict(
    "T_ResponsesApiV1AnimeReleasesLatest", {"items": List[T_ReleaseWithGenresAndLatestEpisode]}
)

T_ResponsesApiV1AnimeReleasesRandom = TypedDict(
    "T_ResponsesApiV1AnimeReleasesRandom", {"items": List[T_ModelsAnimeReleasesV1Release]}
)

T_ResponsesApiV1AnimeReleasesRecommended = TypedDict(
    "T_ResponsesApiV1AnimeReleasesRecommended", {"items": List[T_ModelsAnimeReleasesV1Release]}
)

T_ResponsesApiV1AnimeReleasesList = TypedDict(
    "T_ResponsesApiV1AnimeReleasesList",
    {"data": List[T_ReleaseWithAllDetails], "meta": T_CommonsV1UtilsPaginationSchemesMeta},
)

T_ResponsesApiV1AnimeReleasesRelease = TypedDict(
    "T_ResponsesApiV1AnimeReleasesRelease",
    {
        "id": int,
        "type": T_ModelsAnimeReleasesV1ReleaseType,
        "year": int,
        "name": T_ModelsAnimeReleasesV1ReleaseName,
        "alias": str,
        "season": T_ModelsAnimeReleasesV1ReleaseSeason,
        "poster": T_CommonsV1ModelsComponentsImageWithOptimized,
        "fresh_at": str,  # date-time
        "created_at": str,  # date-time
        "updated_at": str,  # date-time
        "is_ongoing": bool,
        "age_rating": T_ModelsAnimeReleasesV1ReleaseAgeRating,
        "publish_day": T_ModelsAnimeReleasesV1ReleasePublishDay,
        "description": str,
        "notification": str,
        "episodes_total": int,
        "external_player": str,
        "is_in_production": bool,
        "is_blocked_by_geo": bool,
        "is_blocked_by_copyrights": bool,
        "added_in_users_favorites": int,
        "average_duration_of_episode": int,
        "added_in_planned_collection": int,
        "added_in_watched_collection": int,
        "added_in_watching_collection": int,
        "added_in_postponed_collection": int,
        "added_in_abandoned_collection": int,
        "genres": List[T_ModelsAnimeGenresV1Genre],
        "members": List[T_ModelsAnimeReleasesV1ReleaseMember],
        "episodes": List[T_ModelsAnimeReleasesV1ReleaseEpisode],
        "torrents": List[T_ModelsAnimeTorrentsV1Torrent],
        "sponsor": Optional[T_ModelsAnimeSponsorsV1Sponsor],
    },
)

T_ResponsesApiV1AnimeReleasesReleaseMembers = TypedDict(
    "T_ResponsesApiV1AnimeReleasesReleaseMembers", {"items": List[T_ModelsAnimeReleasesV1ReleaseMember]}
)

T_ResponsesApiV1AnimeReleasesReleaseEpisodesTimecodes = TypedDict(
    "T_ResponsesApiV1AnimeReleasesReleaseEpisodesTimecodes", {"items": List[T_UserView]}
)

T_ResponsesApiV1AnimeReleasesEpisode = TypedDict(
    "T_ResponsesApiV1AnimeReleasesEpisode",
    {
        "id": str,
        "name": str,
        "ordinal": float,
        "ending": Optional[T_ModelsAnimeReleasesV1ReleaseEpisodeSkip],
        "opening": Optional[T_ModelsAnimeReleasesV1ReleaseEpisodeSkip],
        "preview": T_CommonsV1ModelsComponentsImageWithOptimized,
        "hls_480": Optional[str],
        "hls_720": Optional[str],
        "hls_1080": Optional[str],
        "duration": int,
        "rutube_id": Optional[str],
        "youtube_id": Optional[str],
        "updated_at": str,  # date-time
        "sort_order": int,
        "release_id": int,
        "name_english": str,
        "release": T_ReleaseWithEpisodes,
    },
)

T_ResponsesApiV1AnimeReleasesEpisodeTimecode = TypedDict(
    "T_ResponsesApiV1AnimeReleasesEpisodeTimecode",
    {"id": int, "nickname": str, "avatar": T_CommonsV1ModelsComponentsImageWithOptimized},
)

T_ResponsesV1AnimeScheduleNow = TypedDict(
    "T_ResponsesV1AnimeScheduleNow",
    {
        "today": List[T_ModelsAnimeScheduleV1ReleaseInSchedule],
        "tomorrow": List[T_ModelsAnimeScheduleV1ReleaseInSchedule],
        "yesterday": List[T_ModelsAnimeScheduleV1ReleaseInSchedule],
    },
)

T_ResponsesV1AnimeScheduleWeek = TypedDict(
    "T_ResponsesV1AnimeScheduleWeek", {"data": List[T_ModelsAnimeScheduleV1ReleaseInSchedule]}
)

T_ResponsesApiV1AnimeTorrents = TypedDict(
    "T_ResponsesApiV1AnimeTorrents", {"data": List[T_TorrentWithDetails], "meta": T_CommonsV1UtilsPaginationSchemesMeta}
)

T_ResponsesApiV1AnimeTorrent = TypedDict(
    "T_ResponsesApiV1AnimeTorrent",
    {
        "id": int,
        "hash": str,
        "size": int,
        "type": T_ModelsAnimeTorrentsV1TorrentType,
        "color": T_ModelsAnimeTorrentsV1TorrentColor,
        "codec": T_ModelsAnimeTorrentsV1TorrentCodec,
        "label": str,
        "quality": T_ModelsAnimeTorrentsV1TorrentQuality,
        "magnet": str,
        "filename": str,
        "seeders": int,
        "bitrate": int,
        "leechers": int,
        "sort_order": int,
        "updated_at": str,  # date-time
        "is_hardsub": bool,
        "description": str,
        "created_at": str,  # date-time
        "completed_times": int,
        "torrent_members": List[T_TorrentMemberWithUser],
        "release": T_ModelsAnimeReleasesV1Release,
    },
)

T_ResponsesApiV1AnimeTorrentsReleaseTorrents = TypedDict(
    "T_ResponsesApiV1AnimeTorrentsReleaseTorrents", {"items": List[T_TorrentWithDetails]}
)

T_ResponsesApiV1AppSearchReleases = TypedDict(
    "T_ResponsesApiV1AppSearchReleases", {"items": List[T_ModelsAnimeReleasesV1Release]}
)


T_ResponsesV1AppStatus_Request = TypedDict(
    "T_ResponsesV1AppStatus_Request", {"ip": str, "country": str, "iso_code": str, "timezone": str}
)

T_ResponsesV1AppStatus = TypedDict(
    "T_ResponsesV1AppStatus",
    {"request": T_ResponsesV1AppStatus_Request, "is_alive": bool, "available_api_endpoints": List[str]},
)


# Sync Client
class AniLibertySync:
    def __init__(
        self,
        base_url: str = "https://aniliberty.top/api/v1",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.Client] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.Client(timeout=self._timeout)

    def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Private method to handle HTTP requests"""
        # Prepare headers
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        # Add authentication
        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        # Make the request
        try:
            response = self._client.request(
                method=method,
                url=self.base_url + path,
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=self._basic,
            )

            # Process response
            if response.is_success:
                return APIResponse(
                    success=True,
                    data=response.json(),
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=None,
                )
            else:
                error = ApiError(f"HTTP {response.status_code}: {response.text}")
                if self.raise_on_error:
                    raise error
                return APIResponse(
                    success=False,
                    data=None,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=error,
                )
        except Exception as e:
            error = ApiError(f"Request failed: {str(e)}")
            if self.raise_on_error:
                raise error
            return APIResponse(success=False, data=None, status_code=0, headers={}, error=error)

    def get_anime_catalog_releases(
        self,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        genres: Optional[str] = None,
        types: Optional[List[E_AnimeReleasesReleaseType]] = None,
        seasons: Optional[List[E_AnimeReleasesReleaseSeason]] = None,
        from_year: Optional[int] = None,
        to_year: Optional[int] = None,
        search: Optional[str] = None,
        sorting: Optional[E_AnimeCatalogFilterSorting] = None,
        age_ratings: Optional[List[E_AnimeReleasesReleaseAgeRating]] = None,
        publish_statuses: Optional[List[E_AnimeCatalogFilterPublishStatus]] = None,
        production_statuses: Optional[List[E_AnimeCatalogFilterProductionStatus]] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeCatalogReleases]:
        """Get list of releases in the catalog

        Args:
            page: Page number
            limit: Limit of items per page
            genres: Comma-separated list of genre IDs
            types: List of release types
            seasons: List of release seasons
            from_year: Minimum release year
            to_year: Maximum release year
            search: Search query
            sorting: Sorting type
            age_ratings: List of age ratings
            publish_statuses: List of publish statuses
            production_statuses: List of production statuses
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with catalog releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if genres is not None:
            params["f[genres]"] = genres
        if types is not None:
            params["f[types]"] = types
        if seasons is not None:
            params["f[seasons]"] = seasons
        if from_year is not None:
            params["f[years][from_year]"] = from_year
        if to_year is not None:
            params["f[years][to_year]"] = to_year
        if search is not None:
            params["f[search]"] = search
        if sorting is not None:
            params["f[sorting]"] = sorting
        if age_ratings is not None:
            params["f[age_ratings]"] = age_ratings
        if publish_statuses is not None:
            params["f[publish_statuses]"] = publish_statuses
        if production_statuses is not None:
            params["f[production_statuses]"] = production_statuses
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/catalog/releases", params=params)

    def post_anime_catalog_releases(
        self,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        genres: Optional[List[int]] = None,
        types: Optional[List[E_AnimeReleasesReleaseType]] = None,
        seasons: Optional[List[E_AnimeReleasesReleaseSeason]] = None,
        from_year: Optional[int] = None,
        to_year: Optional[int] = None,
        search: Optional[str] = None,
        sorting: Optional[E_AnimeCatalogFilterSorting] = None,
        age_ratings: Optional[List[E_AnimeReleasesReleaseAgeRating]] = None,
        publish_statuses: Optional[List[E_AnimeCatalogFilterPublishStatus]] = None,
        production_statuses: Optional[List[E_AnimeCatalogFilterProductionStatus]] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeCatalogReleases]:
        """Post request to get list of releases in the catalog

        Args:
            page: Page number
            limit: Limit of items per page
            genres: List of genre IDs
            types: List of release types
            seasons: List of release seasons
            from_year: Minimum release year
            to_year: Maximum release year
            search: Search query
            sorting: Sorting type
            age_ratings: List of age ratings
            publish_statuses: List of publish statuses
            production_statuses: List of production statuses
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with catalog releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        data = {}
        if page is not None:
            data["page"] = page
        if limit is not None:
            data["limit"] = limit

        filter_data = {}
        if genres is not None:
            filter_data["genres"] = genres
        if types is not None:
            filter_data["types"] = types
        if seasons is not None:
            filter_data["seasons"] = seasons
        if from_year is not None or to_year is not None:
            years_data = {}
            if from_year is not None:
                years_data["from_year"] = from_year
            if to_year is not None:
                years_data["to_year"] = to_year
            filter_data["years"] = years_data
        if search is not None:
            filter_data["search"] = search
        if sorting is not None:
            filter_data["sorting"] = sorting
        if age_ratings is not None:
            filter_data["age_ratings"] = age_ratings
        if publish_statuses is not None:
            filter_data["publish_statuses"] = publish_statuses
        if production_statuses is not None:
            filter_data["production_statuses"] = production_statuses

        if filter_data:
            data["f"] = filter_data

        if include is not None:
            data["include"] = include
        if exclude is not None:
            data["exclude"] = exclude

        return self._request("POST", "/anime/catalog/releases", json=data)

    def get_anime_catalog_references_age_ratings(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesAgeRatings]]:
        """Get list of age ratings in the catalog

        Returns:
            APIResponse with age ratings data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/age-ratings")

    def get_anime_catalog_references_genres(self) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesGenres]]:
        """Get list of genres in the catalog

        Returns:
            APIResponse with genres data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/genres")

    def get_anime_catalog_references_production_statuses(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesProductionStatuses]]:
        """Get list of production statuses in the catalog

        Returns:
            APIResponse with production statuses data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/production-statuses")

    def get_anime_catalog_references_publish_statuses(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesPublishStatuses]]:
        """Get list of publish statuses in the catalog

        Returns:
            APIResponse with publish statuses data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/publish-statuses")

    def get_anime_catalog_references_seasons(self) -> APIResponse[List[T_ResponsesV1AnimeCatalogReferencesSeasons]]:
        """Get list of seasons in the catalog

        Returns:
            APIResponse with seasons data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/seasons")

    def get_anime_catalog_references_sorting(self) -> APIResponse[List[T_ResponsesV1AnimeCatalogReferencesSorting]]:
        """Get list of sorting options in the catalog

        Returns:
            APIResponse with sorting options data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/sorting")

    def get_anime_catalog_references_types(self) -> APIResponse[List[T_ResponsesV1AnimeCatalogReferencesTypes]]:
        """Get list of release types in the catalog

        Returns:
            APIResponse with release types data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/types")

    def get_anime_catalog_references_years(self) -> APIResponse[T_ResponsesV1AnimeCatalogReferencesYears]:
        """Get list of years in the catalog

        Returns:
            APIResponse with years data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/anime/catalog/references/years")

    def get_anime_franchises(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeFranchisesV1Franchise]]:
        """Get list of franchises

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with franchises data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/franchises", params=params)

    def get_anime_franchise(
        self, franchise_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesV1AnimeFranchise]:
        """Get franchise by ID

        Args:
            franchise_id: ID of the franchise
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with franchise data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/franchises/{franchise_id}", params=params)

    def get_anime_franchises_random(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeFranchisesV1Franchise]]:
        """Get list of random franchises

        Args:
            limit: Number of random franchises to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with random franchises data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/franchises/random", params=params)

    def get_anime_franchises_by_release(
        self, release_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesV1AnimeFranchisesByRelease]]:
        """Get list of franchises for a release

        Args:
            release_id: ID of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with franchises data for the release

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/franchises/release/{release_id}", params=params)

    def get_anime_genres(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeGenresV1Genre]]:
        """Get list of all genres

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with genres data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/genres", params=params)

    def get_anime_genre(
        self, genre_id: int, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ModelsAnimeGenresV1Genre]:
        """Get genre by ID

        Args:
            genre_id: ID of the genre
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with genre data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/genres/{genre_id}", params=params)

    def get_anime_genres_random(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeGenresV1Genre]]:
        """Get list of random genres

        Args:
            limit: Number of random genres to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with random genres data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/genres/random", params=params)

    def get_anime_genre_releases(
        self,
        genre_id: int,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeGenresReleases]:
        """Get list of releases for a genre

        Args:
            genre_id: ID of the genre
            page: Page number
            limit: Limit of items per page
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with releases data for the genre

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/genres/{genre_id}/releases", params=params)

    def get_anime_releases_latest(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesApiV1AnimeReleasesLatest]]:
        """Get latest releases

        Args:
            limit: Number of latest releases to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with latest releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/releases/latest", params=params)

    def get_anime_releases_random(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1Release]]:
        """Get random releases

        Args:
            limit: Number of random releases to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with random releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/releases/random", params=params)

    def get_anime_releases_recommended(
        self,
        limit: Optional[int] = None,
        release_id: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1Release]]:
        """Get recommended releases

        Args:
            limit: Number of recommended releases to return
            release_id: ID of the release to get recommendations for
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with recommended releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if release_id is not None:
            params["release_id"] = release_id
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/releases/recommended", params=params)

    def get_anime_releases_list(
        self,
        ids: Optional[List[int]] = None,
        aliases: Optional[List[str]] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesList]:
        """Get list of releases by IDs or aliases

        Args:
            ids: List of release IDs
            aliases: List of release aliases
            page: Page number
            limit: Limit of items per page
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if ids is not None:
            params["ids"] = ids
        if aliases is not None:
            params["aliases"] = aliases
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/releases/list", params=params)

    def get_anime_release(
        self, id_or_alias: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesRelease]:
        """Get release by ID or alias

        Args:
            id_or_alias: ID or alias of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with release data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/releases/{id_or_alias}", params=params)

    def get_anime_release_members(
        self, id_or_alias: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1ReleaseMember]]:
        """Get members of a release

        Args:
            id_or_alias: ID or alias of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with release members data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/releases/{id_or_alias}/members", params=params)

    def get_anime_release_episodes_timecodes(
        self, id_or_alias: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesApiV1AnimeReleasesReleaseEpisodesTimecodes]]:
        """Get timecodes for episodes of a release

        Args:
            id_or_alias: ID or alias of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with episode timecodes data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/releases/{id_or_alias}/episodes/timecodes", params=params)

    def get_anime_release_episode(
        self, release_episode_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesEpisode]:
        """Get episode by ID

        Args:
            release_episode_id: ID of the episode
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with episode data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/releases/episodes/{release_episode_id}", params=params)

    def get_anime_release_episode_timecode(
        self, release_episode_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesEpisodeTimecode]:
        """Get timecode for an episode

        Args:
            release_episode_id: ID of the episode
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with episode timecode data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/releases/episodes/{release_episode_id}/timecode", params=params)

    def get_anime_schedule_now(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesV1AnimeScheduleNow]:
        """Get current anime schedule

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with current schedule data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/schedule/now", params=params)

    def get_anime_schedule_week(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesV1AnimeScheduleWeek]:
        """Get weekly anime schedule

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with weekly schedule data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/schedule/week", params=params)

    def get_anime_torrents(
        self,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeTorrents]:
        """Get list of torrents

        Args:
            page: Page number
            limit: Limit of items per page
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with torrents data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/anime/torrents", params=params)

    def get_anime_torrent(
        self, hash_or_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeTorrent]:
        """Get torrent by hash or ID

        Args:
            hash_or_id: Hash or ID of the torrent
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with torrent data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/torrents/{hash_or_id}", params=params)

    def get_anime_torrent_file(self, hash_or_id: str, pk: Optional[str] = None) -> APIResponse[bytes]:
        """Get torrent file by hash or ID

        Args:
            hash_or_id: Hash or ID of the torrent
            pk: User passkey

        Returns:
            APIResponse with torrent file data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if pk is not None:
            params["pk"] = pk

        response = self._client.get(
            f"{self.base_url}/anime/torrents/{hash_or_id}/file", params=params, headers=self._headers, auth=self._basic
        )

        if response.is_success:
            return APIResponse(
                success=True,
                data=response.content,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        else:
            error = ApiError(f"HTTP {response.status_code}: {response.text}")
            if self.raise_on_error:
                raise error
            return APIResponse(
                success=False, data=None, status_code=response.status_code, headers=dict(response.headers), error=error
            )

    def get_anime_torrents_by_release(
        self, release_id: int, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesApiV1AnimeTorrentsReleaseTorrents]]:
        """Get torrents for a release

        Args:
            release_id: ID of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with torrents data for the release

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", f"/anime/torrents/release/{release_id}", params=params)

    def get_anime_torrents_rss(self, limit: Optional[int] = None, pk: Optional[str] = None) -> APIResponse[str]:
        """Get RSS feed of latest torrents

        Args:
            limit: Number of torrents in the feed
            pk: User passkey

        Returns:
            APIResponse with RSS feed data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if pk is not None:
            params["pk"] = pk

        response = self._client.get(
            f"{self.base_url}/anime/torrents/rss", params=params, headers=self._headers, auth=self._basic
        )

        if response.is_success:
            return APIResponse(
                success=True,
                data=response.text,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        else:
            error = ApiError(f"HTTP {response.status_code}: {response.text}")
            if self.raise_on_error:
                raise error
            return APIResponse(
                success=False, data=None, status_code=response.status_code, headers=dict(response.headers), error=error
            )

    def get_anime_torrents_rss_by_release(self, release_id: int, pk: Optional[str] = None) -> APIResponse[str]:
        """Get RSS feed of torrents for a release

        Args:
            release_id: ID of the release
            pk: User passkey

        Returns:
            APIResponse with RSS feed data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if pk is not None:
            params["pk"] = pk

        response = self._client.get(
            f"{self.base_url}/anime/torrents/rss/release/{release_id}",
            params=params,
            headers=self._headers,
            auth=self._basic,
        )

        if response.is_success:
            return APIResponse(
                success=True,
                data=response.text,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        else:
            error = ApiError(f"HTTP {response.status_code}: {response.text}")
            if self.raise_on_error:
                raise error
            return APIResponse(
                success=False, data=None, status_code=response.status_code, headers=dict(response.headers), error=error
            )

    def get_app_search_releases(
        self, query: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1Release]]:
        """Search releases

        Args:
            query: Search query
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with search results

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        params["query"] = query
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return self._request("GET", "/app/search/releases", params=params)

    def get_app_status(self) -> APIResponse[T_ResponsesV1AppStatus]:
        """Get API status

        Returns:
            APIResponse with API status data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return self._request("GET", "/app/status")

    def close(self):
        """Close the HTTP client"""
        self._client.close()

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.close()


# Async Client
class AniLibertyAsync:
    def __init__(
        self,
        base_url: str = "https://aniliberty.top/api/v1",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.AsyncClient] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.AsyncClient(timeout=self._timeout)

    async def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Private async method to handle HTTP requests"""
        # Prepare headers
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        # Add authentication
        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        # Make the request
        try:
            response = await self._client.request(
                method=method,
                url=self.base_url + path,
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=self._basic,
            )

            # Process response
            if response.is_success:
                return APIResponse(
                    success=True,
                    data=response.json(),
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=None,
                )
            else:
                error = ApiError(f"HTTP {response.status_code}: {response.text}")
                if self.raise_on_error:
                    raise error
                return APIResponse(
                    success=False,
                    data=None,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=error,
                )
        except Exception as e:
            error = ApiError(f"Request failed: {str(e)}")
            if self.raise_on_error:
                raise error
            return APIResponse(success=False, data=None, status_code=0, headers={}, error=error)

    async def get_anime_catalog_releases(
        self,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        genres: Optional[str] = None,
        types: Optional[List[E_AnimeReleasesReleaseType]] = None,
        seasons: Optional[List[E_AnimeReleasesReleaseSeason]] = None,
        from_year: Optional[int] = None,
        to_year: Optional[int] = None,
        search: Optional[str] = None,
        sorting: Optional[E_AnimeCatalogFilterSorting] = None,
        age_ratings: Optional[List[E_AnimeReleasesReleaseAgeRating]] = None,
        publish_statuses: Optional[List[E_AnimeCatalogFilterPublishStatus]] = None,
        production_statuses: Optional[List[E_AnimeCatalogFilterProductionStatus]] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeCatalogReleases]:
        """Get list of releases in the catalog

        Args:
            page: Page number
            limit: Limit of items per page
            genres: Comma-separated list of genre IDs
            types: List of release types
            seasons: List of release seasons
            from_year: Minimum release year
            to_year: Maximum release year
            search: Search query
            sorting: Sorting type
            age_ratings: List of age ratings
            publish_statuses: List of publish statuses
            production_statuses: List of production statuses
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with catalog releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if genres is not None:
            params["f[genres]"] = genres
        if types is not None:
            params["f[types]"] = types
        if seasons is not None:
            params["f[seasons]"] = seasons
        if from_year is not None:
            params["f[years][from_year]"] = from_year
        if to_year is not None:
            params["f[years][to_year]"] = to_year
        if search is not None:
            params["f[search]"] = search
        if sorting is not None:
            params["f[sorting]"] = sorting
        if age_ratings is not None:
            params["f[age_ratings]"] = age_ratings
        if publish_statuses is not None:
            params["f[publish_statuses]"] = publish_statuses
        if production_statuses is not None:
            params["f[production_statuses]"] = production_statuses
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/catalog/releases", params=params)

    async def post_anime_catalog_releases(
        self,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        genres: Optional[List[int]] = None,
        types: Optional[List[E_AnimeReleasesReleaseType]] = None,
        seasons: Optional[List[E_AnimeReleasesReleaseSeason]] = None,
        from_year: Optional[int] = None,
        to_year: Optional[int] = None,
        search: Optional[str] = None,
        sorting: Optional[E_AnimeCatalogFilterSorting] = None,
        age_ratings: Optional[List[E_AnimeReleasesReleaseAgeRating]] = None,
        publish_statuses: Optional[List[E_AnimeCatalogFilterPublishStatus]] = None,
        production_statuses: Optional[List[E_AnimeCatalogFilterProductionStatus]] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeCatalogReleases]:
        """Post request to get list of releases in the catalog

        Args:
            page: Page number
            limit: Limit of items per page
            genres: List of genre IDs
            types: List of release types
            seasons: List of release seasons
            from_year: Minimum release year
            to_year: Maximum release year
            search: Search query
            sorting: Sorting type
            age_ratings: List of age ratings
            publish_statuses: List of publish statuses
            production_statuses: List of production statuses
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with catalog releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        data = {}
        if page is not None:
            data["page"] = page
        if limit is not None:
            data["limit"] = limit

        filter_data = {}
        if genres is not None:
            filter_data["genres"] = genres
        if types is not None:
            filter_data["types"] = types
        if seasons is not None:
            filter_data["seasons"] = seasons
        if from_year is not None or to_year is not None:
            years_data = {}
            if from_year is not None:
                years_data["from_year"] = from_year
            if to_year is not None:
                years_data["to_year"] = to_year
            filter_data["years"] = years_data
        if search is not None:
            filter_data["search"] = search
        if sorting is not None:
            filter_data["sorting"] = sorting
        if age_ratings is not None:
            filter_data["age_ratings"] = age_ratings
        if publish_statuses is not None:
            filter_data["publish_statuses"] = publish_statuses
        if production_statuses is not None:
            filter_data["production_statuses"] = production_statuses

        if filter_data:
            data["f"] = filter_data

        if include is not None:
            data["include"] = include
        if exclude is not None:
            data["exclude"] = exclude

        return await self._request("POST", "/anime/catalog/releases", json=data)

    async def get_anime_catalog_references_age_ratings(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesAgeRatings]]:
        """Get list of age ratings in the catalog

        Returns:
            APIResponse with age ratings data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/age-ratings")

    async def get_anime_catalog_references_genres(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesGenres]]:
        """Get list of genres in the catalog

        Returns:
            APIResponse with genres data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/genres")

    async def get_anime_catalog_references_production_statuses(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesProductionStatuses]]:
        """Get list of production statuses in the catalog

        Returns:
            APIResponse with production statuses data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/production-statuses")

    async def get_anime_catalog_references_publish_statuses(
        self,
    ) -> APIResponse[List[T_ResponsesApiV1AnimeCatalogReferencesPublishStatuses]]:
        """Get list of publish statuses in the catalog

        Returns:
            APIResponse with publish statuses data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/publish-statuses")

    async def get_anime_catalog_references_seasons(
        self,
    ) -> APIResponse[List[T_ResponsesV1AnimeCatalogReferencesSeasons]]:
        """Get list of seasons in the catalog

        Returns:
            APIResponse with seasons data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/seasons")

    async def get_anime_catalog_references_sorting(
        self,
    ) -> APIResponse[List[T_ResponsesV1AnimeCatalogReferencesSorting]]:
        """Get list of sorting options in the catalog

        Returns:
            APIResponse with sorting options data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/sorting")

    async def get_anime_catalog_references_types(self) -> APIResponse[List[T_ResponsesV1AnimeCatalogReferencesTypes]]:
        """Get list of release types in the catalog

        Returns:
            APIResponse with release types data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/types")

    async def get_anime_catalog_references_years(self) -> APIResponse[T_ResponsesV1AnimeCatalogReferencesYears]:
        """Get list of years in the catalog

        Returns:
            APIResponse with years data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/anime/catalog/references/years")

    async def get_anime_franchises(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeFranchisesV1Franchise]]:
        """Get list of franchises

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with franchises data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/franchises", params=params)

    async def get_anime_franchise(
        self, franchise_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesV1AnimeFranchise]:
        """Get franchise by ID

        Args:
            franchise_id: ID of the franchise
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with franchise data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/franchises/{franchise_id}", params=params)

    async def get_anime_franchises_random(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeFranchisesV1Franchise]]:
        """Get list of random franchises

        Args:
            limit: Number of random franchises to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with random franchises data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/franchises/random", params=params)

    async def get_anime_franchises_by_release(
        self, release_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesV1AnimeFranchisesByRelease]]:
        """Get list of franchises for a release

        Args:
            release_id: ID of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with franchises data for the release

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/franchises/release/{release_id}", params=params)

    async def get_anime_genres(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeGenresV1Genre]]:
        """Get list of all genres

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with genres data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/genres", params=params)

    async def get_anime_genre(
        self, genre_id: int, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ModelsAnimeGenresV1Genre]:
        """Get genre by ID

        Args:
            genre_id: ID of the genre
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with genre data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/genres/{genre_id}", params=params)

    async def get_anime_genres_random(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeGenresV1Genre]]:
        """Get list of random genres

        Args:
            limit: Number of random genres to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with random genres data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/genres/random", params=params)

    async def get_anime_genre_releases(
        self,
        genre_id: int,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeGenresReleases]:
        """Get list of releases for a genre

        Args:
            genre_id: ID of the genre
            page: Page number
            limit: Limit of items per page
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with releases data for the genre

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/genres/{genre_id}/releases", params=params)

    async def get_anime_releases_latest(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesApiV1AnimeReleasesLatest]]:
        """Get latest releases

        Args:
            limit: Number of latest releases to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with latest releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/releases/latest", params=params)

    async def get_anime_releases_random(
        self, limit: Optional[int] = None, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1Release]]:
        """Get random releases

        Args:
            limit: Number of random releases to return
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with random releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/releases/random", params=params)

    async def get_anime_releases_recommended(
        self,
        limit: Optional[int] = None,
        release_id: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1Release]]:
        """Get recommended releases

        Args:
            limit: Number of recommended releases to return
            release_id: ID of the release to get recommendations for
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with recommended releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if release_id is not None:
            params["release_id"] = release_id
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/releases/recommended", params=params)

    async def get_anime_releases_list(
        self,
        ids: Optional[List[int]] = None,
        aliases: Optional[List[str]] = None,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesList]:
        """Get list of releases by IDs or aliases

        Args:
            ids: List of release IDs
            aliases: List of release aliases
            page: Page number
            limit: Limit of items per page
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with releases data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if ids is not None:
            params["ids"] = ids
        if aliases is not None:
            params["aliases"] = aliases
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/releases/list", params=params)

    async def get_anime_release(
        self, id_or_alias: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesRelease]:
        """Get release by ID or alias

        Args:
            id_or_alias: ID or alias of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with release data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/releases/{id_or_alias}", params=params)

    async def get_anime_release_members(
        self, id_or_alias: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1ReleaseMember]]:
        """Get members of a release

        Args:
            id_or_alias: ID or alias of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with release members data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/releases/{id_or_alias}/members", params=params)

    async def get_anime_release_episodes_timecodes(
        self, id_or_alias: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesApiV1AnimeReleasesReleaseEpisodesTimecodes]]:
        """Get timecodes for episodes of a release

        Args:
            id_or_alias: ID or alias of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with episode timecodes data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/releases/{id_or_alias}/episodes/timecodes", params=params)

    async def get_anime_release_episode(
        self, release_episode_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesEpisode]:
        """Get episode by ID

        Args:
            release_episode_id: ID of the episode
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with episode data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/releases/episodes/{release_episode_id}", params=params)

    async def get_anime_release_episode_timecode(
        self, release_episode_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeReleasesEpisodeTimecode]:
        """Get timecode for an episode

        Args:
            release_episode_id: ID of the episode
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with episode timecode data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/releases/episodes/{release_episode_id}/timecode", params=params)

    async def get_anime_schedule_now(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesV1AnimeScheduleNow]:
        """Get current anime schedule

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with current schedule data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/schedule/now", params=params)

    async def get_anime_schedule_week(
        self, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesV1AnimeScheduleWeek]:
        """Get weekly anime schedule

        Args:
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with weekly schedule data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/schedule/week", params=params)

    async def get_anime_torrents(
        self,
        page: Optional[int] = None,
        limit: Optional[int] = None,
        include: Optional[str] = None,
        exclude: Optional[str] = None,
    ) -> APIResponse[T_ResponsesApiV1AnimeTorrents]:
        """Get list of torrents

        Args:
            page: Page number
            limit: Limit of items per page
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with torrents data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if page is not None:
            params["page"] = page
        if limit is not None:
            params["limit"] = limit
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/anime/torrents", params=params)

    async def get_anime_torrent(
        self, hash_or_id: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[T_ResponsesApiV1AnimeTorrent]:
        """Get torrent by hash or ID

        Args:
            hash_or_id: Hash or ID of the torrent
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with torrent data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/torrents/{hash_or_id}", params=params)

    async def get_anime_torrent_file(self, hash_or_id: str, pk: Optional[str] = None) -> APIResponse[bytes]:
        """Get torrent file by hash or ID

        Args:
            hash_or_id: Hash or ID of the torrent
            pk: User passkey

        Returns:
            APIResponse with torrent file data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if pk is not None:
            params["pk"] = pk

        response = await self._client.get(
            f"{self.base_url}/anime/torrents/{hash_or_id}/file", params=params, headers=self._headers, auth=self._basic
        )

        if response.is_success:
            return APIResponse(
                success=True,
                data=response.content,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        else:
            error = ApiError(f"HTTP {response.status_code}: {response.text}")
            if self.raise_on_error:
                raise error
            return APIResponse(
                success=False, data=None, status_code=response.status_code, headers=dict(response.headers), error=error
            )

    async def get_anime_torrents_by_release(
        self, release_id: int, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ResponsesApiV1AnimeTorrentsReleaseTorrents]]:
        """Get torrents for a release

        Args:
            release_id: ID of the release
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with torrents data for the release

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", f"/anime/torrents/release/{release_id}", params=params)

    async def get_anime_torrents_rss(self, limit: Optional[int] = None, pk: Optional[str] = None) -> APIResponse[str]:
        """Get RSS feed of latest torrents

        Args:
            limit: Number of torrents in the feed
            pk: User passkey

        Returns:
            APIResponse with RSS feed data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if limit is not None:
            params["limit"] = limit
        if pk is not None:
            params["pk"] = pk

        response = await self._client.get(
            f"{self.base_url}/anime/torrents/rss", params=params, headers=self._headers, auth=self._basic
        )

        if response.is_success:
            return APIResponse(
                success=True,
                data=response.text,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        else:
            error = ApiError(f"HTTP {response.status_code}: {response.text}")
            if self.raise_on_error:
                raise error
            return APIResponse(
                success=False, data=None, status_code=response.status_code, headers=dict(response.headers), error=error
            )

    async def get_anime_torrents_rss_by_release(self, release_id: int, pk: Optional[str] = None) -> APIResponse[str]:
        """Get RSS feed of torrents for a release

        Args:
            release_id: ID of the release
            pk: User passkey

        Returns:
            APIResponse with RSS feed data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        if pk is not None:
            params["pk"] = pk

        response = await self._client.get(
            f"{self.base_url}/anime/torrents/rss/release/{release_id}",
            params=params,
            headers=self._headers,
            auth=self._basic,
        )

        if response.is_success:
            return APIResponse(
                success=True,
                data=response.text,
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        else:
            error = ApiError(f"HTTP {response.status_code}: {response.text}")
            if self.raise_on_error:
                raise error
            return APIResponse(
                success=False, data=None, status_code=response.status_code, headers=dict(response.headers), error=error
            )

    async def get_app_search_releases(
        self, query: str, include: Optional[str] = None, exclude: Optional[str] = None
    ) -> APIResponse[List[T_ModelsAnimeReleasesV1Release]]:
        """Search releases

        Args:
            query: Search query
            include: Fields to include
            exclude: Fields to exclude

        Returns:
            APIResponse with search results

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        params = {}
        params["query"] = query
        if include is not None:
            params["include"] = include
        if exclude is not None:
            params["exclude"] = exclude

        return await self._request("GET", "/app/search/releases", params=params)

    async def get_app_status(self) -> APIResponse[T_ResponsesV1AppStatus]:
        """Get API status

        Returns:
            APIResponse with API status data

        Raises:
            ApiError: If raise_on_error=True and request fails
        """
        return await self._request("GET", "/app/status")

    async def close(self):
        """Close the HTTP client"""
        await self._client.aclose()

    async def __aenter__(self):
        return self

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        await self.close()
