# generated by LLM based from swagger configuration.
# There may be inaccuracies in the data types of the fields.
from typing import List, Optional, Any, Dict, Tuple, Generic, TypeVar
from typing_extensions import TypedDict, NamedTuple
import httpx

T = TypeVar("T")


class APIResponse(NamedTuple, Generic[T]):
    """Monad-like response wrapper"""

    success: bool
    data: T
    status_code: int
    headers: Dict[str, str]
    error: Optional[Exception]  # populated if success=False AND raise_on_error=False

    def raise_for_status(self) -> None:
        if not self.success and self.error:
            raise self.error


class ApiError(Exception):
    """API Error exception"""

    pass


# ============ TYPES ============

T_Cover = TypedDict("T_Cover", {"filename": str, "thumbnail": str, "default": str, "md": str})

T_Background = TypedDict("T_Background", {"filename": str, "url": str})

T_AgeRestriction = TypedDict("T_AgeRestriction", {"id": int, "label": str})

T_Type = TypedDict("T_Type", {"id": int, "label": str})

T_Rating = TypedDict(
    "T_Rating", {"average": str, "averageFormated": str, "votes": int, "votesFormated": str, "user": int}
)

T_Status = TypedDict("T_Status", {"id": int, "label": str})

T_Views = TypedDict("T_Views", {"total": int, "short": str, "formated": str})

T_Moderated = TypedDict("T_Moderated", {"id": int, "label": str})

T_Team = TypedDict(
    "T_Team",
    {
        "id": int,
        "slug": str,
        "slug_url": str,
        "model": str,
        "name": str,
        "cover": T_Cover,
        "donate_enabled": Optional[Any],
    },
)

T_Genre = TypedDict("T_Genre", {"id": int, "name": str, "adult": bool, "alert": bool})

T_Tag = TypedDict("T_Tag", {"id": int, "name": str, "adult": bool, "alert": bool})

T_Subscription = TypedDict(
    "T_Subscription", {"is_subscribed": bool, "source_type": str, "source_id": int, "relation": Optional[Any]}
)

T_Publisher = TypedDict(
    "T_Publisher",
    {
        "id": int,
        "slug": str,
        "slug_url": str,
        "model": str,
        "name": str,
        "rus_name": Optional[Any],
        "cover": T_Cover,
        "subscription": T_Subscription,
    },
)

T_Author = TypedDict(
    "T_Author",
    {
        "id": int,
        "slug": str,
        "slug_url": str,
        "model": str,
        "name": str,
        "rus_name": Optional[Any],
        "alt_name": Optional[Any],
        "cover": T_Cover,
        "subscription": T_Subscription,
        "confirmed": Optional[Any],
        "user_id": int,
    },
)

T_Avatar = TypedDict("T_Avatar", {"filename": str, "url": str})

T_Premium = TypedDict("T_Premium", {"enabled": bool})

T_User = TypedDict(
    "T_User", {"id": int, "username": str, "avatar": T_Avatar, "last_online_at": Optional[Any], "premium": T_Premium}
)

T_MetadataCountCharacters = TypedDict("T_MetadataCountCharacters", {"Main": int, "Supporting": int})

T_MetadataCountReviews = TypedDict(
    "T_MetadataCountReviews", {"neutral": int, "positive": int, "negative": int, "all": int}
)

T_MetadataCount = TypedDict(
    "T_MetadataCount",
    {
        "branches": int,
        "characters": T_MetadataCountCharacters,
        "reviews": T_MetadataCountReviews,
        "relations": int,
        "people": int,
        "covers": int,
    },
)

T_MetadataCommentsDisabled = TypedDict("T_MetadataCommentsDisabled", {"media": bool, "content": bool})

T_Metadata = TypedDict(
    "T_Metadata", {"close_comments": int, "comments_disabled": T_MetadataCommentsDisabled, "count": T_MetadataCount}
)

T_Time = TypedDict("T_Time", {"value": int, "formated": str})

T_ItemsCount = TypedDict("T_ItemsCount", {"uploaded": int, "total": int})

T_EpisodeStatus = TypedDict("T_EpisodeStatus", {"id": str, "label": str, "abbr": Optional[Any]})

T_TranslationType = TypedDict("T_TranslationType", {"id": int, "label": str})

T_Stat = TypedDict("T_Stat", {"value": float, "formated": str, "short": str, "label": str, "tag": str})

T_TeamWithStats = TypedDict(
    "T_TeamWithStats",
    {
        "id": int,
        "slug": str,
        "slug_url": str,
        "model": str,
        "name": str,
        "cover": T_Cover,
        "donate_enabled": Optional[Any],
        "stats": List[T_Stat],
    },
)


T_Quality = TypedDict("T_Quality", {"href": str, "quality": int, "bitrate": int})

T_Video = TypedDict("T_Video", {"id": int, "quality": List[T_Quality]})

T_Player = TypedDict(
    "T_Player",
    {
        "id": int,
        "episode_id": int,
        "player": str,
        "translation_type": T_TranslationType,
        "team": T_TeamWithStats,
        "created_at": str,  # date-time
        "views": int,
        "src": str,
        "video": T_Video,
    },
)

T_Pagination = TypedDict("T_Pagination", {"first": str, "last": Optional[Any], "prev": Optional[Any], "next": str})

T_PaginationMeta = TypedDict(
    "T_PaginationMeta", {"current_page": int, "from": int, "path": str, "per_page": int, "to": int, "seed": str}
)

T_ErrorToast = TypedDict("T_ErrorToast", {"type": str, "message": str})

T_Error = TypedDict("T_Error", {"toast": T_ErrorToast})

T_CountryMeta = TypedDict("T_CountryMeta", {"country": str})

T_AnimeListItem = TypedDict(
    "T_AnimeListItem",
    {
        "id": int,
        "name": str,
        "rus_name": str,
        "eng_name": str,
        "model": str,
        "slug": str,
        "slug_url": str,
        "cover": T_Cover,
        "ageRestriction": T_AgeRestriction,
        "site": int,
        "type": T_Type,
        "releaseDate": str,  # date
        "rating": T_Rating,
        "content_marking": List[Any],
        "status": T_Status,
        "releaseDateString": str,
        "shiki_rate": Optional[Any],
    },
)

T_AnimeDetail = TypedDict(
    "T_AnimeDetail",
    {
        "id": int,
        "name": str,
        "rus_name": str,
        "eng_name": str,
        "model": str,
        "slug": str,
        "slug_url": str,
        "cover": T_Cover,
        "ageRestriction": T_AgeRestriction,
        "site": int,
        "type": T_Type,
        "releaseDate": str,  # date
        "rating": T_Rating,
        "content_marking": List[Any],
        "status": T_Status,
        "releaseDateString": str,
        "otherNames": List[str],
        "background": T_Background,
        "summary": str,
        "close_view": int,
        "views": T_Views,
        "is_licensed": bool,
        "moderated": T_Moderated,
        "teams": List[T_Team],
        "genres": List[T_Genre],
        "tags": List[T_Tag],
        "publisher": List[T_Publisher],
        "franchise": List[Any],
        "authors": List[T_Author],
        "user": T_User,
        "metadata": T_Metadata,
        "time": T_Time,
        "items_count": T_ItemsCount,
        "episodes_schedule": List[Any],
        "shikimori_href": str,
        "shiki_rate": float,
    },
)

T_EpisodeListItem = TypedDict(
    "T_EpisodeListItem",
    {
        "id": int,
        "model": str,
        "name": str,
        "number": str,
        "number_secondary": str,
        "season": str,
        "status": T_EpisodeStatus,
        "anime_id": int,
        "created_at": str,  # date-time
        "item_number": int,
        "type": str,
    },
)

T_EpisodeDetail = TypedDict(
    "T_EpisodeDetail",
    {
        "id": int,
        "model": str,
        "name": str,
        "number": str,
        "number_secondary": str,
        "season": str,
        "status": T_EpisodeStatus,
        "anime_id": int,
        "created_at": str,  # date-time
        "item_number": int,
        "type": str,
        "players": List[T_Player],
    },
)

T_AnimeListResponse = TypedDict(
    "T_AnimeListResponse", {"data": List[T_AnimeListItem], "links": T_Pagination, "meta": T_PaginationMeta}
)

T_AnimeDetailResponse = TypedDict("T_AnimeDetailResponse", {"data": T_AnimeDetail, "meta": T_CountryMeta})

T_EpisodeListResponse = TypedDict("T_EpisodeListResponse", {"data": List[T_EpisodeListItem]})

T_EpisodeDetailResponse = TypedDict("T_EpisodeDetailResponse", {"data": T_EpisodeDetail})

T_BadRequestError = TypedDict("T_BadRequestError", {"error": str})

# ============ SYNC CLIENT ============


class AnimeliborgAPISync:
    """
    Sync client for Animelib.org API
    """

    def __init__(
        self,
        base_url: str = "https://api.cdnlibs.org/api",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.Client] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.Client(timeout=self._timeout)

    def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """
        Private method to handle HTTP requests
        """
        url = f"{self.base_url}{path}"
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"
        if self._basic:
            request_headers["Authorization"] = httpx.BasicAuth(self._basic[0], self._basic[1])._auth_header

        try:
            response = self._client.request(
                method=method, url=url, params=params, headers=request_headers, json=json, files=files, data=data
            )
            response.raise_for_status()

            return APIResponse(
                success=True,
                data=response.json() if response.content else {},
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )

        except Exception as e:
            if self.raise_on_error:
                if isinstance(e, httpx.HTTPStatusError):
                    raise ApiError(f"HTTP error {e.response.status_code}: {e.response.text}") from e
                raise ApiError(f"Request failed: {str(e)}") from e

            return APIResponse(
                success=False,
                data={},
                status_code=getattr(e, "response", None) and e.response.status_code or 0,
                headers={},
                error=e,
            )

    def get_anime(
        self,
        fields: Optional[List[str]] = None,
        site_id: Optional[List[int]] = None,
        # LLM missing this params
        status: Optional[List[int]] = None,
        sort_by: Optional[str] = None,
        q: Optional[str] = None,
    ) -> APIResponse[T_AnimeListResponse]:
        """
        Получить список аниме

        Возвращает список аниме с пагинацией и фильтрацией

        Args:
            fields: Поля для выборки
            site_id: ID сайта
            q: Поисковый запрос

        Returns:
            APIResponse[T_AnimeListResponse]: Ответ со списком аниме

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        params = {}
        if fields:
            params["fields[]"] = fields
        if site_id:
            params["site_id[]"] = site_id
        if q:
            params["q"] = q
        if status:
            params["status[]"] = status
        if sort_by:
            params["sort_by"] = sort_by

        return self._request("GET", "/anime", params=params)

    def get_anime_by_slug_url(
        self, slug_url: str, fields: Optional[List[str]] = None
    ) -> APIResponse[T_AnimeDetailResponse]:
        """
        Получить информацию об аниме

        Возвращает детальную информацию об аниме по его slug

        Args:
            slug_url: URL-идентификатор аниме
            fields: Поля для выборки

        Returns:
            APIResponse[T_AnimeDetailResponse]: Ответ с детальной информацией об аниме

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        params = {}
        if fields:
            params["fields[]"] = fields

        return self._request("GET", f"/anime/{slug_url}", params=params)

    def get_episodes(self, anime_id: Optional[str] = None) -> APIResponse[T_EpisodeListResponse]:
        """
        Получить список эпизодов

        Возвращает список эпизодов с возможностью фильтрации по аниме

        Args:
            anime_id: ID аниме для фильтрации эпизодов

        Returns:
            APIResponse[T_EpisodeListResponse]: Ответ со списком эпизодов

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        params = {}
        if anime_id:
            params["anime_id"] = anime_id

        return self._request("GET", "/episodes", params=params)

    def get_episode_by_id(self, id: str) -> APIResponse[T_EpisodeDetailResponse]:
        """
        Получить информацию об эпизоде

        Возвращает детальную информацию об эпизоде по его ID

        Args:
            id: ID эпизода

        Returns:
            APIResponse[T_EpisodeDetailResponse]: Ответ с детальной информацией об эпизоде

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        return self._request("GET", f"/episodes/{id}")


# ============ ASYNC CLIENT ============


class AnimeliborgAPIAsync:
    """
    Async client for Animelib.org API
    """

    def __init__(
        self,
        base_url: str = "https://api.cdnlibs.org/api",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.AsyncClient] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.AsyncClient(timeout=self._timeout)

    async def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """
        Private method to handle HTTP requests
        """
        url = f"{self.base_url}{path}"
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"
        if self._basic:
            request_headers["Authorization"] = httpx.BasicAuth(self._basic[0], self._basic[1])._auth_header

        try:
            response = await self._client.request(
                method=method, url=url, params=params, headers=request_headers, json=json, files=files, data=data
            )
            response.raise_for_status()

            return APIResponse(
                success=True,
                data=response.json() if response.content else {},
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )

        except Exception as e:
            if self.raise_on_error:
                if isinstance(e, httpx.HTTPStatusError):
                    raise ApiError(f"HTTP error {e.response.status_code}: {e.response.text}") from e
                raise ApiError(f"Request failed: {str(e)}") from e

            return APIResponse(
                success=False,
                data={},
                status_code=getattr(e, "response", None) and e.response.status_code or 0,
                headers={},
                error=e,
            )

    async def get_anime(
        self,
        fields: Optional[List[str]] = None,
        site_id: Optional[List[int]] = None,
        # LLM missing this params
        status: Optional[List[int]] = None,
        sort_by: Optional[str] = None,
        q: Optional[str] = None,
    ) -> APIResponse[T_AnimeListResponse]:
        """
        Получить список аниме

        Возвращает список аниме с пагинацией и фильтрацией

        Args:
            fields: Поля для выборки
            site_id: ID сайта
            q: Поисковый запрос

        Returns:
            APIResponse[T_AnimeListResponse]: Ответ со списком аниме

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        params = {}
        if fields:
            params["fields[]"] = fields
        if site_id:
            params["site_id[]"] = site_id
        if q:
            params["q"] = q
        if status:
            params["status[]"] = status
        if sort_by:
            params["sort_by"] = sort_by

        return await self._request("GET", "/anime", params=params)

    async def get_anime_by_slug_url(
        self, slug_url: str, fields: Optional[List[str]] = None
    ) -> APIResponse[T_AnimeDetailResponse]:
        """
        Получить информацию об аниме

        Возвращает детальную информацию об аниме по его slug

        Args:
            slug_url: URL-идентификатор аниме
            fields: Поля для выборки

        Returns:
            APIResponse[T_AnimeDetailResponse]: Ответ с детальной информацией об аниме

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        params = {}
        if fields:
            params["fields[]"] = fields

        return await self._request("GET", f"/anime/{slug_url}", params=params)

    async def get_episodes(self, anime_id: Optional[str] = None) -> APIResponse[T_EpisodeListResponse]:
        """
        Получить список эпизодов

        Возвращает список эпизодов с возможностью фильтрации по аниме

        Args:
            anime_id: ID аниме для фильтрации эпизодов

        Returns:
            APIResponse[T_EpisodeListResponse]: Ответ со списком эпизодов

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        params = {}
        if anime_id:
            params["anime_id"] = anime_id

        return await self._request("GET", "/episodes", params=params)

    async def get_episode_by_id(self, id: str) -> APIResponse[T_EpisodeDetailResponse]:
        """
        Получить информацию об эпизоде

        Возвращает детальную информацию об эпизоде по его ID

        Args:
            id: ID эпизода

        Returns:
            APIResponse[T_EpisodeDetailResponse]: Ответ с детальной информацией об эпизоде

        Raises:
            ApiError: Если raise_on_error=True и произошла ошибка
        """
        return await self._request("GET", f"/episodes/{id}")
