# generated by LLM based on swagger configuration.
# There may be inaccuracies in the data types of the fields.
from typing import List, Optional, Union, Any, Dict, Tuple, Generic, TypeVar
from typing_extensions import TypedDict, NamedTuple
import httpx


# Type Variables
T = TypeVar("T")


# Exception class
class ApiError(Exception):
    """API error raised when HTTP status >= 400 and raise_on_error=True"""

    pass


# APIResponse class
class APIResponse(NamedTuple, Generic[T]):
    """Monad-like response wrapper"""

    success: bool
    data: T
    status_code: int
    headers: Dict[str, str]
    error: Optional[Exception]  # populated if success=False AND raise_on_error=False

    def raise_for_status(self) -> None:
        if not self.success and self.error:
            raise self.error


# TypedDict types
T_User = TypedDict(
    "T_User", {"id": int, "username": str, "displayName": str, "avatar": Optional[str], "profileUrl": Optional[str]}
)

T_DateInfo = TypedDict(
    "T_DateInfo",
    {
        "createdAt": str,  # date-time
        "publishedAt": Optional[str],  # date-time
        "raw": Optional[str],
    },
)

T_UpdateInfo = TypedDict(
    "T_UpdateInfo",
    {
        "lastUpdated": str,  # date-time
        "updatedBy": Union[T_User, Dict[str, Any]],
        "notes": Optional[str],
    },
)

T_Wall = TypedDict("T_Wall", {"image": str, "color": Optional[str], "ratio": Optional[str]})

T_Description = TypedDict("T_Description", {"text": str, "html": Optional[str], "short": Optional[str]})

T_Status = TypedDict("T_Status", {"statusName": str, "airing": Optional[bool], "progress": Optional[str]})

T_Release = TypedDict(
    "T_Release",
    {
        "id": int,
        "russian": str,
        "original": str,
        "image": Optional[str],
        "wall": Optional[T_Wall],
        "description": Optional[T_Description],
        "status": Optional[T_Status],
        "type": Optional[str],
        "dateissue": Optional[int],
        "season": Optional[str],
        "genres": Optional[str],
        "studio": Optional[str],
        "duration": Optional[int],
        "series": Optional[int],
        "currentSeries": Optional[int],
        "dubbers": Optional[str],
        "timers": Optional[str],
        "user": Optional[T_User],
        "url": str,
        "views": Optional[int],
        "rating": Optional[str],
        "date": Optional[T_DateInfo],
        "update": Optional[T_UpdateInfo],
    },
)

T_ReleasesResponse = TypedDict("T_ReleasesResponse", {"releases": List[T_Release], "count": int})

T_SearchForm = TypedDict(
    "T_SearchForm",
    {"search": Optional[str], "status": Optional[str], "pageSize": Optional[int], "pageNumber": Optional[int]},
    total=False,
)

T_Error = TypedDict("T_Error", {"code": int, "message": str})


# Sync Client
class DreamerscastSync:
    def __init__(
        self,
        base_url: str = "https://dreamerscast.com",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.Client] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.Client(timeout=self._timeout)

    def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Internal method to handle HTTP requests"""
        # Prepare headers
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        # Make the request
        try:
            response = self._client.request(
                method=method,
                url=self.base_url + path,
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=self._basic,
            )

            # Process response
            if response.is_success:
                try:
                    response_data = response.json()
                except Exception:
                    response_data = response.text

                return APIResponse(
                    success=True,
                    data=response_data,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=None,
                )
            else:
                error_data = None
                try:
                    error_data = response.json()
                except Exception:
                    error_data = response.text

                error = ApiError(f"HTTP {response.status_code}: {error_data}")

                if self.raise_on_error:
                    raise error

                return APIResponse(
                    success=False,
                    data=error_data,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=error,
                )
        except Exception as e:
            error = ApiError(f"Request failed: {str(e)}")

            if self.raise_on_error:
                raise error

            return APIResponse(success=False, data=None, status_code=0, headers={}, error=error)

    def get_releases(self, search_form: Optional[T_SearchForm] = None) -> APIResponse[T_ReleasesResponse]:
        """
        Получение списка релизов

        Args:
            search_form: Форма запроса (application/x-www-form-urlencoded). Поля необязательные — использовать по необходимости.

        Returns:
            APIResponse[T_ReleasesResponse]: Успешный ответ — список релизов

        Raises:
            ApiError: If raise_on_error=True and the request fails
        """
        # Convert form data to x-www-form-urlencoded format
        data = None
        if search_form:
            data = {k: v for k, v in search_form.items() if v is not None}

        return self._request(method="POST", path="/", data=data)

    def close(self) -> None:
        """Close the underlying httpx client"""
        if hasattr(self._client, "close"):
            self._client.close()

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.close()


# Async Client
class DreamerscastAsync:
    def __init__(
        self,
        base_url: str = "https://dreamerscast.com",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.AsyncClient] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.AsyncClient(timeout=self._timeout)

    async def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Internal async method to handle HTTP requests"""
        # Prepare headers
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-API-Key"] = self._api_key
        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        # Make the request
        try:
            response = await self._client.request(
                method=method,
                url=self.base_url + path,
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=self._basic,
            )

            # Process response
            if response.is_success:
                try:
                    response_data = response.json()
                except Exception:
                    response_data = response.text

                return APIResponse(
                    success=True,
                    data=response_data,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=None,
                )
            else:
                error_data = None
                try:
                    error_data = response.json()
                except Exception:
                    error_data = response.text

                error = ApiError(f"HTTP {response.status_code}: {error_data}")

                if self.raise_on_error:
                    raise error

                return APIResponse(
                    success=False,
                    data=error_data,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=error,
                )
        except Exception as e:
            error = ApiError(f"Request failed: {str(e)}")

            if self.raise_on_error:
                raise error

            return APIResponse(success=False, data=None, status_code=0, headers={}, error=error)

    async def get_releases(self, search_form: Optional[T_SearchForm] = None) -> APIResponse[T_ReleasesResponse]:
        """
        Получение списка релизов

        Args:
            search_form: Форма запроса (application/x-www-form-urlencoded). Поля необязательные — использовать по необходимости.

        Returns:
            APIResponse[T_ReleasesResponse]: Успешный ответ — список релизов

        Raises:
            ApiError: If raise_on_error=True and the request fails
        """
        # Convert form data to x-www-form-urlencoded format
        data = None
        if search_form:
            data = {k: v for k, v in search_form.items() if v is not None}

        return await self._request(method="POST", path="/", data=data)

    async def close(self) -> None:
        """Close the underlying httpx client"""
        if hasattr(self._client, "aclose"):
            await self._client.aclose()

    async def __aenter__(self):
        return self

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        await self.close()
