# generated by LLM based from swagger configuration.
# There may be inaccuracies in the data types of the fields.
from typing import List, Optional, Union, Any, Dict, Tuple, Generic, TypeVar
from typing_extensions import TypedDict, Literal, NamedTuple
import httpx

# Type variables for generic API responses
T = TypeVar("T")


# Exception class for API errors
class ApiError(Exception):
    """Exception raised when API returns an error."""

    pass


# API Response wrapper
class APIResponse(NamedTuple, Generic[T]):
    """Monad-like response wrapper"""

    success: bool
    data: T
    status_code: int
    headers: Dict[str, str]
    error: Optional[Exception]  # populated if success=False AND raise_on_error=False

    def raise_for_status(self) -> None:
        if not self.success and self.error:
            raise self.error


# Enums
E_AnimeStatus = Literal["вышел", "онгоинг", "анонс"]
E_AnimeStatusAlias = Literal["released", "ongoing", "announcement"]
E_AnimeStatusValue = Literal[0, 1, 2]
E_Season = Literal[1, 2, 3, 4]
E_MinAgeValue = Literal[0, 1, 2, 3, 4, 5]
E_ListTitle = Literal["Смотрю", "В Планах", "Просмотрено", "Брошено", "Отложено"]
E_ListHref = Literal["watch_now", "will", "watched", "lost", "postpone"]
E_ListId = Literal[0, 1, 2, 3, 5]
E_WorldArtType = Literal["animation", "cinema"]
E_GenreId = Literal[
    2,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    106,
    107,
    108,
    109,
    110,
]
E_GenreAlias = Literal[
    "bisenen",
    "dzesej",
    "maho-sedze",
    "sedze",
    "sedze-aj",
    "senen",
    "senen-aj",
    "sejnen",
    "etti",
    "vestern",
    "detektiv",
    "drama",
    "komediya",
    "parodiya",
    "prestupnyj-mir",
    "vori",
    "mafiya-yakudza",
    "ohotniki-za-golovami",
    "piraty",
    "terroristy",
    "ubijcy",
    "meha",
    "androidy",
    "pilotiruemye-roboty",
    "silovye-kostyumy",
    "ii",
    "transformery",
    "mistika",
    "priklyucheniya",
    "romantika",
    "lyubovnyj-treugol-nik",
    "triller",
    "ugasy",
    "fantastika",
    "inoplanetyane",
    "kiborgi",
    "kosmicheskie-priklyucheniya",
    "puteshestviya-vo-vremeni",
    "fentezi",
    "al-ternativnaya-real-nost",
    "angely",
    "bogi",
    "vampiry",
    "ved-my",
    "emony",
    "drakony",
    "zombi",
    "magiya",
    "prizraki",
    "rysalki",
    "sovremennoe-fentezi",
    "sukkuby",
    "temnoe-fentezi",
    "temnye-el-fy",
    "fei",
    "celyj-fentezi-mir",
    "el-fy",
    "virtual-naya-real-nost",
    "parallel-nyj-mir",
    "ekshen",
    "boevye-iskusstva",
    "nindzya",
    "perestrelki",
    "proksi-boi",
    "samurai",
    "srazheniya-na-mechah",
    "supersposobnosti",
    "al-ternativnaya-istoriya",
    "antivojna",
    "antiutopiya",
    "vojna",
    "voennaya-tematika",
    "garem",
    "iskusstvo",
    "muzyka",
    "istoricheskij",
    "kiberpank",
    "kulinariya",
    "lolikon",
    "nelinejnyj-syuzhet",
    "povsednevnost",
    "politika",
    "policejskie",
    "postapokaliptika",
    "rossiya-v-anime",
    "sport",
    "basketbol",
    "stimpank",
    "tajnyj-zagovor",
    "shkola",
    "garem-dlya-devochek",
    "lyudi-zveri",
    "psihologiya",
    "manga",
    "erotica",
    "ne-yaponskoe",
    "trap",
    "sverh-estestvennoe",
    "igry",
    "isekai",
    "chinese3d",
    "motorcycles",
    "badguys",
    "bezumie",
]
E_Sort = Literal["title", "year", "rating", "rating_counters", "views", "top", "random", "id"]
E_Status = Literal["released", "ongoing", "announcement", "announce", "0", "1", "2"]
E_Translates = Literal[
    "1", "4", "5", "6", "7", "full", "dubbing", "multivoice", "onevoice", "single", "twovoice", "duet", "subtitles"
]
E_Types = Literal[
    "0", "1", "2", "3", "4", "5", "6", "7", "tv", "movie", "shortfilm", "ova", "special", "shorttv", "ona"
]
E_SeasonStr = Literal["1", "2", "3", "4", "winter", "fall", "summer", "spring", "autumn"]
E_RequireFields = Literal[
    "creators", "studios", "original", "description", "min_age", "season", "genres", "ep_count", "translates"
]

# TypedDict definitions
T_Poster = TypedDict(
    "T_Poster",
    {
        "small": str,  # Anime poster in WEBP format. 33x47px
        "medium": str,  # Anime poster in WEBP format. 184x260px
        "big": str,  # Anime poster in AVIF format. 250x350px
        "huge": str,  # Anime poster in AVIF format. 400x560
        "fullsize": str,  # Anime FULL poster in JPEG format. Responsive size.
        "mega": str,  # Anime mega poster in AVIF format. 570x800px
    },
)

T_Rating = TypedDict(
    "T_Rating",
    {
        "average": float,
        "kp_rating": float,
        "anidub_rating": float,
        "counters": int,
        "myanimelist_rating": float,
        "shikimori_rating": float,
        "worldart_rating": float,
    },
)

T_AnimeType = TypedDict(
    "T_AnimeType",
    {
        "name": str,  # Anime type title
        "value": int,  # Anime type ID
        "shortname": str,  # Anime type short name
    },
)

T_MinAge = TypedDict(
    "T_MinAge",
    {
        "value": E_MinAgeValue,  # Minimum age rating
        "title": str,  # Minimum age rating title
        "title_long": str,
    },
)

T_AnimeStatus = TypedDict(
    "T_AnimeStatus",
    {
        "title": E_AnimeStatus,  # Anime status title
        "class": str,  # Deprecated, do not use it
        "alias": E_AnimeStatusAlias,  # Anime status alias
        "value": E_AnimeStatusValue,  # Anime status ID
    },
)


T_UserListInfo = TypedDict(
    "T_UserListInfo",
    {
        "title": E_ListTitle,  # List title
        "href": E_ListHref,  # List alias
        "id": E_ListId,
    },
)

T_UserList = TypedDict(
    "T_UserList",
    {
        "is_fav": bool,  # Is anime in favorites
        "list": T_UserListInfo,
    },
)

T_User = TypedDict(
    "T_User",
    {
        "list": T_UserList,
        "rating": float,  # Current user rating for this anime
    },
)

T_RemoteIds = TypedDict(
    "T_RemoteIds",
    {
        "worldart_id": int,  # WorldArt URL looks like: http://world-art.ru/{worldart_type}/{worldart_type}.php?id={worldart_id}
        "worldart_type": E_WorldArtType,
        "kp_id": int,  # Kinopoisk ID. URL looks like: https://www.kinopoisk.ru/film/{kp_id}/
        "anidub_id": int,  # Deprecated. Do not use it
        "sr_id": int,  # SovetRomantica ID. URL looks like: https://sovetromantica.com/anime/{sr_id}
        "anilibria_alias": str,  # Anilibria alias. URL looks like: https://anilibria.tv/release/{anilibria_alias}.html
        "shikimori_id": int,  # Shikimori ID. URL looks like: https://shikimori.one/animes/{shikimori_id}
        "myanimelist_id": int,  # MyAnimeList ID. URL looks like: https://myanimelist.net/anime/{myanimelist_id}
    },
)

T_Top = TypedDict(
    "T_Top",
    {
        "category": int,  # Top place in anime category (ova, ona, tv, film, etc)
        "global": int,  # Global TOP place in all animes.
    },
)

T_Genre = TypedDict(
    "T_Genre",
    {
        "title": str,  # Genre title
        "id": E_GenreId,  # Genre ID
        "alias": E_GenreAlias,
        "url": str,  # Genre URL
        "description": str,
    },
)

T_SubGenre = TypedDict(
    "T_SubGenre",
    {
        "title": str,  # Genre title
        "id": E_GenreId,  # Genre ID
        "alias": E_GenreAlias,
        "url": str,  # Genre URL
    },
)

T_Creator = TypedDict(
    "T_Creator",
    {
        "title": str,
        "id": int,
        "url": str,
    },
)

T_Studio = TypedDict(
    "T_Studio",
    {
        "title": str,
        "id": int,
        "url": str,
    },
)

T_Skip = TypedDict(
    "T_Skip",
    {
        "time": int,
        "length": int,
    },
)

T_Skips = TypedDict(
    "T_Skips",
    {
        "ending": T_Skip,  # Ending skip time and length
        "opening": T_Skip,  # Opening skip time and length
    },
)

T_VideoData = TypedDict(
    "T_VideoData",
    {
        "dubbing": str,
        "player": str,
    },
)

T_Video = TypedDict(
    "T_Video",
    {
        "video_id": int,
        "iframe_url": str,
        "data": T_VideoData,
        "number": str,
        "date": int,  # Video publish date (unix timestamp)
        "index": int,  # Video index (used for ordering episodes)
        "skips": T_Skips,
        "views": int,
        "duration": int,
    },
)

T_Episodes = TypedDict(
    "T_Episodes",
    {
        "aired": int,  # Count of episodes, which already aired
        "count": int,  # The total number of episodes, which this anime has
        "next_date": int,  # UNIX time of next episode
    },
)

T_Translate = TypedDict(
    "T_Translate",
    {
        "title": str,
        "href": str,
        "value": int,
    },
)

T_ScreenshotSize = TypedDict(
    "T_ScreenshotSize",
    {
        "small": str,  # 250x150 webp image
        "full": str,  # Full HD avif image (if no header passed - webp)
    },
)

T_Screenshot = TypedDict(
    "T_Screenshot",
    {
        "sizes": T_ScreenshotSize,
        "id": int,
        "time": int,  # Screenshot time in seconds
        "episode": str,  # Screenshot episode number
    },
)

T_ViewingOrderData = TypedDict(
    "T_ViewingOrderData",
    {
        "id": int,
        "index": int,
        "text": str,
    },
)


T_ViewingOrderUserListInfo = TypedDict(
    "T_ViewingOrderUserListInfo",
    {
        "title": E_ListTitle,  # List title
        "href": E_ListHref,  # List alias
        "id": E_ListId,
    },
)

T_ViewingOrderUserList = TypedDict(
    "T_ViewingOrderUserList",
    {
        "list": T_ViewingOrderUserListInfo,
        "is_fav": bool,
    },
)


T_ViewingOrderUser = TypedDict(
    "T_ViewingOrderUser",
    {
        "list": T_ViewingOrderUserList,
        "rating": float,
    },
)


T_ViewingOrder = TypedDict(
    "T_ViewingOrder",
    {
        "title": str,
        "anime_id": int,
        "type": T_AnimeType,
        "anime_url": str,
        "anime_status": T_AnimeStatus,
        "description": str,
        "poster": T_Poster,
        "user": T_ViewingOrderUser,
        "year": int,
        "data": T_ViewingOrderData,
    },
)

T_Anime = TypedDict(
    "T_Anime",
    {
        "anime_id": int,
        "anime_status": T_AnimeStatus,
        "anime_url": str,  # Anime alias (URL would be https://yummyani.me/catalog/item/anime-alias-123)
        "poster": T_Poster,
        "rating": T_Rating,  # Anime rating
        "title": str,  # Anime title
        "type": T_AnimeType,  # Anime type
        "year": int,  # Anime release year
        "description": str,
        "views": int,
        "season": E_Season,  # 1 - Winter, 2 - Spring, 3 - Summer, 4 - Fall
        "min_age": T_MinAge,
        "user": T_User,
        "remote_ids": T_RemoteIds,
        "top": T_Top,
        "blocked_in": List[str],
        "original": str,
        "duration": int,
        "other_titles": List[str],
        "creators": List[T_Creator],
        "studios": List[T_Studio],
        "videos": List[T_Video],
        "genres": List[T_Genre],
        "viewing_order": List[T_ViewingOrder],
        "translates": List[T_Translate],
        "episodes": T_Episodes,
        "comments_count": int,  # How many comments are in this anime
        "reviews_count": int,  # How many reviews are in this anime
        "random_screenshots": List[T_Screenshot],
        "posts_count": int,
    },
)


T_RatingSimple = TypedDict(
    "T_RatingSimple",
    {
        "counters": int,  # How many users rated this anime
        "average": float,  # Anime average rating
    },
)

T_AnimeSimple = TypedDict(
    "T_AnimeSimple",
    {
        "anime_id": int,
        "anime_status": T_AnimeStatus,
        "anime_url": str,  # Anime alias (URL would be https://yummyani.me/catalog/item/anime-alias-123)
        "poster": T_Poster,
        "rating": T_RatingSimple,  # Anime rating
        "title": str,  # Anime title
        "type": T_AnimeType,  # Anime type
        "year": int,  # Anime release year
        "description": str,
        "views": int,
        "season": E_Season,  # 1 - Winter, 2 - Spring, 3 - Summer, 4 - Fall
        "min_age": T_MinAge,
        "user": T_User,
        "remote_ids": T_RemoteIds,
        "top": T_Top,
        "blocked_in": List[str],
    },
)

T_GenreItem = TypedDict(
    "T_GenreItem",
    {
        "title": str,
        "href": str,
        "value": int,
        "more_titles": List[str],
        "group_id": int,
    },
)

T_GenreGroup = TypedDict(
    "T_GenreGroup",
    {
        "title": str,
        "id": int,
    },
)

T_Genres = TypedDict(
    "T_Genres",
    {
        "genres": List[T_GenreItem],
        "groups": List[T_GenreGroup],
    },
)

T_TypeCount = TypedDict(
    "T_TypeCount",
    {
        "type": T_AnimeType,
        "count": int,
    },
)

T_ScheduleAnime = TypedDict(
    "T_ScheduleAnime",
    {
        "title": str,
        "description": str,
        "poster": T_Poster,
        "anime_url": str,
        "anime_id": int,
        "episodes": T_Episodes,
    },
)

T_GetAnimeGenresIdResponseData = TypedDict(
    "T_GetAnimeGenresIdResponseData",
    {
        "title": str,  # Genre title
        "id": E_GenreId,  # Genre ID
        "alias": E_GenreAlias,
        "url": str,  # Genre URL
        "description": str,
        "sub_genres": List[T_SubGenre],
    },
)

T_GetAnimeGenresIdResponse = TypedDict("T_GetAnimeGenresIdResponse", {"response": T_GetAnimeGenresIdResponseData})
T_GetAnimeCatalogResponseData = TypedDict(
    "T_GetAnimeCatalogResponseData",
    {
        "genres": T_Genres,
        "data": List[T_Anime],
        "types": List[T_TypeCount],
    },
)

T_GetAnimeCatalogResponse = TypedDict("T_GetAnimeCatalogResponse", {"response": T_GetAnimeCatalogResponseData})

T_GetAnimeGenresResponse = TypedDict(
    "T_GetAnimeGenresResponse",
    {
        "response": T_Genres,
    },
)

T_GetAnimeCountsTypesResponse = TypedDict(
    "T_GetAnimeCountsTypesResponse",
    {
        "response": List[T_TypeCount],
    },
)

T_GetAnimeScheduleResponse = TypedDict(
    "T_GetAnimeScheduleResponse",
    {
        "response": List[T_ScheduleAnime],
    },
)

T_GetAnimeResponse = TypedDict(
    "T_GetAnimeResponse",
    {
        "response": List[T_AnimeSimple],
    },
)

T_GetSearchResponse = TypedDict(
    "T_GetSearchResponse",
    {
        "response": List[T_AnimeSimple],
    },
)

T_GetAnimeIdVideosResponse = TypedDict(
    "T_GetAnimeIdVideosResponse",
    {
        "response": List[T_Video],
    },
)

T_ArgumentsApiError = TypedDict(
    "T_ArgumentsApiError",
    {
        "error": str,  # Error message
        "error_code": int,  # Error code
        "error_title": str,  # Error title
        "error_name": str,  # Error name
        "sub_error_code": int,  # Sub error code
    },
)

T_NotFoundError = TypedDict(
    "T_NotFoundError",
    {
        "error": str,  # Error message
        "error_code": int,  # Error code
        "error_title": str,  # Error title
        "error_name": str,  # Error name
    },
)


# Sync Client
class YummyAnimeAPISync:
    def __init__(
        self,
        base_url: str = "https://api.yani.tv",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.Client] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.Client(timeout=self._timeout)

    def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Private method to handle HTTP requests."""
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-Application"] = self._api_key

        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        if self._basic:
            auth = self._basic
        else:
            auth = None

        try:
            response = self._client.request(
                method=method,
                url=f"{self.base_url}{path}",
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=auth,
            )

            if response.status_code >= 400:
                error_data = response.json() if response.content else {"error": "Unknown error"}
                error = ApiError(f"API Error: {error_data}")
                if self.raise_on_error:
                    raise error
                return APIResponse(
                    success=False,
                    data=error_data,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=error,
                )

            return APIResponse(
                success=True,
                data=response.json() if response.content else {},
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        except Exception as e:
            error = ApiError(f"Request Error: {str(e)}")
            if self.raise_on_error:
                raise error
            return APIResponse(success=False, data={}, status_code=0, headers={}, error=error)

    def get_anime_genre(self, id: str) -> APIResponse[T_GetAnimeGenresIdResponse]:
        """Get anime genre by id.

        Args:
            id: Genre ID or alias

        Returns:
            APIResponse with genre data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return self._request("GET", f"/anime/genres/{id}")

    def get_anime_catalog(self) -> APIResponse[T_GetAnimeCatalogResponse]:
        """Get genres, anime types and and default catalog items.

        Returns:
            APIResponse with catalog data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return self._request("GET", "/anime/catalog")

    def get_anime_genres(self) -> APIResponse[T_GetAnimeGenresResponse]:
        """List of all anime genres.

        Returns:
            APIResponse with genres data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return self._request("GET", "/anime/genres")

    def get_anime_counts_types(self) -> APIResponse[T_GetAnimeCountsTypesResponse]:
        """Get anime count, grouped by anime types.

        Returns:
            APIResponse with anime counts by type

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return self._request("GET", "/anime/counts/types")

    def get_anime_schedule(self) -> APIResponse[T_GetAnimeScheduleResponse]:
        """Get anime (ongoings) schedule.

        Returns:
            APIResponse with anime schedule

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return self._request("GET", "/anime/schedule")

    def filter_anime(
        self,
        studio_ids: Optional[List[int]] = None,
        q: Optional[str] = None,
        director_ids: Optional[List[int]] = None,
        worldart_ids: Optional[List[int]] = None,
        mal_ids: Optional[List[int]] = None,
        kp_ids: Optional[List[int]] = None,
        shikimori_ids: Optional[List[int]] = None,
        min_age: Optional[List[int]] = None,
        max_rating_counters: Optional[int] = None,
        min_rating_counters: Optional[int] = None,
        require_fields: Optional[List[E_RequireFields]] = None,
        ids: Optional[List[int]] = None,
        season: Optional[List[E_SeasonStr]] = None,
        status: Optional[List[E_Status]] = None,
        translates: Optional[List[E_Translates]] = None,
        types: Optional[List[E_Types]] = None,
        exclude_genres: Optional[List[Union[E_GenreId, E_GenreAlias]]] = None,
        genres: Optional[List[Union[E_GenreId, E_GenreAlias]]] = None,
        max_rating: Optional[float] = None,
        min_rating: Optional[float] = None,
        ep_to: Optional[int] = None,
        ep_from: Optional[int] = None,
        to_year: Optional[int] = None,
        from_year: Optional[int] = None,
        sort_forward: Optional[bool] = None,
        sort: Optional[E_Sort] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> APIResponse[T_GetAnimeResponse]:
        """Filter anime by different parameters.

        Args:
            studio_ids: Filter animes by studio ids
            q: Search query
            director_ids: Fitler anime by director ids
            worldart_ids: Filter animes by worldart ids
            mal_ids: Filter animes by MyAnimeList ids
            kp_ids: Filter animes by kinopoisk ids
            shikimori_ids: Filter animes by shikimori ids
            min_age: Filter animes by year ratings (PG - 1, PG-13 - 2, R-17+ - 3, R+ - 4)
            max_rating_counters: Maximum rating counters
            min_rating_counters: Minimum rating counters
            require_fields: Return only animes, which contains certain fields
            ids: Filter animes by ids
            season: Season
            status: Status
            translates: Type of anime translates
            types: Types
            exclude_genres: Exclude genres
            genres: Genres
            max_rating: To rating
            min_rating: From rating
            ep_to: Maximum episodes number
            ep_from: Minimum episodes number
            to_year: To year
            from_year: From year
            sort_forward: Sort forward
            sort: Sort by
            offset: Offset
            limit: Limit

        Returns:
            APIResponse with filtered anime data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        params = {}
        if studio_ids is not None:
            params["studio_ids"] = studio_ids
        if q is not None:
            params["q"] = q
        if director_ids is not None:
            params["director_ids"] = director_ids
        if worldart_ids is not None:
            params["worldart_ids"] = worldart_ids
        if mal_ids is not None:
            params["mal_ids"] = mal_ids
        if kp_ids is not None:
            params["kp_ids"] = kp_ids
        if shikimori_ids is not None:
            params["shikimori_ids"] = shikimori_ids
        if min_age is not None:
            params["min_age"] = min_age
        if max_rating_counters is not None:
            params["max_rating_counters"] = max_rating_counters
        if min_rating_counters is not None:
            params["min_rating_counters"] = min_rating_counters
        if require_fields is not None:
            params["require_fields"] = require_fields
        if ids is not None:
            params["ids"] = ids
        if season is not None:
            params["season"] = season
        if status is not None:
            params["status"] = status
        if translates is not None:
            params["translates"] = translates
        if types is not None:
            params["types"] = types
        if exclude_genres is not None:
            params["exclude_genres"] = exclude_genres
        if genres is not None:
            params["genres"] = genres
        if max_rating is not None:
            params["max_rating"] = max_rating
        if min_rating is not None:
            params["min_rating"] = min_rating
        if ep_to is not None:
            params["ep_to"] = ep_to
        if ep_from is not None:
            params["ep_from"] = ep_from
        if to_year is not None:
            params["to_year"] = to_year
        if from_year is not None:
            params["from_year"] = from_year
        if sort_forward is not None:
            params["sort_forward"] = sort_forward
        if sort is not None:
            params["sort"] = sort
        if offset is not None:
            params["offset"] = offset
        if limit is not None:
            params["limit"] = limit

        return self._request("GET", "/anime", params=params)

    def search_anime(
        self, q: str, offset: Optional[int] = None, limit: Optional[int] = None
    ) -> APIResponse[T_GetSearchResponse]:
        """Search anime by search query. Minimum 3 chars in query.

        Args:
            q: Search query
            offset: Offset
            limit: Limit

        Returns:
            APIResponse with search results

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        params = {"q": q}
        if offset is not None:
            params["offset"] = offset
        if limit is not None:
            params["limit"] = limit

        return self._request("GET", "/search", params=params)

    def get_anime_videos(self, id: int) -> APIResponse[T_GetAnimeIdVideosResponse]:
        """Get anime videos.

        Args:
            id: Anime ID

        Returns:
            APIResponse with anime videos

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return self._request("GET", f"/anime/{id}/videos")


# Async Client
class YummyAnimeAPIAsync:
    def __init__(
        self,
        base_url: str = "https://api.yani.tv",
        *,
        api_key: Optional[str] = None,
        bearer_token: Optional[str] = None,
        basic_auth: Optional[Tuple[str, str]] = None,
        headers: Optional[Dict[str, str]] = None,
        timeout: Optional[float] = None,
        client: Optional[httpx.AsyncClient] = None,
        raise_on_error: bool = False,
    ):
        self.base_url = base_url.rstrip("/")
        self._api_key = api_key
        self._bearer = bearer_token
        self._basic = basic_auth
        self._headers = headers or {}
        self._timeout = timeout
        self.raise_on_error = raise_on_error
        self._client = client or httpx.AsyncClient(timeout=self._timeout)

    async def _request(
        self,
        method: str,
        path: str,
        params: Optional[Dict[str, Any]] = None,
        headers: Optional[Dict[str, str]] = None,
        json: Optional[Any] = None,
        files: Optional[Dict[str, Any]] = None,
        data: Optional[Any] = None,
    ) -> APIResponse[Any]:
        """Private async method to handle HTTP requests."""
        request_headers = self._headers.copy()
        if headers:
            request_headers.update(headers)

        if self._api_key:
            request_headers["X-Application"] = self._api_key

        if self._bearer:
            request_headers["Authorization"] = f"Bearer {self._bearer}"

        if self._basic:
            auth = self._basic
        else:
            auth = None

        try:
            response = await self._client.request(
                method=method,
                url=f"{self.base_url}{path}",
                params=params,
                headers=request_headers,
                json=json,
                files=files,
                data=data,
                auth=auth,
            )

            if response.status_code >= 400:
                error_data = response.json() if response.content else {"error": "Unknown error"}
                error = ApiError(f"API Error: {error_data}")
                if self.raise_on_error:
                    raise error
                return APIResponse(
                    success=False,
                    data=error_data,
                    status_code=response.status_code,
                    headers=dict(response.headers),
                    error=error,
                )

            return APIResponse(
                success=True,
                data=response.json() if response.content else {},
                status_code=response.status_code,
                headers=dict(response.headers),
                error=None,
            )
        except Exception as e:
            error = ApiError(f"Request Error: {str(e)}")
            if self.raise_on_error:
                raise error
            return APIResponse(success=False, data={}, status_code=0, headers={}, error=error)

    async def get_anime_genre(self, id: str) -> APIResponse[T_GetAnimeGenresIdResponse]:
        """Get anime genre by id.

        Args:
            id: Genre ID or alias

        Returns:
            APIResponse with genre data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return await self._request("GET", f"/anime/genres/{id}")

    async def get_anime_catalog(self) -> APIResponse[T_GetAnimeCatalogResponse]:
        """Get genres, anime types and and default catalog items.

        Returns:
            APIResponse with catalog data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return await self._request("GET", "/anime/catalog")

    async def get_anime_genres(self) -> APIResponse[T_GetAnimeGenresResponse]:
        """List of all anime genres.

        Returns:
            APIResponse with genres data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return await self._request("GET", "/anime/genres")

    async def get_anime_counts_types(self) -> APIResponse[T_GetAnimeCountsTypesResponse]:
        """Get anime count, grouped by anime types.

        Returns:
            APIResponse with anime counts by type

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return await self._request("GET", "/anime/counts/types")

    async def get_anime_schedule(self) -> APIResponse[T_GetAnimeScheduleResponse]:
        """Get anime (ongoings) schedule.

        Returns:
            APIResponse with anime schedule

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return await self._request("GET", "/anime/schedule")

    async def filter_anime(
        self,
        studio_ids: Optional[List[int]] = None,
        q: Optional[str] = None,
        director_ids: Optional[List[int]] = None,
        worldart_ids: Optional[List[int]] = None,
        mal_ids: Optional[List[int]] = None,
        kp_ids: Optional[List[int]] = None,
        shikimori_ids: Optional[List[int]] = None,
        min_age: Optional[List[int]] = None,
        max_rating_counters: Optional[int] = None,
        min_rating_counters: Optional[int] = None,
        require_fields: Optional[List[E_RequireFields]] = None,
        ids: Optional[List[int]] = None,
        season: Optional[List[E_SeasonStr]] = None,
        status: Optional[List[E_Status]] = None,
        translates: Optional[List[E_Translates]] = None,
        types: Optional[List[E_Types]] = None,
        exclude_genres: Optional[List[Union[E_GenreId, E_GenreAlias]]] = None,
        genres: Optional[List[Union[E_GenreId, E_GenreAlias]]] = None,
        max_rating: Optional[float] = None,
        min_rating: Optional[float] = None,
        ep_to: Optional[int] = None,
        ep_from: Optional[int] = None,
        to_year: Optional[int] = None,
        from_year: Optional[int] = None,
        sort_forward: Optional[bool] = None,
        sort: Optional[E_Sort] = None,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> APIResponse[T_GetAnimeResponse]:
        """Filter anime by different parameters.

        Args:
            studio_ids: Filter animes by studio ids
            q: Search query
            director_ids: Fitler anime by director ids
            worldart_ids: Filter animes by worldart ids
            mal_ids: Filter animes by MyAnimeList ids
            kp_ids: Filter animes by kinopoisk ids
            shikimori_ids: Filter animes by shikimori ids
            min_age: Filter animes by year ratings (PG - 1, PG-13 - 2, R-17+ - 3, R+ - 4)
            max_rating_counters: Maximum rating counters
            min_rating_counters: Minimum rating counters
            require_fields: Return only animes, which contains certain fields
            ids: Filter animes by ids
            season: Season
            status: Status
            translates: Type of anime translates
            types: Types
            exclude_genres: Exclude genres
            genres: Genres
            max_rating: To rating
            min_rating: From rating
            ep_to: Maximum episodes number
            ep_from: Minimum episodes number
            to_year: To year
            from_year: From year
            sort_forward: Sort forward
            sort: Sort by
            offset: Offset
            limit: Limit

        Returns:
            APIResponse with filtered anime data

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        params = {}
        if studio_ids is not None:
            params["studio_ids"] = studio_ids
        if q is not None:
            params["q"] = q
        if director_ids is not None:
            params["director_ids"] = director_ids
        if worldart_ids is not None:
            params["worldart_ids"] = worldart_ids
        if mal_ids is not None:
            params["mal_ids"] = mal_ids
        if kp_ids is not None:
            params["kp_ids"] = kp_ids
        if shikimori_ids is not None:
            params["shikimori_ids"] = shikimori_ids
        if min_age is not None:
            params["min_age"] = min_age
        if max_rating_counters is not None:
            params["max_rating_counters"] = max_rating_counters
        if min_rating_counters is not None:
            params["min_rating_counters"] = min_rating_counters
        if require_fields is not None:
            params["require_fields"] = require_fields
        if ids is not None:
            params["ids"] = ids
        if season is not None:
            params["season"] = season
        if status is not None:
            params["status"] = status
        if translates is not None:
            params["translates"] = translates
        if types is not None:
            params["types"] = types
        if exclude_genres is not None:
            params["exclude_genres"] = exclude_genres
        if genres is not None:
            params["genres"] = genres
        if max_rating is not None:
            params["max_rating"] = max_rating
        if min_rating is not None:
            params["min_rating"] = min_rating
        if ep_to is not None:
            params["ep_to"] = ep_to
        if ep_from is not None:
            params["ep_from"] = ep_from
        if to_year is not None:
            params["to_year"] = to_year
        if from_year is not None:
            params["from_year"] = from_year
        if sort_forward is not None:
            params["sort_forward"] = sort_forward
        if sort is not None:
            params["sort"] = sort
        if offset is not None:
            params["offset"] = offset
        if limit is not None:
            params["limit"] = limit

        return await self._request("GET", "/anime", params=params)

    async def search_anime(
        self, q: str, offset: Optional[int] = None, limit: Optional[int] = None
    ) -> APIResponse[T_GetSearchResponse]:
        """Search anime by search query. Minimum 3 chars in query.

        Args:
            q: Search query
            offset: Offset
            limit: Limit

        Returns:
            APIResponse with search results

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        params = {"q": q}
        if offset is not None:
            params["offset"] = offset
        if limit is not None:
            params["limit"] = limit

        return await self._request("GET", "/search", params=params)

    async def get_anime_videos(self, id: int) -> APIResponse[T_GetAnimeIdVideosResponse]:
        """Get anime videos.

        Args:
            id: Anime ID

        Returns:
            APIResponse with anime videos

        Raises:
            ApiError: If raise_on_error=True and the API returns an error
        """
        return await self._request("GET", f"/anime/{id}/videos")
