# autogenerated by ssc-gen DO NOT EDIT

import re
import json
from html import unescape as _html_unescape
from typing import List, Dict, TypedDict, Union
from contextlib import suppress
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


J_AggregateRating = TypedDict(
    "J_AggregateRating",
    {
        "type": str,
        "ratingCount": int,
        "bestRating": int,
        "ratingValue": str,
    },
)
J_Director = TypedDict(
    "J_Director",
    {
        "type": str,
        "url": str,
        "name": str,
    },
)
J_Actor = TypedDict(
    "J_Actor",
    {
        "type": str,
        "url": str,
        "name": str,
    },
)
J_Creator = TypedDict(
    "J_Creator",
    {
        "type": str,
        "url": str,
        "name": str,
    },
)
J_Content = TypedDict(
    "J_Content",
    {
        "context": str,
        "type": str,
        "url": str,
        "name": str,
        "contentRating": str,
        "description": str,
        "aggregateRating": J_AggregateRating,
        "startDate": str,
        "image": str,
        "genre": List[str],
        "alternativeHeadline": List[str],
        "director": List[J_Director],
        "actor": List[J_Actor],
        "creator": List[J_Creator],
    },
)
T_PageUtils = TypedDict(
    "T_PageUtils",
    {
        "url_canonical": str,
    },
)
T_PageOngoing = TypedDict(
    "T_PageOngoing",
    {
        "url_path": str,
        "title": str,
        "thumbnail": str,
        "episode": str,
        "dub": str,
    },
)
T_PageSearch = TypedDict(
    "T_PageSearch",
    {
        "title": str,
        "thumbnail": str,
        "url": str,
    },
)
T_PageAnime = TypedDict(
    "T_PageAnime",
    {
        "title": str,
        "description": str,
        "thumbnail": str,
        "id": str,
        "raw_json": J_Content,
    },
)
T_EpisodesView = TypedDict(
    "T_EpisodesView",
    {
        "num": str,
        "title": str,
        "id": str,
    },
)
T_EpisodeDubbersView = Dict[str, str]
T_PageEpisode = TypedDict(
    "T_PageEpisode",
    {
        "is_film": bool,
        "dubbers": T_EpisodeDubbersView,
        "episodes": List[T_EpisodesView],
    },
)
T_EpisodeVideoPlayersView = TypedDict(
    "T_EpisodeVideoPlayersView",
    {
        "player": str,
        "data_provider": str,
        "data_provide_dubbing": str,
    },
)
T_PageEpisodeVideo = TypedDict(
    "T_PageEpisodeVideo",
    {
        "is_film": bool,
        "dubbers": T_EpisodeDubbersView,
        "videos": List[T_EpisodeVideoPlayersView],
    },
)
T_SourceVideoView = TypedDict(
    "T_SourceVideoView",
    {
        "title": str,
        "url": str,
        "data_provider": str,
        "data_provide_dubbing": str,
    },
)
T_SourceDubbersView = Dict[str, str]
T_PageSource = TypedDict(
    "T_PageSource",
    {
        "dubbers": T_SourceDubbersView,
        "videos": List[T_SourceVideoView],
    },
)


class PageUtils:
    """

    {
        "url_canonical": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_url_canonical(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect('link[rel="canonical"]')[0]
        v1 = v0.get("href")

        return v1.rstrip("/")

    def parse(self) -> T_PageUtils:
        return {
            "url_canonical": self._parse_url_canonical(self._document),
        }


class PageOngoing:
    """Get all available ongoings from the main page

        GET https://animego.one


        NOTE: animego can change the domain, so only the path is returned.
        To get the real url, extract the value using the selector 'link[rel="canonical"]::attr(href)'



    [
        {
            "url_path": "String",
            "title": "String",
            "thumbnail": "String",
            "episode": "String",
            "dub": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".border-bottom-0.cursor-pointer")

    def _parse_url_path(self, v: html.HtmlElement) -> str:
        v0 = v.get("onclick")
        v1 = ssc_rm_prefix(v0, "location.href=")

        return v1.strip("'")

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".last-update-title")[0]

        return v0.text_content()

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".lazy[style]")[0]
        v1 = v0.get("style")
        v2 = ssc_rm_prefix(v1, "background-image: url(")

        return v2.rstrip(");")

    def _parse_episode(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".text-truncate")[0]
        v1 = v0.text_content()

        return re.search("(\\d+)\\s", v1)[1]

    def _parse_dub(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".text-gray-dark-6")[0]
        v1 = v0.text_content()
        v2 = v1.replace(")", "")

        return v2.replace("(", "")

    def parse(self) -> List[T_PageOngoing]:
        return [
            {
                "url_path": self._parse_url_path(el),
                "title": self._parse_title(el),
                "thumbnail": self._parse_thumbnail(el),
                "episode": self._parse_episode(el),
                "dub": self._parse_dub(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageSearch:
    """Get all search results by query

        USAGE:

            GET https://animego.one/search/anime
            q={QUERY}

        EXAMPLE:

            GET https://animego.one/search/anime?q=LAIN


    [
        {
            "title": "String",
            "thumbnail": "String",
            "url": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".row > .col-ul-2")

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".text-truncate a[title]")[0]

        return v0.get("title")

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".lazy[data-original]")[0]

        return v0.get("data-original")

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".text-truncate a[href]")[0]

        return v0.get("href")

    def parse(self) -> List[T_PageSearch]:
        return [
            {
                "title": self._parse_title(el),
                "thumbnail": self._parse_thumbnail(el),
                "url": self._parse_url(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageAnime:
    """Anime page information. anime path contains in SearchView.url or Ongoing.url

        - id needed for next API requests
        - raw_json used for extract extra metadata (unescape required)

        USAGE:

            GET https://animego.one/anime/<ANIME_PATH>

        EXAMPLE:

            GET https://animego.one/anime/eksperimenty-leyn-1114


        ISSUES:
            If blocked, you can try skip extract anime metadata and send api request:

            id contains in url:
                - id=1114 for https://animego.one/anime/eksperimenty-leyn-1114
                - id=2589 for https://animego.org/anime/chelovek-muskul-2589

            GET 'https://animego.one/anime/{id}/player?_allow=true'


    {
        "title": "String",
        "description": "String",
        "thumbnail": "String",
        "id": "String",
        "raw_json": {
            "context": "String",
            "type": "String",
            "url": "String",
            "name": "String",
            "contentRating": "String",
            "description": "String",
            "aggregateRating": {
                "type": "String",
                "ratingCount": "Int",
                "bestRating": "Int",
                "ratingValue": "String"
            },
            "startDate": "String",
            "image": "String",
            "genre": "Array<String>",
            "alternativeHeadline": "Array<String>",
            "director": [
                {
                    "type": "String",
                    "url": "String",
                    "name": "String"
                },
                "..."
            ],
            "actor": [
                {
                    "type": "String",
                    "url": "String",
                    "name": "String"
                },
                "..."
            ],
            "creator": [
                {
                    "type": "String",
                    "url": "String",
                    "name": "String"
                },
                "..."
            ]
        }
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".anime-title h1")[0]

        return v0.text_content()

    def _parse_description(self, v: html.HtmlElement) -> str:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".description")
            v2 = [e.text_content() for e in v1]
            v3 = "".join(v2)

            return re.sub("(?:^\\s+)|(?:\\s+$)", "", v3)
        return ""

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("#content img[src]")[0]

        return v0.get("src")

    def _parse_id(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".br-2 .my-list-anime")[0]
        v1 = v0.get("id")

        return v1.lstrip("my-list-")

    def _parse_raw_json(self, v: html.HtmlElement) -> J_Content:
        v0 = v.cssselect("script[type='application/ld+json']")[0]
        v1 = v0.text_content()
        v2 = v1.replace('"@type"', '"type"')
        v3 = v2.replace('"@context"', '"context"')

        return json.loads(v3)

    def parse(self) -> T_PageAnime:
        return {
            "title": self._parse_title(self._document),
            "description": self._parse_description(self._document),
            "thumbnail": self._parse_thumbnail(self._document),
            "id": self._parse_id(self._document),
            "raw_json": self._parse_raw_json(self._document),
        }


class EpisodesView:
    """

    [
        {
            "num": "String",
            "title": "String",
            "id": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("#video-carousel .mb-0")

    def _parse_num(self, v: html.HtmlElement) -> str:
        return v.get("data-episode")

    def _parse_title(self, v: html.HtmlElement) -> str:
        return v.get("data-episode-title")

    def _parse_id(self, v: html.HtmlElement) -> str:
        return v.get("data-id")

    def parse(self) -> List[T_EpisodesView]:
        return [
            {
                "num": self._parse_num(el),
                "title": self._parse_title(el),
                "id": self._parse_id(el),
            }
            for el in self._split_doc(self._document)
        ]


class EpisodeDubbersView:
    """

    {
        "<dubber_id>": "<dubber_name>",
        "<id>": "..."
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("#video-dubbing .mb-1")

    def _parse_key(self, v: html.HtmlElement) -> str:
        return v.get("data-dubbing")

    def _parse_value(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("span")[0]
        v1 = v0.text_content()

        return re.sub("^\\s+|\\s+$", "", v1)

    def parse(self) -> T_EpisodeDubbersView:
        return {self._parse_key(el): self._parse_value(el) for el in self._split_doc(self._document)}


class PageEpisode:
    """Representation episodes

        NOTE:
            film pages does not exist video-carousel feature: test by `#video-carousel` CSS selector
            or match by '<div id="video-carousel"' substring

        Prepare:
          1. get id from Anime object
          2. GET 'https://animego.one/anime/{Anime.id}/player?_allow=true'
          3. extract html from json by ['content'] key
          4. OPTIONAL: unescape HTML

        EXAMPLE:
            GET https://animego.one/anime/anime/1114//player?_allow=true


    {
        "is_film": "Bool",
        "dubbers": {
            "<dubber_id>": "<dubber_name>",
            "<id>": "..."
        },
        "episodes": [
            {
                "num": "String",
                "title": "String",
                "id": "String"
            },
            "..."
        ]
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_is_film(self, v: html.HtmlElement) -> bool:
        v0 = v
        with suppress(Exception):
            assert not v0.cssselect("div#video-carousel"), ""
            v1 = v0

            return bool(v1 or v1 == 0)
        return True

    def _parse_dubbers(self, v: html.HtmlElement) -> T_EpisodeDubbersView:
        return EpisodeDubbersView(v).parse()

    def _parse_episodes(self, v: html.HtmlElement) -> List[T_EpisodesView]:
        return EpisodesView(v).parse()

    def parse(self) -> T_PageEpisode:
        return {
            "is_film": self._parse_is_film(self._document),
            "dubbers": self._parse_dubbers(self._document),
            "episodes": self._parse_episodes(self._document),
        }


class EpisodeVideoPlayersView:
    """

    [
        {
            "player": "String",
            "data_provider": "String",
            "data_provide_dubbing": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("#video-players > .mb-1")

    def _parse_player(self, v: html.HtmlElement) -> str:
        v0 = v.get("data-player")
        v1 = re.sub("^https?", "", v0)

        return f"https:{v1}"

    def _parse_data_provider(self, v: html.HtmlElement) -> str:
        return v.get("data-provider")

    def _parse_data_provide_dubbing(self, v: html.HtmlElement) -> str:
        v0 = v.get("data-provide-dubbing")

        return re.sub("(?:^\\s+)|(?:\\s+$)", "", v0)

    def parse(self) -> List[T_EpisodeVideoPlayersView]:
        return [
            {
                "player": self._parse_player(el),
                "data_provider": self._parse_data_provider(el),
                "data_provide_dubbing": self._parse_data_provide_dubbing(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageEpisodeVideo:
    """Represent Episode object for film (it have not same signatures)

        NOTE:
            film pages does not exist video-carousel feature: test by `#video-carousel` CSS selector
            or match by '<div id="video-carousel"' substring

        Prepare:
          1. get id from Anime object
          2. GET 'https://animego.one/anime/{Anime.id}/player?_allow=true'
          3. extract html from json by ['content'] key
          4. OPTIONAL: unescape HTML

        EXAMPLE:
            GET https://animego.one/anime/315/player?_allow=true


    {
        "is_film": "Bool",
        "dubbers": {
            "<dubber_id>": "<dubber_name>",
            "<id>": "..."
        },
        "videos": [
            {
                "player": "String",
                "data_provider": "String",
                "data_provide_dubbing": "String"
            },
            "..."
        ]
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_is_film(self, v: html.HtmlElement) -> bool:
        v0 = v
        with suppress(Exception):
            assert not v0.cssselect("div#video-carousel"), ""
            v1 = v0

            return bool(v1 or v1 == 0)
        return True

    def _parse_dubbers(self, v: html.HtmlElement) -> T_EpisodeDubbersView:
        return EpisodeDubbersView(v).parse()

    def _parse_videos(self, v: html.HtmlElement) -> List[T_EpisodeVideoPlayersView]:
        return EpisodeVideoPlayersView(v).parse()

    def parse(self) -> T_PageEpisodeVideo:
        return {
            "is_film": self._parse_is_film(self._document),
            "dubbers": self._parse_dubbers(self._document),
            "videos": self._parse_videos(self._document),
        }


class SourceVideoView:
    """

    [
        {
            "title": "String",
            "url": "String",
            "data_provider": "String",
            "data_provide_dubbing": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("#video-players > span")

    def _parse_title(self, v: html.HtmlElement) -> str:
        return v.text_content()

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.get("data-player")

        return f"https:{v0}"

    def _parse_data_provider(self, v: html.HtmlElement) -> str:
        return v.get("data-provider")

    def _parse_data_provide_dubbing(self, v: html.HtmlElement) -> str:
        return v.get("data-provide-dubbing")

    def parse(self) -> List[T_SourceVideoView]:
        return [
            {
                "title": self._parse_title(el),
                "url": self._parse_url(el),
                "data_provider": self._parse_data_provider(el),
                "data_provide_dubbing": self._parse_data_provide_dubbing(el),
            }
            for el in self._split_doc(self._document)
        ]


class SourceDubbersView:
    """

    {
        "<dubber_id>": "<dubber_name>",
        "...": "..."
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("#video-dubbing > span")

    def _parse_key(self, v: html.HtmlElement) -> str:
        return v.get("data-dubbing")

    def _parse_value(self, v: html.HtmlElement) -> str:
        v0 = v.text_content()
        v1 = re.sub("^\\s+", "", v0)

        return re.sub("\\s+$", "", v1)

    def parse(self) -> T_SourceDubbersView:
        return {self._parse_key(el): self._parse_value(el) for el in self._split_doc(self._document)}


class PageSource:
    """representation player urls

        Prepare:
          1. get num and id from Episode

          2.

          GET https://animego.one/anime/series
          dubbing=2&provider=24&episode={Episode.num}id={Episode.id}

          3. extract html from json by ["content"] key

          4. OPTIONAL: unescape document

        EXAMPLE:

            GET https://animego.one/anime/series?dubbing=2&provider=24&episode=2&id=15837


    {
        "dubbers": {
            "<dubber_id>": "<dubber_name>",
            "...": "..."
        },
        "videos": [
            {
                "title": "String",
                "url": "String",
                "data_provider": "String",
                "data_provide_dubbing": "String"
            },
            "..."
        ]
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_dubbers(self, v: html.HtmlElement) -> T_SourceDubbersView:
        return SourceDubbersView(v).parse()

    def _parse_videos(self, v: html.HtmlElement) -> List[T_SourceVideoView]:
        return SourceVideoView(v).parse()

    def parse(self) -> T_PageSource:
        return {
            "dubbers": self._parse_dubbers(self._document),
            "videos": self._parse_videos(self._document),
        }
