# autogenerated by ssc-gen DO NOT EDIT
"""Thanks https://github.com/barsikus007 for researches and decoder impl

NOTE: for extract Search and Ongoing items use rest-api requests

Ongoing:
        POST https://dreamerscast.com/"
        {'search': "", "status": "", "pageSize": 16, 'pageNumber': 1}

Search:

    POST https://dreamerscast.com/"
    {'search': "<QUERY>", "status": "", "pageSize": 16, 'pageNumber': 1}


For extract playlist required reverse obfuscated playlist data and obfuscated javascript player
"""

import re
from html import unescape as _html_unescape
from typing import Dict, TypedDict, Union, Optional
from contextlib import suppress
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


T_PageAnime = TypedDict(
    "T_PageAnime",
    {
        "title": str,
        "description": Optional[str],
        "thumbnail": str,
        "player_js_encoded": str,
        "player_js_url": str,
    },
)


class PageAnime:
    """
        Usage example:

        GET https://dreamerscast.com/home/release/323-tensei-kizoku-kantei-skill-de-nariagaru-2

        Encoding (24.12.24 actual step-by-step)

        decoding and extract playlist:

        - GET <player_js_url>
        - unpack, extract encoded symbols
        - by <player_js_encoded> and <player_js_url> values decrypt it (implement logic from original player sources)


    {
        "title": "String",
        "description": "String",
        "thumbnail": "String",
        "player_js_encoded": "String",
        "player_js_url": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("h3")[0]

        return v0.text_content()

    def _parse_description(self, v: html.HtmlElement) -> Optional[str]:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".postDesc")[0]

            return v1.text_content()
        return None

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".details_poster img")[0]
        v1 = v0.get("src")

        return f"https:{v1}"

    def _parse_player_js_encoded(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")

        return re.search('new Playerjs\\("(.*?)"\\)', v0)[1]

    def _parse_player_js_url(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search('<script[^>]+src="(/js/playerjs.*?)"', v0)[1]

        return f"https://dreamerscast.com{v1}"

    def parse(self) -> T_PageAnime:
        return {
            "title": self._parse_title(self._document),
            "description": self._parse_description(self._document),
            "thumbnail": self._parse_thumbnail(self._document),
            "player_js_encoded": self._parse_player_js_encoded(self._document),
            "player_js_url": self._parse_player_js_url(self._document),
        }
