# autogenerated by ssc-gen DO NOT EDIT

import re
from html import unescape as _html_unescape
from typing import List, Dict, TypedDict, Union, Optional
from contextlib import suppress
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


T_PageOngoing = TypedDict(
    "T_PageOngoing",
    {
        "url": str,
        "title": str,
        "thumbnail": str,
        "counts": str,
    },
)
T_PageSearch = TypedDict(
    "T_PageSearch",
    {
        "url": str,
        "title": str,
        "thumbnail": str,
        "counts": str,
    },
)
T_EpisodesView = TypedDict(
    "T_EpisodesView",
    {
        "title": str,
        "url": str,
    },
)
T_PageAnime = TypedDict(
    "T_PageAnime",
    {
        "title": str,
        "description": str,
        "thumbnail": str,
        "episodes": List[T_EpisodesView],
    },
)
T_SourceView = Dict[str, Optional[str]]
T_PageSource = TypedDict(
    "T_PageSource",
    {
        "videos": T_SourceView,
    },
)


class PageOngoing:
    """usage:

        POST https://jut.su/anime/ongoing/
        ajax_load=yes&start_from_page=1&show_search=&anime_of_user=



    [
        {
            "url": "String",
            "title": "String",
            "thumbnail": "String",
            "counts": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".all_anime_global")

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("a")[0]
        v1 = v0.get("href")

        return f"https://jut.su{v1}"

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".aaname")[0]

        return v0.text_content()

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".all_anime_image[style]")[0]
        v1 = v0.get("style")

        return re.search("'(https?://.*?)'", v1)[1]

    def _parse_counts(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".aailines")
        v1 = [e.text_content() for e in v0]
        v2 = [i.strip("\r\n ") for i in v1]

        return " ".join(v2)

    def parse(self) -> List[T_PageOngoing]:
        return [
            {
                "url": self._parse_url(el),
                "title": self._parse_title(el),
                "thumbnail": self._parse_thumbnail(el),
                "counts": self._parse_counts(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageSearch:
    """
        POST https://jut.su/anime/
        ajax_load=yes&start_from_page=1&show_search=<QUERY>&anime_of_user=

        EXAMPLE:
            POST https://jut.su/anime/
            ajax_load=yes&start_from_page=1&show_search=LA&anime_of_user=


    [
        {
            "url": "String",
            "title": "String",
            "thumbnail": "String",
            "counts": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".all_anime_global")

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("a")[0]
        v1 = v0.get("href")

        return f"https://jut.su{v1}"

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".aaname")[0]

        return v0.text_content()

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".all_anime_image[style]")[0]
        v1 = v0.get("style")

        return re.search("'(https?://.*?)'", v1)[1]

    def _parse_counts(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".aailines")
        v1 = [e.text_content() for e in v0]
        v2 = [i.strip("\r\n ") for i in v1]

        return " ".join(v2)

    def parse(self) -> List[T_PageSearch]:
        return [
            {
                "url": self._parse_url(el),
                "title": self._parse_title(el),
                "thumbnail": self._parse_thumbnail(el),
                "counts": self._parse_counts(el),
            }
            for el in self._split_doc(self._document)
        ]


class EpisodesView:
    """

    [
        {
            "title": "String",
            "url": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".video")

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.text_content()

        return v0.strip(" ")

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.get("href")

        return f"https://jut.su{v0}"

    def parse(self) -> List[T_EpisodesView]:
        return [
            {
                "title": self._parse_title(el),
                "url": self._parse_url(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageAnime:
    """
        GET https://jut.su/<ANIME PATH>

        EXAMPLE:
            GET https://jut.su/kime-no-yaiba/


    {
        "title": "String",
        "description": "String",
        "thumbnail": "String",
        "episodes": [
            {
                "title": "String",
                "url": "String"
            },
            "..."
        ]
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".anime_padding_for_title")[0]
        v1 = v0.text_content()

        return re.search("Смотреть\\s*(.*?)\\s*все", v1)[1]

    def _parse_description(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".uv_rounded_bottom span")
        v1 = [e.text_content() for e in v0]

        return " ".join(v1)

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".all_anime_title[style]")[0]
        v1 = v0.get("style")

        return re.search("'(https?://.*?)'", v1)[1]

    def _parse_episodes(self, v: html.HtmlElement) -> List[T_EpisodesView]:
        return EpisodesView(v).parse()

    def parse(self) -> T_PageAnime:
        return {
            "title": self._parse_title(self._document),
            "description": self._parse_description(self._document),
            "thumbnail": self._parse_thumbnail(self._document),
            "episodes": self._parse_episodes(self._document),
        }


class SourceView:
    """

    {
        "QUALITY": "URL"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("#my-player > source")

    def _parse_key(self, v: html.HtmlElement) -> str:
        v0 = v
        with suppress(Exception):
            return v0.get("res")
        return "null"

    def _parse_value(self, v: html.HtmlElement) -> Optional[str]:
        v0 = v
        with suppress(Exception):
            return v0.get("src")
        return None

    def parse(self) -> T_SourceView:
        return {self._parse_key(el): self._parse_value(el) for el in self._split_doc(self._document)}


class PageSource:
    """
        GET https://jut.su/<ANIME PATH>/<SEASON?>/episode-<NUM>.html

        NOTE: VIDEO PLAY REQUEST SHOULD HAVE THE SAME USER-AGENT AS AN API CLIENT

        eg:

        cl = Client(headers={"user-agent": "X"})

        ...

        s = SourcePage(doc).parse()

        mpv s["url_1080"] # 403, FORBIDDEN

        mpv s["url_1080"] --user-agent="Y" # 403, FORBIDDEN

        mpv s["url_1080"] --user-agent="X" # 200, OK

        EXAMPLE:
            GET https://jut.su/kime-no-yaiba/season-1/episode-1.html

        ISSUES:
            CHECK 'null' KEY in 'video'. if it contains - videos not available

            check block reasons regex patterns:

            - 'block_video_text_str_everywhere\\+' - К сожалению, это видео недоступно.
            - 'block_video_text_str\\+' - К сожалению, в России это видео недоступно.


    {
        "videos": {
            "QUALITY": "URL"
        }
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_videos(self, v: html.HtmlElement) -> T_SourceView:
        return SourceView(v).parse()

    def parse(self) -> T_PageSource:
        return {
            "videos": self._parse_videos(self._document),
        }
