# autogenerated by ssc-gen DO NOT EDIT

import re
from html import unescape as _html_unescape
from typing import List, Dict, TypedDict, Union
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


T_PageOngoing = TypedDict(
    "T_PageOngoing",
    {
        "url": str,
        "title": str,
        "thumbnail": str,
    },
)
T_PageSearch = TypedDict(
    "T_PageSearch",
    {
        "title": str,
        "thumbnail": str,
        "url": str,
    },
)
T_PageAnime = TypedDict(
    "T_PageAnime",
    {
        "title": str,
        "alt_title": str,
        "description": str,
        "thumbnail": str,
        "player_url": str,
    },
)
T_PagePlaylistURL = TypedDict(
    "T_PagePlaylistURL",
    {
        "playlist_url": str,
    },
)


class PageOngoing:
    """GET https://sameband.studio/novinki

    [
        {
            "url": "String",
            "title": "String",
            "thumbnail": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".col-auto")

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("a[href]")[0]

        return v0.get("href")

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".col-auto .poster[title]")[0]

        return v0.get("title")

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("img.swiper-lazy[src]")[0]
        v1 = v0.get("src")

        return f"https://sameband.studio{v1}"

    def parse(self) -> List[T_PageOngoing]:
        return [
            {
                "url": self._parse_url(el),
                "title": self._parse_title(el),
                "thumbnail": self._parse_thumbnail(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageSearch:
    """
        POST https://sameband.studio/index.php?do=search
        do=search&subaction=search&search_start=0&full_search=0&result_from=1&story=<QUERY>

        NOTE:
            search query len should be 4 or more characters. And in manual tests, works only cyrillic queries

        EXAMPLE:
            POST https://sameband.studio/index.php?do=search
        do=search&subaction=search&search_start=0&full_search=0&result_from=1&story=ВЕДЬ


    [
        {
            "title": "String",
            "thumbnail": "String",
            "url": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".col-auto")

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".col-auto .poster[title]")[0]

        return v0.get("title")

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("img.swiper-lazy[src]")[0]
        v1 = v0.get("src")

        return f"https://sameband.studio{v1}"

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".image[href]")[0]

        return v0.get("href")

    def parse(self) -> List[T_PageSearch]:
        return [
            {
                "title": self._parse_title(el),
                "thumbnail": self._parse_thumbnail(el),
                "url": self._parse_url(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageAnime:
    """
        GET https://sameband.studio/anime/<ANIME PATH>.html

        EXAMPLE:
            # https://sameband.studio/anime/20-госпожа-кагуя-3.html
            GET https://sameband.studio/anime/20-%D0%B3%D0%BE%D1%81%D0%BF%D0%BE%D0%B6%D0%B0-%D0%BA%D0%B0%D0%B3%D1%83%D1%8F-3.html


    {
        "title": "String",
        "alt_title": "String",
        "description": "String",
        "thumbnail": "String",
        "player_url": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect("h1.m-0")[0]

        return v0.text_content()

    def _parse_alt_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".help")[0]
        v1 = v0.text_content()

        return re.sub("(?:^\\s+)|(?:\\s+$)", "", v1)

    def _parse_description(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".limiter span")
        v1 = [e.text_content() for e in v0]

        return " ".join(v1)

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".image > img[src]")[0]
        v1 = v0.get("src")

        return f"https://sameband.studio{v1}"

    def _parse_player_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".player > .player-content > iframe[src]")[0]
        v1 = v0.get("src")

        return f"https://sameband.studio{v1}"

    def parse(self) -> T_PageAnime:
        return {
            "title": self._parse_title(self._document),
            "alt_title": self._parse_alt_title(self._document),
            "description": self._parse_description(self._document),
            "thumbnail": self._parse_thumbnail(self._document),
            "player_url": self._parse_player_url(self._document),
        }


class PagePlaylistURL:
    """GET https://sameband.studio/pl/a/<PLAYLIST NAME>.html

        EXAMPLE:
            GET https://sameband.studio/pl/a/Mashle_2nd_Season.html


        url contains in AnimeView.player_url key:

          playlist items signature (need manually provide json unmarshall logic):

        ```
            [
                {
                    "title": "<img src='/v/anime/...01 RUS_snapshot.jpg' class=playlist_poster><div class=playlist_duration>23:37</div>... 01",
                    ### delimiter - ','
                    "file": "[480p]/v/anime/... - 01 RUS_480p/... - 01 RUS_r480p.m3u8,[720p]/v/anime/.../... - 01 RUS_720p/... - 01 RUS_r720p.m3u8,[1080p]/v/anime/.../... -
                    01 RUS_1080p/... - 01 RUS_r1080p.m3u8",
                    ### thumbnails images for video
                    "thumbnails": "/v/anime/.../thumbnails/... - 01 RUS.txt"  # contains
                },
                {
                    ...
                },
                ...
            ]
        ```
        player script signature:
        ...
        <script>var player = new Playerjs({id:"player",file:"/v/list/....txt"});
        ...


    {
        "playlist_url": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_playlist_url(self, v: html.HtmlElement) -> str:
        v0 = html.tostring(v, encoding="unicode")
        v1 = re.search("Playerjs[^>]+file:\\s*[\\\"']([^>]+)[\\\"']", v0)[1]

        return f"https://sameband.studio{v1}"

    def parse(self) -> T_PagePlaylistURL:
        return {
            "playlist_url": self._parse_playlist_url(self._document),
        }
