# autogenerated by ssc-gen DO NOT EDIT

import re
from html import unescape as _html_unescape
from typing import List, Dict, TypedDict, Union, Optional
from contextlib import suppress
from functools import reduce


from lxml import html

FALLBACK_HTML_STR = "<html><body></body></html>"


_RE_HEX_ENTITY = re.compile(r"&#x([0-9a-fA-F]+);")
_RE_UNICODE_ENTITY = re.compile(r"\\\\u([0-9a-fA-F]{4})")
_RE_BYTES_ENTITY = re.compile(r"\\\\x([0-9a-fA-F]{2})")
_RE_CHARS_MAP = {"\\b": "\b", "\\f": "\f", "\\n": "\n", "\\r": "\r", "\\t": "\t"}


def ssc_unescape(s: str) -> str:
    s = _html_unescape(s)
    s = _RE_HEX_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_UNICODE_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    s = _RE_BYTES_ENTITY.sub(lambda m: chr(int(m.group(1), 16)), s)
    for ch, r in _RE_CHARS_MAP.items():
        s = s.replace(ch, r)
    return s


def ssc_map_replace(s: str, replacements: Dict[str, str]) -> str:
    return reduce(lambda acc, kv: acc.replace(kv[0], kv[1]), replacements.items(), s)


def ssc_rm_prefix(v: str, p: str) -> str:
    return v[len(p) :] if v.startswith(p) else v


def ssc_rm_suffix(v: str, s: str) -> str:
    return v[: -(len(s))] if v.endswith(s) else v


def ssc_rm_prefix_and_suffix(v: str, p: str, s: str) -> str:
    return ssc_rm_suffix(ssc_rm_prefix(v, p), s)


T_PageUtils = TypedDict(
    "T_PageUtils",
    {
        "url": str,
    },
)
T_PageOngoing = TypedDict(
    "T_PageOngoing",
    {
        "thumbnail_path": str,
        "url_path": str,
        "episode": int,
        "title": str,
    },
)
T_PageSearch = TypedDict(
    "T_PageSearch",
    {
        "title": str,
        "thumbnail_path": str,
        "url": str,
    },
)
T_PageAnime = TypedDict(
    "T_PageAnime",
    {
        "title": str,
        "alt_title": Optional[str],
        "description": str,
        "thumbnail": str,
    },
)


class PageUtils:
    """extract canonical url

    {
        "url": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_url(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect('link[rel="canonical"], link[rel="alternate"] ')[0]
        v1 = v0.get("href")
        v2 = v1.rstrip("/")

        return ssc_rm_suffix(v2, "/rss.xml")

    def parse(self) -> T_PageUtils:
        return {
            "url": self._parse_url(self._document),
        }


class PageOngoing:
    """Get all available ongoings from the main page

        can be change domains, extract real domain from `link[rel="canonical"]` element
        USAGE:

            GET https://yummyanime.in/



    [
        {
            "thumbnail_path": "String",
            "url_path": "String",
            "episode": "Int",
            "title": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect(".ksupdate_block a")

    def _parse_thumbnail_path(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".xfieldimage[src]")[0]

        return v0.get("src")

    def _parse_url_path(self, v: html.HtmlElement) -> str:
        return v.get("href")

    def _parse_episode(self, v: html.HtmlElement) -> int:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".cell-2")[0]
            v2 = v1.text_content()
            v3 = re.search("(\\d+)\\s", v2)[1]

            return int(v3)
        return 1

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".xfieldimage[alt]")[0]

        return v0.get("alt")

    def parse(self) -> List[T_PageOngoing]:
        return [
            {
                "thumbnail_path": self._parse_thumbnail_path(el),
                "url_path": self._parse_url_path(el),
                "episode": self._parse_episode(el),
                "title": self._parse_title(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageSearch:
    """Get search results

        USAGE:

            POST https://yummyanime.in
            do=search&subaction=search&story=<QUERY>

        EXAMPLE:

            POST https://yummyanime.in/index.php
            do=search&subaction=search=from_page=0story=ван-пис


    [
        {
            "title": "String",
            "thumbnail_path": "String",
            "url": "String"
        },
        "..."
    ]"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _split_doc(self, v: html.HtmlElement) -> List[html.HtmlElement]:
        return v.cssselect("a.has-overlay")

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".poster__title")[0]

        return v0.text_content()

    def _parse_thumbnail_path(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".xfieldimage[data-src]")[0]

        return v0.get("data-src")

    def _parse_url(self, v: html.HtmlElement) -> str:
        return v.get("href")

    def parse(self) -> List[T_PageSearch]:
        return [
            {
                "title": self._parse_title(el),
                "thumbnail_path": self._parse_thumbnail_path(el),
                "url": self._parse_url(el),
            }
            for el in self._split_doc(self._document)
        ]


class PageAnime:
    """get anime page

        USAGE:

            GET https://yummyanime.in/<...>.html

        EXAMPLE:

            GET https://yummyanime.in/4790-vedma-i-chudovische.html



    {
        "title": "String",
        "alt_title": "String",
        "description": "String",
        "thumbnail": "String"
    }"""

    def __init__(self, document: Union[str, html.HtmlElement]) -> None:
        if isinstance(document, html.HtmlElement):
            self._document = document
        elif isinstance(document, str):
            self._document = html.fromstring(document.strip() or FALLBACK_HTML_STR)

    def _parse_title(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".anime__title h1")[0]

        return v0.text_content()

    def _parse_alt_title(self, v: html.HtmlElement) -> Optional[str]:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".anime__title .pmovie__original-title")[0]

            return v1.text_content()
        return None

    def _parse_description(self, v: html.HtmlElement) -> str:
        v0 = v
        with suppress(Exception):
            v1 = v0.cssselect(".page__text p")
            v2 = [e.text_content() for e in v1]

            return "".join(v2)
        return ""

    def _parse_thumbnail(self, v: html.HtmlElement) -> str:
        v0 = v.cssselect(".pmovie__poster .xfieldimage[data-src]")[0]

        return v0.get("data-src")

    def parse(self) -> T_PageAnime:
        return {
            "title": self._parse_title(self._document),
            "alt_title": self._parse_alt_title(self._document),
            "description": self._parse_description(self._document),
            "thumbnail": self._parse_thumbnail(self._document),
        }
