"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _1 = require("./");
const app = new aws_cdk_lib_1.App();
const env = {
    region: process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const stack = new aws_cdk_lib_1.Stack(app, 'demo-stack', { env });
const provider = new _1.Provider(stack, 'GithubOpenIdConnectProvider');
provider.createRole('gh-oidc-role', [
    { owner: 'pahud', repo: 'gitpod-workspace' },
    { owner: 'pahud', repo: 'github-codespace' },
    { owner: 'pahud', repo: 'vscode' },
]);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkNBRXFCO0FBQ3JCLHlCQUE4QjtBQUU5QixNQUFNLEdBQUcsR0FBRyxJQUFJLGlCQUFHLEVBQUUsQ0FBQztBQUV0QixNQUFNLEdBQUcsR0FBRztJQUNWLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQjtJQUN0QyxPQUFPLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUI7Q0FDekMsQ0FBQztBQUVGLE1BQU0sS0FBSyxHQUFHLElBQUksbUJBQUssQ0FBQyxHQUFHLEVBQUUsWUFBWSxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUVwRCxNQUFNLFFBQVEsR0FBRyxJQUFJLFdBQVEsQ0FBQyxLQUFLLEVBQUUsNkJBQTZCLENBQUMsQ0FBQztBQUNwRSxRQUFRLENBQUMsVUFBVSxDQUFDLGNBQWMsRUFDaEM7SUFDRSxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLGtCQUFrQixFQUFFO0lBQzVDLEVBQUUsS0FBSyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsa0JBQWtCLEVBQUU7SUFDNUMsRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUU7Q0FDbkMsQ0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgU3RhY2ssIEFwcCxcbn0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgUHJvdmlkZXIgfSBmcm9tICcuLyc7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuY29uc3QgZW52ID0ge1xuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbiAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbn07XG5cbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ2RlbW8tc3RhY2snLCB7IGVudiB9KTtcblxuY29uc3QgcHJvdmlkZXIgPSBuZXcgUHJvdmlkZXIoc3RhY2ssICdHaXRodWJPcGVuSWRDb25uZWN0UHJvdmlkZXInKTtcbnByb3ZpZGVyLmNyZWF0ZVJvbGUoJ2doLW9pZGMtcm9sZScsXG4gIFtcbiAgICB7IG93bmVyOiAncGFodWQnLCByZXBvOiAnZ2l0cG9kLXdvcmtzcGFjZScgfSxcbiAgICB7IG93bmVyOiAncGFodWQnLCByZXBvOiAnZ2l0aHViLWNvZGVzcGFjZScgfSxcbiAgICB7IG93bmVyOiAncGFodWQnLCByZXBvOiAndnNjb2RlJyB9LFxuICBdLFxuKTsiXX0=